/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import oracle.dbtools.crest.model.design.compare.COPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class AttributeComparator
extends COPropertiesComparator {
    private Attribute source;
    private Attribute target;

    public AttributeComparator(Attribute attribute, Attribute attribute2) {
        super(attribute, attribute2);
        this.source = attribute;
        this.target = attribute2;
        this.initPropertiesList();
    }

    @Override
    protected void initPropertiesList() {
        super.initPropertiesList();
        PropertyHolder propertyHolder = new PropertyHolder(SCOPE);
        Table table = null;
        if (this.target != null && this.target.getScope() != null) {
            propertyHolder.setRightValue(this.target.getScope().getName());
        } else {
            propertyHolder.setRightValue("");
        }
        if (this.source != null && this.source.getScope() != null) {
            propertyHolder.setLeftValue(this.source.getScope().getName());
            if (this.target != null) {
                table = ((Entity)this.source.getScope()).getEngTable((RelationalDesign)this.target.getDesignPart());
            }
        } else {
            propertyHolder.setLeftValue("");
        }
        if (this.source != null && this.target != null && table != this.target.getScope()) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyScopeFromAttributeToAttribute();
    }

    private void copyScopeFromAttributeToAttribute() {
        if (this.source != null && this.target != null) {
            this.target.setTemporaryWriteable(true);
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(SCOPE) || this.source.getScope() != null) continue;
                this.target.setScopeId(null);
            }
            this.target.setTemporaryWriteable(false);
        }
    }

    @Override
    public String getLeftName() {
        return this.source != null ? this.source.getContainerWithKeyObject().getName() + "." + this.source.getName() : "";
    }

    @Override
    public String getRightName() {
        return this.target != null ? this.target.getContainerWithKeyObject().getName() + "." + this.target.getName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.source != null && this.target != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.getName().equals(NATIVE_DATA_TYPE) || !engPropertyHolder.isSelected()) continue;
                return true;
            }
        }
        return super.hasToBeRename();
    }

    public boolean isDataTypeChanged() {
        if (this.source != null && this.target != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.getName().equals(NATIVE_DATA_TYPE) || !engPropertyHolder.isModified()) continue;
                return true;
            }
        }
        return false;
    }
}

