/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;

public class TableViewComparator
extends PropertiesComparator {
    private TableView sourceTableView;
    private TableView targetTableView;
    private TableViewProxy sourceTableViewProxy;
    private TableViewProxy targetTableViewProxy;

    TableViewComparator(TableView tableView, TableView tableView2) {
        super(tableView, tableView2);
        this.sourceTableView = tableView;
        this.targetTableView = tableView2;
        this.initPropertiesList();
    }

    public TableViewComparator(TableView tableView, TableView tableView2, TableViewProxy tableViewProxy, TableViewProxy tableViewProxy2) {
        super(tableView, tableView2);
        this.sourceTableView = tableView;
        this.targetTableView = tableView2;
        this.sourceTableViewProxy = tableViewProxy;
        this.targetTableViewProxy = tableViewProxy2;
        this.initPropertiesList();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromTableViewToTableView();
    }

    protected void initPropertiesList() {
        String string;
        String string2;
        this.initNameProperty();
        if (this.sourceTableViewProxy != null || this.targetTableViewProxy != null) {
            this.initSchemaProperty();
        }
        this.initCommentsAndNotes();
        PropertyHolder propertyHolder = new PropertyHolder(STRUCTURED_TYPE);
        String string3 = null;
        if (this.sourceTableView != null && this.sourceTableView.getBasedOnStructuredType() != null) {
            string3 = this.sourceTableView.getBasedOnStructuredType().getName();
            propertyHolder.setLeftValue(string3);
        } else {
            propertyHolder.setLeftValue("");
        }
        String string4 = null;
        if (this.targetTableView != null && this.targetTableView.getBasedOnStructuredType() != null) {
            string4 = this.targetTableView.getBasedOnStructuredType().getName();
            propertyHolder.setRightValue(string4);
        } else {
            propertyHolder.setRightValue("");
        }
        if (string3 != null && string4 != null) {
            if (!string3.equalsIgnoreCase(string4)) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
        } else if (string3 != string4) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(WHERE_PROPERTY);
        propertyHolder.setLeftValue(this.sourceTableView != null ? this.sourceTableView.getWhere() : "");
        propertyHolder.setRightValue(this.targetTableView != null ? this.targetTableView.getWhere() : "");
        if (this.sourceTableView != null && this.targetTableView != null && !this.sourceTableView.getWhere().equals(this.targetTableView.getWhere())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(HAVING_PROPERTY);
        propertyHolder.setLeftValue(this.sourceTableView != null ? this.sourceTableView.getHaving() : "");
        propertyHolder.setRightValue(this.targetTableView != null ? this.targetTableView.getHaving() : "");
        if (this.sourceTableView != null && this.targetTableView != null && !this.sourceTableView.getHaving().equals(this.targetTableView.getHaving())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(USER_DEFINED_DQL);
        propertyHolder.setLeftValue(this.sourceTableView != null ? this.sourceTableView.getUserDefinedSQLAsDDL() : "");
        propertyHolder.setRightValue(this.targetTableView != null ? this.targetTableView.getUserDefinedSQLAsDDL() : "");
        if (this.sourceTableView != null && this.targetTableView != null && !(string2 = propertyHolder.getLeftValue().replaceAll("[\\p{javaWhitespace}]+", " ").trim()).equalsIgnoreCase(string = propertyHolder.getRightValue().replaceAll("[\\p{javaWhitespace}]+", " ").trim())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    private void copyPropertiesFromTableViewToTableView() {
        if (this.sourceTableView != null && this.targetTableView != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(STRUCTURED_TYPE)) {
                    this.targetTableView.setBasedOnStructuredType(this.sourceTableView.getBasedOnStructuredType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(WHERE_PROPERTY)) {
                    this.targetTableView.setWhere(this.sourceTableView.getWhere());
                    continue;
                }
                if (engPropertyHolder.getName().equals(HAVING_PROPERTY)) {
                    this.targetTableView.setHaving(this.sourceTableView.getHaving());
                    continue;
                }
                if (engPropertyHolder.getName().equals(USER_DEFINED_DQL)) {
                    this.targetTableView.setUserDefinedSQL(this.sourceTableView.getUserDefinedSQL());
                    MergingModels.synchronizeColumnsView(this.sourceTableView, this.targetTableView);
                    continue;
                }
                if (!engPropertyHolder.getName().equals(SCHEMA) || this.sourceTableViewProxy == null || this.targetTableViewProxy == null) continue;
                this.targetTableViewProxy.setUserSchema(this.sourceTableViewProxy.getUserSchema().getName());
            }
        }
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceTableView == null && this.targetTableView != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceTableView != null && this.targetTableView != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(NAME)) continue;
                return true;
            }
        }
        return super.hasToBeRename();
    }

    protected void initSchemaProperty() {
        PropertyHolder propertyHolder = new PropertyHolder(SCHEMA);
        propertyHolder.setLeftValue(this.sourceTableViewProxy != null && this.sourceTableViewProxy.getUserSchema() != null ? this.sourceTableViewProxy.getUserSchema().getName() : "");
        propertyHolder.setRightValue(this.targetTableViewProxy != null && this.targetTableViewProxy.getUserSchema() != null ? this.targetTableViewProxy.getUserSchema().getName() : "");
        if (this.sourceTableViewProxy != null && this.targetTableViewProxy != null && this.sourceTableViewProxy.getUserSchema() != null && this.targetTableViewProxy.getUserSchema() != null) {
            if (this.caseSensitive) {
                if (!this.sourceTableViewProxy.getUserSchema().getName().equals(this.targetTableViewProxy.getUserSchema().getName())) {
                    propertyHolder.setModified(true);
                    if (this.useSchema) {
                        propertyHolder.setSelected(true);
                    } else {
                        propertyHolder.setFiltered(true);
                    }
                }
            } else if (!this.sourceTableViewProxy.getUserSchema().getName().equalsIgnoreCase(this.targetTableViewProxy.getUserSchema().getName())) {
                propertyHolder.setModified(true);
                if (this.useSchema) {
                    propertyHolder.setSelected(true);
                } else {
                    propertyHolder.setFiltered(true);
                }
            }
        }
        this.propertiesList.add(propertyHolder);
    }
}

