/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;

public class IndexComparator
extends PropertiesComparator {
    private Index sourceIndex;
    private Index targetIndex;
    private Map objectsMap;

    public IndexComparator(Index index, Index index2, Map map) {
        super(index, index2);
        this.sourceIndex = index;
        this.targetIndex = index2;
        this.objectsMap = map;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder propertyHolder = new PropertyHolder(INDEX_STATUS);
        propertyHolder.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexState() : "");
        propertyHolder.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexState() : "");
        if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexState().equals(this.sourceIndex.getIndexState())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(INDEX_FUNCTION_EXPRESSION);
        propertyHolder.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexExpression() : "");
        propertyHolder.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexExpression() : "");
        if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexExpression().equals(this.sourceIndex.getIndexExpression())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(COLUMNS);
        propertyHolder.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
        propertyHolder.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
        if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
            propertyHolder.setEditable(false);
        }
        this.propertiesList.add(propertyHolder);
    }

    private String getElementsToString(Index index) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = index.getElementsCollection().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            String string;
            Column column = (Column)iterator.next();
            if (index.isPK() || index.isUnique()) {
                if (bl) {
                    stringBuffer.append(column.getName());
                    bl = false;
                    continue;
                }
                stringBuffer.append("; ").append(column.getName());
                continue;
            }
            if (bl) {
                string = index.getColumnSortOrder(column).trim();
                if ("ASC".equalsIgnoreCase(string)) {
                    string = "";
                }
                stringBuffer.append(column.getName()).append(" ").append(string);
                bl = false;
                continue;
            }
            string = index.getColumnSortOrder(column).trim();
            if ("ASC".equalsIgnoreCase(string)) {
                string = "";
            }
            stringBuffer.append("; ").append(column.getName()).append(" ").append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromIndexToKey();
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.targetIndex != null && this.sourceIndex != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(INDEX_STATUS)) {
                    this.targetIndex.setIndexState(this.sourceIndex.getIndexState());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.sourceIndex, this.targetIndex);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceIndex != null ? this.sourceIndex.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetIndex != null ? this.targetIndex.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceIndex == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceIndex == null && this.targetIndex != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    @Override
    public String getChoosedPropertyValue(String string) {
        return super.getChoosedPropertyValue(string);
    }

    public void presetColumnsOrder() {
        EngPropertyHolder engPropertyHolder = this.getPropertyHolderByName(COLUMNS);
        if (engPropertyHolder != null) {
            if (this.getLeftSelectionObject() != null) {
                engPropertyHolder.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.sourceIndex != null) {
                    CompareObjectSelection[] compareObjectSelectionArray = this.getColumnNodes(this.sourceIndex, this.getTableNode());
                    engPropertyHolder.setLeftValue(this.getElementsToString(this.sourceIndex, compareObjectSelectionArray));
                } else {
                    engPropertyHolder.setLeftValue("");
                }
                if (this.targetIndex != null && this.sourceIndex != null) {
                    if (!MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
                        engPropertyHolder.setModified(true);
                        engPropertyHolder.setSelected(true);
                    } else {
                        engPropertyHolder.setModified(false);
                        engPropertyHolder.setSelected(false);
                    }
                    engPropertyHolder.setEditable(false);
                }
            } else {
                engPropertyHolder.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
                engPropertyHolder.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
                    engPropertyHolder.setModified(true);
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setEditable(false);
                }
            }
        }
    }

    private CompareObjectSelection[] getColumnNodes(Index index, CompareObjectSelection compareObjectSelection) {
        ContainedObject[] containedObjectArray;
        ArrayList<ContainedObject[]> arrayList = new ArrayList<ContainedObject[]>();
        CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)compareObjectSelection.getChild(0);
        int n = compareObjectSelection2.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            containedObjectArray = (ContainedObject[])compareObjectSelection2.getChild(i);
            if (containedObjectArray.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!containedObjectArray.isSelected() || containedObjectArray.getStatus() != ModelIdObjectSelection.STATE_NEW) && containedObjectArray.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            arrayList.add(containedObjectArray);
        }
        ArrayList<CompareObjectSelection> arrayList2 = new ArrayList<CompareObjectSelection>();
        containedObjectArray = index.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            CompareObjectSelection compareObjectSelection3 = this.getNode(arrayList, containedObjectArray[i]);
            if (compareObjectSelection3 == null) continue;
            arrayList2.add(compareObjectSelection3);
        }
        return arrayList2.toArray(new CompareObjectSelection[0]);
    }

    private CompareObjectSelection getNode(List list, ModelIDObject modelIDObject) {
        for (CompareObjectSelection compareObjectSelection : list) {
            if (compareObjectSelection.getObject() != modelIDObject) continue;
            return compareObjectSelection;
        }
        return null;
    }

    private String getElementsToString(Index index, CompareObjectSelection[] compareObjectSelectionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < compareObjectSelectionArray.length; ++i) {
            ContainedObject containedObject = (ContainedObject)compareObjectSelectionArray[i].getObject();
            if (index.isPK() || index.isUnique()) {
                if (bl) {
                    stringBuffer.append(containedObject.getName());
                    bl = false;
                    continue;
                }
                stringBuffer.append("; ").append(containedObject.getName());
                continue;
            }
            if (bl) {
                stringBuffer.append(containedObject.getName()).append(" ").append(index.getColumnSortOrder(containedObject));
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(containedObject.getName()).append(" ").append(index.getColumnSortOrder(containedObject));
        }
        return stringBuffer.toString();
    }

    private CompareObjectSelection getTableNode() {
        if (this.getLeftSelectionObject() != null) {
            return (CompareObjectSelection)((CompareObjectSelection)this.getLeftSelectionObject().getParent()).getParent();
        }
        return null;
    }
}

