/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;

public class FKComparator
extends PropertiesComparator {
    private FKIndexAssociation lfk;
    private FKIndexAssociation rfk;
    private KeyObject right_key;
    private KeyObject left_key;
    private boolean matchingRemoteKey;
    private boolean matchingColumns;

    public FKComparator(FKIndexAssociation fKIndexAssociation, FKIndexAssociation fKIndexAssociation2, boolean bl, boolean bl2) {
        super(fKIndexAssociation, fKIndexAssociation2);
        this.lfk = fKIndexAssociation;
        this.rfk = fKIndexAssociation2;
        this.left_key = fKIndexAssociation != null ? fKIndexAssociation.getKeyObject() : null;
        this.right_key = fKIndexAssociation2 != null ? fKIndexAssociation2.getKeyObject() : null;
        this.matchingRemoteKey = bl;
        this.matchingColumns = bl2;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder propertyHolder = new PropertyHolder(MANDATORY);
        propertyHolder.setDDLHolder(false);
        propertyHolder.setLeftValue(this.left_key != null ? String.valueOf(this.lfk.isMandatory()) : "");
        propertyHolder.setRightValue(this.right_key != null ? String.valueOf(this.rfk.isMandatory()) : "");
        if (this.rfk != null && this.lfk != null && this.rfk.isMandatory() != this.lfk.isMandatory()) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
            propertyHolder.setEditable(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(TRANSFERABLE);
        propertyHolder.setDDLHolder(false);
        propertyHolder.setLeftValue(this.left_key != null ? String.valueOf(this.lfk.isTransferable()) : "");
        propertyHolder.setRightValue(this.right_key != null ? String.valueOf(this.rfk.isTransferable()) : "");
        if (this.rfk != null && this.lfk != null && this.rfk.isTransferable() != this.lfk.isTransferable()) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
            propertyHolder.setEditable(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(DELETE_RULE);
        propertyHolder.setDDLHolder(false);
        propertyHolder.setLeftValue(this.left_key != null ? this.lfk.getDeleteRule() : "");
        propertyHolder.setRightValue(this.right_key != null ? this.rfk.getDeleteRule() : "");
        if (this.rfk != null && this.lfk != null && !this.lfk.getDeleteRule().equals(this.rfk.getDeleteRule())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
            propertyHolder.setEditable(true);
            if (this.isDeleteRuleCompatible()) {
                propertyHolder.setSelected(false);
            }
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(IN_ARC);
        propertyHolder.setDDLHolder(false);
        propertyHolder.setLeftValue(this.left_key != null ? String.valueOf(this.lfk.isInArc()) : "");
        propertyHolder.setRightValue(this.right_key != null ? String.valueOf(this.rfk.isInArc()) : "");
        if (this.rfk != null && this.lfk != null && this.rfk.isInArc() != this.lfk.isInArc()) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
            propertyHolder.setEditable(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(PRIMARY_KEY);
        propertyHolder.setLeftValue(this.left_key != null ? this.left_key.getLongName() : "");
        propertyHolder.setRightValue(this.right_key != null ? this.right_key.getLongName() : "");
        if (this.rfk != null && this.lfk != null && !this.matchingRemoteKey) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
            propertyHolder.setEditable(false);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(COLUMN_ASSOCIATION);
        propertyHolder.setLeftValue(this.lfk != null ? this.getElementsToString(this.lfk) : "");
        propertyHolder.setRightValue(this.rfk != null ? this.getElementsToString(this.rfk) : "");
        if (this.rfk != null && this.lfk != null && !this.matchingColumns) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
            propertyHolder.setEditable(false);
        }
        this.propertiesList.add(propertyHolder);
    }

    private boolean isDeleteRuleCompatible() {
        String string = this.lfk.getDeleteRule();
        String string2 = this.rfk.getDeleteRule();
        return string.equalsIgnoreCase("NO ACTION") && string2.equalsIgnoreCase("RESTRICT") || string.equalsIgnoreCase("RESTRICT") && string2.equalsIgnoreCase("NO ACTION");
    }

    private String getElementsToString(FKIndexAssociation fKIndexAssociation) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Column> iterator = Arrays.asList(fKIndexAssociation.getColumns()).iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ContainedObject containedObject = iterator.next();
            if (bl) {
                stringBuffer.append(containedObject.getName());
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(containedObject.getName());
        }
        return stringBuffer.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromLeftFK();
    }

    private void copyPropertiesFromLeftFK() {
        if (this.right_key != null && this.left_key != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey((Index)this.left_key, (Index)this.right_key);
                break;
            }
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(MANDATORY)) {
                    this.rfk.setMandatory(this.lfk.isMandatory());
                    continue;
                }
                if (engPropertyHolder.getName().equals(TRANSFERABLE)) {
                    this.rfk.setTransferable(this.lfk.isTransferable());
                    continue;
                }
                if (engPropertyHolder.getName().equals(DELETE_RULE)) {
                    this.rfk.setDeleteRule(this.lfk.getDeleteRule());
                    continue;
                }
                if (engPropertyHolder.getName().equals(IN_ARC)) {
                    if (this.lfk.isInArc()) continue;
                    this.rfk.setArc(null);
                    continue;
                }
                if (!engPropertyHolder.getName().equals(PRIMARY_KEY)) continue;
                this.right_key.setPK(this.left_key.isPK());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.lfk != null ? this.lfk.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.rfk != null ? this.rfk.getLongName() : "";
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.lfk == null && this.rfk != null) {
            return true;
        }
        return super.hasToBeDrop();
    }
}

