/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelIdObjectSelectionListener;
import oracle.dbtools.crest.model.ModelObject;

public class CompareTreeNavigationDesign
implements TreeModel,
ModelIdObjectSelectionListener {
    private Set listeners = new HashSet();
    private ModelObject despart;

    public CompareTreeNavigationDesign(ModelObject modelObject) {
        this.despart = modelObject;
        this.traverseTreeAndRegisterListener(this.despart);
    }

    public CompareTreeNavigationDesign(ModelObject modelObject, boolean bl) {
        this.despart = modelObject;
        if (bl) {
            this.traverseTreeAndRegisterListener(this.despart);
        }
    }

    protected void traverseTreeAndRegisterListener(ModelObject modelObject) {
        int n = modelObject.getNumberOfChildren();
        if (modelObject instanceof ModelIdObjectSelection) {
            ((ModelIdObjectSelection)modelObject).addDDLSelectionListener(this);
        }
        for (int i = 0; i < n; ++i) {
            ModelObject modelObject2 = modelObject.getChild(i);
            if (modelObject2 == null) continue;
            this.traverseTreeAndRegisterListener(modelObject2);
        }
    }

    protected void traverseTreeAndUnregisterAsListener(ModelObject modelObject) {
        int n = modelObject.getNumberOfChildren();
        if (modelObject instanceof ModelIdObjectSelection) {
            ((ModelIdObjectSelection)modelObject).removeDDLSelectionListener(this);
        }
        for (int i = 0; i < n; ++i) {
            ModelObject modelObject2 = modelObject.getChild(i);
            if (modelObject2 == null) continue;
            this.traverseTreeAndUnregisterAsListener(modelObject2);
        }
    }

    @Override
    public Object getRoot() {
        return this.despart;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    protected ModelObject toModelObject(Object object) {
        return (ModelObject)object;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object instanceof ModelObject) {
            return this.toModelObject(object).isLeaf();
        }
        return true;
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.toModelObject(object).getChildPlain(n);
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof ModelObject) {
            return this.toModelObject(object).getNumberOfChildren();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object2 instanceof ModelObject) {
            return this.toModelObject(object).getIndexForChild(this.toModelObject(object2));
        }
        return this.toModelObject(object).getIndexForChild(object2);
    }

    protected void fireStructureChanged(ModelObject modelObject) {
        if (modelObject.hasAlternatePaths()) {
            Object[][] objectArray = modelObject.getAlternatePaths();
            for (int i = 0; i < objectArray.length; ++i) {
                this.fireStructureChanged(modelObject, objectArray[i]);
            }
        } else {
            this.fireStructureChanged(modelObject, modelObject.getPath());
        }
    }

    protected void fireStructureChanged(ModelObject modelObject, Object[] objectArray) {
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, objectArray));
        }
    }

    protected void fireNodeChanged(ModelObject modelObject) {
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, new TreePath(modelObject.getPath())));
        }
        this.fireStructureChanged(modelObject);
    }

    @Override
    public void changed(ModelIdObjectSelection modelIdObjectSelection) {
        this.fireNodeChanged(modelIdObjectSelection);
    }

    public void unregisterAsListener() {
        this.traverseTreeAndUnregisterAsListener(this.despart);
    }
}

