/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.FileUtils;

public class CompareModelsController {
    private ApplicationView view;
    private Design design;
    private Design tempDesign;

    public CompareModelsController(ApplicationView applicationView) {
        this.view = applicationView;
        this.design = applicationView.getCurrentDesign();
    }

    public void loadTempDesign(File file) throws Exception {
        String string = ".dmd";
        String string2 = file.getParentFile().getAbsolutePath();
        String string3 = file.getName();
        int n = string3.lastIndexOf(".");
        if (n > -1) {
            string = string3.substring(n);
        }
        String string4 = FileUtils.removeExt(file.getName());
        ApplicationView applicationView = this.getApplicationView();
        this.tempDesign = new Design(applicationView);
        this.tempDesign.setOldRepositoryType(".xml".equalsIgnoreCase(string));
        this.tempDesign.setCompressedDesign(".dmdz".equalsIgnoreCase(string));
        this.tempDesign.setFileName(string4);
        this.tempDesign.setDesignPath(string2);
        ProgressDialog progressDialog = null;
        this.tempDesign.getBusinessInfoDesign().setLoaded(false);
        this.tempDesign.getLogicalDesign().setLoaded(false);
        applicationView.setCurrentDesign(this.tempDesign);
        applicationView.setDesignName(String.valueOf(string4));
        applicationView.getPersistenceManager().setAppView(applicationView);
        if (this.tempDesign.isOldRepositoryType()) {
            applicationView.getPersistenceManager().setAppView(applicationView);
            applicationView.getPersistenceManager().read((Object)string4, this.tempDesign, progressDialog);
            applicationView.getPersistenceManager().readSystemInit(this.tempDesign);
            this.tempDesign.loadDomainFiles();
            this.tempDesign.loadRDBMSSites();
        } else {
            applicationView.getXMLTransformationManager().openDesign(this.tempDesign, file);
            applicationView.getPersistenceManager().readSystemInit(this.tempDesign);
            applicationView.getXMLTransformationManager().loadDomains(this.tempDesign);
        }
    }

    public List getDPObject() {
        ArrayList<RelationalDesign> arrayList = new ArrayList<RelationalDesign>();
        for (int i = 0; i < this.tempDesign.getRelationalDesigns().size(); ++i) {
            RelationalDesign relationalDesign = (RelationalDesign)this.tempDesign.getRelationalDesigns().getElement(i);
            arrayList.add(relationalDesign);
        }
        return arrayList;
    }

    public void removeTempDesign() {
        this.tempDesign = null;
        this.getApplicationView().setCurrentDesign(this.design);
        System.gc();
    }

    public ApplicationView getApplicationView() {
        return this.view;
    }

    public Design getDesign() {
        return this.design;
    }

    public void setApplicationView(ApplicationView applicationView) {
        this.view = applicationView;
    }

    public void loadRelationalDesign(RelationalDesign relationalDesign) {
        relationalDesign.setShouldBeOpen(true);
        this.getDesign().setClosing(true);
        this.getDesign().setClosing(false);
        if (relationalDesign.getDesign().isOldRepositoryType()) {
            relationalDesign.load();
        } else {
            this.getApplicationView().getXMLTransformationManager().openDesignPart(relationalDesign);
            RMExtendedMap rMExtendedMap = relationalDesign.getRMExtendedMap();
            relationalDesign.getAppView().getXMLTransformationManager().transformFromXMLToObject(rMExtendedMap, new File(rMExtendedMap.getStorageName()), relationalDesign.getDesign().isCompressedDesign());
        }
        relationalDesign.getDesign().getExtendedMap().distributenMappings(relationalDesign);
    }
}

