/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.AbstractMerging;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.ColumnSelection;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.EmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.FKComparator;
import oracle.dbtools.crest.model.design.compare.FilteredSelection;
import oracle.dbtools.crest.model.design.compare.IndexComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableConstraintComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CollectionTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.compare.cwddesign.DistinctTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MethodComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.StructuredTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.TypeElementComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterTableConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterColumnOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterIndexOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBFKIndexOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBSequenceOracle10vg;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBSnapshotOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBTableViewOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBAlterColumnOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBAlterIndexOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBCreateTableOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBRenameTableOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBSnapshotOraclev11g;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SequenceComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SnapshotComparator;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;

public class CompareModelToModel
extends CompareObjectSelection {
    private static String NEW_VIEW = Messages.getString("CompareModelToModel.NewView");
    private CompareObjectSelection rightRelationalRoot;
    private Map comparatorsMap = new TreeMap();
    private Map leftSelectionMap = new TreeMap();
    private List deletedMappings = new ArrayList();
    private List newMappings = new ArrayList();
    private RelationalDesign sourcedes;
    private RelationalDesign targetdes;
    private List pkInd = new ArrayList();
    private List fkInd = new ArrayList();
    private List indexes = new ArrayList();
    private static String NEW_SNAPSHOT = Messages.getString("CompareModelToModel.NewSnapshot");
    private static String NEW_SEQUENCE = Messages.getString("CompareModelToModel.NewSequence");
    private Map objectsMap;
    private List tablesToRecreate = new ArrayList();
    private List columnsWithChangedDataType = new ArrayList();
    private DataTypesDesign sourceDTD;
    private DataTypesDesign targetDTD;
    private boolean buildDataTypes = false;
    private static boolean caseSensitive = false;
    private static boolean useSchema = true;
    private static boolean swapTarget = false;
    private boolean useGenerateInDDL = false;
    private Map selectedIDs;
    private boolean syncMode;

    public CompareModelToModel(RelationalDesign relationalDesign, RelationalDesign relationalDesign2, boolean bl, boolean bl2, Map map) {
        super(relationalDesign.getName());
        this.useGenerateInDDL = bl2;
        this.selectedIDs = map;
        this.syncMode = bl;
        relationalDesign.getDesign().getDataTypesDesign().getPredefinedStCollection();
        relationalDesign2.getDesign().getDataTypesDesign().getPredefinedStCollection();
        this.tablesToRecreate.clear();
        caseSensitive = relationalDesign.getAppView().getSettings().isCaseSensitiveNamesInCompare();
        useSchema = relationalDesign.getAppView().getSettings().isUseSchemaPropertyInCompare();
        this.sourceDTD = relationalDesign.getDesign().getDataTypesDesign();
        this.targetDTD = relationalDesign2.getDesign().getDataTypesDesign();
        this.buildDataTypes = this.sourceDTD != null && this.targetDTD != null && this.sourceDTD != this.targetDTD;
        this.objectsMap = new TreeMap();
        AbstractMerging.objectsMap = this.objectsMap;
        this.sourcedes = relationalDesign;
        String string = relationalDesign.getName() + "(" + relationalDesign.getDesign().getName() + ")";
        this.setName(string);
        this.targetdes = relationalDesign2;
        this.rightRelationalRoot = new CompareObjectSelection(this.targetdes.getName());
        String string2 = relationalDesign2.getName() + "(" + relationalDesign2.getDesign().getName() + ")";
        this.rightRelationalRoot.setName(string2);
        this.setCorrespondentNode(this.rightRelationalRoot);
        this.rightRelationalRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.rightRelationalRoot);
        this.addFromSourceModel();
    }

    private void setEmptyComparator(CompareObjectSelection compareObjectSelection) {
        compareObjectSelection.setPropertiesComparator(new EmptyPropertiesComparator(null, null));
    }

    private void addTable(Table table, ModelIdObjectSelection modelIdObjectSelection, ModelIdObjectSelection modelIdObjectSelection2) {
        TableProxy tableProxy = (TableProxy)this.getSourceStorageDesign().getTableProxySet().getProxy(table.getObjectID());
        Table table2 = (Table)this.getCorrespondingObject(this.targetdes.getTableSet(), table, useSchema);
        TableProxy tableProxy2 = null;
        if (table2 != null) {
            tableProxy2 = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(table2.getObjectID());
        }
        if (this.useGenerateInDDL && !this.isGenerateInDDL(tableProxy, tableProxy2)) {
            if (table != null && table2 != null) {
                this.objectsMap.put(table.getObjectID(), table2);
            }
            return;
        }
        TableSelection tableSelection = new TableSelection(table);
        TableSelection tableSelection2 = null;
        if (table2 != null) {
            tableSelection2 = new TableSelection(table2);
            TableComparator tableComparator = new TableComparator(table, table2, tableProxy, tableProxy2);
            tableSelection.setPropertiesComparator(tableComparator);
            tableSelection2.setPropertiesComparator(tableComparator);
            this.comparatorsMap.put(tableComparator.getID(), tableComparator);
            tableSelection.setSelected(tableComparator.isModified());
            tableComparator.setLeftSelectionObject(tableSelection);
            this.objectsMap.put(table.getObjectID(), table2);
        } else {
            tableSelection2 = new TableSelection(NEW_TABLE);
            tableSelection.setStatus(STATE_NEW);
            tableSelection2.setStatus(STATE_NEW);
            tableSelection2.setElementDescriptor(Table.class);
            this.objectsMap.put(table.getObjectID(), null);
            TableComparator tableComparator = new TableComparator(table, table2, tableProxy, null);
            tableSelection.setPropertiesComparator(tableComparator);
            tableSelection2.setPropertiesComparator(tableComparator);
            this.comparatorsMap.put(tableComparator.getID(), tableComparator);
            tableSelection.setSelected(true);
            this.newMappings.add(tableSelection);
        }
        tableSelection2.setCorrespondentNode(tableSelection);
        tableSelection.setCorrespondentNode(tableSelection2);
        this.addTableDetails(table, tableSelection, table2, tableSelection2);
        modelIdObjectSelection.addChild(tableSelection);
        modelIdObjectSelection2.addChild(tableSelection2);
        if (tableSelection2.isRecreateTable()) {
            this.tablesToRecreate.add(tableSelection2);
        }
        if (tableSelection.isModified() || tableSelection.hasChildsWithChangeStatus()) {
            tableSelection.setSelectedNoPropagateSelection(true);
        }
    }

    public static DesignObject getCorrespondingObject(DesignObjectSet designObjectSet, DesignObject designObject) {
        DesignObject designObject2;
        if (designObject == null) {
            return null;
        }
        Iterator iterator = designObjectSet.iterator();
        while (iterator.hasNext()) {
            designObject2 = (DesignObject)iterator.next();
            if (!(designObject2.getImportedId() != null && designObject2.getImportedId().equals(designObject.getObjectID()) || designObject.getImportedId() != null && designObject.getImportedId().equals(designObject2.getObjectID()) || designObject.getObjectID().equals(designObject2.getObjectID())) && (designObject.getImportedId() == null || designObject2.getImportedId() == null || !designObject.getImportedId().equals(designObject2.getImportedId()))) continue;
            return designObject2;
        }
        designObject2 = (DesignObject)CompareModelToModel.getCorrespondingImportedObject(designObjectSet.iterator(), designObject, false);
        if (designObject2 != null) {
            return designObject2;
        }
        return designObjectSet.getByName(designObject.getName(), caseSensitive);
    }

    public DesignObject getCorrespondingObject(DesignObjectSet designObjectSet, DesignObject designObject, boolean bl) {
        DesignObject designObject2;
        Iterator iterator = designObjectSet.iterator();
        while (iterator.hasNext()) {
            designObject2 = (DesignObject)iterator.next();
            if (!(designObject2.getImportedId() != null && designObject2.getImportedId().equals(designObject.getObjectID()) || designObject.getImportedId() != null && designObject.getImportedId().equals(designObject2.getObjectID()) || designObject.getObjectID().equals(designObject2.getObjectID())) && (designObject2.getImportedId() == null || designObject.getImportedId() == null || !designObject.getImportedId().equals(designObject2.getImportedId()))) continue;
            return designObject2;
        }
        designObject2 = (DesignObject)CompareModelToModel.getCorrespondingImportedObject(designObjectSet.iterator(), designObject, bl);
        if (designObject2 != null) {
            return designObject2;
        }
        if (bl) {
            if (designObject instanceof Index || designObject instanceof FKIndexAssociation) {
                return designObjectSet.getByVeryLongdName(designObject.getVeryLongName());
            }
            return designObjectSet.getByLongName(designObject.getLongName());
        }
        if (!bl && (designObject instanceof Index || designObject instanceof FKIndexAssociation)) {
            return designObjectSet.getByLongName(designObject.getLongName());
        }
        return designObjectSet.getByName(designObject.getName(), caseSensitive);
    }

    private DesignObject getCorrespondingObject(List list, DesignObject designObject) {
        DesignObject designObject22;
        for (DesignObject designObject22 : list) {
            if (!(designObject22.getImportedId() != null && designObject22.getImportedId().equals(designObject.getObjectID()) || designObject.getImportedId() != null && designObject.getImportedId().equals(designObject22.getObjectID()) || designObject.getObjectID().equals(designObject22.getObjectID())) && (designObject.getImportedId() == null || designObject22.getImportedId() == null || !designObject.getImportedId().equals(designObject22.getImportedId()))) continue;
            return designObject22;
        }
        designObject22 = (DesignObject)CompareModelToModel.getCorrespondingImportedObject(list.iterator(), designObject, false);
        if (designObject22 != null) {
            return designObject22;
        }
        String string = designObject.getName();
        for (DesignObject designObject3 : list) {
            boolean bl = caseSensitive ? designObject3.getName().equals(string) : designObject3.getName().equalsIgnoreCase(string);
            if (!bl) continue;
            if (designObject3 instanceof Method) {
                if (this.objectsMap.containsValue(designObject3)) continue;
                return designObject3;
            }
            return designObject3;
        }
        return null;
    }

    private static ModelObject getCorrespondingImportedObject(Iterator iterator, ModelObject modelObject, boolean bl) {
        String string = modelObject.getSourceConnName();
        if (!"".equals(string)) {
            String string2 = modelObject.getSourceObjName();
            String string3 = modelObject.getSourceObjSchema();
            RelationalDesign relationalDesign = modelObject.getDesign().getRelationalDesign();
            while (iterator.hasNext()) {
                ModelObject modelObject2 = (ModelObject)iterator.next();
                if (!swapTarget) {
                    relationalDesign = modelObject2.getDesign().getRelationalDesign();
                }
                if ("".equals(modelObject2.getSourceConnName()) || !relationalDesign.isSameDB(string, modelObject2.getSourceConnName()) || !(caseSensitive ? string2.equals(modelObject2.getSourceObjName()) && (!bl || string3.equals(modelObject2.getSourceObjSchema())) : string2.equalsIgnoreCase(modelObject2.getSourceObjName()) && (!bl || string3.equalsIgnoreCase(modelObject2.getSourceObjSchema())))) continue;
                return modelObject2;
            }
        } else {
            String string4 = modelObject.getName();
            String string5 = "";
            if (modelObject instanceof DesignObject) {
                string5 = ((DesignObject)modelObject).getSchema();
            }
            while (iterator.hasNext()) {
                ModelObject modelObject3 = (ModelObject)iterator.next();
                if (!(caseSensitive ? string4.equals(modelObject3.getSourceObjName()) && (!bl || string5.equals(modelObject3.getSourceObjSchema())) : string4.equalsIgnoreCase(modelObject3.getSourceObjName()) && (!bl || string5.equalsIgnoreCase(modelObject3.getSourceObjSchema())))) continue;
                return modelObject3;
            }
        }
        return null;
    }

    private static ModelObject getCorrespondingImportedColumn(ContainedObject[] containedObjectArray, ModelObject modelObject) {
        if (!"".equals(modelObject.getSourceConnName())) {
            String string = modelObject.getSourceConnName();
            String string2 = modelObject.getSourceObjName();
            String string3 = modelObject.getSourceObjSchema();
            RelationalDesign relationalDesign = modelObject.getDesign().getRelationalDesign();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                ContainedObject containedObject = containedObjectArray[i];
                if (!swapTarget) {
                    relationalDesign = containedObject.getDesign().getRelationalDesign();
                }
                if ("".equals(containedObject.getSourceConnName()) || !relationalDesign.isSameDB(string, containedObject.getSourceConnName()) || !(caseSensitive ? string2.equals(containedObject.getSourceObjName()) && string3.equals(containedObject.getSourceObjSchema()) : string2.equalsIgnoreCase(containedObject.getSourceObjName()) && string3.equalsIgnoreCase(containedObject.getSourceObjSchema()))) continue;
                return containedObject;
            }
        }
        return null;
    }

    private void addTableView(TableView tableView, ModelIdObjectSelection modelIdObjectSelection, ModelIdObjectSelection modelIdObjectSelection2) {
        TableView tableView2 = (TableView)this.getCorrespondingObject(this.targetdes.getTableViewSet(), tableView, useSchema);
        TableViewProxy tableViewProxy = (TableViewProxy)this.getSourceStorageDesign().getTableViewProxySet().getProxy(tableView.getObjectID());
        TableViewProxy tableViewProxy2 = null;
        if (tableView2 != null) {
            tableViewProxy2 = (TableViewProxy)this.getTargetStorageDesign().getTableViewProxySet().getProxy(tableView2.getObjectID());
        }
        if (this.useGenerateInDDL && !this.isGenerateInDDL(tableViewProxy, tableViewProxy2)) {
            if (tableView != null && tableView2 != null) {
                this.objectsMap.put(tableView.getObjectID(), tableView2);
            }
            return;
        }
        CompareObjectSelection compareObjectSelection = new CompareObjectSelection(tableView);
        CompareObjectSelection compareObjectSelection2 = null;
        if (tableView2 != null) {
            compareObjectSelection2 = new CompareObjectSelection(tableView2);
            TableViewComparator tableViewComparator = new TableViewComparator(tableView, tableView2, tableViewProxy, tableViewProxy2);
            compareObjectSelection.setPropertiesComparator(tableViewComparator);
            compareObjectSelection2.setPropertiesComparator(tableViewComparator);
            this.comparatorsMap.put(tableViewComparator.getID(), tableViewComparator);
            compareObjectSelection.setSelected(tableViewComparator.isModified());
            this.objectsMap.put(tableView.getObjectID(), tableView2);
        } else {
            compareObjectSelection.setSelected(true);
            compareObjectSelection2 = new CompareObjectSelection(NEW_VIEW);
            TableViewComparator tableViewComparator = new TableViewComparator(tableView, tableView2, tableViewProxy, null);
            compareObjectSelection.setPropertiesComparator(tableViewComparator);
            compareObjectSelection2.setPropertiesComparator(tableViewComparator);
            compareObjectSelection2.setElementDescriptor(TableView.class);
            this.comparatorsMap.put(tableViewComparator.getID(), tableViewComparator);
            this.objectsMap.put(tableView.getObjectID(), null);
            compareObjectSelection.setStatus(STATE_NEW);
            compareObjectSelection2.setStatus(STATE_NEW);
            this.newMappings.add(compareObjectSelection);
        }
        compareObjectSelection2.setCorrespondentNode(compareObjectSelection);
        compareObjectSelection.setCorrespondentNode(compareObjectSelection2);
        modelIdObjectSelection.addChild(compareObjectSelection);
        modelIdObjectSelection2.addChild(compareObjectSelection2);
    }

    private void addFK(FKIndexAssociation fKIndexAssociation, CompareObjectSelection compareObjectSelection, CompareObjectSelection compareObjectSelection2) {
        FKIndexAssociation fKIndexAssociation2 = (FKIndexAssociation)this.getCorrespondingObject(this.targetdes.getFKIndexAssociationSet(), fKIndexAssociation, useSchema);
        ModelIDObject modelIDObject = this.getSourceStorageDesign().getStorageObject(fKIndexAssociation.getObjectID());
        if (modelIDObject == null) {
            modelIDObject = fKIndexAssociation;
        }
        ModelIDObject modelIDObject2 = null;
        if (fKIndexAssociation2 != null) {
            modelIDObject2 = this.getTargetStorageDesign().getStorageObject(fKIndexAssociation2.getObjectID());
        }
        if (modelIDObject2 == null) {
            modelIDObject2 = fKIndexAssociation2;
        }
        if (this.useGenerateInDDL && !this.isGenerateInDDL(modelIDObject, modelIDObject2)) {
            if (fKIndexAssociation != null && fKIndexAssociation2 != null) {
                this.objectsMap.put(fKIndexAssociation.getObjectID(), fKIndexAssociation2);
            }
            return;
        }
        CompareObjectSelection compareObjectSelection3 = new CompareObjectSelection(fKIndexAssociation);
        String string = fKIndexAssociation.getName() + " (" + fKIndexAssociation.getContainerWithKeyObject().getName() + " : " + fKIndexAssociation.getRemoteTable().getName() + " )";
        compareObjectSelection3.setName(string);
        compareObjectSelection3.setSelected(true);
        CompareObjectSelection compareObjectSelection4 = null;
        if (fKIndexAssociation2 != null) {
            compareObjectSelection4 = new CompareObjectSelection(fKIndexAssociation2);
            Table table = fKIndexAssociation2.getRemoteTable();
            if (table != null) {
                KeyObject keyObject = (KeyObject)this.getCorrespondingObject(table.getPK_UKList(), fKIndexAssociation.getKeyObject());
                if (keyObject == null) {
                    compareObjectSelection3.setSelected(true);
                    compareObjectSelection4 = new CompareObjectSelection(NEW_RELATION);
                    compareObjectSelection3.setStatus(STATE_NEW);
                    compareObjectSelection4.setStatus(STATE_NEW);
                    this.newMappings.add(compareObjectSelection3);
                    compareObjectSelection4.setElementDescriptor(FKIndexAssociation.class);
                    FKComparator fKComparator = new FKComparator(fKIndexAssociation, null, false, false);
                    compareObjectSelection3.setPropertiesComparator(fKComparator);
                    compareObjectSelection4.setPropertiesComparator(fKComparator);
                    this.comparatorsMap.put(fKComparator.getID(), fKComparator);
                    this.objectsMap.put(fKIndexAssociation.getObjectID(), null);
                } else {
                    DesignObject designObject;
                    Column[] columnArray;
                    Column[] columnArray2;
                    boolean bl;
                    boolean bl2 = false;
                    KeyObject keyObject2 = fKIndexAssociation2.getKeyObject();
                    if (keyObject2 != null && keyObject2.getObjectID().equals(keyObject.getObjectID())) {
                        bl2 = true;
                    }
                    boolean bl3 = bl = (columnArray2 = fKIndexAssociation.getColumns()).length == (columnArray = fKIndexAssociation2.getColumns()).length;
                    if (bl) {
                        for (int i = 0; i < columnArray2.length; ++i) {
                            designObject = (Column)this.objectsMap.get(columnArray2[i].getObjectID());
                            if (designObject != null && designObject.getObjectID().equals(columnArray[i].getObjectID())) continue;
                            bl = false;
                            break;
                        }
                    }
                    FKComparator fKComparator = new FKComparator(fKIndexAssociation, fKIndexAssociation2, bl2, bl);
                    compareObjectSelection3.setPropertiesComparator(fKComparator);
                    compareObjectSelection4.setPropertiesComparator(fKComparator);
                    compareObjectSelection4.setSelected(fKComparator.isModified());
                    compareObjectSelection3.setSelected(fKComparator.isModified());
                    designObject = (Table)fKIndexAssociation2.getContainerWithKeyObject();
                    Table table2 = fKIndexAssociation2.getRemoteTable();
                    if (designObject != null && table2 != null) {
                        String string2 = fKIndexAssociation2.getName() + " (" + designObject.getName() + " : " + table2.getName() + ")";
                        compareObjectSelection4.setName(string2);
                    }
                    this.comparatorsMap.put(fKComparator.getID(), fKComparator);
                    this.objectsMap.put(fKIndexAssociation.getObjectID(), fKIndexAssociation2);
                    this.objectsMap.put(fKIndexAssociation.getLocalFKIndex().getObjectID(), fKIndexAssociation2.getLocalFKIndex());
                }
            }
        } else {
            compareObjectSelection3.setSelected(true);
            compareObjectSelection4 = new CompareObjectSelection(NEW_RELATION);
            compareObjectSelection3.setStatus(STATE_NEW);
            compareObjectSelection4.setStatus(STATE_NEW);
            this.newMappings.add(compareObjectSelection3);
            compareObjectSelection4.setElementDescriptor(FKIndexAssociation.class);
            FKComparator fKComparator = new FKComparator(fKIndexAssociation, null, false, false);
            compareObjectSelection3.setPropertiesComparator(fKComparator);
            compareObjectSelection4.setPropertiesComparator(fKComparator);
            this.comparatorsMap.put(fKComparator.getID(), fKComparator);
            this.objectsMap.put(fKIndexAssociation.getObjectID(), null);
        }
        compareObjectSelection4.setCorrespondentNode(compareObjectSelection3);
        compareObjectSelection3.setCorrespondentNode(compareObjectSelection4);
        compareObjectSelection.addChild(compareObjectSelection3);
        compareObjectSelection2.addChild(compareObjectSelection4);
    }

    private void addFromSourceModel() {
        List list;
        boolean bl = false;
        FilteredSelection filteredSelection = new FilteredSelection(Messages.getString("CompareModelToModel.Tables"));
        FilteredSelection filteredSelection2 = new FilteredSelection(Messages.getString("CompareModelToModel.Tables"));
        filteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        filteredSelection2.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        FilteredSelection filteredSelection3 = new FilteredSelection(Messages.getString("CompareModelToModel.Views"));
        FilteredSelection filteredSelection4 = new FilteredSelection(Messages.getString("CompareModelToModel.Views"));
        filteredSelection3.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        filteredSelection4.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        FilteredSelection filteredSelection5 = new FilteredSelection(Messages.getString("CompareModelToModel.Snapshots"));
        FilteredSelection filteredSelection6 = new FilteredSelection(Messages.getString("CompareModelToModel.Snapshots"));
        filteredSelection5.setIcon(GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_FOLDER_ICON"));
        filteredSelection6.setIcon(GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_FOLDER_ICON"));
        FilteredSelection filteredSelection7 = new FilteredSelection(Messages.getString("CompareModelToModel.Sequences"));
        FilteredSelection filteredSelection8 = new FilteredSelection(Messages.getString("CompareModelToModel.Sequences"));
        filteredSelection7.setIcon(GUIConfiguration.getInstance().getIcon("SEQUENCE_FOLDER_ICON"));
        filteredSelection8.setIcon(GUIConfiguration.getInstance().getIcon("SEQUENCE_FOLDER_ICON"));
        filteredSelection.setCorrespondentNode(filteredSelection2);
        filteredSelection2.setCorrespondentNode(filteredSelection);
        filteredSelection3.setCorrespondentNode(filteredSelection4);
        filteredSelection4.setCorrespondentNode(filteredSelection3);
        this.setEmptyComparator(filteredSelection2);
        this.setEmptyComparator(filteredSelection4);
        filteredSelection2.setSelected(false);
        filteredSelection4.setSelected(false);
        this.setEmptyComparator(filteredSelection);
        this.setEmptyComparator(filteredSelection3);
        if (this.buildDataTypes) {
            this.addDataTypes();
        }
        boolean bl2 = this.syncMode;
        if (this.getSourceStorageDesign() instanceof StorageDesignOracle) {
            list = this.getTables((StorageDesignOracle)this.getSourceStorageDesign());
        } else {
            list = new ArrayList();
            this.sourcedes.getTableSet().addAllElementsTo(list);
        }
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        for (ModelIDObject modelIDObject : list) {
            if (bl2 && this.selectedIDs != null) {
                if (!this.selectedIDs.containsKey(modelIDObject.getObjectID())) continue;
                this.addTable((Table)modelIDObject, filteredSelection, filteredSelection2);
                continue;
            }
            this.addTable((Table)modelIDObject, filteredSelection, filteredSelection2);
        }
        list.clear();
        this.sourcedes.getTableViewSet().addAllElementsTo(list);
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        for (ModelIDObject modelIDObject : list) {
            if (bl2 && this.selectedIDs != null) {
                if (!this.selectedIDs.containsKey(modelIDObject.getObjectID())) continue;
                this.addTableView((TableView)modelIDObject, filteredSelection3, filteredSelection4);
                continue;
            }
            this.addTableView((TableView)modelIDObject, filteredSelection3, filteredSelection4);
        }
        if (ModelChooserDialog.isSelectedDatabase && this.sourcedes.getStorageDesign() instanceof StorageDesignOracle) {
            ModelIDObject modelIDObject;
            bl = true;
            filteredSelection5.setCorrespondentNode(filteredSelection6);
            filteredSelection6.setCorrespondentNode(filteredSelection5);
            filteredSelection7.setCorrespondentNode(filteredSelection8);
            filteredSelection8.setCorrespondentNode(filteredSelection7);
            this.setEmptyComparator(filteredSelection6);
            this.setEmptyComparator(filteredSelection8);
            filteredSelection6.setSelected(false);
            filteredSelection8.setSelected(false);
            this.setEmptyComparator(filteredSelection5);
            this.setEmptyComparator(filteredSelection7);
            modelIDObject = (StorageDesignOracle)this.getSourceStorageDesign();
            list.clear();
            ((StorageDesignOracle)modelIDObject).getSnapshotSet().addAllElementsTo(list);
            Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
            for (AbstractStorageObjectOracle abstractStorageObjectOracle : list) {
                if (bl2 && this.selectedIDs != null) {
                    if (!this.selectedIDs.containsKey(abstractStorageObjectOracle.getImplementedTable().getObjectID())) continue;
                    this.addSnapshot((SnapshotOracle)abstractStorageObjectOracle, filteredSelection5, filteredSelection6);
                    continue;
                }
                this.addSnapshot((SnapshotOracle)abstractStorageObjectOracle, filteredSelection5, filteredSelection6);
            }
            if (this.selectedIDs == null) {
                list.clear();
                ((StorageDesignOracle)modelIDObject).getSequenceSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                for (AbstractStorageObjectOracle abstractStorageObjectOracle : list) {
                    this.addSequence((SequenceOracle)abstractStorageObjectOracle, filteredSelection7, filteredSelection8);
                }
            }
        }
        this.addDeletedTables(filteredSelection, filteredSelection2);
        this.addDeletedTableViews(filteredSelection3, filteredSelection4);
        if (bl) {
            this.addDeletedSnapshots(filteredSelection5, filteredSelection6);
            if (this.selectedIDs == null) {
                this.addDeletedSequences(filteredSelection7, filteredSelection8);
            }
        }
        this.addChild(filteredSelection);
        this.rightRelationalRoot.addChild(filteredSelection2);
        this.addChild(filteredSelection3);
        this.rightRelationalRoot.addChild(filteredSelection4);
        if (bl) {
            this.addChild(filteredSelection5);
            this.rightRelationalRoot.addChild(filteredSelection6);
            this.addChild(filteredSelection7);
            this.rightRelationalRoot.addChild(filteredSelection8);
        }
    }

    private List getTables(StorageDesignOracle storageDesignOracle) {
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        Iterator iterator = storageDesignOracle.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            arrayList.add(tableProxyOracle.getObject());
        }
        return arrayList;
    }

    private void addSequence(SequenceOracle sequenceOracle, ModelIdObjectSelection modelIdObjectSelection, ModelIdObjectSelection modelIdObjectSelection2) {
        Object object;
        Object object2;
        CompareObjectSelection compareObjectSelection = new CompareObjectSelection(sequenceOracle);
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getTargetStorageDesign();
        SequenceOracle sequenceOracle2 = (SequenceOracle)CompareModelToModel.getCorrespondingImportedObject(storageDesignOracle.getSequenceSet().iterator(), sequenceOracle, useSchema);
        if (sequenceOracle2 == null) {
            object2 = sequenceOracle.getName();
            object = sequenceOracle.getUser() == null ? "" : sequenceOracle.getUser().getName();
            sequenceOracle2 = (SequenceOracle)storageDesignOracle.getSequenceSet().getByUserSchemaAndName((String)object, (String)object2);
            if (sequenceOracle2 == null && !useSchema) {
                sequenceOracle2 = (SequenceOracle)storageDesignOracle.getSequenceSet().getByName((String)object2);
            }
        }
        object2 = null;
        if (sequenceOracle2 != null) {
            object2 = new CompareObjectSelection(sequenceOracle2);
            object = new SequenceComparator(sequenceOracle, sequenceOracle2);
            compareObjectSelection.setPropertiesComparator((PropertiesComparator)object);
            ((CompareObjectSelection)object2).setPropertiesComparator((PropertiesComparator)object);
            this.comparatorsMap.put(((StoragePropertiesComparator)object).getID(), object);
            compareObjectSelection.setSelected(((PropertiesComparator)object).isModified());
            this.objectsMap.put(sequenceOracle.getObjectID(), sequenceOracle2);
        } else {
            compareObjectSelection.setSelected(true);
            object2 = new CompareObjectSelection(NEW_SEQUENCE);
            object = new SequenceComparator(sequenceOracle, sequenceOracle2);
            compareObjectSelection.setPropertiesComparator((PropertiesComparator)object);
            ((CompareObjectSelection)object2).setPropertiesComparator((PropertiesComparator)object);
            ((ModelIdObjectSelection)object2).setElementDescriptor(SequenceOracle.class);
            this.comparatorsMap.put(((StoragePropertiesComparator)object).getID(), object);
            this.objectsMap.put(sequenceOracle.getObjectID(), null);
            compareObjectSelection.setStatus(STATE_NEW);
            ((CompareObjectSelection)object2).setStatus(STATE_NEW);
            this.newMappings.add(compareObjectSelection);
        }
        ((CompareObjectSelection)object2).setCorrespondentNode(compareObjectSelection);
        compareObjectSelection.setCorrespondentNode((CompareObjectSelection)object2);
        modelIdObjectSelection.addChild(compareObjectSelection);
        modelIdObjectSelection2.addChild((ModelIdObjectSelection)object2);
    }

    private void addDeletedSnapshots(ModelIdObjectSelection modelIdObjectSelection, ModelIdObjectSelection modelIdObjectSelection2) {
        StorageDesign storageDesign = this.targetdes.getStorageDesign();
        if (storageDesign instanceof StorageDesignOracle) {
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)storageDesign;
            Iterator iterator = storageDesignOracle.getSnapshotSet().iterator();
            while (iterator.hasNext()) {
                SnapshotOracle snapshotOracle = (SnapshotOracle)iterator.next();
                if (this.selectedIDs != null && !this.selectedIDs.containsKey(snapshotOracle.getImplementedTable().getObjectID()) || this.objectsMap.containsValue(snapshotOracle)) continue;
                CompareObjectSelection compareObjectSelection = new CompareObjectSelection(TO_DROP);
                this.deletedMappings.add(compareObjectSelection);
                compareObjectSelection.setSelected(false);
                CompareObjectSelection compareObjectSelection2 = new CompareObjectSelection(snapshotOracle);
                compareObjectSelection.setElementDescriptor(SnapshotOracle.class);
                SnapshotComparator snapshotComparator = new SnapshotComparator(null, snapshotOracle, this.objectsMap);
                this.comparatorsMap.put(snapshotComparator.getID(), snapshotComparator);
                compareObjectSelection.setPropertiesComparator(snapshotComparator);
                compareObjectSelection2.setPropertiesComparator(snapshotComparator);
                compareObjectSelection.setStatus(STATE_DELETED);
                compareObjectSelection2.setStatus(STATE_DELETED);
                compareObjectSelection2.setCorrespondentNode(compareObjectSelection);
                compareObjectSelection.setCorrespondentNode(compareObjectSelection2);
                modelIdObjectSelection.addChild(compareObjectSelection);
                modelIdObjectSelection2.addChild(compareObjectSelection2);
            }
        }
    }

    private void addDeletedSequences(ModelIdObjectSelection modelIdObjectSelection, ModelIdObjectSelection modelIdObjectSelection2) {
        StorageDesign storageDesign = this.targetdes.getStorageDesign();
        if (storageDesign instanceof StorageDesignOracle) {
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)storageDesign;
            Iterator iterator = storageDesignOracle.getSequenceSet().iterator();
            while (iterator.hasNext()) {
                SequenceOracle sequenceOracle = (SequenceOracle)iterator.next();
                if (this.objectsMap.containsValue(sequenceOracle)) continue;
                CompareObjectSelection compareObjectSelection = new CompareObjectSelection(TO_DROP);
                this.deletedMappings.add(compareObjectSelection);
                compareObjectSelection.setSelected(false);
                CompareObjectSelection compareObjectSelection2 = new CompareObjectSelection(sequenceOracle);
                compareObjectSelection.setElementDescriptor(SequenceOracle.class);
                SequenceComparator sequenceComparator = new SequenceComparator(null, sequenceOracle);
                this.comparatorsMap.put(sequenceComparator.getID(), sequenceComparator);
                compareObjectSelection.setPropertiesComparator(sequenceComparator);
                compareObjectSelection2.setPropertiesComparator(sequenceComparator);
                compareObjectSelection.setStatus(STATE_DELETED);
                compareObjectSelection2.setStatus(STATE_DELETED);
                compareObjectSelection2.setCorrespondentNode(compareObjectSelection);
                compareObjectSelection.setCorrespondentNode(compareObjectSelection2);
                modelIdObjectSelection.addChild(compareObjectSelection);
                modelIdObjectSelection2.addChild(compareObjectSelection2);
            }
        }
    }

    private void addSnapshot(SnapshotOracle snapshotOracle, ModelIdObjectSelection modelIdObjectSelection, ModelIdObjectSelection modelIdObjectSelection2) {
        CompareObjectSelection compareObjectSelection = new CompareObjectSelection(snapshotOracle);
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getTargetStorageDesign();
        SnapshotOracle snapshotOracle2 = (SnapshotOracle)CompareModelToModel.getCorrespondingImportedObject(storageDesignOracle.getSnapshotSet().iterator(), snapshotOracle, useSchema);
        if (snapshotOracle2 == null) {
            snapshotOracle2 = (SnapshotOracle)storageDesignOracle.getSnapshotSet().getByName(snapshotOracle.getName());
        }
        CompareObjectSelection compareObjectSelection2 = null;
        if (snapshotOracle2 != null) {
            compareObjectSelection2 = new CompareObjectSelection(snapshotOracle2);
            SnapshotComparator snapshotComparator = new SnapshotComparator(snapshotOracle, snapshotOracle2, this.objectsMap);
            compareObjectSelection.setPropertiesComparator(snapshotComparator);
            compareObjectSelection2.setPropertiesComparator(snapshotComparator);
            this.comparatorsMap.put(snapshotComparator.getID(), snapshotComparator);
            compareObjectSelection.setSelected(snapshotComparator.isModified());
            this.objectsMap.put(snapshotOracle.getObjectID(), snapshotOracle2);
        } else {
            compareObjectSelection.setSelected(true);
            compareObjectSelection2 = new CompareObjectSelection(NEW_SNAPSHOT);
            SnapshotComparator snapshotComparator = new SnapshotComparator(snapshotOracle, snapshotOracle2, this.objectsMap);
            compareObjectSelection.setPropertiesComparator(snapshotComparator);
            compareObjectSelection2.setPropertiesComparator(snapshotComparator);
            compareObjectSelection2.setElementDescriptor(TableView.class);
            this.comparatorsMap.put(snapshotComparator.getID(), snapshotComparator);
            this.objectsMap.put(snapshotOracle.getObjectID(), null);
            compareObjectSelection.setStatus(STATE_NEW);
            compareObjectSelection2.setStatus(STATE_NEW);
            this.newMappings.add(compareObjectSelection);
        }
        compareObjectSelection2.setCorrespondentNode(compareObjectSelection);
        compareObjectSelection.setCorrespondentNode(compareObjectSelection2);
        modelIdObjectSelection.addChild(compareObjectSelection);
        modelIdObjectSelection2.addChild(compareObjectSelection2);
    }

    private void addColumn(Column column, Table table, FilteredSelection filteredSelection, FilteredSelection filteredSelection2, int n) {
        Object object;
        ColumnSelection columnSelection = new ColumnSelection(column);
        ModelIdObjectSelection modelIdObjectSelection = null;
        ColumnProxy columnProxy = (ColumnProxy)this.getSourceStorageDesign().getColumnProxySet().getProxy(column.getObjectID());
        Column column2 = null;
        if (table != null && (column2 = (Column)this.getCorrespondingColumn(table.getElements(), column, n)) != null) {
            modelIdObjectSelection = new FilteredSelection(column2);
            object = (ColumnProxy)this.getTargetStorageDesign().getColumnProxySet().getProxy(column2.getObjectID());
            ColumnComparator columnComparator = new ColumnComparator(column, column2, columnProxy, (ColumnProxy)object);
            columnSelection.setPropertiesComparator(columnComparator);
            ((CompareObjectSelection)modelIdObjectSelection).setPropertiesComparator(columnComparator);
            this.comparatorsMap.put(columnComparator.getID(), columnComparator);
            ((CompareObjectSelection)columnSelection).setSelected(columnComparator.isModified());
            columnSelection.setEditable(columnComparator.isModified());
            this.objectsMap.put(column.getObjectID(), column2);
        }
        if (column2 == null) {
            ((CompareObjectSelection)columnSelection).setSelected(true);
            modelIdObjectSelection = new FilteredSelection(NEW_COLUMN);
            ((CompareObjectSelection)modelIdObjectSelection).setStatus(STATE_NEW);
            columnSelection.setStatus(STATE_NEW);
            this.newMappings.add(columnSelection);
            object = new ColumnComparator(column, column2, columnProxy, null);
            columnSelection.setPropertiesComparator((PropertiesComparator)object);
            ((CompareObjectSelection)modelIdObjectSelection).setPropertiesComparator((PropertiesComparator)object);
            this.comparatorsMap.put(((PropertiesComparator)object).getID(), object);
            this.objectsMap.put(column.getObjectID(), null);
        }
        modelIdObjectSelection.setElementDescriptor(Column.class);
        columnSelection.setCorrespondentNode((CompareObjectSelection)modelIdObjectSelection);
        ((CompareObjectSelection)modelIdObjectSelection).setCorrespondentNode(columnSelection);
        filteredSelection.addChild(columnSelection);
        filteredSelection2.addChild(modelIdObjectSelection);
        if (((ColumnComparator)((CompareObjectSelection)modelIdObjectSelection).getPropertiesComparator()).isDataTypeChanged()) {
            this.columnsWithChangedDataType.add(modelIdObjectSelection);
        }
    }

    private DesignObject getCorrespondingColumn(ContainedObject[] containedObjectArray, Column column, int n) {
        ContainedObject containedObject;
        Object object;
        DesignObject designObject;
        CompareMapping compareMapping = this.sourcedes.getDesign().getDLSettings().getCompareMapping();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ContainedObject containedObject2 = containedObjectArray[i];
            if (!(containedObject2.getImportedId() != null && containedObject2.getImportedId().equals(column.getObjectID()) || column.getImportedId() != null && column.getImportedId().equals(containedObject2.getObjectID()) || column.getObjectID().equals(containedObject2.getObjectID())) && (containedObject2.getImportedId() == null || column.getImportedId() == null || !containedObject2.getImportedId().equals(column.getImportedId()))) continue;
            return containedObject2;
        }
        DesignObject designObject2 = (DesignObject)CompareModelToModel.getCorrespondingImportedColumn(containedObjectArray, column);
        if (designObject2 != null) {
            return designObject2;
        }
        for (int i = 0; i < containedObjectArray.length; ++i) {
            designObject = containedObjectArray[i];
            if (!(caseSensitive ? designObject.getName().equals(column.getName()) : designObject.getName().equalsIgnoreCase(column.getName()))) continue;
            return designObject;
        }
        if (compareMapping.getCompareMap().containsKey(column.getName())) {
            Table table;
            Column column2 = column;
            designObject = (Table)column2.getContainer();
            object = compareMapping.getCompareMap().get(column.getName());
            if (object != null && ((CompareMappingObject)object).isSelected() && designObject.getName().equals(((CompareMappingObject)object).getSourceParentName()) && (table = (Table)this.targetdes.getTableSet().getByName(((CompareMappingObject)object).getTargetParentName())) != null) {
                Column column3 = (Column)table.getElementByName(((CompareMappingObject)object).getTargetObjectName());
                return column3;
            }
        }
        if (n < containedObjectArray.length && (containedObject = containedObjectArray[n]) instanceof Column) {
            designObject = (Column)containedObject;
            object = column;
            if (((ContainedObject)designObject).getIndex() == column.getIndex() && ((Column)designObject).getDataType().toString().equals(((Column)object).getDataType().toString()) && ((ContainedObject)object).getContainer().getElementByName(((ContainedObject)designObject).getName()) == null) {
                return designObject;
            }
        }
        return null;
    }

    private void addTableDetails(Table table, CompareObjectSelection compareObjectSelection, Table table2, CompareObjectSelection compareObjectSelection2) {
        ModelObject modelObject42;
        ModelObject modelObject222;
        ModelObject modelObject3;
        FilteredSelection filteredSelection = new FilteredSelection(Messages.getString("CompareModelToModel.Columns"));
        FilteredSelection filteredSelection2 = new FilteredSelection(Messages.getString("CompareModelToModel.Columns"));
        filteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        filteredSelection2.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        filteredSelection.setCorrespondentNode(filteredSelection2);
        filteredSelection2.setCorrespondentNode(filteredSelection);
        this.setEmptyComparator(filteredSelection);
        this.setEmptyComparator(filteredSelection2);
        filteredSelection2.setSelected(false);
        Iterator<Object> iterator = table.getElementsCollection().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            modelObject3 = (Column)iterator.next();
            this.addColumn((Column)modelObject3, table2, filteredSelection, filteredSelection2, n);
            ++n;
        }
        if (table2 != null) {
            this.addDeletedColumns(table, filteredSelection, table2, filteredSelection2);
        }
        compareObjectSelection.addChild(filteredSelection);
        compareObjectSelection2.addChild(filteredSelection2);
        ((TableComparator)compareObjectSelection.getPropertiesComparator()).presetColumnsOrder();
        this.initIndexes(table);
        modelObject3 = new FilteredSelection(Messages.getString("CompareModelToModel.Indexes"));
        FilteredSelection filteredSelection3 = new FilteredSelection(Messages.getString("CompareModelToModel.Indexes"));
        modelObject3.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        filteredSelection3.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        ((CompareObjectSelection)modelObject3).setCorrespondentNode(filteredSelection3);
        filteredSelection3.setCorrespondentNode((CompareObjectSelection)modelObject3);
        this.setEmptyComparator((CompareObjectSelection)modelObject3);
        this.setEmptyComparator(filteredSelection3);
        filteredSelection3.setSelected(false);
        for (ModelObject modelObject222 : this.indexes) {
            this.addIndex((Index)modelObject222, table2, (FilteredSelection)modelObject3, filteredSelection3, false);
        }
        if (table2 != null) {
            this.addDeletedIndexes(table2, (FilteredSelection)modelObject3, filteredSelection3, false);
        }
        compareObjectSelection.addChild((ModelIdObjectSelection)modelObject3);
        compareObjectSelection2.addChild(filteredSelection3);
        modelObject222 = new FilteredSelection(Messages.getString("CompareModelToModel.PKUKConstraints"));
        FilteredSelection filteredSelection4 = new FilteredSelection(Messages.getString("CompareModelToModel.PKUKConstraints"));
        modelObject222.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        filteredSelection4.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        ((CompareObjectSelection)modelObject222).setCorrespondentNode(filteredSelection4);
        filteredSelection4.setCorrespondentNode((CompareObjectSelection)modelObject222);
        this.setEmptyComparator((CompareObjectSelection)modelObject222);
        this.setEmptyComparator(filteredSelection4);
        filteredSelection4.setSelected(false);
        for (ModelObject modelObject42 : this.pkInd) {
            this.addIndex((Index)modelObject42, table2, (FilteredSelection)modelObject222, filteredSelection4, true);
        }
        if (table2 != null) {
            this.addDeletedIndexes(table2, (FilteredSelection)modelObject222, filteredSelection4, true);
        }
        compareObjectSelection.addChild((ModelIdObjectSelection)modelObject222);
        compareObjectSelection2.addChild(filteredSelection4);
        modelObject42 = new FilteredSelection(Messages.getString("CompareModelToModel.ForeignKeys"));
        FilteredSelection filteredSelection5 = new FilteredSelection(Messages.getString("CompareModelToModel.ForeignKeys"));
        modelObject42.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        filteredSelection5.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        ((CompareObjectSelection)modelObject42).setCorrespondentNode(filteredSelection5);
        filteredSelection5.setCorrespondentNode((CompareObjectSelection)modelObject42);
        this.setEmptyComparator((CompareObjectSelection)modelObject42);
        this.setEmptyComparator(filteredSelection5);
        filteredSelection5.setSelected(false);
        List<FKIndexAssociation> list = Arrays.asList(table.getFKAssociations());
        for (FKIndexAssociation object2 : list) {
            this.addFK(object2, (CompareObjectSelection)modelObject42, filteredSelection5);
        }
        if (table2 != null) {
            this.addDeletedFKAssociation(table2, (FilteredSelection)modelObject42, filteredSelection5);
        }
        compareObjectSelection.addChild((ModelIdObjectSelection)modelObject42);
        compareObjectSelection2.addChild(filteredSelection5);
        String string = Messages.getString("CompareModelToModel.TableCheckConstraints");
        FilteredSelection filteredSelection6 = new FilteredSelection(string);
        FilteredSelection filteredSelection7 = new FilteredSelection(string);
        filteredSelection6.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON"));
        filteredSelection7.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON"));
        filteredSelection6.setCorrespondentNode(filteredSelection7);
        filteredSelection7.setCorrespondentNode(filteredSelection6);
        this.setEmptyComparator(filteredSelection6);
        this.setEmptyComparator(filteredSelection7);
        filteredSelection7.setSelected(false);
        for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
            this.addCheckConstraint(tableLevelConstraint, table2, filteredSelection6, filteredSelection7);
        }
        if (table2 != null) {
            this.addDeletedCheckConstraints(table2, filteredSelection6, filteredSelection7);
        }
        compareObjectSelection.addChild(filteredSelection6);
        compareObjectSelection2.addChild(filteredSelection7);
    }

    private void addDeletedFKAssociation(Table table, FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        for (FKIndexAssociation fKIndexAssociation : Arrays.asList(table.getFKAssociations())) {
            if (this.objectsMap.containsValue(fKIndexAssociation)) continue;
            ModelIDObject modelIDObject = null;
            if (fKIndexAssociation != null) {
                modelIDObject = this.getTargetStorageDesign().getStorageObject(fKIndexAssociation.getObjectID());
            }
            if (modelIDObject == null) {
                modelIDObject = fKIndexAssociation;
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, modelIDObject)) continue;
            String string = fKIndexAssociation.getName() + " (" + fKIndexAssociation.getContainerWithKeyObject().getName() + " : " + fKIndexAssociation.getRemoteTable().getName() + " )";
            FilteredSelection filteredSelection3 = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection3);
            filteredSelection3.setSelected(false);
            FilteredSelection filteredSelection4 = new FilteredSelection(fKIndexAssociation);
            filteredSelection4.setElementDescriptor(FKIndexAssociation.class);
            filteredSelection3.setElementDescriptor(FKIndexAssociation.class);
            this.setEmptyComparator(filteredSelection3);
            FKComparator fKComparator = new FKComparator(null, fKIndexAssociation, false, false);
            this.comparatorsMap.put(fKComparator.getID(), fKComparator);
            filteredSelection4.setPropertiesComparator(fKComparator);
            filteredSelection4.setName(string);
            filteredSelection3.setStatus(STATE_DELETED);
            filteredSelection4.setStatus(STATE_DELETED);
            filteredSelection4.setCorrespondentNode(filteredSelection3);
            filteredSelection3.setCorrespondentNode(filteredSelection4);
            filteredSelection.addChild(filteredSelection3);
            filteredSelection2.addChild(filteredSelection4);
        }
    }

    private void initIndexes(Table table) {
        this.clearIndexList();
        Iterator iterator = table.getKeySet().iterator();
        while (iterator.hasNext()) {
            KeyObject keyObject = (KeyObject)iterator.next();
            if (keyObject.isPK() || keyObject.isUnique()) {
                this.pkInd.add(keyObject);
                continue;
            }
            if (keyObject.isFK()) continue;
            this.indexes.add(keyObject);
        }
    }

    private void clearIndexList() {
        this.pkInd.clear();
        this.fkInd.clear();
        this.indexes.clear();
    }

    private void addIndex(Index index, Table table, FilteredSelection filteredSelection, FilteredSelection filteredSelection2, boolean bl) {
        Object object;
        ModelObject modelObject;
        Object object2;
        Index index2 = null;
        if (table != null) {
            object2 = bl ? table.getPK_UKList() : table.getIndexes_Plain_List();
            index2 = (Index)this.getCorrespondingObject((List)object2, index);
            modelObject = this.getSourceStorageDesign().getStorageObject(index.getObjectID());
            if (modelObject == null) {
                modelObject = index;
            }
            object = null;
            if (index2 != null) {
                object = this.getTargetStorageDesign().getStorageObject(index2.getObjectID());
            }
            if (object == null) {
                object = index2;
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL((ModelIDObject)modelObject, (ModelIDObject)object)) {
                if (index != null && index2 != null) {
                    this.objectsMap.put(index.getObjectID(), index2);
                }
                return;
            }
        }
        object2 = new FilteredSelection(index);
        ((CompareObjectSelection)object2).setSelected(true);
        modelObject = null;
        if (table != null) {
            if (index2 == null) {
                index2 = this.checkForEqualStructure(index, table, filteredSelection);
            }
            if (index2 != null) {
                modelObject = new FilteredSelection(index2);
                object = new IndexComparator(index, index2, this.objectsMap);
                ((CompareObjectSelection)object2).setPropertiesComparator((PropertiesComparator)object);
                ((CompareObjectSelection)modelObject).setPropertiesComparator((PropertiesComparator)object);
                this.comparatorsMap.put(((PropertiesComparator)object).getID(), object);
                ((CompareObjectSelection)object2).setSelected(((PropertiesComparator)object).isModified());
                ((CompareObjectSelection)object2).setEditable(((PropertiesComparator)object).isModified());
                ((PropertiesComparator)object).setLeftSelectionObject((CompareObjectSelection)object2);
                this.objectsMap.put(index.getObjectID(), index2);
            }
        }
        if (index2 == null) {
            ((CompareObjectSelection)object2).setSelected(true);
            modelObject = new FilteredSelection(NEW_INDEX);
            ((CompareObjectSelection)modelObject).setStatus(STATE_NEW);
            ((CompareObjectSelection)object2).setStatus(STATE_NEW);
            this.newMappings.add(object2);
            ((ModelIdObjectSelection)modelObject).setElementDescriptor(Index.class);
            object = new IndexComparator(index, index2, this.objectsMap);
            ((CompareObjectSelection)object2).setPropertiesComparator((PropertiesComparator)object);
            ((CompareObjectSelection)modelObject).setPropertiesComparator((PropertiesComparator)object);
            this.comparatorsMap.put(((PropertiesComparator)object).getID(), object);
            this.objectsMap.put(index.getObjectID(), null);
        }
        ((CompareObjectSelection)object2).setCorrespondentNode((CompareObjectSelection)modelObject);
        ((CompareObjectSelection)modelObject).setCorrespondentNode((CompareObjectSelection)object2);
        filteredSelection2.addChild((ModelIdObjectSelection)modelObject);
        filteredSelection.addChild((ModelIdObjectSelection)object2);
    }

    private Index checkForEqualStructure(Index index, Table table, FilteredSelection filteredSelection) {
        block4: {
            Table table2;
            block5: {
                block3: {
                    table2 = (Table)index.getContainerObject();
                    if (!index.isPK()) break block3;
                    Index index2 = (Index)table.getPK();
                    if (index2 != null && this.checkIndexes(index, index2)) {
                        return index2;
                    }
                    break block4;
                }
                if (!index.isUnique()) break block5;
                Iterator iterator = table.getUKeys().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Index index3 = e instanceof ContainerObjectPlaceHolder ? (Index)((ContainerObjectPlaceHolder)e).getObject() : (Index)e;
                    if (!this.checkIndexes(index, index3) || table2.getUKeys().getByName(index3.getName()) != null) continue;
                    return index3;
                }
                break block4;
            }
            if (index.isFK()) break block4;
            Iterator iterator = table.getIndexes().iterator();
            while (iterator.hasNext()) {
                Index index4 = (Index)((ContainerObjectPlaceHolder)iterator.next()).getObject();
                if (!this.checkIndexes(index, index4) || table2.getIndexes().getByName(index4.getName()) != null) continue;
                return index4;
            }
        }
        return null;
    }

    private boolean checkIndexes(Index index, Index index2) {
        ContainedObject[] containedObjectArray;
        ContainedObject[] containedObjectArray2 = index.getElements();
        if (containedObjectArray2.length != (containedObjectArray = index2.getElements()).length) {
            return false;
        }
        for (int i = 0; i < containedObjectArray2.length; ++i) {
            Column column = (Column)containedObjectArray2[i];
            Column column2 = (Column)this.objectsMap.get(column.getObjectID());
            if (column2 == null) {
                return false;
            }
            if (column2.getName().equals(((Column)containedObjectArray[i]).getName())) continue;
            return false;
        }
        return true;
    }

    private void addCheckConstraint(TableLevelConstraint tableLevelConstraint, Table table, FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        TableConstraintComparator tableConstraintComparator;
        FilteredSelection filteredSelection3 = new FilteredSelection(tableLevelConstraint);
        filteredSelection3.setSelected(true);
        CompareObjectSelection compareObjectSelection = null;
        TableLevelConstraint tableLevelConstraint2 = null;
        if (table != null) {
            tableLevelConstraint2 = (TableLevelConstraint)this.getCorrespondingObject(table.getCheckConstraints(), tableLevelConstraint);
            if (tableLevelConstraint2 == null) {
                tableLevelConstraint2 = this.checkForEqualRule(tableLevelConstraint, table);
            }
            if (tableLevelConstraint2 != null) {
                compareObjectSelection = new FilteredSelection(tableLevelConstraint2);
                tableConstraintComparator = new TableConstraintComparator(tableLevelConstraint, tableLevelConstraint2);
                filteredSelection3.setPropertiesComparator(tableConstraintComparator);
                compareObjectSelection.setPropertiesComparator(tableConstraintComparator);
                this.comparatorsMap.put(tableConstraintComparator.getID(), tableConstraintComparator);
                filteredSelection3.setSelected(tableConstraintComparator.isModified());
                filteredSelection3.setEditable(tableConstraintComparator.isModified());
                tableConstraintComparator.setLeftSelectionObject(filteredSelection3);
                this.objectsMap.put(tableLevelConstraint.getObjectID(), tableLevelConstraint2);
            }
        }
        if (tableLevelConstraint2 == null) {
            filteredSelection3.setSelected(true);
            compareObjectSelection = new FilteredSelection(NEW_CONSTRAINT);
            compareObjectSelection.setStatus(STATE_NEW);
            filteredSelection3.setStatus(STATE_NEW);
            this.newMappings.add(filteredSelection3);
            compareObjectSelection.setElementDescriptor(TableLevelConstraint.class);
            tableConstraintComparator = new TableConstraintComparator(tableLevelConstraint, tableLevelConstraint2);
            filteredSelection3.setPropertiesComparator(tableConstraintComparator);
            compareObjectSelection.setPropertiesComparator(tableConstraintComparator);
            this.comparatorsMap.put(tableConstraintComparator.getID(), tableConstraintComparator);
            this.objectsMap.put(tableLevelConstraint.getObjectID(), null);
        }
        filteredSelection3.setCorrespondentNode(compareObjectSelection);
        compareObjectSelection.setCorrespondentNode(filteredSelection3);
        filteredSelection2.addChild(compareObjectSelection);
        filteredSelection.addChild(filteredSelection3);
    }

    private TableLevelConstraint checkForEqualRule(TableLevelConstraint tableLevelConstraint, Table table) {
        for (TableLevelConstraint tableLevelConstraint2 : table.getCheckConstraints()) {
            if (!tableLevelConstraint.getRule().equals(tableLevelConstraint2.getRule())) continue;
            boolean bl = false;
            for (TableLevelConstraint tableLevelConstraint3 : tableLevelConstraint.getTable().getCheckConstraints()) {
                if (!tableLevelConstraint3.getName().equalsIgnoreCase(tableLevelConstraint2.getName())) continue;
                bl = true;
            }
            if (bl) continue;
            return tableLevelConstraint2;
        }
        return null;
    }

    private void addDeletedCheckConstraints(Table table, FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
            if (this.objectsMap.containsValue(tableLevelConstraint)) continue;
            FilteredSelection filteredSelection3 = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection3);
            filteredSelection3.setSelected(false);
            filteredSelection3.setElementDescriptor(TableLevelConstraint.class);
            FilteredSelection filteredSelection4 = new FilteredSelection(tableLevelConstraint);
            filteredSelection4.setElementDescriptor(TableLevelConstraint.class);
            TableConstraintComparator tableConstraintComparator = new TableConstraintComparator(null, tableLevelConstraint);
            this.comparatorsMap.put(tableConstraintComparator.getID(), tableConstraintComparator);
            filteredSelection4.setPropertiesComparator(tableConstraintComparator);
            filteredSelection3.setPropertiesComparator(tableConstraintComparator);
            filteredSelection3.setStatus(STATE_DELETED);
            filteredSelection4.setStatus(STATE_DELETED);
            filteredSelection4.setCorrespondentNode(filteredSelection3);
            filteredSelection3.setCorrespondentNode(filteredSelection4);
            filteredSelection.addChild(filteredSelection3);
            filteredSelection2.addChild(filteredSelection4);
        }
    }

    public CompareObjectSelection getRelationalRoot() {
        return this;
    }

    public CompareObjectSelection getRightRelationalRoot() {
        return this.rightRelationalRoot;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    private void addDeletedColumns(Table table, FilteredSelection filteredSelection, Table table2, FilteredSelection filteredSelection2) {
        for (Column column : table2.getElementsCollection()) {
            if (this.objectsMap.containsValue(column)) continue;
            FilteredSelection filteredSelection3 = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection3);
            filteredSelection3.setSelected(false);
            filteredSelection3.setElementDescriptor(Column.class);
            FilteredSelection filteredSelection4 = new FilteredSelection(column);
            filteredSelection4.setElementDescriptor(Column.class);
            ColumnComparator columnComparator = new ColumnComparator(null, column);
            this.comparatorsMap.put(columnComparator.getID(), columnComparator);
            filteredSelection4.setPropertiesComparator(columnComparator);
            filteredSelection3.setPropertiesComparator(columnComparator);
            filteredSelection3.setStatus(STATE_DELETED);
            filteredSelection4.setStatus(STATE_DELETED);
            filteredSelection4.setCorrespondentNode(filteredSelection3);
            filteredSelection3.setCorrespondentNode(filteredSelection4);
            filteredSelection.addChild(filteredSelection3);
            filteredSelection2.addChild(filteredSelection4);
        }
    }

    private void addDeletedIndexes(Table table, FilteredSelection filteredSelection, FilteredSelection filteredSelection2, boolean bl) {
        Iterator iterator = table.getKeySet().iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            Index index = (Index)iterator.next();
            boolean bl3 = bl2 = bl == (index.isPK() || index.isUnique());
            if (index.isFK() || !bl2 || this.objectsMap.containsValue(index)) continue;
            ModelIDObject modelIDObject = null;
            if (index != null) {
                modelIDObject = this.getTargetStorageDesign().getStorageObject(index.getObjectID());
            }
            if (modelIDObject == null) {
                modelIDObject = index;
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, modelIDObject)) continue;
            FilteredSelection filteredSelection3 = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection3);
            filteredSelection3.setSelected(false);
            FilteredSelection filteredSelection4 = new FilteredSelection(index);
            filteredSelection3.setElementDescriptor(Index.class);
            IndexComparator indexComparator = new IndexComparator(null, index, this.objectsMap);
            this.comparatorsMap.put(indexComparator.getID(), indexComparator);
            filteredSelection4.setPropertiesComparator(indexComparator);
            filteredSelection3.setPropertiesComparator(indexComparator);
            filteredSelection3.setStatus(STATE_DELETED);
            filteredSelection4.setStatus(STATE_DELETED);
            filteredSelection4.setCorrespondentNode(filteredSelection3);
            filteredSelection3.setCorrespondentNode(filteredSelection4);
            filteredSelection.addChild(filteredSelection3);
            filteredSelection2.addChild(filteredSelection4);
        }
    }

    private void addDeletedTables(ModelIdObjectSelection modelIdObjectSelection, ModelIdObjectSelection modelIdObjectSelection2) {
        Iterator iterator = this.getTargetStorageDesign() instanceof StorageDesignOracle ? this.getTables((StorageDesignOracle)this.getTargetStorageDesign()).iterator() : this.targetdes.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (this.selectedIDs != null && !this.selectedIDs.containsKey(table.getObjectID()) || this.objectsMap.containsValue(table)) continue;
            TableProxy tableProxy = null;
            if (table != null) {
                tableProxy = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tableProxy)) continue;
            FilteredSelection filteredSelection = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection);
            filteredSelection.setSelected(false);
            FilteredSelection filteredSelection2 = new FilteredSelection(table);
            filteredSelection.setElementDescriptor(Table.class);
            tableProxy = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            TableComparator tableComparator = new TableComparator(null, table, null, tableProxy);
            this.comparatorsMap.put(tableComparator.getID(), tableComparator);
            filteredSelection.setPropertiesComparator(tableComparator);
            filteredSelection2.setPropertiesComparator(tableComparator);
            filteredSelection.setStatus(STATE_DELETED);
            filteredSelection2.setStatus(STATE_DELETED);
            filteredSelection2.setCorrespondentNode(filteredSelection);
            filteredSelection.setCorrespondentNode(filteredSelection2);
            modelIdObjectSelection.addChild(filteredSelection);
            modelIdObjectSelection2.addChild(filteredSelection2);
        }
    }

    private void addDeletedTableViews(ModelIdObjectSelection modelIdObjectSelection, ModelIdObjectSelection modelIdObjectSelection2) {
        Iterator iterator = this.targetdes.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            if (this.selectedIDs != null && !this.selectedIDs.containsKey(tableView.getObjectID()) || this.objectsMap.containsValue(tableView)) continue;
            TableViewProxy tableViewProxy = (TableViewProxy)this.getTargetStorageDesign().getProxy(tableView.getObjectID());
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tableViewProxy)) continue;
            FilteredSelection filteredSelection = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection);
            filteredSelection.setSelected(false);
            FilteredSelection filteredSelection2 = new FilteredSelection(tableView);
            filteredSelection.setElementDescriptor(TableView.class);
            TableViewComparator tableViewComparator = new TableViewComparator(null, tableView, null, tableViewProxy);
            this.comparatorsMap.put(tableViewComparator.getID(), tableViewComparator);
            filteredSelection.setPropertiesComparator(tableViewComparator);
            filteredSelection2.setPropertiesComparator(tableViewComparator);
            filteredSelection.setStatus(STATE_DELETED);
            filteredSelection2.setStatus(STATE_DELETED);
            filteredSelection2.setCorrespondentNode(filteredSelection);
            filteredSelection.setCorrespondentNode(filteredSelection2);
            modelIdObjectSelection.addChild(filteredSelection);
            modelIdObjectSelection2.addChild(filteredSelection2);
        }
    }

    public List getDeletedMappings() {
        return this.deletedMappings;
    }

    public List getNewMappings() {
        return this.newMappings;
    }

    public Map getObjectsMap() {
        return this.objectsMap;
    }

    @Override
    protected DDLGenerator createDDLGenerator() {
        StorageDesign storageDesign = this.targetdes.getStorageDesign();
        if (storageDesign instanceof StorageDesignOraclev11g) {
            return this.createDDLGeneratorOraclev11g();
        }
        if (storageDesign instanceof StorageDesignOraclev10g) {
            return this.createDDLGeneratorOraclev10g();
        }
        return super.createDDLGenerator();
    }

    private DDLGenerator createDDLGeneratorOraclev11g() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        CSSBCreateTableOraclev11g cSSBCreateTableOraclev11g = new CSSBCreateTableOraclev11g();
        dDLGeneratorSpecific.append(cSSBCreateTableOraclev11g);
        dDLGeneratorSpecific.append(new CSSBRenameTableOraclev11g(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBAlterTableOraclev10g());
        dDLGeneratorSpecific.append(new CSSBAlterIndexOraclev11g(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBAlterColumnOraclev11g());
        dDLGeneratorSpecific.append(new CSSBAlterTableConstraint());
        dDLGeneratorSpecific.append(new CSSBFKIndexOraclev10g(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBSnapshotOraclev11g(cSSBCreateTableOraclev11g));
        dDLGeneratorSpecific.append(new CSSBSequenceOracle10vg());
        dDLGeneratorSpecific.append(new CSSBTableViewOraclev10g());
        return dDLGeneratorSpecific;
    }

    private DDLGenerator createDDLGeneratorOraclev10g() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        CSSBCreateTableOraclev10g cSSBCreateTableOraclev10g = new CSSBCreateTableOraclev10g();
        dDLGeneratorSpecific.append(cSSBCreateTableOraclev10g);
        dDLGeneratorSpecific.append(new CSSBRenameTableOraclev10g(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBAlterTableOraclev10g());
        dDLGeneratorSpecific.append(new CSSBAlterIndexOraclev10g(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBAlterColumnOraclev10g());
        dDLGeneratorSpecific.append(new CSSBAlterTableConstraint());
        dDLGeneratorSpecific.append(new CSSBFKIndexOraclev10g(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBSnapshotOraclev10g(cSSBCreateTableOraclev10g));
        dDLGeneratorSpecific.append(new CSSBSequenceOracle10vg());
        dDLGeneratorSpecific.append(new CSSBTableViewOraclev10g());
        return dDLGeneratorSpecific;
    }

    public StorageDesign getSourceStorageDesign() {
        return this.sourcedes.getStorageDesign();
    }

    public StorageDesign getTargetStorageDesign() {
        return this.targetdes.getStorageDesign();
    }

    public Map getLeftSelectionMap() {
        return this.leftSelectionMap;
    }

    public List getColumnsWithChangedDataType() {
        return this.columnsWithChangedDataType;
    }

    public List getTablesToRecreate() {
        return this.tablesToRecreate;
    }

    private void addDataTypes() {
        AbstractDTObject abstractDTObject;
        FilteredSelection filteredSelection = new FilteredSelection(Messages.getString("CompareCWDDesigns.DataTypesModel"));
        FilteredSelection filteredSelection2 = new FilteredSelection(Messages.getString("CompareCWDDesigns.DataTypesModel"));
        filteredSelection.setCorrespondentNode(filteredSelection2);
        filteredSelection2.setCorrespondentNode(filteredSelection);
        this.setEmptyComparator(filteredSelection);
        this.setEmptyComparator(filteredSelection2);
        this.addChild(filteredSelection);
        this.rightRelationalRoot.addChild(filteredSelection2);
        FilteredSelection filteredSelection3 = new FilteredSelection(Messages.getString("CompareCWDDesigns.DistinctTypes"));
        FilteredSelection filteredSelection4 = new FilteredSelection(Messages.getString("CompareCWDDesigns.DistinctTypes"));
        filteredSelection3.setCorrespondentNode(filteredSelection4);
        filteredSelection4.setCorrespondentNode(filteredSelection3);
        this.setEmptyComparator(filteredSelection3);
        this.setEmptyComparator(filteredSelection4);
        filteredSelection.addChild(filteredSelection3);
        filteredSelection2.addChild(filteredSelection4);
        filteredSelection4.setSelected(false);
        FilteredSelection filteredSelection5 = new FilteredSelection(Messages.getString("DataTypesDesign.StructuredTypes"));
        FilteredSelection filteredSelection6 = new FilteredSelection(Messages.getString("DataTypesDesign.StructuredTypes"));
        filteredSelection5.setCorrespondentNode(filteredSelection6);
        filteredSelection6.setCorrespondentNode(filteredSelection5);
        this.setEmptyComparator(filteredSelection5);
        this.setEmptyComparator(filteredSelection6);
        filteredSelection.addChild(filteredSelection5);
        filteredSelection2.addChild(filteredSelection6);
        filteredSelection6.setSelected(false);
        FilteredSelection filteredSelection7 = new FilteredSelection(Messages.getString("CompareCWDDesigns.CollectionTypes"));
        FilteredSelection filteredSelection8 = new FilteredSelection(Messages.getString("CompareCWDDesigns.CollectionTypes"));
        filteredSelection7.setCorrespondentNode(filteredSelection8);
        filteredSelection8.setCorrespondentNode(filteredSelection7);
        this.setEmptyComparator(filteredSelection7);
        this.setEmptyComparator(filteredSelection8);
        filteredSelection.addChild(filteredSelection7);
        filteredSelection2.addChild(filteredSelection8);
        filteredSelection8.setSelected(false);
        Iterator iterator = this.getSourceDataTypesDesign().getDistinctTypeSet().iterator();
        while (iterator.hasNext()) {
            abstractDTObject = (DistinctType)iterator.next();
            this.addDistinctType((DistinctType)abstractDTObject, filteredSelection3, filteredSelection4);
        }
        this.addDeletedDistinctTypes(filteredSelection3, filteredSelection4);
        iterator = this.getSourceDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            abstractDTObject = (StructuredType)iterator.next();
            this.addStructuredType((StructuredType)abstractDTObject, filteredSelection5, filteredSelection6);
        }
        if (this.selectedIDs == null || this.selectedIDs.size() == 0) {
            this.addDeletedStructuredTypes(filteredSelection5, filteredSelection6);
        }
        iterator = this.getSourceDataTypesDesign().getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            abstractDTObject = (CollectionType)iterator.next();
            this.addCollectionType((CollectionType)abstractDTObject, filteredSelection7, filteredSelection8);
        }
        if (this.selectedIDs == null || this.selectedIDs.size() == 0) {
            this.addDeletedCollectionTypes(filteredSelection7, filteredSelection8);
        }
    }

    private void addDistinctType(DistinctType distinctType, FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        FilteredSelection filteredSelection3 = new FilteredSelection(distinctType);
        FilteredSelection filteredSelection4 = null;
        DistinctType distinctType2 = (DistinctType)CompareModelToModel.getCorrespondingObject(this.getTargetDataTypesDesign().getDistinctTypeSet(), distinctType);
        if (distinctType2 != null) {
            filteredSelection4 = new FilteredSelection(distinctType2);
            DistinctTypeComparator distinctTypeComparator = new DistinctTypeComparator(distinctType, distinctType2);
            filteredSelection3.setPropertiesComparator(distinctTypeComparator);
            filteredSelection4.setPropertiesComparator(distinctTypeComparator);
            this.comparatorsMap.put(distinctTypeComparator.getID(), distinctTypeComparator);
            filteredSelection3.setSelected(distinctTypeComparator.isModified());
            distinctTypeComparator.setLeftSelectionObject(filteredSelection3);
            this.objectsMap.put(distinctType.getObjectID(), distinctType2);
        } else {
            filteredSelection4 = new FilteredSelection(CompareCWDDesigns.NEW_DISTINCT_TYPE);
            filteredSelection3.setStatus(STATE_NEW);
            filteredSelection4.setStatus(STATE_NEW);
            filteredSelection4.setElementDescriptor(DistinctType.class);
            this.objectsMap.put(distinctType.getObjectID(), null);
            DistinctTypeComparator distinctTypeComparator = new DistinctTypeComparator(distinctType, distinctType2);
            filteredSelection3.setPropertiesComparator(distinctTypeComparator);
            filteredSelection4.setPropertiesComparator(distinctTypeComparator);
            this.comparatorsMap.put(distinctTypeComparator.getID(), distinctTypeComparator);
            filteredSelection3.setSelected(true);
            this.newMappings.add(filteredSelection3);
        }
        filteredSelection4.setCorrespondentNode(filteredSelection3);
        filteredSelection3.setCorrespondentNode(filteredSelection4);
        filteredSelection.addChild(filteredSelection3);
        filteredSelection2.addChild(filteredSelection4);
    }

    private void addDeletedDistinctTypes(FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        Iterator iterator = this.getTargetDataTypesDesign().getDistinctTypeSet().iterator();
        while (iterator.hasNext()) {
            DistinctType distinctType = (DistinctType)iterator.next();
            if (this.objectsMap.containsValue(distinctType)) continue;
            FilteredSelection filteredSelection3 = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection3);
            filteredSelection3.setSelected(false);
            FilteredSelection filteredSelection4 = new FilteredSelection(distinctType);
            filteredSelection3.setElementDescriptor(DistinctType.class);
            DistinctTypeComparator distinctTypeComparator = new DistinctTypeComparator(null, distinctType);
            this.comparatorsMap.put(distinctTypeComparator.getID(), distinctTypeComparator);
            filteredSelection3.setPropertiesComparator(distinctTypeComparator);
            filteredSelection4.setPropertiesComparator(distinctTypeComparator);
            filteredSelection3.setStatus(STATE_DELETED);
            filteredSelection4.setStatus(STATE_DELETED);
            filteredSelection4.setCorrespondentNode(filteredSelection3);
            filteredSelection3.setCorrespondentNode(filteredSelection4);
            filteredSelection.addChild(filteredSelection3);
            filteredSelection2.addChild(filteredSelection4);
        }
    }

    private void addStructuredType(StructuredType structuredType, FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        FilteredSelection filteredSelection3 = new FilteredSelection(structuredType);
        FilteredSelection filteredSelection4 = null;
        StructuredType structuredType2 = (StructuredType)CompareModelToModel.getCorrespondingObject(this.getTargetDataTypesDesign().getStructuredTypeSet(), structuredType);
        if (structuredType2 != null) {
            filteredSelection4 = new FilteredSelection(structuredType2);
            StructuredTypeComparator structuredTypeComparator = new StructuredTypeComparator(structuredType, structuredType2);
            filteredSelection3.setPropertiesComparator(structuredTypeComparator);
            filteredSelection4.setPropertiesComparator(structuredTypeComparator);
            this.comparatorsMap.put(structuredTypeComparator.getID(), structuredTypeComparator);
            filteredSelection3.setSelected(structuredTypeComparator.isModified());
            structuredTypeComparator.setLeftSelectionObject(filteredSelection3);
            this.objectsMap.put(structuredType.getObjectID(), structuredType2);
        } else {
            filteredSelection4 = new FilteredSelection(CompareCWDDesigns.NEW_STRUCTURED_TYPE);
            filteredSelection3.setStatus(STATE_NEW);
            filteredSelection4.setStatus(STATE_NEW);
            filteredSelection4.setElementDescriptor(StructuredType.class);
            this.objectsMap.put(structuredType.getObjectID(), null);
            StructuredTypeComparator structuredTypeComparator = new StructuredTypeComparator(structuredType, structuredType2);
            filteredSelection3.setPropertiesComparator(structuredTypeComparator);
            filteredSelection4.setPropertiesComparator(structuredTypeComparator);
            this.comparatorsMap.put(structuredTypeComparator.getID(), structuredTypeComparator);
            filteredSelection3.setSelected(true);
            this.newMappings.add(filteredSelection3);
        }
        filteredSelection4.setCorrespondentNode(filteredSelection3);
        filteredSelection3.setCorrespondentNode(filteredSelection4);
        this.addStructuredTypeDetails(structuredType, filteredSelection3, structuredType2, filteredSelection4);
        filteredSelection.addChild(filteredSelection3);
        filteredSelection2.addChild(filteredSelection4);
    }

    private void addDeletedStructuredTypes(FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        Iterator iterator = this.getTargetDataTypesDesign().getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (structuredType.getName().equalsIgnoreCase("SDO_GEOMETRY") || structuredType.getName().equalsIgnoreCase("XMLTYPE") || this.objectsMap.containsValue(structuredType)) continue;
            FilteredSelection filteredSelection3 = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection3);
            filteredSelection3.setSelected(false);
            FilteredSelection filteredSelection4 = new FilteredSelection(structuredType);
            filteredSelection3.setElementDescriptor(StructuredType.class);
            StructuredTypeComparator structuredTypeComparator = new StructuredTypeComparator(null, structuredType);
            this.comparatorsMap.put(structuredTypeComparator.getID(), structuredTypeComparator);
            filteredSelection3.setPropertiesComparator(structuredTypeComparator);
            filteredSelection4.setPropertiesComparator(structuredTypeComparator);
            filteredSelection3.setStatus(STATE_DELETED);
            filteredSelection4.setStatus(STATE_DELETED);
            filteredSelection4.setCorrespondentNode(filteredSelection3);
            filteredSelection3.setCorrespondentNode(filteredSelection4);
            filteredSelection.addChild(filteredSelection3);
            filteredSelection2.addChild(filteredSelection4);
        }
    }

    private void addStructuredTypeDetails(StructuredType structuredType, FilteredSelection filteredSelection, StructuredType structuredType2, FilteredSelection filteredSelection2) {
        ModelObject modelObject;
        FilteredSelection filteredSelection3 = new FilteredSelection(Messages.getString("CompareCWDDesigns.Attributes"));
        FilteredSelection filteredSelection4 = new FilteredSelection(Messages.getString("CompareCWDDesigns.Attributes"));
        filteredSelection3.setCorrespondentNode(filteredSelection4);
        filteredSelection4.setCorrespondentNode(filteredSelection3);
        this.setEmptyComparator(filteredSelection3);
        this.setEmptyComparator(filteredSelection4);
        filteredSelection4.setSelected(false);
        TypeElement[] typeElementArray = structuredType.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            modelObject = typeElementArray[i];
            this.addTypeElement((TypeElement)modelObject, structuredType2, filteredSelection3, filteredSelection4);
        }
        if (structuredType2 != null) {
            this.addDeletedTypeElements(filteredSelection3, structuredType2, filteredSelection4);
        }
        filteredSelection.addChild(filteredSelection3);
        filteredSelection2.addChild(filteredSelection4);
        ((StructuredTypeComparator)filteredSelection.getPropertiesComparator()).presetTypeElemsOrder();
        FilteredSelection filteredSelection5 = new FilteredSelection(Messages.getString("CompareCWDDesigns.Methods"));
        modelObject = new FilteredSelection(Messages.getString("CompareCWDDesigns.Methods"));
        filteredSelection5.setCorrespondentNode((CompareObjectSelection)modelObject);
        ((CompareObjectSelection)modelObject).setCorrespondentNode(filteredSelection5);
        this.setEmptyComparator(filteredSelection5);
        this.setEmptyComparator((CompareObjectSelection)modelObject);
        ((CompareObjectSelection)modelObject).setSelected(false);
        Method[] methodArray = structuredType.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            this.addMethod(method, structuredType2, filteredSelection5, (FilteredSelection)modelObject);
        }
        if (structuredType2 != null) {
            this.addDeletedMethods(filteredSelection5, structuredType2, (FilteredSelection)modelObject);
        }
        filteredSelection.addChild(filteredSelection5);
        filteredSelection2.addChild((ModelIdObjectSelection)modelObject);
    }

    private void addTypeElement(TypeElement typeElement, StructuredType structuredType, FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        TypeElementComparator typeElementComparator;
        FilteredSelection filteredSelection3 = new FilteredSelection(typeElement);
        ModelIdObjectSelection modelIdObjectSelection = null;
        TypeElement typeElement2 = null;
        if (structuredType != null && (typeElement2 = (TypeElement)this.getCorrespondingObject(structuredType.getTypeElementSet(), typeElement, true)) != null) {
            modelIdObjectSelection = new FilteredSelection(typeElement2);
            typeElementComparator = new TypeElementComparator(typeElement, typeElement2);
            filteredSelection3.setPropertiesComparator(typeElementComparator);
            ((CompareObjectSelection)modelIdObjectSelection).setPropertiesComparator(typeElementComparator);
            this.comparatorsMap.put(typeElementComparator.getID(), typeElementComparator);
            filteredSelection3.setSelected(typeElementComparator.isModified());
            filteredSelection3.setEditable(typeElementComparator.isModified());
            this.objectsMap.put(typeElement.getObjectID(), typeElement2);
        }
        if (typeElement2 == null) {
            filteredSelection3.setSelected(true);
            modelIdObjectSelection = new FilteredSelection(CompareCWDDesigns.NEW_ATTRIBUTE);
            ((CompareObjectSelection)modelIdObjectSelection).setStatus(STATE_NEW);
            filteredSelection3.setStatus(STATE_NEW);
            this.newMappings.add(filteredSelection3);
            typeElementComparator = new TypeElementComparator(typeElement, null);
            filteredSelection3.setPropertiesComparator(typeElementComparator);
            ((CompareObjectSelection)modelIdObjectSelection).setPropertiesComparator(typeElementComparator);
            this.comparatorsMap.put(typeElementComparator.getID(), typeElementComparator);
            this.objectsMap.put(typeElement.getObjectID(), null);
        }
        modelIdObjectSelection.setElementDescriptor(TypeElement.class);
        filteredSelection.addChild(filteredSelection3);
        filteredSelection2.addChild(modelIdObjectSelection);
    }

    private void addDeletedTypeElements(FilteredSelection filteredSelection, StructuredType structuredType, FilteredSelection filteredSelection2) {
        TypeElement[] typeElementArray = structuredType.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            TypeElement typeElement = typeElementArray[i];
            if (this.objectsMap.containsValue(typeElement)) continue;
            FilteredSelection filteredSelection3 = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection3);
            filteredSelection3.setSelected(false);
            filteredSelection3.setElementDescriptor(TypeElement.class);
            FilteredSelection filteredSelection4 = new FilteredSelection(typeElement);
            filteredSelection4.setElementDescriptor(TypeElement.class);
            TypeElementComparator typeElementComparator = new TypeElementComparator(null, typeElement);
            this.comparatorsMap.put(typeElementComparator.getID(), typeElementComparator);
            filteredSelection4.setPropertiesComparator(typeElementComparator);
            filteredSelection3.setPropertiesComparator(typeElementComparator);
            filteredSelection3.setStatus(STATE_DELETED);
            filteredSelection4.setStatus(STATE_DELETED);
            filteredSelection4.setCorrespondentNode(filteredSelection3);
            filteredSelection3.setCorrespondentNode(filteredSelection4);
            filteredSelection.addChild(filteredSelection3);
            filteredSelection2.addChild(filteredSelection4);
        }
    }

    private void addMethod(Method method, StructuredType structuredType, FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        MethodComparator methodComparator;
        FilteredSelection filteredSelection3 = new FilteredSelection(method);
        CompareObjectSelection compareObjectSelection = null;
        Method method2 = null;
        if (structuredType != null && (method2 = (Method)this.getCorrespondingObject(structuredType.getMethodsList(), method)) != null) {
            compareObjectSelection = new FilteredSelection(method2);
            methodComparator = new MethodComparator(method, method2);
            filteredSelection3.setPropertiesComparator(methodComparator);
            compareObjectSelection.setPropertiesComparator(methodComparator);
            this.comparatorsMap.put(methodComparator.getID(), methodComparator);
            filteredSelection3.setSelected(methodComparator.isModified());
            filteredSelection3.setEditable(methodComparator.isModified());
            methodComparator.setLeftSelectionObject(filteredSelection3);
            this.objectsMap.put(method.getObjectID(), method2);
        }
        if (method2 == null) {
            filteredSelection3.setSelected(true);
            compareObjectSelection = new FilteredSelection(CompareCWDDesigns.NEW_METHOD);
            compareObjectSelection.setStatus(STATE_NEW);
            filteredSelection3.setStatus(STATE_NEW);
            this.newMappings.add(filteredSelection3);
            compareObjectSelection.setElementDescriptor(Method.class);
            methodComparator = new MethodComparator(method, method2);
            filteredSelection3.setPropertiesComparator(methodComparator);
            compareObjectSelection.setPropertiesComparator(methodComparator);
            this.comparatorsMap.put(methodComparator.getID(), methodComparator);
            this.objectsMap.put(method.getObjectID(), null);
        }
        filteredSelection3.setCorrespondentNode(compareObjectSelection);
        compareObjectSelection.setCorrespondentNode(filteredSelection3);
        filteredSelection.addChild(filteredSelection3);
        filteredSelection2.addChild(compareObjectSelection);
    }

    private void addDeletedMethods(FilteredSelection filteredSelection, StructuredType structuredType, FilteredSelection filteredSelection2) {
        Method[] methodArray = structuredType.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (this.objectsMap.containsValue(method)) continue;
            FilteredSelection filteredSelection3 = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection3);
            filteredSelection3.setSelected(false);
            filteredSelection3.setElementDescriptor(Method.class);
            FilteredSelection filteredSelection4 = new FilteredSelection(method);
            filteredSelection4.setElementDescriptor(Method.class);
            MethodComparator methodComparator = new MethodComparator(null, method);
            this.comparatorsMap.put(methodComparator.getID(), methodComparator);
            filteredSelection4.setPropertiesComparator(methodComparator);
            filteredSelection3.setPropertiesComparator(methodComparator);
            filteredSelection3.setStatus(STATE_DELETED);
            filteredSelection4.setStatus(STATE_DELETED);
            filteredSelection4.setCorrespondentNode(filteredSelection3);
            filteredSelection3.setCorrespondentNode(filteredSelection4);
            filteredSelection.addChild(filteredSelection3);
            filteredSelection2.addChild(filteredSelection4);
        }
    }

    private void addCollectionType(CollectionType collectionType, FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        FilteredSelection filteredSelection3 = new FilteredSelection(collectionType);
        FilteredSelection filteredSelection4 = null;
        CollectionType collectionType2 = (CollectionType)CompareModelToModel.getCorrespondingObject(this.getTargetDataTypesDesign().getCollectionTypeSet(), collectionType);
        if (collectionType2 != null) {
            filteredSelection4 = new FilteredSelection(collectionType2);
            CollectionTypeComparator collectionTypeComparator = new CollectionTypeComparator(collectionType, collectionType2);
            filteredSelection3.setPropertiesComparator(collectionTypeComparator);
            filteredSelection4.setPropertiesComparator(collectionTypeComparator);
            this.comparatorsMap.put(collectionTypeComparator.getID(), collectionTypeComparator);
            filteredSelection3.setSelected(collectionTypeComparator.isModified());
            collectionTypeComparator.setLeftSelectionObject(filteredSelection3);
            this.objectsMap.put(collectionType.getObjectID(), collectionType2);
        } else {
            filteredSelection4 = new FilteredSelection(CompareCWDDesigns.NEW_COLLECTION_TYPE);
            filteredSelection3.setStatus(STATE_NEW);
            filteredSelection4.setStatus(STATE_NEW);
            filteredSelection4.setElementDescriptor(CollectionType.class);
            this.objectsMap.put(collectionType.getObjectID(), null);
            CollectionTypeComparator collectionTypeComparator = new CollectionTypeComparator(collectionType, collectionType2);
            filteredSelection3.setPropertiesComparator(collectionTypeComparator);
            filteredSelection4.setPropertiesComparator(collectionTypeComparator);
            this.comparatorsMap.put(collectionTypeComparator.getID(), collectionTypeComparator);
            filteredSelection3.setSelected(true);
            this.newMappings.add(filteredSelection3);
        }
        filteredSelection4.setCorrespondentNode(filteredSelection3);
        filteredSelection3.setCorrespondentNode(filteredSelection4);
        filteredSelection.addChild(filteredSelection3);
        filteredSelection2.addChild(filteredSelection4);
    }

    private void addDeletedCollectionTypes(FilteredSelection filteredSelection, FilteredSelection filteredSelection2) {
        Iterator iterator = this.getTargetDataTypesDesign().getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            CollectionType collectionType = (CollectionType)iterator.next();
            if (this.objectsMap.containsValue(collectionType)) continue;
            FilteredSelection filteredSelection3 = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(filteredSelection3);
            filteredSelection3.setSelected(false);
            FilteredSelection filteredSelection4 = new FilteredSelection(collectionType);
            filteredSelection3.setElementDescriptor(CollectionType.class);
            CollectionTypeComparator collectionTypeComparator = new CollectionTypeComparator(null, collectionType);
            this.comparatorsMap.put(collectionTypeComparator.getID(), collectionTypeComparator);
            filteredSelection3.setPropertiesComparator(collectionTypeComparator);
            filteredSelection4.setPropertiesComparator(collectionTypeComparator);
            filteredSelection3.setStatus(STATE_DELETED);
            filteredSelection4.setStatus(STATE_DELETED);
            filteredSelection4.setCorrespondentNode(filteredSelection3);
            filteredSelection3.setCorrespondentNode(filteredSelection4);
            filteredSelection.addChild(filteredSelection3);
            filteredSelection2.addChild(filteredSelection4);
        }
    }

    private DataTypesDesign getTargetDataTypesDesign() {
        return this.targetDTD;
    }

    private DataTypesDesign getSourceDataTypesDesign() {
        return this.sourceDTD;
    }

    private boolean isGenerateInDDL(ModelIDObject modelIDObject, ModelIDObject modelIDObject2) {
        if (swapTarget) {
            if (modelIDObject != null) {
                return modelIDObject.isMarkedGenerate();
            }
        } else if (modelIDObject2 != null) {
            return modelIDObject2.isMarkedGenerate();
        }
        return true;
    }
}

