/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.persistence.ConfigurationFileLoader;
import oracle.dbtools.crest.util.logging.Logger;

public class WordMapper
extends ConfigurationFileLoader {
    private static final Logger LOGGER = new Logger(WordMapper.class);
    private Map stringMapF = new TreeMap();
    private Map stringMapR = new TreeMap();

    public void initializeWith() {
        this.stringMapF.put("ENTITY", "TABLE");
        this.stringMapF.put("ATTRIBUTE", "COLUMN");
        this.stringMapF.put("KEY", "INDEX");
        this.stringMapF.put("Entity", "Table");
        this.stringMapF.put("Attribute", "Column");
        this.stringMapF.put("Key", "Index");
        this.stringMapF.put("entity", "table");
        this.stringMapF.put("attribute", "column");
        this.stringMapF.put("key", "index");
        this.stringMapR.put("TABLE", "ENTITY");
        this.stringMapR.put("COLUMN", "ATTRIBUTE");
        this.stringMapR.put("INDEX", "KEY");
        this.stringMapR.put("Table", "Entity");
        this.stringMapR.put("Column", "Attribute");
        this.stringMapR.put("Index", "Key");
        this.stringMapR.put("table", "entity");
        this.stringMapR.put("column", "column");
        this.stringMapR.put("index", "key");
    }

    public Map getStringMap() {
        return this.stringMapF;
    }

    public String get(String string) {
        return (String)this.getStringMap().get(string);
    }

    public int size() {
        return this.getStringMap().size();
    }

    public String getContent() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.stringMapF.keySet()) {
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append((String)this.stringMapF.get(string));
            stringBuffer.append(NEWLINE);
        }
        return stringBuffer.toString();
    }

    @Override
    protected void createDefaultFile(File file) {
        File file2 = new File(file, "logtophys.properties");
        try {
            System.out.println("WordMapper writing: " + file2);
            file2.createNewFile();
            this.storeMap(this.getStringMap(), file2);
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
        }
    }

    public String transformFromLogical(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "_", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (this.getStringMap().containsKey(string2)) {
                stringBuffer.append(this.getStringMap().get(string2));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String transformFromRelational(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "_", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (this.stringMapR.containsKey(string2)) {
                stringBuffer.append(this.stringMapR.get(string2));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

