/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;

public class Measurement
extends DesignObject {
    public static final String OBJECT_TYPE = "Measurement";
    private String value = "";
    private String unit = "";
    private String type = "";
    private String creationDate = "";
    private String effectiveDate = "";
    private DesignObject object;
    public static final String[] TYPE_STATES_DISPLAY = new String[]{Messages.getString("Measurement.Measure"), Messages.getString("Measurement.Estimate"), Messages.getString("Measurement.Plan"), Messages.getString("Measurement.Minimum"), Messages.getString("Measurement.Maximum"), Messages.getString("Measurement.Average")};
    public static final String[] TYPE_STATES_INTERNAL = new String[]{"Measure", "Estimate", "Plan", "Minimum", "Maximum", "Average"};
    private static Set typeSet = null;

    public Measurement(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return OBJECT_TYPE;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String string) {
        if (string != null && string.equals(this.creationDate)) {
            return;
        }
        this.creationDate = string;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String string) {
        if (string != null && string.equals(this.effectiveDate)) {
            return;
        }
        this.effectiveDate = string;
    }

    public DesignObject getObject() {
        return this.object;
    }

    public void setObject(DesignObject designObject) {
        if (this.object != designObject) {
            this.object = designObject;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        if (string != null && string.equals(this.type)) {
            return;
        }
        if (this.checkType(string)) {
            this.type = string;
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        if (string != null && string.equals(this.unit)) {
            return;
        }
        this.unit = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (this.value != string) {
            this.value = string;
        }
    }

    private boolean checkType(String string) {
        if (typeSet == null) {
            typeSet = new HashSet();
            typeSet.addAll(Arrays.asList(TYPE_STATES_INTERNAL));
        }
        return typeSet.contains(string);
    }
}

