/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public class LogicalDatatypeSet
extends DesignObjectSet
implements RepositoryObject {
    private static final Object[] PROTOTYPE = new LogicalDatatype[0];
    private LogicalDatatype defaultType;
    public static String UNKNOWN = "UNKNOWN";
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private boolean checkedOut = false;
    private boolean checkedOutByMe = false;
    private String checkedOutBy = "";
    private boolean dirty = false;
    private RepositoryObject pac_Element;

    public LogicalDatatypeSet(DesignPart designPart) {
        super(designPart);
    }

    public void createUnknownType() {
        LogicalDatatype logicalDatatype = this.createLogicalDatatype("LOGDT017");
        logicalDatatype.setName("unknown");
        Iterator iterator = this.getDesign().getDefaultRDBMSTypeSet().iterator();
        while (iterator.hasNext()) {
            RDBMSType rDBMSType = (RDBMSType)iterator.next();
            logicalDatatype.put(rDBMSType.getName(), UNKNOWN);
        }
        logicalDatatype.setReadOnly(true);
        this.setDefaultType(logicalDatatype);
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTOTYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default log datatype name");
    }

    public void setDefaultType(LogicalDatatype logicalDatatype) {
        this.defaultType = logicalDatatype;
    }

    public LogicalDatatype getDefaultType() {
        return this.defaultType;
    }

    public LogicalDatatype createLogicalDatatype(String string) {
        LogicalDatatype logicalDatatype = new LogicalDatatype(this.getDesignPart());
        logicalDatatype.setObjectID(string);
        this.getDesign().addDesignObject(logicalDatatype);
        this.add(logicalDatatype);
        return logicalDatatype;
    }

    public LogicalDatatype getLogTypeByName(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)iterator.next();
            if (!string.equalsIgnoreCase(logicalDatatype.getName())) continue;
            return logicalDatatype;
        }
        return null;
    }

    public LogicalDatatype getLogTypeByObjectID(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)iterator.next();
            if (!string.equalsIgnoreCase(logicalDatatype.getObjectID())) continue;
            return logicalDatatype;
        }
        return null;
    }

    public List getLogicalDataTypes() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public LogicalDatatype getLogTypeByNativeType(String string, String string2) {
        int n;
        String string3;
        Map map;
        LogicalDatatype logicalDatatype;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            logicalDatatype = (LogicalDatatype)iterator.next();
            if (!string.equalsIgnoreCase(logicalDatatype.getName())) continue;
            map = logicalDatatype.getToPhysical();
            string3 = (String)map.get(string2);
            n = string3.indexOf(44);
            if (n > -1) {
                string3 = string3.substring(0, n);
            }
            if (!string.equalsIgnoreCase(string3.trim())) continue;
            return logicalDatatype;
        }
        iterator = this.iterator();
        while (iterator.hasNext()) {
            logicalDatatype = (LogicalDatatype)iterator.next();
            map = logicalDatatype.getToPhysical();
            string3 = (String)map.get(string2);
            n = string3.indexOf(44);
            if (n > -1) {
                string3 = string3.substring(0, n);
            }
            if (!string.equalsIgnoreCase(string3.trim())) continue;
            return logicalDatatype;
        }
        return null;
    }

    public LogicalDatatype getLogTypeForVarcharMax(String string, String string2) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map map;
            Map map2;
            String string3;
            LogicalDatatype logicalDatatype = (LogicalDatatype)iterator.next();
            Map map3 = logicalDatatype.getToPhysical();
            String string4 = (String)map3.get(string2);
            int n = string4.indexOf(44);
            if (n > -1) {
                string4 = string4.substring(0, n);
            }
            if (!string.equalsIgnoreCase(string4.trim()) || !"max".equalsIgnoreCase(string3 = (String)(map2 = (Map)(map = logicalDatatype.getDefaultValues()).get(string2)).get("size_default_value"))) continue;
            return logicalDatatype;
        }
        return null;
    }

    public LogicalDatatype getFirstNumberDataType() {
        return this.getLogTypeByNativeType("NUMBER", StorageDesignOraclev11g.RDBMS_TYPE.getName());
    }

    @Override
    public boolean canBedeleted() {
        return false;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean bl) {
        this.checkedOut = bl;
    }

    @Override
    public void setCheckedOutBy(String string) {
        this.checkedOutBy = string;
    }

    @Override
    public void setCheckedOutByMe(boolean bl) {
        this.checkedOutByMe = bl;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public void setRepositoryOID(String string) {
        this.repositoryOID = string;
    }

    @Override
    public void setRepositoryOVID(String string) {
        this.repositoryOVID = string;
    }

    @Override
    public String getName() {
        return "LogicalDatatypeSet";
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject repositoryObject) {
        this.pac_Element = repositoryObject;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.createUnknownType();
    }
}

