/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class Label
extends MultiShapedDesignObject
implements EditableFonts {
    private List editableFonts;
    private int site = 1;
    private TVConnector tvConnector;
    private Point2D lastPos = new Point2D.Double(0.0, 0.0);
    private boolean connectorSelected = false;

    public Label(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    @Override
    public String getObjectTypeName() {
        return "Label";
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "Label";
    }

    public String getText() {
        return this.getComment();
    }

    public void setText(String string) {
        this.setComment(string);
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("Label")) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("Label")) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
        } else {
            DefaultFontAndColor defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("Label");
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
        }
        this.setUseDefaultColor(bl);
    }

    public int getSite() {
        return this.site;
    }

    public void setSite(int n) {
        this.site = n;
    }

    public boolean isCenterLabel() {
        return this.site == 1;
    }

    public TVConnector getTVConnector() {
        return this.tvConnector;
    }

    public void setTVConnector(TVConnector tVConnector) {
        this.tvConnector = tVConnector;
    }

    public Point2D getLastPos() {
        return this.lastPos;
    }

    public void setLastPos(Point2D point2D) {
        this.lastPos.setLocation(point2D);
    }

    public boolean isConnectorSelected() {
        return this.connectorSelected;
    }

    public void setConnectorSelected(boolean bl) {
        this.connectorSelected = bl;
    }

    public Rectangle getBounds() {
        if (this.tvConnector != null) {
            switch (this.site) {
                case 0: {
                    return this.tvConnector.getSourceLabelBounds();
                }
                case 1: {
                    return this.tvConnector.getLabelBounds();
                }
                case 2: {
                    return this.tvConnector.getTargetLabelBounds();
                }
            }
        }
        return null;
    }

    public void setBounds(Rectangle rectangle) {
        if (this.tvConnector != null && rectangle != null) {
            switch (this.site) {
                case 0: {
                    this.tvConnector.setSourceLabelBounds(rectangle);
                    break;
                }
                case 1: {
                    this.tvConnector.setLabelBounds(rectangle);
                    break;
                }
                case 2: {
                    this.tvConnector.setTargetLabelBounds(rectangle);
                }
            }
        }
    }
}

