/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.List;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;

public abstract class KeyObject
extends SubsetCO
implements Constants {
    protected boolean unique = false;
    private FKIndexAssociation fkassociation = null;
    private boolean oidKey = false;
    private transient boolean isPK_temp = false;

    public KeyObject(DesignPart designPart) {
        super(designPart);
    }

    public boolean isValidPK() {
        ContainedObject[] containedObjectArray = this.getElements();
        if (containedObjectArray.length == 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < containedObjectArray.length; ++i) {
            bl = bl && !containedObjectArray[i].getNullsAllowed();
        }
        return bl;
    }

    public void makeValidPKIfNotEmpty() {
        ContainedObject[] containedObjectArray = this.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            containedObjectArray[i].setNullsAllowed(false);
        }
    }

    public void setUnique(boolean bl) {
        if (this.unique != bl) {
            this.unique = bl;
            this.isPK_temp = false;
            this.setColumnsState(bl);
            ObjectChangeEvent objectChangeEvent = null;
            objectChangeEvent = bl ? ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE : ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE;
            this.fireChange(objectChangeEvent);
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void makePK() {
        this.setPK(true);
        this.makeValidPKIfNotEmpty();
    }

    public void setColumnsState(boolean bl) {
        ContainedObject[] containedObjectArray = this.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            if (containedObjectArray[i].isUnique() == bl) continue;
            containedObjectArray[i].setUnique(bl);
        }
    }

    public void setPK(boolean bl) {
        boolean bl2 = this.isPK();
        if (!bl2 && !bl) {
            return;
        }
        if (bl2 == bl) {
            return;
        }
        if (bl && this.isUnique()) {
            this.setUnique(false);
        }
        if (this.getTopLevelContainer() != null) {
            KeyObject keyObject = bl ? this : null;
            KeyObject keyObject2 = ((ContainerWithKeyObject)this.getTopLevelContainer()).getPK();
            ObjectChangeEvent objectChangeEvent = null;
            boolean bl3 = ((ContainerWithKeyObject)this.getTopLevelContainer()).hasKey(this);
            if (bl) {
                if (keyObject2 != null && keyObject2 != keyObject && bl) {
                    keyObject2.firePKRemoved();
                    keyObject2.isPK_temp = false;
                }
                if (bl3) {
                    ((ContainerWithKeyObject)this.getTopLevelContainer()).setPK(keyObject);
                    this.isPK_temp = true;
                    this.makeValidPKIfNotEmpty();
                    objectChangeEvent = ObjectChangeEvent.KEY_CHANGED_TO_PK;
                } else {
                    this.isPK_temp = true;
                    this.makeValidPKIfNotEmpty();
                }
            } else {
                this.isPK_temp = false;
                if (bl2 && bl3) {
                    ((ContainerWithKeyObject)this.getTopLevelContainer()).setPK(null);
                }
                objectChangeEvent = ObjectChangeEvent.KEY_CHANGED_NO_PK;
            }
            if (objectChangeEvent != null) {
                this.fireChange(objectChangeEvent);
            }
            if (!bl && !this.isUnique()) {
                this.setUnique(true);
            }
        }
    }

    public void firePKRemoved() {
        ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.PK_REMOVED;
        this.fireChange(objectChangeEvent);
        this.setUnique(true);
    }

    public boolean isPK() {
        if (this.getTopLevelContainer() != null) {
            if (this.isPK_temp) {
                return true;
            }
            ContainerWithKeyObject containerWithKeyObject = (ContainerWithKeyObject)this.getTopLevelContainer();
            KeyObject keyObject = containerWithKeyObject.getPK();
            if (containerWithKeyObject.hasKey(this) && keyObject != null && keyObject.getObjectID().equals(this.getObjectID())) {
                return true;
            }
        }
        return false;
    }

    public boolean isFK() {
        return this.getFKAssociation() != null;
    }

    public FKIndexAssociation getFKAssociation() {
        return this.fkassociation;
    }

    public void setFKAssociation(FKIndexAssociation fKIndexAssociation) {
        this.fkassociation = fKIndexAssociation;
    }

    @Override
    public void remove() {
        if (this.getContainerWithKeyObject() != null) {
            this.getContainerWithKeyObject().remove(this);
        }
        super.remove();
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        return (ContainerWithKeyObject)this.getTopLevelContainer();
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainerWithKeyObject() != null && this.getContainerWithKeyObject().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView designPartView) {
        return this.getContainerWithKeyObject().hasRepresentationInDPV(designPartView);
    }

    public boolean isOidKey() {
        return this.oidKey;
    }

    public void setOidKey(boolean bl) {
        this.oidKey = bl;
    }

    public boolean hasFKAttribute() {
        Attribute[] attributeArray = (Attribute[])this.getElements();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (!attributeArray[i].isFKAttribute()) continue;
            return true;
        }
        return false;
    }

    public Attribute getFKAttribute() {
        Attribute[] attributeArray = (Attribute[])this.getElements();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (!attributeArray[i].isFKAttribute()) continue;
            return attributeArray[i];
        }
        return null;
    }

    @Override
    protected void assignLocalID(ModelIDObject modelIDObject) {
    }

    public XtdMapping getDeletedMapping(ContainerWithKeyObject containerWithKeyObject) {
        String string = containerWithKeyObject.getObjectID();
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, containerWithKeyObject.getDesignPartId());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string2;
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                if (string.equals(xtdMapping.getRecreatedContainerID())) {
                    return xtdMapping;
                }
                if (this.getContainerObject() == null || !string.equals(string2 = xtdMapping.getOtherContainerID(this.getContainerObject().getObjectID()))) continue;
                return xtdMapping;
            }
        }
        return null;
    }

    public XtdMapping getDeletedMapping(String string, String string2) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, string2);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                if (string.equals(xtdMapping.getRecreatedContainerID())) {
                    return xtdMapping;
                }
                String string3 = xtdMapping.getDeletedID();
                String string4 = ContainerObject.getContainerID_From(string3);
                if (!string.equals(string4)) continue;
                return xtdMapping;
            }
        }
        return null;
    }

    @Override
    public void setDirty(boolean bl) {
        super.setDirty(bl);
        if (bl && this.getContainerObject() != null) {
            this.getContainerObject().setDirty(bl);
        }
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        KeyObject keyObject = (KeyObject)designObject;
        this.setOidKey(this.isOidKey());
        ContainerWithKeyObject containerWithKeyObject = keyObject.getContainerWithKeyObject();
        keyObject.getElementsCollection().clear();
        for (ContainedObject containedObject : this.getElementsCollection()) {
            ContainedObject containedObject2 = containerWithKeyObject.getElementByID(containedObject.getObjectID());
            if (containedObject2 == null) {
                containedObject2 = containerWithKeyObject.getElementByName(containedObject.getName());
            }
            if (containedObject2 == null) continue;
            keyObject.getElementsCollection().add(containedObject2);
        }
    }

    @Override
    public void setObjectID(String string) {
        String string2 = this.getObjectID();
        super.setObjectID(string);
        ContainerWithKeyObject containerWithKeyObject = this.getContainerWithKeyObject();
        if (containerWithKeyObject != null && string2 == null) {
            containerWithKeyObject.putInLocalIDMap(string, this);
        }
        if (containerWithKeyObject != null && string != null && string2 != null && !string.equals(string2)) {
            containerWithKeyObject.updateLocalObjectId(string2, string);
        }
    }
}

