/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDataTypeStrings;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.util.string.StringUtilities;

public class DomainFactory
implements SectionConstants,
LogicalDataTypeStrings {
    private Map domainMap = new HashMap();
    public static String DOOMAIN_FILE_SUFIX = "_Domains";

    public Domain getInstance(Design design, LogicalDatatype logicalDatatype, MDDataType mDDataType, int n, String[] stringArray, String string) {
        String string2 = string != null ? string : DomainFactory.createDomainName(logicalDatatype, stringArray);
        Domain domain = (Domain)this.domainMap.get(string2);
        if (domain == null) {
            DomainSet domainSet = design.getDomainSet();
            Domain domain2 = domainSet.createDomain();
            domain2.setName(string2);
            if (logicalDatatype != null) {
                domain2.setLogicalDatatype(logicalDatatype);
            } else {
                LogicalDatatype logicalDatatype2 = design.getLogicalDatatypeSet().createLogicalDatatype(null);
                domain2.setLogicalDatatype(logicalDatatype2);
            }
            if (mDDataType != null) {
                domain2.setDataType(mDDataType);
            }
            switch (n) {
                case 0: {
                    domain2.setFileName(design.getFileName() + DOOMAIN_FILE_SUFIX);
                    break;
                }
                case 1: {
                    domain2.setFileName(design.getFileName() + DOOMAIN_FILE_SUFIX);
                    break;
                }
                case 2: {
                    domain2.setFileName(design.getFileName() + DOOMAIN_FILE_SUFIX);
                    break;
                }
                case 3: {
                    domain2.setFileName(design.getFileName() + DOOMAIN_FILE_SUFIX);
                    break;
                }
                default: {
                    domain2.setFileName("wrongFileName");
                }
            }
            domain2.setOwnerDesignName(design.getFileName());
            this.setParameters(domain2, stringArray);
            this.domainMap.put(string2, domain2);
            return domain2;
        }
        return domain;
    }

    public static String createDomainName(LogicalDatatype logicalDatatype, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (logicalDatatype != null) {
            stringBuffer.append(logicalDatatype.getName());
        } else {
            stringBuffer.append("UNKNOWN");
        }
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (StringUtilities.isNotEmpty(stringArray[i])) {
                    stringBuffer.append("_" + stringArray[i]);
                    continue;
                }
                stringBuffer.append("_0");
            }
        }
        return stringBuffer.toString();
    }

    private void setParameters(Domain domain, String[] stringArray) {
        LogicalDatatype logicalDatatype = domain.getLogicalDatatype();
        if (logicalDatatype != null) {
            domain.setDataTypeParameter("size", stringArray[2]);
            domain.setDataTypeParameter("scale", stringArray[1]);
            domain.setDataTypeParameter("precision", stringArray[0]);
        }
    }
}

