/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.crest.imports.domains.DomainPropertiesComparator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.datatype.DataTypeListener;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.swingui.editor.DomainPropertiesDialogEx;

public class Domain
extends DesignObject
implements DataTypeListener,
ObjectListener,
ConstrainedObject {
    public static final ObjectChangeEvent CONSTRAINT_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.ConstraintChanged"));
    public static final ObjectChangeEvent DATATYPE_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.DatatypeChanged"));
    public static final ObjectChangeEvent LOGICALTYPE_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.LogicalDatatypeChanged"));
    public static final ObjectChangeEvent DATATYPE_SIZEINFO_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.DatatypeSizePrecisionScaleChanged"));
    public static final ObjectChangeEvent FILENAME_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.DomainFilenameChanged"));
    public static final String TYPE_NAME = "Domain";
    public static final String DEFAULT_FILE = "defaultdomains";
    private String fileName;
    private LogicalDatatype logicalType;
    private Map parameters = new TreeMap();
    private Map dataTypes = new TreeMap();
    private CheckConstraint check;
    private ConstraintEnumeration valueList;
    private String defaultValue;
    private String unitOfMeasure;
    private Set avts;
    private int avtSortOrder = 0;
    private String synonym;
    private String dimension = "";
    private boolean readonly = false;
    private boolean persisted;

    public Domain(DesignPart designPart) {
        super(designPart);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.synonym = "";
        this.fileName = DEFAULT_FILE;
        this.logicalType = null;
        this.check = null;
        this.avts = new TreeSet();
        this.valueList = null;
        this.setComment("");
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public MDDataType getDataType() {
        return this.getDataType(this.getSelectedRDBMSType().toString());
    }

    public MDDataType getDataType(String string) {
        if (!this.dataTypes.containsKey(string)) {
            MDDataType mDDataType = this.getLogicalDatatype().createDataType(string, this.parameters);
            this.dataTypes.put(string, mDDataType);
        }
        if (this.dataTypes.get(string) == null) {
            this.dataTypes.put(string, MDDataTypeFactory.getInstance(string, this.getDesign().getAppView().getSettings()).createStringEncodedType("UNKNOWN"));
        }
        return (MDDataType)this.dataTypes.get(string);
    }

    public void setDataType(MDDataType mDDataType) {
        this.setDataType(this.getSelectedRDBMSType().toString(), mDDataType);
    }

    public void setDataType(String string, MDDataType mDDataType) {
        if (this.dataTypes.containsKey(string)) {
            if (this.dataTypes.get(string) == mDDataType) {
                return;
            }
            ((MDDataType)this.dataTypes.get(string)).removeDataTypeListener(this);
        }
        this.dataTypes.put(string, mDDataType);
        mDDataType.addDataTypeListener(this);
        this.fireChange(DATATYPE_CHANGED);
    }

    public void setDataTypeParameter(String string, String string2) {
        if (string2 == null || "".equals(string2)) {
            this.parameters.remove(string);
            this.dataTypes.clear();
        } else {
            String string3 = (String)this.parameters.get(string);
            if (string3 == null || string3 != null && !string3.equals(string2)) {
                this.parameters.put(string, string2);
                this.dataTypes.clear();
            }
        }
    }

    public String getDataTypeParameter(String string) {
        Object object = this.parameters.get(string);
        if (object == null) {
            object = "";
        }
        return (String)object;
    }

    public String getSize() {
        return this.getDataTypeParameter("size");
    }

    public String getPrecision() {
        return this.getDataTypeParameter("precision");
    }

    public String getScale() {
        return this.getDataTypeParameter("scale");
    }

    public Iterator getDataTypeParameterNames() {
        return this.parameters.keySet().iterator();
    }

    public void setLogicalDatatype(LogicalDatatype logicalDatatype) {
        if (this.logicalType != logicalDatatype) {
            this.dataTypes.clear();
            if (this.logicalType != null) {
                this.logicalType.removeObjectListener(this);
            }
            this.logicalType = logicalDatatype;
            if (logicalDatatype != null) {
                logicalDatatype.addObjectListener(this);
                this.fireChange(LOGICALTYPE_CHANGED);
            }
        }
    }

    public LogicalDatatype getLogicalDatatype() {
        if (this.logicalType == null) {
            this.logicalType = this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        return this.logicalType;
    }

    public LogicalDatatype[] getAvailableLogicalDatatypes() {
        return (LogicalDatatype[])this.getDesign().getLogicalDatatypeSet().toArray();
    }

    public String[] getRequiredParametersNames() {
        return this.getLogicalDatatype().getRequiredParameters();
    }

    public String getRequiredParametersRepresentation() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getRequiredParametersNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public String getUnits() {
        String string = this.getSize();
        String[] stringArray = string.split(" ");
        if (stringArray.length == 2) {
            return stringArray[1];
        }
        return "";
    }

    public void setFileName(String string) {
        if (!this.fileName.equals(string)) {
            this.fileName = string;
            if (DEFAULT_FILE.equals(string)) {
                this.setOwnerDesignName(Design.getSystemDesignName());
            }
            this.fireChange(FILENAME_CHANGED);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getOwnerDesignName() {
        if (DEFAULT_FILE.equals(this.getFileName())) {
            return Design.getSystemDesignName();
        }
        return super.getOwnerDesignName();
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public void changed(MDDataType mDDataType) {
        this.fireChange(DATATYPE_SIZEINFO_CHANGED);
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("domain id prefix");
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public int getNumberOfChildren() {
        return 0;
    }

    @Override
    public ModelObject getChild(int n) {
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Object getParent() {
        return this.getDesign().getDomainSet();
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String string) {
        if (!this.synonym.equals(string)) {
            this.synonym = string;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String string) {
        if (string != null && string.equals(this.dimension)) {
            return;
        }
        this.dimension = string;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public void addAVT(AVT aVT) {
        if (!this.avts.contains(aVT)) {
            this.avts.add(aVT);
        }
    }

    @Override
    public Set getAVTs() {
        LogicalDatatype logicalDatatype;
        if (this.avts.size() > 1 && (logicalDatatype = this.getLogicalDatatype()) != null && logicalDatatype.isNumeric()) {
            TreeSet treeSet = new TreeSet(new AVTNumberComparator());
            treeSet.addAll(this.avts);
            return treeSet;
        }
        return this.avts;
    }

    @Override
    public void removeAVT(AVT aVT) {
        if (this.avts.contains(aVT)) {
            this.avts.remove(aVT);
        }
    }

    @Override
    public void clearAVTs() {
        this.avts.clear();
    }

    public String getAVTString() {
        return "View";
    }

    @Override
    public ConstraintEnumeration getValueList() {
        return this.valueList;
    }

    @Override
    public void setValueList(ConstraintEnumeration constraintEnumeration) {
        this.valueList = constraintEnumeration;
    }

    public Iterator getValueIterator() {
        return this.getValues().iterator();
    }

    public Set getValues() {
        ConstraintEnumeration constraintEnumeration = this.getValueList();
        if (constraintEnumeration != null) {
            LogicalDatatype logicalDatatype;
            Set set = constraintEnumeration.getValues();
            if (set.size() > 1 && (logicalDatatype = this.getLogicalDatatype()) != null && logicalDatatype.isNumeric()) {
                TreeSet treeSet = new TreeSet(new ValueComparator());
                treeSet.addAll(set);
                return treeSet;
            }
            return set;
        }
        return new TreeSet();
    }

    @Override
    public CheckConstraint getCheck() {
        return this.check;
    }

    @Override
    public void setCheck(CheckConstraint checkConstraint) {
        if (this.check != checkConstraint) {
            this.check = checkConstraint;
            this.fireChange(CONSTRAINT_CHANGED);
        }
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getDefaultValue() {
        String string = this.defaultValue;
        if (string == null) {
            return "";
        }
        return this.defaultValue;
    }

    public void setUnitOfMeasure(String string) {
        this.unitOfMeasure = string;
    }

    public String getUnitOfMeasure() {
        if (this.unitOfMeasure == null) {
            return "";
        }
        return this.unitOfMeasure;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DomainPropertiesDialogEx domainPropertiesDialogEx = new DomainPropertiesDialogEx(this.getDesign().getAppView(), this);
            domainPropertiesDialogEx.initProperties(this);
            domainPropertiesDialogEx.show();
        }
    }

    public void copyTo(Domain domain) {
        domain.setName(this.getName());
        domain.setSynonym(this.getSynonym());
        domain.setLogicalDatatype(this.getLogicalDatatype());
        domain.setComment(this.getComment());
        domain.setFileName(this.getFileName());
        domain.setDataTypeParameter("precision", this.getDataTypeParameter("precision"));
        domain.setDataTypeParameter("scale", this.getDataTypeParameter("scale"));
        domain.setDataTypeParameter("size", this.getDataTypeParameter("size"));
        DomainPropertiesComparator.copyCheckConstrant(this, domain);
        DomainPropertiesComparator.copyLOVConstrant(this, domain);
        DomainPropertiesComparator.copyRangeConstrant(this, domain);
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (bl) {
            this.getChange().setTimeNow();
        }
        if (bl) {
            this.getDesign().setDirty(bl);
        }
    }

    public String getLogicalRepresentationName(boolean bl) {
        String string = this.getName();
        if (bl && this.getLogicalDatatype() != null) {
            string = this.getLogicalDatatype().getName();
            String string2 = this.getDataTypeParameter("size");
            if (string2 != null && !"".equals(string2) && !"0".equals(string2)) {
                return string + "(" + string2 + ")";
            }
            String string3 = this.getDataTypeParameter("precision");
            if (string3 != null && !"".equals(string3) && !"0".equals(string3)) {
                String string4 = this.getDataTypeParameter("scale");
                if (string4 != null && !"".equals(string4) && !"0".equals(string4)) {
                    return string + "(" + string3 + "," + string4 + ")";
                }
                return string + "(" + string3 + ")";
            }
        }
        return string;
    }

    @Override
    public int getAVTSortOrder() {
        return this.avtSortOrder;
    }

    @Override
    public void setAVTSortOrder(int n) {
        this.avtSortOrder = n;
    }

    public boolean isDefault() {
        return DEFAULT_FILE.equalsIgnoreCase(this.fileName);
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readonly = bl;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean bl) {
        this.persisted = bl;
    }

    public void setDataTypeSize(String string) {
        this.setDataTypeParameter("size", string);
    }

    public String getDataTypeSize() {
        return this.getDataTypeParameter("size");
    }

    public void setDataTypePrecision(String string) {
        this.setDataTypeParameter("precision", string);
    }

    public String getDataTypePrecision() {
        return this.getDataTypeParameter("precision");
    }

    public void setDataTypeScale(String string) {
        this.setDataTypeParameter("scale", string);
    }

    public String getDataTypeScale() {
        return this.getDataTypeParameter("scale");
    }

    public ConstraintEnumeration createConstraintEnumeration() {
        ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
        constraintEnumeration.setDesign(this.getDesign());
        return constraintEnumeration;
    }

    public CheckConstraint createCheckConstraint() {
        CheckConstraint checkConstraint = new CheckConstraint();
        checkConstraint.setDesign(this.getDesign());
        return checkConstraint;
    }

    public void clearCheckConstraint() {
        this.check = null;
    }

    public void clearValueList() {
        this.valueList = null;
    }

    public AVT createAVT() {
        return new AVT();
    }

    public List getAVTList() {
        ArrayList<AVT> arrayList = new ArrayList<AVT>();
        for (AVT aVT : this.getAVTs()) {
            arrayList.add(aVT);
        }
        return arrayList;
    }

    public void applyAVTList(List list) {
        this.avts.clear();
        this.avts.addAll(list);
    }

    public static void clearEvents() {
        CONSTRAINT_CHANGED.setAffected(null);
        DATATYPE_CHANGED.setAffected(null);
        LOGICALTYPE_CHANGED.setAffected(null);
        DATATYPE_SIZEINFO_CHANGED.setAffected(null);
        FILENAME_CHANGED.setAffected(null);
    }

    private class ValueComparator
    implements Comparator {
        private ValueComparator() {
        }

        public int compare(Object object, Object object2) {
            try {
                double d = Double.parseDouble((String)object);
                double d2 = Double.parseDouble((String)object2);
                if (d > d2) {
                    return 1;
                }
                if (d < d2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception exception) {
                return ((String)object).compareTo((String)object2);
            }
        }
    }

    private class AVTNumberComparator
    implements Comparator {
        private AVTNumberComparator() {
        }

        public int compare(Object object, Object object2) {
            try {
                double d = Double.parseDouble(((AVT)object).getBeginValue());
                double d2 = Double.parseDouble(((AVT)object2).getBeginValue());
                if (d > d2) {
                    return 1;
                }
                if (d < d2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception exception) {
                return ((AVT)object).getBeginValue().compareTo(((AVT)object2).getBeginValue());
            }
        }
    }
}

