/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramViewListener;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewRenderer;

public class DiagramView
extends MultiShapedDesignObject
implements DiagramViewListener {
    private DesignPartView dpv = null;
    private String dpvID = "";
    private String dpvName = "";
    private boolean compositeView = false;
    private DiagramViewRenderer renderer;

    public DiagramView(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return Messages.getString("DiagramView.DiagramView");
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "DiagramView";
    }

    @Override
    public void showPropertyDialog() {
        if (this.getDesignPartView() != null) {
            if (this.getDesignPartView().isMainDiagram()) {
                this.getDesignPartView().getDesignPart().showPropertyDialog();
            } else if (this.getDesignPartView().getPlaceHolder() != null) {
                this.getDesignPartView().getPlaceHolder().showPropertyDialog();
            }
        }
    }

    public DesignPartView getDesignPartView() {
        DesignPartView designPartView;
        if (this.dpv == null && !"".equalsIgnoreCase(this.dpvID) && (designPartView = this.getDesign().getDesignPartView(this.dpvID)) != null) {
            if (!designPartView.isVisible()) {
                designPartView.setVisible(true);
            }
            this.setDesignPartView(designPartView);
        }
        return this.dpv;
    }

    public void setDesignPartView(DesignPartView designPartView) {
        if (this.dpv != designPartView) {
            if (this.dpv != null) {
                this.dpv.removeDiagramViewListener(this);
            }
            this.dpv = designPartView;
            designPartView.getDesignPart().addDiagramViewListener(this);
            designPartView.addDiagramViewListener(this);
            this.dpvID = designPartView.getDPVId();
        }
    }

    @Override
    public void designPartDeleted(DesignPart designPart) {
        if (designPart == this.getDesignPartView().getDesignPart()) {
            this.remove();
        }
    }

    public void removeIfNotModelExists() {
        DesignPartView designPartView = this.getDesign().getDesignPartView(this.dpvID);
        if (designPartView == null) {
            super.remove();
        }
    }

    @Override
    public void remove() {
        if (this.getDesignPartView() != null) {
            this.getDesignPartView().getDesignPart().removeDiagramViewListener(this);
            this.getDesignPartView().removeDiagramViewListener(this);
        }
        super.remove();
    }

    public String getDpvID() {
        if (this.getDesignPartView() != null) {
            return this.getDesignPartView().getDPVId();
        }
        return this.dpvID;
    }

    public void setDpvID(String string) {
        this.dpvID = string;
    }

    public String getDpvName() {
        if (this.getDesignPartView() != null) {
            return this.getDesignPartView().getName();
        }
        return this.dpvName;
    }

    public void setDpvName(String string) {
        this.dpvName = string;
    }

    public boolean isCompositeView() {
        if (this.getDesignPartView() == null || !this.getDesignPartView().getDesignPart().isLoaded()) {
            return false;
        }
        return this.compositeView;
    }

    public void setCompositeView(boolean bl) {
        this.compositeView = bl;
    }

    public DiagramViewRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DiagramViewRenderer diagramViewRenderer) {
        this.renderer = diagramViewRenderer;
    }

    @Override
    public void designPartViewDeleted(DesignPartView designPartView) {
        if (this.dpv == designPartView) {
            if (!this.dpv.isMasterDPV()) {
                this.setDesignPartView(this.dpv.getMasterDPV());
                this.dpv.setVisible(true);
                this.getRenderer().resetOverviewPanel();
            } else {
                this.remove();
            }
        }
    }
}

