/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;

public abstract class DesignObjectSet
extends ModelObject
implements ElementSet {
    protected List elements = new ArrayList();
    private Set listeners = new HashSet();
    protected Map names = new TreeMap();
    protected int count = 1;
    private boolean createNameVariants = true;
    private String name;
    private DesignPart designPart;
    protected static boolean clearAll = false;
    private DesignObject currentRemoved = null;
    private SegmentNameManager segManager = new SegmentNameManager();
    private Boolean containsTopLevelStorableObjects = null;
    protected boolean requireSort = false;
    public static final DesignObjectSet NULL_SET = new NullSet(null);

    public DesignObjectSet(DesignPart designPart) {
        this.designPart = designPart;
    }

    public boolean add(DesignObject designObject) {
        if (!this.getDesign().isLoading()) {
            String string;
            if (this.elements.contains(designObject)) {
                return false;
            }
            DesignObjectSet designObjectSet = designObject.getDesignObjectSet();
            designObject.setDesignObjectSet(this);
            String string2 = designObject.getName().trim();
            String string3 = string = designObject.getLongName().trim();
            if (designObject instanceof ContainerObject) {
                string3 = string2;
            }
            if (this.names.containsKey(string3.toUpperCase())) {
                if (this.getCreateNameVariants()) {
                    int n = string.length() - string2.length();
                    String string4 = this.createNameVariant(string3);
                    String string5 = "";
                    string5 = designObject instanceof ContainerObject ? string4 : string4.substring(n);
                    designObject.setName(string5);
                    boolean bl = this.doAdd(designObject);
                    return bl;
                }
                designObject.setDesignObjectSet(designObjectSet);
                return false;
            }
        } else {
            designObject.setDesignObjectSet(this);
        }
        return this.doAdd(designObject);
    }

    public DesignObject[] getProtoArray() {
        return (DesignObject[])this.getProtoTypeArray();
    }

    public boolean containsId(String string) {
        return null != this.getObjectByID(string);
    }

    protected boolean doAdd(DesignObject designObject) {
        this.elements.add(designObject);
        if (ApplicationView.canLogging && this.requireSort) {
            this.sort();
        }
        this.addToNameMap(designObject);
        SetEvent.OBJECT_ADDED.setAffected(designObject);
        this.fireChange(SetEvent.OBJECT_ADDED);
        return true;
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_COMPARATOR);
    }

    public boolean justAdd(DesignObject designObject) {
        if (!this.contains(designObject)) {
            this.elements.add(designObject);
            this.addToNameMap(designObject);
            SetEvent.OBJECT_ADDED.setAffected(designObject);
            this.fireChange(SetEvent.OBJECT_ADDED);
            return true;
        }
        return false;
    }

    public void addToNameMap(DesignObject designObject) {
        String string = designObject.getLongName();
        if (designObject instanceof ContainerObject) {
            string = designObject.getName();
        }
        this.names.put(string.toUpperCase(), designObject);
    }

    private void removeFromNameMap(DesignObject designObject) {
        if (!clearAll) {
            String string;
            Object object;
            String string2;
            if (designObject instanceof ContainerObject) {
                string2 = designObject instanceof Table || designObject instanceof TableView ? designObject.getLongName() : designObject.getName();
            } else {
                string2 = designObject.getLongName();
                if (designObject instanceof Column && (object = ((Column)designObject).getContainer()) != null && !"".equals(string = ((ContainerObject)object).getSchema())) {
                    string2 = string + "." + string2;
                }
            }
            this.names.remove(string2.toUpperCase());
            if (this.names.containsValue(designObject)) {
                object = this.names.keySet().iterator();
                while (object.hasNext()) {
                    string = object.next();
                    if (!this.names.get(string).equals(designObject)) continue;
                    object.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DesignObject designObject) {
        boolean bl = this.elements.remove(designObject);
        if (designObject.getDesign().isCleaning() || designObject.getDesign().isClosing() || bl) {
            this.getDesign().removeDesignObject(designObject);
            this.removeFromNameMap(designObject);
            designObject.setDesignObjectSet(null);
            this.currentRemoved = designObject;
            SetEvent.OBJECT_REMOVED.setAffected(designObject);
            try {
                this.fireChange(SetEvent.OBJECT_REMOVED);
            }
            finally {
                this.currentRemoved = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        clearAll = true;
        try {
            DesignObject[] designObjectArray = (DesignObject[])this.toArray();
            for (int i = designObjectArray.length - 1; i >= 0; --i) {
                this.remove(designObjectArray[i]);
            }
            this.names.clear();
            this.resetCounter();
        }
        finally {
            clearAll = false;
        }
    }

    public boolean containsName(String string) {
        return this.names.containsKey(string.toUpperCase());
    }

    @Override
    public boolean contains(ModelObject modelObject) {
        return this.elements.contains(modelObject);
    }

    @Override
    public DesignObject getByName(String string) {
        DesignObject designObject2 = (DesignObject)this.names.get(string);
        if (designObject2 == null && (designObject2 = (DesignObject)this.names.get(string.toUpperCase())) == null && string.indexOf(46) == -1) {
            for (DesignObject designObject2 : this.elements) {
                if (!string.equalsIgnoreCase(designObject2.getName())) continue;
                return designObject2;
            }
            return null;
        }
        return designObject2;
    }

    public DesignObject getByName(String string, DesignObject designObject) {
        DesignObject designObject2 = (DesignObject)this.names.get(string);
        if (designObject2 == null) {
            designObject2 = (DesignObject)this.names.get(string.toUpperCase());
        }
        return designObject2;
    }

    public DesignObject getBySchemaAndName(String string, String string2) {
        for (DesignObject designObject : this.elements) {
            if (!designObject.getSchema().equalsIgnoreCase(string) || !designObject.getName().equalsIgnoreCase(string2)) continue;
            return designObject;
        }
        return null;
    }

    public DesignObject getByVeryLongdName(String string) {
        for (DesignObject designObject : this.elements) {
            if (!designObject.getVeryLongName().equalsIgnoreCase(string)) continue;
            return designObject;
        }
        return null;
    }

    public DesignObject getByName(String string, boolean bl) {
        for (DesignObject designObject : this.elements) {
            if (!(bl ? designObject.getName().equals(string) : designObject.getName().equalsIgnoreCase(string))) continue;
            return designObject;
        }
        return null;
    }

    public DesignObject getByLongName(String string) {
        return (DesignObject)this.names.get(string.toUpperCase());
    }

    public boolean changeName(String string, String string2, DesignObject designObject) {
        if (string != null) {
            Object v;
            Object v2 = this.names.get(string.toUpperCase());
            if ((v2 == null || v2 != null && v2 == designObject) && ((v = this.names.get(string2.toUpperCase())) == null || v != null && v == designObject)) {
                this.doRenaming(string, string2, designObject);
                return true;
            }
        } else {
            Object v = this.names.get(string2.toUpperCase());
            if (v == null || v != null && v == designObject) {
                this.doRenaming(string, string2, designObject);
                return true;
            }
        }
        return false;
    }

    private void doRenaming(String string, String string2, DesignObject designObject) {
        if (designObject.getDesign().isLoading()) {
            if (string != null) {
                String string3 = string.toUpperCase();
                DesignObject designObject2 = (DesignObject)this.names.get(string3);
                if (designObject2 != null && designObject2 != designObject) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("DesignObjectSet.TwoObjectsWithSameName"), string));
                }
                this.names.remove(string3);
            }
            this.names.put(string2.toUpperCase(), designObject);
            if (ApplicationView.canLogging) {
                this.refreshContainedObjectsNames(string, string2, designObject);
                this.sort();
            }
        } else if (this.contains(designObject)) {
            if (string != null) {
                String string4 = string.toUpperCase();
                DesignObject designObject3 = (DesignObject)this.names.get(string4);
                if (designObject3 != null && designObject3 != designObject) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("DesignObjectSet.TwoObjectsWithSameName"), string));
                }
                this.names.remove(string4);
            }
            this.names.put(string2.toUpperCase(), designObject);
            if (ApplicationView.canLogging) {
                this.refreshContainedObjectsNames(string, string2, designObject);
                if (this.requireSort) {
                    this.sort();
                }
                SetEvent.SORT_COLLECTION.setAffected(designObject);
                this.fireChange(SetEvent.SORT_COLLECTION);
            }
            SetEvent.NAME_CHANGED.setAffected(designObject);
            this.fireChange(SetEvent.NAME_CHANGED);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateNamesMap(SchemaObject schemaObject, String string, SchemaObject schemaObject2, String string2, DesignObject designObject) {
        String string3;
        String string4 = schemaObject != null ? (schemaObject.getName() + "." + string).toUpperCase() : string.toUpperCase();
        if (string4.equals(string3 = schemaObject2 != null ? (schemaObject2.getName() + "." + string2).toUpperCase() : string2.toUpperCase())) {
            return true;
        }
        Object v = this.names.get(string4);
        if (v != null) {
            if (v != designObject) return false;
            this.names.remove(string4);
            Object v2 = this.names.get(string3);
            if (v2 != null && v2 != designObject) {
                return false;
            }
            this.names.put(string3, designObject);
            return true;
        } else {
            Object v3 = this.names.get(string3);
            if (v3 != null && v3 != designObject) {
                return false;
            }
            this.names.put(string3, designObject);
        }
        return true;
    }

    private void refreshContainedObjectsNames(String string, String string2, DesignObject designObject) {
        if (designObject instanceof ContainerWithKeyObject) {
            ContainerWithKeyObject containerWithKeyObject = (ContainerWithKeyObject)designObject;
            containerWithKeyObject.getContainedSet().refreshNames(string, string2);
            if (ApplicationView.canLogging) {
                containerWithKeyObject.getContainedSet().sort();
            }
            containerWithKeyObject.getKeySet().refreshNames(string, string2);
            if (designObject instanceof Table && ApplicationView.canLogging) {
                ((RelationalDesign)designObject.getDesignPart()).getFKIndexAssociationSet().sort();
            } else if (designObject instanceof Entity && ApplicationView.canLogging) {
                ((LogicalDesign)designObject.getDesignPart()).getGlobalCandidateKeySet().sortByLongName();
            }
        } else if (designObject instanceof ContainerObject && !(designObject instanceof KeyObject) && !(designObject instanceof Arc) && !(designObject instanceof FKArc)) {
            ContainerObject containerObject = (ContainerObject)designObject;
            containerObject.getContainedSet().refreshNames(string, string2);
        }
        if (!(designObject instanceof Index && ApplicationView.canLogging || designObject instanceof Column && ApplicationView.canLogging)) {
            if (designObject instanceof CandidateKey && ApplicationView.canLogging) {
                ((LogicalDesign)designObject.getDesignPart()).getGlobalCandidateKeySet().sortByLongName();
            } else if (designObject instanceof Relation && ApplicationView.canLogging) {
                ((LogicalDesign)designObject.getDesignPart()).getRelationSet().sort();
            } else if (!(designObject instanceof Attribute) || ApplicationView.canLogging) {
                // empty if block
            }
        }
    }

    public void refreshNames(String string, String string2) {
        String string3 = string.toUpperCase() + '.';
        int n = string3.length() - 1;
        String string4 = string2.toUpperCase();
        Object[] objectArray = this.names.keySet().toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            String string5 = (String)objectArray[i];
            if (!string5.startsWith(string3)) continue;
            Object v = this.names.get(string5);
            String string6 = string5.substring(n);
            this.names.remove(string5);
            this.names.put(string4 + string6, v);
        }
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray(this.getProtoTypeArray());
    }

    protected abstract Object[] getProtoTypeArray();

    protected abstract String getDefaultNamePrefix();

    protected String getSeparator() {
        return "_";
    }

    protected String getVariantSeparator() {
        return "v";
    }

    public Class getElementClass() {
        return this.getProtoTypeArray().getClass().getComponentType();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getDefaultNamePrefix();
    }

    @Override
    public boolean setName(String string) {
        boolean bl = super.setName(string);
        if (bl) {
            this.name = string;
        }
        return bl;
    }

    public String createName(DesignObject designObject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDefaultNamePrefix());
        stringBuffer.append(this.getSeparator());
        while (this.getByName(stringBuffer.toString() + String.valueOf(this.count), designObject) != null) {
            ++this.count;
        }
        stringBuffer.append(this.count++);
        return stringBuffer.toString();
    }

    public String createName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDefaultNamePrefix());
        stringBuffer.append(this.getSeparator());
        while (this.getByName(stringBuffer.toString() + String.valueOf(this.count)) != null) {
            ++this.count;
        }
        stringBuffer.append(this.count++);
        return stringBuffer.toString();
    }

    public String createNameVariant(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = string;
        stringBuffer.append(this.getVariantSeparator());
        int n = stringBuffer.length();
        for (int i = 1; i <= this.names.size(); ++i) {
            stringBuffer.setLength(n);
            stringBuffer.append(i);
            string2 = stringBuffer.toString();
            if (this.names.containsKey(string2.toUpperCase())) continue;
            return string2;
        }
        throw new IllegalStateException("NoNameVariantFound");
    }

    public String createNameVariant(String string, String string2) {
        if (string == null || "".equals(string)) {
            return this.createNameVariant(string2);
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        String string3 = string2;
        stringBuffer.append(this.getVariantSeparator());
        int n = stringBuffer.length();
        for (int i = 1; i <= this.names.size(); ++i) {
            stringBuffer.setLength(n);
            stringBuffer.append(i);
            string3 = stringBuffer.toString();
            if (this.names.containsKey((string + "." + string3).toUpperCase())) continue;
            return string3;
        }
        throw new IllegalStateException("NoNameVariantFound");
    }

    public void setCreateNameVariants(boolean bl) {
        this.createNameVariants = bl;
    }

    public boolean getCreateNameVariants() {
        return this.createNameVariants;
    }

    public void addSetListener(SetListener setListener) {
        this.listeners.add(setListener);
    }

    public void removeSetListener(SetListener setListener) {
        this.listeners.remove(setListener);
    }

    public void fireChange(SetEvent setEvent) {
        SetListener[] setListenerArray = this.listeners.toArray(new SetListener[0]);
        for (int i = 0; i < setListenerArray.length; ++i) {
            if (this.currentRemoved != null) {
                setEvent.setAffected(this.currentRemoved);
            }
            setListenerArray[i].changed(this, setEvent);
        }
    }

    public boolean isNullSet() {
        return false;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(DesignObject designObject) {
        return this.getObjectGeneratedBy(designObject.getObjectID());
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(String string) {
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            ModelIDObject modelIDObject = (ModelIDObject)iterator.next();
            if (!string.equals(modelIDObject.getGeneratorID())) continue;
            iterator = null;
            return modelIDObject;
        }
        iterator = null;
        return null;
    }

    public ModelIDObject getObjectByImportedID(String string) {
        if (string != null) {
            for (DesignObject designObject : this.elements) {
                if (!string.equals(designObject.getImportedId())) continue;
                return designObject;
            }
        }
        return null;
    }

    @Override
    public Collection getObjectsGeneratedBy(String string, Collection collection) {
        for (DesignObject designObject : this.elements) {
            if (!string.equals(designObject.getGeneratorID())) continue;
            collection.add(designObject);
        }
        return collection;
    }

    @Override
    public DesignObject getObjectByID(String string) {
        if (string != null) {
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                DesignObject designObject = (DesignObject)iterator.next();
                if (!string.equals(designObject.getObjectID())) continue;
                iterator = null;
                return designObject;
            }
            iterator = null;
        }
        return null;
    }

    @Override
    public void addAllElementsTo(Collection collection) {
        collection.addAll(this.elements);
    }

    public ModelObject getElement(int n) {
        return n < this.elements.size() ? (ModelObject)this.elements.get(n) : null;
    }

    public int getIndexOf(ModelObject modelObject) {
        return this.elements.indexOf(modelObject);
    }

    @Override
    public int getNumberOfChildren() {
        return this.size();
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return this.getIndexOf(modelObject);
    }

    @Override
    public ModelObject getChild(int n) {
        return this.getElement(n);
    }

    @Override
    public boolean isLeaf() {
        return this.size() <= 0;
    }

    @Override
    public boolean isObjectCollection() {
        return true;
    }

    @Override
    public Iterator iterator() {
        return Collections.unmodifiableList(this.elements).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void resetCounter() {
        this.count = 1;
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public void setDesignPart(DesignPart designPart) {
        this.designPart = designPart;
    }

    public String getSegmentName(DesignObject designObject) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(designObject);
        }
        return "";
    }

    public String getSegmentName(String string) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(string);
        }
        return "";
    }

    public void addSegmentEntry(String string, String string2) {
        this.addSegmentEntry(string, string2, false);
    }

    public void addSegmentEntry(String string, String string2, boolean bl) {
        if (this.isContainsTopLevelStorableObjects()) {
            if (bl) {
                this.segManager.removeID(string2);
            }
            this.segManager.add(string, string2);
        }
    }

    public boolean isContainsTopLevelStorableObjects() {
        if (this.containsTopLevelStorableObjects == null) {
            this.containsTopLevelStorableObjects = this instanceof NullSet ? Boolean.valueOf(true) : (this.getDesignPart().getStorableSets().contains(this) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return this.containsTopLevelStorableObjects;
    }

    @Override
    public boolean canSort() {
        return ApplicationView.canLogging;
    }

    private static class NullSet
    extends DesignObjectSet {
        private static final Object[] EMPTY = new Object[0];

        public NullSet(DesignPart designPart) {
            super(designPart);
        }

        @Override
        public boolean add(DesignObject designObject) {
            return false;
        }

        @Override
        public void remove(DesignObject designObject) {
        }

        @Override
        protected String getDefaultNamePrefix() {
            return "NULL SET GENERATED";
        }

        @Override
        protected Object[] getProtoTypeArray() {
            return EMPTY;
        }

        @Override
        public void addSetListener(SetListener setListener) {
        }

        @Override
        public boolean changeName(String string, String string2, DesignObject designObject) {
            return true;
        }

        @Override
        public boolean isNullSet() {
            return true;
        }
    }
}

