/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.util.logging.Logger;

public class DesignObjectPlaceHolder
extends DesignObject
implements ObjectListener,
ContainerObjectListener {
    private DesignObject object;
    private static final Logger LOGGER = new Logger(DesignObjectPlaceHolder.class);
    protected boolean propagate = false;
    protected ContainerObjectEvent sharedEvent = new ContainerObjectEvent();

    public DesignObjectPlaceHolder(DesignPart designPart) {
        super(designPart);
    }

    public DesignObjectPlaceHolder(DesignPart designPart, String string) {
        super(designPart);
        this.setName(string);
    }

    public DesignObjectPlaceHolder(DesignPart designPart, DesignObject designObject) {
        super(designPart);
        this.object = designObject;
        this.setDesign(designObject.getDesign());
        if (this.getDesignObject() != null) {
            this.getDesignObject().addObjectListener(this);
            if (this.getDesignObject() instanceof ContainerObject) {
                ((ContainerObject)this.getDesignObject()).addContainerListener(this);
            }
        }
    }

    public DesignObjectPlaceHolder(DesignObject designObject) {
        this(designObject.getDesignPart(), designObject);
    }

    public DesignObjectPlaceHolder(DesignPart designPart, DesignObject designObject, boolean bl) {
        this(designPart, designObject);
        this.propagate = bl;
    }

    public void setObject(DesignObject designObject) {
        if (this.getDesignObject() != null) {
            this.getDesignObject().removeObjectListener(this);
        }
        this.object = designObject;
        if (this.getDesignObject() != null) {
            this.getDesignObject().addObjectListener(this);
        }
    }

    public Object getObject() {
        return this.object;
    }

    public DesignObject getDesignObject() {
        return this.object;
    }

    @Override
    public String getName() {
        if (this.object != null && this.object.getName() != null && !"".equals(this.object.getName())) {
            return this.object.getName();
        }
        return super.getName();
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return "StorageObjectPlaceHolder";
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("StorageObjectPlaceHolder");
    }

    @Override
    public int getNumberOfChildren() {
        return 0;
    }

    @Override
    public ModelObject getChild(int n) {
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    @Override
    public Object getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return super.getParent();
    }

    @Override
    public void setShouldEngineer(boolean bl) {
        if (this.getDesignObject() != null) {
            this.getDesignObject().setShouldEngineer(bl);
            if (this.propagate) {
                this.propagateShouldEngineer(bl);
            }
        }
    }

    @Override
    public boolean getShouldEngineer() {
        if (this.getDesignObject() != null) {
            return this.getDesignObject().getShouldEngineer();
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getObject().toString();
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.fireChange(ObjectChangeEvent.DESIGN_OBJECT_NAME_CHANGED);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = bl;
        if (this.propagate) {
            this.propagateSelected(bl);
        }
    }

    public void propagateSelected(boolean bl) {
        int n = this.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            DesignObject designObject = (DesignObject)this.getChild(i);
            designObject.setSelected(bl);
        }
    }

    public void propagateShouldEngineer(boolean bl) {
        int n = this.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            ModelObject modelObject = this.getChild(i);
            if (!(modelObject instanceof DesignObject)) continue;
            DesignObject designObject = (DesignObject)modelObject;
            designObject.setShouldEngineer(bl);
        }
    }

    @Override
    public boolean shouldBeEngineered() {
        if (this.getDesignObject() != null) {
            return this.getDesignObject().shouldBeEngineered();
        }
        return false;
    }

    @Override
    public void changed(ContainerObject containerObject, ContainerObjectEvent containerObjectEvent) {
        this.sharedEvent.setType(6);
        this.sharedEvent.setElement(containerObject);
        ObjectListener[] objectListenerArray = this.getListeners().toArray(new ObjectListener[0]);
        for (int i = 0; i < objectListenerArray.length; ++i) {
            try {
                this.fireChange(new ObjectChangeEvent(Messages.getString("DesignObjectPlaceHolder.DesignObjectNameChanged")));
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Listener caused exception: ", exception);
            }
        }
    }

    @Override
    public String getLongName() {
        if (this.getDesignObject() != null && this.getDesignObject().getName() != null && !"".equals(this.getDesignObject().getName())) {
            return this.getDesignObject().getLongName();
        }
        return super.getLongName();
    }
}

