/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.fcp.vcs.DeletedFile;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ChangeRequestSet;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DLDomains;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.RLDomains;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.constraint.ConstraintSet;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.engineering.AttributeColumnComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EntViewTableViewComparator;
import oracle.dbtools.crest.model.design.engineering.EntityTableComparator;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.engineering.KeyIndexComparator;
import oracle.dbtools.crest.model.design.engineering.RelationFKComparator;
import oracle.dbtools.crest.model.design.engineering.ReverseEngineering;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesignSet;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesignFactory;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.undo.DP_UndoManager;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.xml.RXMLDefaultRDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.xml.WXMLRelationalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMapBase;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.OpenDesignDialog;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.DesignPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.SelectExportDialog;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.dbtools.crest.util.options.namingstandards.GlossaryFile;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.dbtools.crest.util.options.namingstandards.WordRule;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Design
extends ModelIDObject
implements ModelObjectSetListener,
NamingConstants {
    public static final String TYPE_NAME = "Design";
    public static final int CURRENT_OPERATION_NONE = -1;
    public static final int CURRENT_OPERATION_OPEN = 1;
    public static final int CURRENT_OPERATION_CLOSE = 2;
    public static final int CURRENT_OPERATION_SAVE = 3;
    public static final int CURRENT_OPERATION_SAVE_AS = 4;
    public static final int CURRENT_OPERATION_EXPORT_TO = 5;
    private static final String SYSTEM_DESIGN = Messages.getString("Design.System");
    public static final String ENTITY_TABLE = Messages.getString("Design.EntityTable");
    public static final String ATTRIBUTE_COLUMN = Messages.getString("Design.AttributeColumn");
    public static final String KEY_INDEX = Messages.getString("Design.KeyIndex");
    public static final String RELATION_FK = Messages.getString("Design.RelationForeignkey");
    public static final String ENTVIEW_TBLVIEW = Messages.getString("Design.EntityViewView");
    public static boolean USE_DROP_DEPENDENCY = true;
    public static boolean DROP_GENERATED_OBJECTS_ONLY = true;
    private LogicalDesign logicalDesign;
    private BusinessInfoDesign businessInfoDesign;
    private RelationalDesign relationalDesign;
    private ProcessModel processModel;
    private DataTypesDesign dataTypesDesign;
    private MultidimensionalDesign multidimensionalDesign;
    private LogicalDatatypeSet logicalDatatypeSet;
    private String fileName;
    private String exportFileName = "";
    private final Set listeners = new HashSet();
    private boolean readOnly = false;
    private DomainSet domainSet;
    private ConstraintSet constraintSet;
    private FWDEngineering fwdEngineering;
    private ReverseEngineering revEngineering;
    private Set importedDesigns = null;
    private final Map idMap = new TreeMap();
    private final Map fkMap = new TreeMap();
    private ChangeRequestSet changeRequestSet;
    private RelationalDesignSet pdesignSet;
    private MultidimensionalDesignSet mddSet;
    private boolean engineerCoordinates = true;
    private boolean engineerAsSubView = false;
    private String defDateFormat = "YYYY/MM/DD HH24:MI:SS";
    private String defTimestampFormat = "YYYY/MM/DD HH24:MI:SS.FF";
    private String defTimestampWTZFormat = "YYYY/MM/DD HH24:MI:SS.FFTZH:TZM";
    private String engDateFormat = "YYYY/MM/DD HH24:MI:SS";
    private String engTimestampFormat = "YYYY/MM/DD HH24:MI:SS.FF";
    private String engTimestampWTZFormat = "YYYY/MM/DD HH24:MI:SS.FFTZH:TZM";
    private boolean propagatePKChahges = true;
    private boolean showEngineeringInTree = false;
    private boolean showMappingsInEngineeringDialog = true;
    private boolean engineerGenerated = false;
    private boolean replaceSpaces = false;
    private boolean capitalNames = false;
    private boolean deleteWithoutOrigin = false;
    private boolean cleaning = false;
    private final Collection loadedRelDesIDs = new ArrayList();
    private Collection domainFileNames;
    private boolean disableTreeUpdate = false;
    private float loadedVersion = 3.5f;
    private boolean importToCurrent = false;
    private ExtendedMap extendedMap;
    private MergingModels mergingModels;
    private boolean applyNameSubstitution = false;
    private String unloadDirectory = "";
    private final Map dpvs = new TreeMap();
    private List diagramViews = new ArrayList();
    private int currentOperation = -1;
    private List entTablePropertyList;
    private List attrColPropertyList;
    private List keyIdxPropertyList;
    private List relFKPropertyList;
    private List viewPropertyList;
    private boolean applyNameStandardization = false;
    private boolean usePreferredAbbreviation = true;
    private boolean saveDefaultDomains = false;
    private final List exportedDesignParts = new ArrayList();
    private final Map expDesPartsMap = new TreeMap();
    private final Map expPartialDesPartsMap = new TreeMap();
    private final Map expDesObjectsMap = new TreeMap();
    private final Map expDPVMap = new TreeMap();
    private static boolean OPEN_FAILED = false;
    private boolean showSelPropsOnly = true;
    private boolean notForNewObjects = true;
    private boolean excludeFromTree = false;
    private DP_UndoManager undoManager = new DP_UndoManager();
    private RLDomains rlDomains;
    private DLDomains dlDomains;
    private TreeMap repositoryMap = new TreeMap();
    private TreeMap localDPMap = new TreeMap();
    private boolean loadFromDB = false;
    private boolean merging = false;
    private ApplicationView appView;
    private RDBMSSiteSet rdbmsSiteSet = null;
    private RDBMSTypeSet defauttRdbmsTypeSet;
    private boolean newDesign;
    private boolean modelListChanged = false;
    private boolean oldRepositoryType = false;
    private boolean changeRequestListChanged = false;
    private boolean compressedDesign = false;
    private boolean versioned;
    private Map f2tMap = null;
    private String designPath = "";
    private String exportDesignPath = "";
    private Map correspondenceMap;
    private boolean dlSettingsChanged = false;
    private DLSettings dlSettings;
    private NamingStandardRule namingRule;
    private CompareMapping compareMapping;
    private List tempProxiesToDelete = new ArrayList();
    private List proxiesToDelete = new ArrayList();
    private TreeMap<String, String> changeRequestsMap = new TreeMap();
    private DesignPartView selectedSubView = null;
    private static final Logger LOGGER = new Logger(Design.class);
    boolean closing = false;

    public Design(ApplicationView applicationView) {
        this.appView = applicationView;
        this.dlSettings = new DLSettings(applicationView);
        this.newDesign = true;
        this.createRelationalDesignSet();
        this.createMDDSet();
        this.rlDomains = new RLDomains(this);
        this.dlDomains = new DLDomains(this);
        this.setDesignID(new GUID().toString());
        this.setDesign(this);
    }

    public static final String getRelationalModelsSetName() {
        return Messages.getString("Design.RelationalModels");
    }

    public static final String getMultidimensionalDesignSetName() {
        return Messages.getString("Design.MultidimensionalModels");
    }

    private void createRelationalDesignSet() {
        this.pdesignSet = new RelationalDesignSet(this);
        this.pdesignSet.setName(Design.getRelationalModelsSetName());
        this.pdesignSet.setElementDescriptor(RelationalDesign.class);
        this.pdesignSet.setDesign(this);
        this.pdesignSet.setParent(this);
    }

    private void createMDDSet() {
        this.mddSet = new MultidimensionalDesignSet(this);
        this.mddSet.setName(Design.getMultidimensionalDesignSetName());
        this.mddSet.setElementDescriptor(MultidimensionalDesign.class);
        this.pdesignSet.setDesign(this);
        this.mddSet.setParent(this);
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setClosing(boolean bl) {
        this.closing = bl;
    }

    public void addDiagramView(DiagramView diagramView) {
        if (!this.diagramViews.contains(diagramView)) {
            this.diagramViews.add(diagramView);
        }
    }

    public void clearAll(boolean bl) {
        this.removeDeletedProxies();
        AbstractRepositoryManager abstractRepositoryManager = this.getAppView().getDBPersistenceManager().getDBRepositoryManager();
        if (abstractRepositoryManager.isConnected()) {
            try {
                abstractRepositoryManager.getConnection().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setLoadFromDB(false);
        ApplicationView.IS_VIEWER = ApplicationView.BACK_UP_IS_VIEWER;
        ApplicationView.LOGICAL_MODEL_ONLY = ApplicationView.BACK_UP_LOGICAL_MODEL_ONLY;
        this.getAppView().getController().updateMenus();
        this.getAppView().getController().updateToolbar();
        this.getAppView().updateActions();
        this.clearDesign(bl);
        this.tempProxiesToDelete.clear();
        if (this.relationalDesign != null) {
            this.relationalDesign.closeStorageDesigns();
        }
        this.diagramViews.clear();
    }

    public void removeDeletedProxies() {
        try {
            if (!this.proxiesToDelete.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                Iterator iterator = this.getRelationalDesigns().iterator();
                while (iterator.hasNext()) {
                    Object object = (RelationalDesign)iterator.next();
                    arrayList.addAll(this.findFiles(new File(((RelationalDesign)object).getStoragePath(), "phys")));
                }
                if (Extension.isSVNExtensionLoaded() && this.isVersioned()) {
                    SVNClientHelper.getInstance().doRemove(arrayList.toArray(new File[0]));
                } else {
                    for (Object object : arrayList) {
                        try {
                            ((File)object).delete();
                        }
                        catch (Exception exception) {
                            LOGGER.error("Unable to delete file: " + ((File)object).getAbsolutePath(), exception);
                        }
                    }
                }
                this.proxiesToDelete.clear();
            }
            this.tempProxiesToDelete.clear();
        }
        catch (Exception exception) {
            LOGGER.error("Unable to remove deleted proxies", exception);
        }
    }

    private List findFiles(File file) {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file != null && file.exists() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isFile()) {
                    String string = FileUtils.removeExt(file2.getName());
                    if (!this.proxiesToDelete.contains(string)) continue;
                    arrayList.add(file2);
                    continue;
                }
                if (!file2.isDirectory()) continue;
                arrayList.addAll(this.findFiles(file2));
            }
        }
        return arrayList;
    }

    public void clearDesign(boolean bl) {
        DesignPart designPart;
        int n;
        this.closing = true;
        this.getExportedDesignParts().clear();
        this.getExtendedMap().clearMappings();
        this.getChangeRequestSet().removeAll();
        for (n = this.pdesignSet.size() - 1; n >= 0; --n) {
            designPart = (RelationalDesign)this.pdesignSet.getElement(n);
            ((RelationalDesign)designPart).clearDesignPart();
            this.pdesignSet.remove(designPart);
            this.removeDesignPartView(((RelationalDesign)designPart).getMainView());
            designPart.removeDesignPartListener(this.getExtendedMap());
        }
        this.pdesignSet.resetCounter();
        this.setRelationalDesign(null);
        for (n = this.mddSet.size() - 1; n >= 0; --n) {
            designPart = (MultidimensionalDesign)this.mddSet.getElement(n);
            designPart.clearDesignPart();
            this.mddSet.remove(designPart);
            this.removeDesignPartView(((MultidimensionalDesign)designPart).getMainView());
            designPart.removeDesignPartListener(this.getExtendedMap());
        }
        this.mddSet.resetCounter();
        this.setMultidimensionalDesign(null);
        this.getProcessModel().clearDesignPart();
        this.getLogicalDesign().clearDesignPart();
        this.getBusinessInfoDesign().clearAll();
        Design.clearMap(this.idMap);
        Design.clearMap(this.fkMap);
        this.setName("");
        this.setFileName(this.getAppView().getDesigns().createName(false));
        this.getDomainSet().removeAll();
        this.getLogicalDatatypeSet().removeAll();
        this.getDataTypesDesign().clearDesignPart();
        this.getRDBMSSiteSet().setLoadFromRepository(false);
        this.resetRDBMSSites();
        this.closing = false;
        this.getAppView().clearTree();
        this.loadedRelDesIDs.clear();
        this.getAppView().getIDGenerator().setCounter(0L);
        System.gc();
        if (bl) {
            this.getAppView().getPersistenceManager().readSystemInit(this);
            this.getLogicalDesign().setMainViewVisible(true);
            this.getRelationalDesign().setMainViewVisible(true);
        }
        this.setSaveDefaultDomains(false);
        this.getLogicalDesign().setDirty(false);
        this.getRelationalDesign().setDirty(false);
        this.getDataTypesDesign().setDirty(false);
        this.clearCompareLists();
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
        this.setCheckedOut(false);
        this.setCheckedOutByMe(false);
        this.setCheckedOutBy("");
        this.undoManager.discardAllEdits();
        this.setObjectID(new GUID().toString());
    }

    public String getRDBMS() {
        return this.getRelationalDesign().getRDBMS();
    }

    @Override
    public String getName() {
        if (this.currentOperation == 5) {
            return this.exportFileName;
        }
        return super.getName();
    }

    public String getFileName() {
        if (this.currentOperation == 5) {
            return this.exportFileName;
        }
        if (this.fileName == null) {
            this.fileName = this.getName();
        }
        return this.fileName;
    }

    public void setFileName(String string) {
        if (SYSTEM_DESIGN.equalsIgnoreCase(string)) {
            this.fileName = SYSTEM_DESIGN;
        } else {
            if (this.isNewDesign()) {
                this.setDirty(true);
            }
            this.fileName = string;
        }
        this.setName(string);
        this.fireNameChange();
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileName(String string) {
        this.exportFileName = string;
    }

    public boolean isSystem() {
        return SYSTEM_DESIGN.equalsIgnoreCase(this.getFileName());
    }

    public ConstraintSet getConstraintSet() {
        if (this.constraintSet == null) {
            this.constraintSet = new ConstraintSet();
            this.constraintSet.setDesign(this);
            this.constraintSet.setParent(this);
        }
        return this.constraintSet;
    }

    public DomainSet getDomainSet() {
        if (this.domainSet == null) {
            this.domainSet = new DomainSet(this.getLogicalDesign());
            this.domainSet.setDesign(this);
            this.domainSet.setName(Messages.getString("Design.Domains"));
            this.domainSet.createUnknownDomain();
            this.domainSet.setParent(this);
        }
        return this.domainSet;
    }

    public Domain getLoadDomain(String string, String string2) {
        Domain domain = (Domain)this.getDomainSet().getObjectByID(string);
        if (null == domain) {
            this.getDomainSet().loadDomainFile(string2);
            domain = (Domain)this.getDomainSet().getObjectByID(string);
        }
        return domain;
    }

    public LogicalDatatypeSet getLogicalDatatypeSet() {
        if (this.logicalDatatypeSet == null) {
            this.logicalDatatypeSet = new LogicalDatatypeSet(this.getLogicalDesign());
            this.logicalDatatypeSet.setDesign(this);
            this.logicalDatatypeSet.createUnknownType();
            this.logicalDatatypeSet.setParent(this);
        }
        return this.logicalDatatypeSet;
    }

    public LogicalDesign getLogicalDesign() {
        if (this.logicalDesign == null) {
            this.logicalDesign = new LogicalDesign();
            this.logicalDesign.setObjectID(new GUID().toString());
            this.logicalDesign.setDesign(this);
            this.logicalDesign.setParent(this);
            this.logicalDesign.setName(Messages.getString("Design.LogicalModel"));
            this.logicalDesign.addDesignPartListener(this.getExtendedMap());
        }
        return this.logicalDesign;
    }

    public BusinessInfoDesign getBusinessInfoDesign() {
        if (this.businessInfoDesign == null) {
            this.businessInfoDesign = new BusinessInfoDesign(this);
            this.businessInfoDesign.setObjectID(new GUID().toString());
            this.businessInfoDesign.setDesign(this);
            this.businessInfoDesign.setName(Messages.getString("Design.BusinessInformation"));
            this.businessInfoDesign.setParent(this);
        }
        return this.businessInfoDesign;
    }

    public DataTypesDesign getDataTypesDesign() {
        if (this.dataTypesDesign == null) {
            this.dataTypesDesign = new DataTypesDesign();
            this.dataTypesDesign.setObjectID(new GUID().toString());
            this.dataTypesDesign.setDesign(this);
            this.dataTypesDesign.setName(Messages.getString("Design.DataTypes"));
            this.dataTypesDesign.setParent(this);
        }
        return this.dataTypesDesign;
    }

    public ProcessModel getProcessModel() {
        if (this.processModel == null) {
            this.processModel = new ProcessModel(this);
            this.processModel.setObjectID(new GUID().toString());
            this.processModel.setDesign(this);
            this.processModel.setParent(this);
        }
        return this.processModel;
    }

    public Map getFKMap() {
        return this.fkMap;
    }

    public RelationalDesign getRelationalDesign() {
        if (this.relationalDesign == null) {
            this.relationalDesign = this.addRelationalDesign(null);
        }
        return this.relationalDesign;
    }

    public void setRelationalDesign(RelationalDesign relationalDesign) {
        this.relationalDesign = relationalDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        if (this.multidimensionalDesign == null) {
            this.multidimensionalDesign = this.addMultidimensionalDesign(null);
        }
        return this.multidimensionalDesign;
    }

    public MultidimensionalDesign addMultidimensionalDesign() {
        MultidimensionalDesign multidimensionalDesign;
        this.multidimensionalDesign = multidimensionalDesign = this.addMultidimensionalDesign(null);
        return multidimensionalDesign;
    }

    public MultidimensionalDesign addMultidimensionalDesign(String string) {
        MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)this.mddSet.createElement(null);
        multidimensionalDesign.setDesign(this);
        if (string != null) {
            multidimensionalDesign.setName(string);
        }
        if (this.multidimensionalDesign == null) {
            this.multidimensionalDesign = multidimensionalDesign;
        }
        multidimensionalDesign.getMainView().setName(multidimensionalDesign.getName());
        multidimensionalDesign.createCompactDiagram();
        this.getLogicalDesign().addDesignPartListener(multidimensionalDesign);
        this.setDirty(true);
        this.setModelListChanged(true);
        return multidimensionalDesign;
    }

    public void setMultidimensionalDesign(MultidimensionalDesign multidimensionalDesign) {
        this.multidimensionalDesign = multidimensionalDesign;
    }

    public void addDesignObject(DesignObject designObject) {
        if (designObject.isDesignLevelAccessibleObject()) {
            this.registerAndAssignIDIfNull(designObject);
            this.idMap.put(designObject.getObjectID(), designObject);
            if (designObject.hasProxyToDelete() && this.tempProxiesToDelete.contains(designObject.getObjectID())) {
                this.tempProxiesToDelete.remove(designObject.getObjectID());
            }
        } else {
            throw new RuntimeException("trying to add object that is not design level accessible.");
        }
    }

    public void removeDesignObject(DesignObject designObject) {
        if (designObject != null && designObject.getObjectID() != null) {
            if (designObject.hasProxyToDelete() && !this.tempProxiesToDelete.contains(designObject.getObjectID())) {
                this.tempProxiesToDelete.add(designObject.getObjectID());
            }
            this.idMap.remove(designObject.getObjectID());
        }
    }

    private void registerAndAssignIDIfNull(DesignObject designObject) {
        String string = designObject.getObjectID();
        if (string == null) {
            designObject.createGlobalID();
        }
    }

    public DesignObject getDesignObject(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(35) > -1) {
            DesignObject designObject = this.getTopDesignObject(string);
            if (designObject != null) {
                return designObject;
            }
            designObject = this.getTopDesignObject(this.getTopDesignObjectId(string));
            if (designObject != null) {
                if (designObject instanceof ContainerObject) {
                    return (DesignObject)((ContainerObject)designObject).getLocalObject(string);
                }
                if (designObject instanceof StructuredType) {
                    DesignObject designObject2 = ((StructuredType)designObject).getElementByID(string);
                    if (designObject2 == null) {
                        designObject2 = ((StructuredType)designObject).getMethodByID(string);
                    }
                    return designObject2;
                }
                return null;
            }
            return null;
        }
        return this.getTopDesignObject(string);
    }

    public void updateDesignObjectId(String string, String string2) {
        ContainerObject containerObject;
        if (string == null || "".equalsIgnoreCase(string)) {
            return;
        }
        Object v = this.idMap.get(string);
        if (v != null) {
            this.idMap.remove(string);
            if (string2 != null && !"".equalsIgnoreCase(string2)) {
                this.idMap.put(string2, v);
            }
        } else if (string.indexOf(35) > -1 && (containerObject = (ContainerObject)this.getTopDesignObject(this.getTopDesignObjectId(string))) != null) {
            containerObject.updateLocalObjectId(string, string2);
        }
    }

    public String getTopDesignObjectId(String string) {
        int n = -1;
        n = string.indexOf(35);
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public DesignObject getTopDesignObject(String string) {
        return (DesignObject)this.idMap.get(string);
    }

    public FWDEngineering getFWDEngineering() {
        if (this.fwdEngineering == null) {
            this.fwdEngineering = new FWDEngineering(this);
        }
        return this.fwdEngineering;
    }

    public ReverseEngineering getReverseEngineering() {
        if (this.revEngineering == null) {
            this.revEngineering = new ReverseEngineering(this);
        }
        return this.revEngineering;
    }

    public void forwardEngineer(DesignPartView designPartView, Map map) {
        this.getFWDEngineering().execute(designPartView, map);
    }

    public void executeMerging(DesignPart designPart, Map map, Map map2) {
        this.getMergingModels().execute(designPart, map, map2);
    }

    private MergingModels getMergingModels() {
        if (this.mergingModels == null) {
            this.mergingModels = new MergingModels(this);
        }
        return this.mergingModels;
    }

    public void reverseEngineer(Map map) {
        this.getReverseEngineering().execute(map);
    }

    public Collection getStorableDesignObjects() {
        ArrayList arrayList = new ArrayList();
        this.getDomainSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    public Collection getAllTopLevelObjects() {
        ModelIDObject modelIDObject;
        ArrayList arrayList = new ArrayList();
        this.getLogicalDesign().getEntitySet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getEntityViewSet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getAttributeSet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getGlobalCandidateKeySet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getRelationSet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getNoteSet().addAllElementsTo(arrayList);
        this.getDataTypesDesign().getDistinctTypeSet().addAllElementsTo(arrayList);
        this.getDataTypesDesign().getStructuredTypeSet().addAllElementsTo(arrayList);
        this.getDataTypesDesign().getCollectionTypeSet().addAllElementsTo(arrayList);
        this.getDataTypesDesign().getNoteSet().addAllElementsTo(arrayList);
        Iterator iterator = this.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (RelationalDesign)iterator.next();
            ((RelationalDesign)modelIDObject).getTableSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getColumnSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getTableSet().getGlobalIndexSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getFKIndexAssociationSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getColumnViewSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getTableViewSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getNoteSet().addAllElementsTo(arrayList);
        }
        iterator = this.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (MultidimensionalDesign)iterator.next();
            ((MultidimensionalDesign)modelIDObject).getCubeSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getDimensionSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getHierarchySet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getLevelSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getMeasureSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getRollupLinkSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getSliceSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getNoteSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getMeasureFolderSet().addAllElementsTo(arrayList);
        }
        this.getProcessModel().getRecordStructureSet().addAllElementsTo(arrayList);
        this.getProcessModel().getExternalDataSet().addAllElementsTo(arrayList);
        this.getProcessModel().getEventSet().addAllElementsTo(arrayList);
        this.getProcessModel().getInfoStructureSet().addAllElementsTo(arrayList);
        this.getProcessModel().getInfoStoreSet().addAllElementsTo(arrayList);
        this.getProcessModel().getRoleSet().addAllElementsTo(arrayList);
        iterator = this.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (DataFlowDesign)iterator.next();
            ((DataFlowDesign)modelIDObject).getProcessSet().addAllElementsTo(arrayList);
            ((DataFlowDesign)modelIDObject).getExternalAgentSet().addAllElementsTo(arrayList);
            ((DataFlowDesign)modelIDObject).getFlowSet().addAllElementsTo(arrayList);
            ((DataFlowDesign)modelIDObject).getNoteSet().addAllElementsTo(arrayList);
        }
        iterator = this.getProcessModel().getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (TransformationPackage)iterator.next();
            Iterator iterator2 = ((TransformationPackage)modelIDObject).getTransformationTaskSet().iterator();
            while (iterator2.hasNext()) {
                TransformationTask transformationTask = (TransformationTask)iterator2.next();
                transformationTask.getFlowSet().addAllElementsTo(arrayList);
                transformationTask.getNoteSet().addAllElementsTo(arrayList);
                transformationTask.getTransformationSet().addAllElementsTo(arrayList);
            }
        }
        return arrayList;
    }

    public List getAllStorableObjects() {
        ModelIDObject modelIDObject;
        ArrayList<ModelIDObject> arrayList = new ArrayList<ModelIDObject>();
        this.getChangeRequestSet().addAllElementsTo(arrayList);
        this.getBusinessInfoDesign().getEmailSet().addAllElementsTo(arrayList);
        this.getBusinessInfoDesign().getLocationSet().addAllElementsTo(arrayList);
        this.getBusinessInfoDesign().getPhoneSet().addAllElementsTo(arrayList);
        this.getBusinessInfoDesign().getUrlSet().addAllElementsTo(arrayList);
        this.getBusinessInfoDesign().getContactSet().addAllElementsTo(arrayList);
        this.getBusinessInfoDesign().getResPartySet().addAllElementsTo(arrayList);
        this.getBusinessInfoDesign().getDocumentSet().addAllElementsTo(arrayList);
        this.getDataTypesDesign().getDistinctTypeSet().addAllElementsTo(arrayList);
        this.getDataTypesDesign().getStructuredTypeSet().addAllElementsTo(arrayList);
        this.getDataTypesDesign().getCollectionTypeSet().addAllElementsTo(arrayList);
        this.getDataTypesDesign().getNoteSet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getEntitySet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getEntityViewSet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getRelationSet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getInheritanceRelationSet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getArcSet().addAllElementsTo(arrayList);
        this.getLogicalDesign().getNoteSet().addAllElementsTo(arrayList);
        Iterator iterator = this.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (RelationalDesign)iterator.next();
            ((RelationalDesign)modelIDObject).getSchemaObjectSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getTableSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getTableViewSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getArcSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getFKIndexAssociationSet().addAllElementsTo(arrayList);
            ((RelationalDesign)modelIDObject).getNoteSet().addAllElementsTo(arrayList);
        }
        iterator = this.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (MultidimensionalDesign)iterator.next();
            ((MultidimensionalDesign)modelIDObject).getLevelSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getRaggedHLinkSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getDimensionSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getSliceSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getCubeSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getRollupLinkSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getHierarchySet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getMeasureFolderSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getSQLAccessToAWSet().addAllElementsTo(arrayList);
            ((MultidimensionalDesign)modelIDObject).getNoteSet().addAllElementsTo(arrayList);
        }
        this.getProcessModel().getRecordStructureSet().addAllElementsTo(arrayList);
        this.getProcessModel().getEventSet().addAllElementsTo(arrayList);
        this.getProcessModel().getInfoStructureSet().addAllElementsTo(arrayList);
        this.getProcessModel().getInfoStoreSet().addAllElementsTo(arrayList);
        this.getProcessModel().getRoleSet().addAllElementsTo(arrayList);
        iterator = this.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (DataFlowDesign)iterator.next();
            ((DataFlowDesign)modelIDObject).getExternalAgentSet().addAllElementsTo(arrayList);
            ((DataFlowDesign)modelIDObject).getProcessSet().addAllElementsTo(arrayList);
            ((DataFlowDesign)modelIDObject).getFlowSet().addAllElementsTo(arrayList);
            ((DataFlowDesign)modelIDObject).getNoteSet().addAllElementsTo(arrayList);
        }
        iterator = this.getProcessModel().getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            modelIDObject = (TransformationPackage)iterator.next();
            arrayList.add(modelIDObject);
            Iterator iterator2 = ((TransformationPackage)modelIDObject).getTransformationTaskSet().iterator();
            while (iterator2.hasNext()) {
                TransformationTask transformationTask = (TransformationTask)iterator2.next();
                arrayList.add(transformationTask);
                transformationTask.getTransformationSet().addAllElementsTo(arrayList);
                transformationTask.getFlowSet().addAllElementsTo(arrayList);
                transformationTask.getNoteSet().addAllElementsTo(arrayList);
            }
        }
        return arrayList;
    }

    @Override
    public ApplicationView getAppView() {
        return this.appView;
    }

    @Override
    public int getNumberOfChildren() {
        return 8;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.getLogicalDesign();
            }
            case 1: {
                return this.mddSet;
            }
            case 2: {
                return this.pdesignSet;
            }
            case 3: {
                return this.getDomainSet();
            }
            case 4: {
                return this.getDataTypesDesign();
            }
            case 5: {
                return this.getProcessModel();
            }
            case 6: {
                return this.getBusinessInfoDesign();
            }
            case 7: {
                return this.getChangeRequestSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.getLogicalDesign()) {
            return 0;
        }
        if (modelObject == this.mddSet) {
            return 1;
        }
        if (modelObject == this.pdesignSet) {
            return 2;
        }
        if (modelObject == this.getDomainSet()) {
            return 3;
        }
        if (modelObject == this.getDataTypesDesign()) {
            return 4;
        }
        if (modelObject == this.getProcessModel()) {
            return 5;
        }
        if (modelObject == this.getBusinessInfoDesign()) {
            return 6;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public static String getSystemDesignName() {
        return SYSTEM_DESIGN;
    }

    public void addDesignListener(DesignListener designListener) {
        this.listeners.add(designListener);
    }

    public void removeDesignListener(DesignListener designListener) {
        this.listeners.remove(designListener);
    }

    protected void fireNameChange() {
        DesignEvent designEvent = new DesignEvent(DesignEvent.NAME_CHANGED);
        this.fireDesignChange(designEvent);
        this.resetOwner();
        this.getAppView().getBrowserPanel().updateDesignName();
    }

    protected void fireDesignChange(DesignEvent designEvent) {
        designEvent.setDesign(this);
        DesignListener[] designListenerArray = this.listeners.toArray(DesignListener.ARRAY_PROTOTYPE);
        for (int i = 0; i < designListenerArray.length; ++i) {
            designListenerArray[i].designChanged(designEvent);
        }
    }

    private void resetOwner() {
        for (Object object : this.getAllTopLevelObjects()) {
            if (!(object instanceof ModelIDObject)) continue;
            ((ModelIDObject)object).setOwnerDesign(this);
        }
        Iterator iterator = this.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            Object object;
            object = (RelationalDesign)iterator.next();
            StorageDesign[] storageDesignArray = ((RelationalDesign)object).getStorageDesignFactory().getOpenStorageDesigns();
            for (int i = 0; i < storageDesignArray.length; ++i) {
                StorageDesign storageDesign = storageDesignArray[i];
                for (Object e : storageDesign.getAllTopLevelObjects()) {
                    if (!(e instanceof ModelIDObject)) continue;
                    ((ModelIDObject)e).setOwnerDesign(this);
                }
            }
        }
    }

    public void resetDomains() {
        for (Object e : this.getStorableDesignObjects()) {
            if (!(e instanceof ModelIDObject)) continue;
            ((ModelIDObject)e).setOwnerDesign(this);
        }
    }

    public void resetDesignForDomains() {
        Iterator iterator = this.getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            domain.setDesign(this);
        }
    }

    public static void fixDataTypeSize(DesignObjectSet designObjectSet) {
        Iterator iterator = designObjectSet.iterator();
        while (iterator.hasNext()) {
            try {
                ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)iterator.next();
                String string = containedObjectWithDomain.getDataTypeSize();
                String string2 = containedObjectWithDomain.getDataTypePrecision();
                if (string == null || "".equals(string) || string2 == null || "".equals(string2)) continue;
                containedObjectWithDomain.setDataTypeSize(null);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openDesign(String string, String string2) {
        TimeLog.log();
        this.diagramViews.clear();
        OPEN_FAILED = false;
        boolean bl = false;
        int n = 18;
        ProgressDialog progressDialog = null;
        try {
            Flow flow;
            Object object;
            Object object2;
            DesignPart designPart;
            Object object3;
            this.getUndoManager().setLocked(true);
            RelationalDesign relationalDesign = this.getRelationalDesign();
            relationalDesign.setMainViewVisible(false);
            this.getLogicalDesign().setLoaded(false);
            this.getLogicalDesign().setMainViewVisible(false);
            this.getBusinessInfoDesign().setLoaded(false);
            this.getDataTypesDesign().setLoaded(false);
            this.getDataTypesDesign().getMainView();
            relationalDesign.setLoaded(false);
            this.setFileName(string);
            ApplicationView.loading = true;
            bl = this.isOldRepositoryType() ? null != this.getAppView().getPersistenceManager().read((Object)string, this, progressDialog) : this.getAppView().getXMLTransformationManager().openDesign(this, new File(this.getDesignPath(), string + string2));
            this.fireDesignChange(new DesignEvent(DesignEvent.DESIGN_OPENED));
            if (this.appView.getSettings().isLoadDLSettingsOnOpen()) {
                this.loadDesignLevelSettings();
            }
            if (this.getLoadedVersion() > this.getVersion()) {
                object3 = this.getAppView().getMDConfiguration().get("appName");
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Design.DesignFormatIsNewerThanFormat"), object3), Messages.getString("Design.Warning"), 0, 1, null, new String[]{Messages.getString("Design.OK")}, Messages.getString("Design.OK"));
            }
            if (this.getLoadedVersion() < this.getVersion() && this.isEditable()) {
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), Messages.getString("Design.ThisDesignIsInOldFormat"), Messages.getString("Design.Warning"), 0, 1, null, new String[]{Messages.getString("Design.OK")}, Messages.getString("Design.OK"));
            }
            if (this.getAppView().getSettings().showSelectRelModelDialog() && this.getRelationalDesigns().size() > 0) {
                object3 = new OpenDesignDialog(this.getAppView(), this);
                ((Dialog)object3).setVisible(true);
            }
            progressDialog = new ProgressDialog(this.getAppView(), "", 0, 100);
            progressDialog.setNote(MessageFormat.format(Messages.getString("Design.OpenDesign"), string));
            try {
                progressDialog.setNote(Messages.getString("Design.ReadRDBMSSites"));
                progressDialog.setProgress(20);
                if (this.isOldRepositoryType()) {
                    this.loadRDBMSSites();
                }
                progressDialog.setProgress(30);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            progressDialog.setNote(Messages.getString("Design.ReadDomains"));
            progressDialog.setProgress(20);
            if (this.isOldRepositoryType()) {
                this.loadDomainFiles();
            } else {
                this.getAppView().getXMLTransformationManager().loadDomains(this);
            }
            this.getDomainSet().sort();
            progressDialog.setProgress(30);
            progressDialog.setNote(Messages.getString("Design.OpenBusinessInformation"));
            if (this.isOldRepositoryType()) {
                this.getBusinessInfoDesign().load();
            } else {
                this.getAppView().getXMLTransformationManager().openDesignPart(this.getBusinessInfoDesign());
            }
            this.getBusinessInfoDesign().sortCollections();
            progressDialog.setProgress(35);
            progressDialog.setNote(Messages.getString("Design.OpenDataTypes"));
            if (this.isOldRepositoryType()) {
                this.getDataTypesDesign().load();
            } else {
                this.getAppView().getXMLTransformationManager().openDesignPart(this.getDataTypesDesign());
            }
            this.getDataTypesDesign().sortCollections();
            progressDialog.setNote(Messages.getString("Design.OpenLogicalModel"));
            if (this.isOldRepositoryType()) {
                this.getLogicalDesign().load();
            } else {
                this.getAppView().getXMLTransformationManager().openDesignPart(this.getLogicalDesign());
            }
            this.getLogicalDesign().sortCollections();
            if (this.getLoadedVersion() < 3.41f) {
                Design.fixDataTypeSize(this.getLogicalDesign().getAttributeSet());
            }
            object3 = this.getRelationalDesigns().iterator();
            int n2 = 40;
            int n3 = 30;
            if (this.getRelationalDesigns().size() > 0) {
                n3 = 30 / this.getRelationalDesigns().size();
            }
            while (object3.hasNext()) {
                designPart = (RelationalDesign)object3.next();
                if (designPart.isShouldBeOpen() || this.getLoadedVersion() < 3.5f) {
                    object2 = ((RelationalDesign)designPart).getName();
                    if (((String)object2).length() > n) {
                        object2 = ((String)object2).substring(0, n) + "...";
                    }
                    progressDialog.setNote(MessageFormat.format(Messages.getString("Design.OpenRelationalModel"), object2));
                    progressDialog.setProgress(n2);
                    if (this.isOldRepositoryType()) {
                        ((RelationalDesign)designPart).load();
                    } else {
                        this.getAppView().getXMLTransformationManager().openDesignPart(designPart);
                    }
                    ((RelationalDesign)designPart).sortCollections();
                    if (this.getLoadedVersion() < 3.41f) {
                        Design.fixDataTypeSize(((RelationalDesign)designPart).getColumnSet());
                    }
                }
                n2 += n3;
            }
            progressDialog.setNote(Messages.getString("Design.ReadMappings"));
            System.out.println("Mappings begin - " + System.currentTimeMillis());
            if (this.isOldRepositoryType()) {
                this.getExtendedMap().load();
            } else {
                this.getAppView().getXMLTransformationManager().transformFromXMLToObject(this.getExtendedMap(), new File(this.getExtendedMap().getStorageName()), this.getDesign().isCompressedDesign());
            }
            this.getExtendedMap().setDirty(false);
            if (this.getLoadedVersion() > 3.49999f) {
                object3 = this.getRelationalDesigns().iterator();
                while (object3.hasNext()) {
                    designPart = (RelationalDesign)object3.next();
                    object2 = ((RelationalDesign)designPart).getRMExtendedMap();
                    this.getAppView().getXMLTransformationManager().transformFromXMLToObject(object2, new File(((RMExtendedMap)object2).getStorageName()), this.getDesign().isCompressedDesign());
                    ((ExtendedMapBase)object2).setDirty(false);
                }
            }
            System.out.println("Mappings end - " + System.currentTimeMillis());
            object3 = this.getMultidimensionalDesigns().iterator();
            while (object3.hasNext()) {
                designPart = (MultidimensionalDesign)object3.next();
                if (!designPart.isShouldBeOpen()) continue;
                object2 = designPart.getName();
                if (((String)object2).length() > n) {
                    object2 = ((String)object2).substring(0, n) + "...";
                }
                progressDialog.setNote(MessageFormat.format(Messages.getString("Design.OpenMultidimensionalDiagram"), object2));
                if (this.isOldRepositoryType()) {
                    ((MultidimensionalDesign)designPart).load();
                } else {
                    this.getAppView().getXMLTransformationManager().openDesignPart(designPart);
                }
                ((MultidimensionalDesign)designPart).clearUnusedObjects();
                ((MultidimensionalDesign)designPart).sortCollections();
            }
            designPart = this.getProcessModel();
            if (this.isOldRepositoryType()) {
                ((ProcessModel)designPart).load();
            } else {
                this.getAppView().getXMLTransformationManager().openDesignPart(designPart);
            }
            ((ProcessModel)designPart).sortCollections();
            object3 = ((ProcessModel)designPart).getDataFlowDesigns().iterator();
            while (object3.hasNext()) {
                object2 = (DataFlowDesign)object3.next();
                if (!((DesignPart)object2).isShouldBeOpen()) continue;
                object = ((DataFlowDesign)object2).getName();
                if (((String)object).length() > n) {
                    object = ((String)object).substring(0, n) + "...";
                }
                progressDialog.setNote(MessageFormat.format(Messages.getString("Design.OpenDataFlowDiagram"), object));
                if (this.isOldRepositoryType()) {
                    ((DataFlowDesign)object2).load();
                } else {
                    this.getAppView().getXMLTransformationManager().openDesignPart((DesignPart)object2);
                }
                ((DataFlowDesign)object2).sortCollections();
            }
            object3 = ((ProcessModel)designPart).getDataFlowDesigns().iterator();
            while (object3.hasNext()) {
                object2 = (DataFlowDesign)object3.next();
                object = ((DataFlowDesign)object2).getFlowSet().iterator();
                while (object.hasNext()) {
                    flow = (Flow)object.next();
                    if (!this.isOldRepositoryType()) continue;
                    flow.addSynonymToCompositeProcDiagram();
                    flow.createOrSetParentFlow();
                }
            }
            ((ProcessModel)designPart).updateObjects();
            object3 = ((ProcessModel)designPart).getDataFlowDesigns().iterator();
            while (object3.hasNext()) {
                object2 = (DataFlowDesign)object3.next();
                ((DataFlowDesign)object2).setDirty(false);
            }
            if (this.getLoadedVersion() < this.getVersion()) {
                this.resetToDirtyStorableObjects();
            }
            ApplicationView.loading = false;
            System.out.println("Mappings check and clear begin - " + System.currentTimeMillis());
            this.getExtendedMap().checkAndCleanMappings();
            this.getExtendedMap().distributenMappings();
            System.out.println("Mappings check and clear end - " + System.currentTimeMillis());
            progressDialog.setNote(Messages.getString("Design.CreateGraphicalObjects"));
            progressDialog.setProgress(80);
            if (this.isOldRepositoryType()) {
                object3 = ((ProcessModel)designPart).getDataFlowDesigns().iterator();
                while (object3.hasNext()) {
                    object2 = (DataFlowDesign)object3.next();
                    object = ((DataFlowDesign)object2).getFlowSet().iterator();
                    while (object.hasNext()) {
                        flow = (Flow)object.next();
                        flow.addToAllDPVs(null);
                    }
                }
            }
            progressDialog.setNote(Messages.getString("Design.CenterDesign"));
            progressDialog.setProgress(90);
            this.getAppView().centerDesign();
            object2 = this.getLogicalDesign().getEntitySet();
            if (((DesignObjectSet)object2).size() > 0) {
                object = ((DesignObject)((DesignObjectSet)object2).getElement(0)).getTopView();
                this.getAppView().getDPVLogical().setCurrentSelection(((TopView)object).getSelectableObject(), (TopView)object);
            }
            this.deleteNotUsedDiagramViews();
            progressDialog.setNote(Messages.getString("Design.ShowModels"));
            progressDialog.setProgress(98);
            if (this.getLogicalDesign().isVisible()) {
                this.getLogicalDesign().setMainViewVisible(true, true);
                this.getLogicalDesign().getMainView().getTabbedPane().setSelectedIndex(0);
            } else {
                this.getLogicalDesign().setMainViewVisible(false);
            }
            this.showLogicalSubViews();
            this.showAllRelationalDesigns();
            this.showDataTypesDesign();
            this.showAllMultidimensionalDesigns();
            this.showAllDataFlowDesigns();
            this.showAllTransformationTask();
            this.createLocalDP_Map();
            this.createChangeRequestsMap();
            if (this.getRelationalDesign().getTableSet().size() > 0 && this.getRelationalDesign().getMainView().isVisible()) {
                this.getAppView().setCurrentDPV(this.getRelationalDesign().getMainView());
            } else if (this.getLogicalDesign().getEntitySet().size() > 0 && this.getLogicalDesign().getMainView().isVisible()) {
                this.getAppView().setCurrentDPV(this.getLogicalDesign().getMainView());
            }
            this.getRelationalDesign().setDirty(false);
            this.getLogicalDesign().setDirty(false);
            this.getAppView().addRecent(this.getFileName(), this.getDesignPath());
            this.setDirty(false);
            this.setModelListChanged(false);
            this.setChangeRequestListChanged(false);
            this.setLoadFromDB(false);
            this.setNewDesign(false);
            this.checkDataFlowDesigns();
        }
        finally {
            ApplicationView.loading = false;
            this.getAppView().clearTree();
            if (progressDialog != null) {
                progressDialog.close();
            }
            this.getUndoManager().setLocked(false);
        }
        TimeLog.log();
        if (OPEN_FAILED) {
            MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), Messages.getString("Design.SomeObjectsNotLoadedCorrectly"));
        }
        if (ApplicationView.debugMode) {
            // empty if block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDataFlowDesigns() {
        boolean bl = false;
        Iterator iterator = this.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            if (dataFlowDesign.getTopLevelDataFlowDesign() != null) continue;
            bl = true;
            LOGGER.error("Design.checkDataFlowDesigns(): DataFlow Diagram (" + dataFlowDesign.getName() + ") has no parent object and must be deleted from the file system." + "\n Delete the file and related directory - " + dataFlowDesign.getSegmentedStorageName());
        }
        if (bl) {
            boolean bl2 = ApplicationView.canLogging;
            ApplicationView.canLogging = true;
            try {
                ApplicationView.log("There are bad Data Flow Diagrams - please check the log file for details");
            }
            finally {
                ApplicationView.canLogging = bl2;
            }
        }
    }

    private void deleteNotUsedDiagramViews() {
        Object[] objectArray = this.diagramViews.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            DiagramView diagramView = (DiagramView)objectArray[i];
            diagramView.removeIfNotModelExists();
        }
    }

    public void loadDomainFiles() {
        for (String string : this.getDomainFileNames()) {
            if ("defaultdomains".equalsIgnoreCase(string)) continue;
            this.getAppView().getPersistenceManager().readDomainFile(string, this, false);
        }
    }

    public void loadRDBMSSites() {
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append("_RDBMSSites");
        String string2 = stringBuffer.toString();
        RDBMSSiteSet rDBMSSiteSet = (RDBMSSiteSet)this.getAppView().getPersistenceManager().read((Object)string2, this, false);
        RDBMSSiteSet rDBMSSiteSet2 = this.getRDBMSSiteSet();
        Iterator iterator = rDBMSSiteSet.iterator();
        while (iterator.hasNext()) {
            rDBMSSiteSet2.add((RDBMSSite)iterator.next());
        }
        this.setRDBMSSiteSet(rDBMSSiteSet2);
    }

    public void showLogicalSubViews() {
        Iterator iterator = this.getLogicalDesign().getLogicalDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            if (!designPartViewPlaceHolder.getDesignPartView().mustBeVisible()) continue;
            designPartViewPlaceHolder.setVisible(true, true);
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            if (designPartView.isBoxInBox()) {
                this.getLogicalDesign().fixBoxInBox(designPartView);
            }
            designPartView.setDirty(false);
        }
    }

    public void showDataTypesDesign() {
        DataTypesDesign dataTypesDesign = this.getDataTypesDesign();
        if (dataTypesDesign.isLoaded()) {
            if (dataTypesDesign.isVisible()) {
                dataTypesDesign.setMainViewVisible(true, true);
                dataTypesDesign.getMainView().getTabbedPane().setSelectedIndex(0);
            }
            Iterator iterator = dataTypesDesign.getDesignSubviews().iterator();
            while (iterator.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                if (!designPartViewPlaceHolder.getDesignPartView().mustBeVisible()) continue;
                designPartViewPlaceHolder.setVisible(true, true);
                designPartViewPlaceHolder.setDirty(false);
            }
            dataTypesDesign.setDirty(false);
        }
    }

    public void showAllRelationalDesigns() {
        Iterator iterator = this.pdesignSet.iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (relationalDesign.isLoaded()) {
                if (relationalDesign.isVisible() && !relationalDesign.isMainViewVisible()) {
                    relationalDesign.setMainViewVisible(true, true);
                    relationalDesign.getMainView().getTabbedPane().setSelectedIndex(0);
                }
                Iterator iterator2 = relationalDesign.getDesignSubviews().iterator();
                while (iterator2.hasNext()) {
                    DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator2.next();
                    if (!designPartViewPlaceHolder.getDesignPartView().mustBeVisible()) continue;
                    designPartViewPlaceHolder.setVisible(true, true);
                    designPartViewPlaceHolder.setDirty(false);
                }
            }
            relationalDesign.setDirty(false);
        }
    }

    public void showAllMultidimensionalDesigns() {
        Iterator iterator = this.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            if (multidimensionalDesign.isLoaded() && !multidimensionalDesign.isEmpty()) {
                if (multidimensionalDesign.isVisible()) {
                    multidimensionalDesign.setMainViewVisible(true, true);
                }
                if (multidimensionalDesign.getCompactDiagram().mustBeVisible()) {
                    multidimensionalDesign.getCompactDiagramPlaceHolder().setVisible(true, true);
                    multidimensionalDesign.getCompactDiagramPlaceHolder().setDirty(false);
                }
            }
            multidimensionalDesign.setDirty(false);
        }
    }

    public void showAllDataFlowDesigns() {
        if (!this.processModel.hasOpenedDFDesigns()) {
            this.processModel.clearDesign();
        } else {
            Iterator iterator = this.processModel.getDataFlowDesigns().iterator();
            while (iterator.hasNext()) {
                DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
                if (dataFlowDesign.isLoaded() && dataFlowDesign.isVisible()) {
                    dataFlowDesign.setMainViewVisible(true, true);
                }
                dataFlowDesign.setDirty(false);
            }
        }
    }

    public void showAllTransformationTask() {
        Iterator iterator = this.getProcessModel().getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)iterator.next();
            Iterator iterator2 = transformationPackage.getTransformationTaskSet().iterator();
            while (iterator2.hasNext()) {
                TransformationTask transformationTask = (TransformationTask)iterator2.next();
                if (transformationTask.isLoaded() && transformationTask.isVisible()) {
                    transformationTask.setMainViewVisible(true, true);
                }
                transformationTask.setDirty(false);
            }
            transformationPackage.setDirty(false);
        }
    }

    public void resetToDirtyStorableObjects() {
        ModelIDObject modelIDObject2;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getLogicalDesign().getStorableDesignObjects());
        arrayList.addAll(this.getDataTypesDesign().getStorableDesignObjects());
        Iterator iterator = this.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject2 = (RelationalDesign)iterator.next();
            arrayList.addAll(((DesignPart)modelIDObject2).getStorableDesignObjects());
        }
        iterator = this.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject2 = (DataFlowDesign)iterator.next();
            arrayList.addAll(((DesignPart)modelIDObject2).getStorableDesignObjects());
        }
        iterator = this.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            modelIDObject2 = (MultidimensionalDesign)iterator.next();
            arrayList.addAll(((DesignPart)modelIDObject2).getStorableDesignObjects());
        }
        iterator = this.getProcessModel().getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            modelIDObject2 = (TransformationPackage)iterator.next();
            Iterator iterator2 = ((TransformationPackage)modelIDObject2).getTransformationTaskSet().iterator();
            while (iterator2.hasNext()) {
                TransformationTask transformationTask = (TransformationTask)iterator2.next();
                arrayList.addAll(transformationTask.getStorableDesignObjects());
            }
        }
        for (ModelIDObject modelIDObject2 : arrayList) {
            ((DesignObject)modelIDObject2).setDirty(true);
        }
    }

    public boolean saveDesign() {
        return this.saveAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAll() {
        boolean bl = false;
        try {
            ProgressDialog progressDialog = new ProgressDialog(this.getAppView(), "", 0, 100);
            try {
                progressDialog.setNote(MessageFormat.format(Messages.getString("Design.SaveDesign"), this.getFileName()));
                progressDialog.setProgress(50);
                this.proxiesToDelete.clear();
                this.proxiesToDelete.addAll(this.tempProxiesToDelete);
                bl = this.getAppView().getXMLTransformationManager().saveDesign(this);
                this.setLoadedVersion(this.getVersion());
                if (this.getCurrentOperation() != 5) {
                    this.removeDeletedDesignParts();
                }
                progressDialog.setProgress(100);
                this.fireDesignChange(new DesignEvent(DesignEvent.DESIGN_SAVED));
                this.setDirty(false);
                this.dlSettingsChanged = false;
                if (this.getCurrentOperation() != 5) {
                    this.createLocalDP_Map();
                    this.createChangeRequestsMap();
                }
                this.setOldRepositoryType(false);
            }
            finally {
                progressDialog.close();
            }
        }
        catch (Exception exception) {
            LOGGER.error(exception);
            MessageDialogs.showErrorMessage(Messages.getString("Design.UnableToSaveTheDesign"));
        }
        return bl;
    }

    public boolean canUpgradeInPlace() {
        return this.getLoadedVersion() >= 3.4f && this.isVersioned();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllRDandSD() {
        try {
            ApplicationView.loading = true;
            int n = this.getDesign().getRelationalDesigns().size();
            if (n == 0) {
                n = 2;
            }
            Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                File file;
                File[] fileArray;
                Object object;
                RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
                if (!relationalDesign.isLoaded()) {
                    if (relationalDesign.getDesign().isOldRepositoryType()) {
                        relationalDesign.load();
                    } else {
                        relationalDesign.getAppView().getXMLTransformationManager().openDesignPart(relationalDesign);
                        object = relationalDesign.getRMExtendedMap();
                        relationalDesign.getAppView().getXMLTransformationManager().transformFromXMLToObject(object, new File(((RMExtendedMap)object).getStorageName()), relationalDesign.getDesign().isCompressedDesign());
                    }
                    relationalDesign.getDesign().getExtendedMap().distributenMappings(relationalDesign);
                    this.getAppView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(relationalDesign);
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getAppView().getCurrentDesign().getDesignPath());
                if (this.getDesign().getLoadedVersion() < 3.2f) {
                    stringBuffer.append(WXMLRelationalDesign.getRelativePath(relationalDesign)).append('/').append(relationalDesign.getObjectID()).append("/storage");
                } else if (this.getDesign().getLoadedVersion() < 3.4f) {
                    stringBuffer.append(WXMLRelationalDesign.getRelativePath(relationalDesign)).append('/').append(relationalDesign.getPathIDString()).append("/phys");
                } else {
                    stringBuffer.append(WXMLRelationalDesign.getRelativePath(relationalDesign)).append('/').append(relationalDesign.getShortObjectID()).append("/phys");
                }
                if ((fileArray = (file = new File((String)(object = stringBuffer.toString()))).listFiles()) == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    StorageDesign storageDesign;
                    if (!fileArray[i].isDirectory()) continue;
                    String string = fileArray[i].getName();
                    RDBMSSite rDBMSSite = null;
                    rDBMSSite = this.getDesign().getLoadedVersion() < 3.2f ? relationalDesign.getStorageDesignFactory().getRDBMSSiteSet().getByObjectID(string) : relationalDesign.getStorageDesignFactory().getRDBMSSiteSet().getByShortObjectIDString(string);
                    if (rDBMSSite == null || (storageDesign = relationalDesign.getStorageDesignFactory().getStorageDesign(rDBMSSite)) == null || storageDesign.isOpen()) continue;
                    if (storageDesign.getDesign().isOldRepositoryType()) {
                        storageDesign.load();
                    } else {
                        this.getAppView().getXMLTransformationManager().openPhysicalModel(storageDesign);
                    }
                    storageDesign.setOpen(true);
                }
            }
            ApplicationView.loading = false;
        }
        catch (Exception exception) {
        }
        finally {
            ApplicationView.loading = false;
        }
    }

    public void fixGeneratorIds(Design design) {
        FKIndexAssociation fKIndexAssociation;
        KeyObject keyObject;
        KeyObject keyObject2;
        KeyObject keyObject3;
        KeyObject keyObject4;
        DesignObject designObject;
        Relation relation;
        Column column;
        Column column2;
        Attribute attribute;
        Attribute attribute2;
        Table table;
        Table table2;
        Entity entity;
        Entity entity2;
        Iterator iterator = this.getLogicalDesign().getEntitySet().iterator();
        while (iterator.hasNext()) {
            int n;
            entity2 = (Entity)iterator.next();
            if (entity2.getImportedId() == null || ModelIDObject.USER_GENERATED.equals((entity = (Entity)design.getDesignObject(entity2.getImportedId())).getGeneratorID()) || (table2 = (Table)design.getDesignObject(entity.getGeneratorID())) == null) continue;
            table = (Table)this.getCorrObject(table2.getObjectID());
            entity2.setGeneratorID(table.getObjectID());
            for (n = 0; n < entity2.getAttributes().size(); ++n) {
                attribute2 = (Attribute)entity2.getAttributes().get(n);
                if (attribute2.getImportedId() == null || ModelIDObject.USER_GENERATED.equals((attribute = (Attribute)entity.getElementByID(attribute2.getImportedId())).getGeneratorID())) continue;
                if (design.getDesignObject(attribute.getGeneratorID()) instanceof Column) {
                    column2 = (Column)design.getDesignObject(attribute.getGeneratorID());
                    column = (Column)this.getCorrObject(column2.getObjectID());
                    attribute2.setGeneratorID(column.getObjectID());
                    continue;
                }
                if (!(design.getDesignObject(attribute.getGeneratorID()) instanceof Relation)) continue;
                relation = (Relation)design.getDesignObject(attribute.getGeneratorID());
                designObject = (Relation)this.getCorrObject(relation.getObjectID());
                attribute2.setGeneratorID(designObject.getObjectID());
            }
            for (n = 0; n < entity2.getKeys().length; ++n) {
                keyObject4 = entity2.getKeys()[n];
                if (keyObject4.getImportedId() == null || ModelIDObject.USER_GENERATED.equals((keyObject3 = entity.getKeyObject(keyObject4.getImportedId())).getGeneratorID())) continue;
                keyObject2 = (KeyObject)design.getDesignObject(keyObject3.getGeneratorID());
                keyObject = (KeyObject)this.getCorrObject(keyObject2.getObjectID());
                keyObject4.setGeneratorID(keyObject.getObjectID());
            }
        }
        iterator = this.getLogicalDesign().getRelationSet().iterator();
        while (iterator.hasNext()) {
            Relation relation2 = (Relation)iterator.next();
            if (relation2.getImportedId() == null || ModelIDObject.USER_GENERATED.equals((relation = (Relation)design.getDesignObject(relation2.getImportedId())).getGeneratorID()) || (fKIndexAssociation = (FKIndexAssociation)design.getDesignObject(relation.getGeneratorID())) == null) continue;
            designObject = (FKIndexAssociation)this.getCorrObject(fKIndexAssociation.getObjectID());
            relation2.setGeneratorID(designObject.getObjectID());
        }
        iterator = this.getRelationalDesign().getTableSet().iterator();
        while (iterator.hasNext()) {
            int n;
            table = (Table)iterator.next();
            if (table.getImportedId() == null || (table2 = (Table)design.getDesignObject(table.getImportedId())) == null || ModelIDObject.USER_GENERATED.equals(table2.getGeneratorID()) || (entity = (Entity)design.getDesignObject(table2.getGeneratorID())) == null) continue;
            entity2 = (Entity)this.getCorrObject(entity.getObjectID());
            table.setGeneratorID(entity2.getObjectID());
            for (n = 0; n < table.getElements().length; ++n) {
                column = (Column)table.getElements()[n];
                if (column.getImportedId() == null || ModelIDObject.USER_GENERATED.equals((column2 = (Column)table2.getElementByID(column.getImportedId())).getGeneratorID())) continue;
                if (design.getDesignObject(column2.getGeneratorID()) instanceof Attribute) {
                    attribute = (Attribute)design.getDesignObject(column2.getGeneratorID());
                    attribute2 = (Attribute)this.getCorrObject(attribute.getObjectID());
                    column.setGeneratorID(attribute2.getObjectID());
                    continue;
                }
                if (!(design.getDesignObject(column2.getGeneratorID()) instanceof FKIndexAssociation)) continue;
                fKIndexAssociation = (FKIndexAssociation)design.getDesignObject(column2.getGeneratorID());
                designObject = (FKIndexAssociation)this.getCorrObject(fKIndexAssociation.getObjectID());
                column.setGeneratorID(designObject.getObjectID());
            }
            for (n = 0; n < table.getKeys().length; ++n) {
                keyObject = table.getKeys()[n];
                if (keyObject.getImportedId() == null || ModelIDObject.USER_GENERATED.equals((keyObject2 = table2.getKeyObject(keyObject.getImportedId())).getGeneratorID())) continue;
                keyObject3 = (KeyObject)design.getDesignObject(keyObject2.getGeneratorID());
                keyObject4 = (KeyObject)this.getCorrObject(keyObject3.getObjectID());
                keyObject.setGeneratorID(keyObject4.getObjectID());
            }
        }
        iterator = this.getRelationalDesign().getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            designObject = (FKIndexAssociation)iterator.next();
            if (designObject.getImportedId() == null || ModelIDObject.USER_GENERATED.equals((fKIndexAssociation = (FKIndexAssociation)design.getDesignObject(designObject.getImportedId())).getGeneratorID())) continue;
            relation = (Relation)design.getDesignObject(fKIndexAssociation.getGeneratorID());
            Relation relation3 = (Relation)this.getCorrObject(relation.getObjectID());
            designObject.setGeneratorID(relation3.getObjectID());
        }
    }

    public DesignObject getCorrObject(String string) {
        for (DesignObject designObject : this.getAllTopLevelObjects()) {
            if (designObject.getImportedId() == null || !designObject.getImportedId().equalsIgnoreCase(string)) continue;
            return designObject;
        }
        return null;
    }

    public void addImportedDesignName(String string) {
        this.getImportedDesignsSet().add(string);
    }

    private Set getImportedDesignsSet() {
        if (this.importedDesigns == null) {
            this.importedDesigns = new TreeSet();
        }
        return this.importedDesigns;
    }

    public String[] getImportedDesignNames() {
        int n = this.getImportedDesignsSet().size();
        return this.getImportedDesignsSet().toArray(new String[n]);
    }

    public boolean isDesign() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getRepositoryOID() != null && this.isLoadFromDB() && !this.isLoading()) {
            return !this.isCheckedOutByMe();
        }
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public RelationalDesign addRelationalDesign() {
        RelationalDesign relationalDesign;
        this.relationalDesign = relationalDesign = this.addRelationalDesign(null);
        return relationalDesign;
    }

    public RelationalDesign addRelationalDesign(String string) {
        RelationalDesign relationalDesign = (RelationalDesign)this.pdesignSet.createElement(null);
        relationalDesign.setDesign(this);
        if (this.relationalDesign == null) {
            this.relationalDesign = relationalDesign;
        }
        if (string != null) {
            RelationalDesign relationalDesign2 = (RelationalDesign)this.getRelationalDesigns().getByName(string);
            if (relationalDesign2 != null && relationalDesign2 != relationalDesign) {
                String string2 = string;
                int n = 1;
                while (relationalDesign2 != null && relationalDesign2 != relationalDesign) {
                    string2 = string + "(" + ++n + ")";
                    relationalDesign2 = (RelationalDesign)this.getRelationalDesigns().getByName(string2);
                }
                string = string2;
            }
            relationalDesign.setName(string);
        }
        relationalDesign.getMainView().setName(relationalDesign.getName());
        this.setModelListChanged(true);
        return relationalDesign;
    }

    public void addToListOfLoaded(RelationalDesign relationalDesign) {
        Iterator iterator = this.loadedRelDesIDs.iterator();
        String string = relationalDesign.getObjectID();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            return;
        }
        this.loadedRelDesIDs.add(string);
    }

    public void removeDeletedRelationalDesigns() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : this.loadedRelDesIDs) {
            Object object2;
            if (object == null) continue;
            Iterator iterator = this.pdesignSet.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                object2 = (RelationalDesign)iterator.next();
                if (object2 == null || !((String)object).equalsIgnoreCase(((ModelIDObject)object2).getObjectID())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object2 = this.makeRelDesignPath((String)object);
            String string = (String)object2 + ".xml" + (this.compressedDesign ? "z" : "");
            arrayList.add(object2);
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            Object object;
            object = this.getAppView().getPersistenceManager();
            ((PersistenceManager)object).deleteFiles(arrayList);
        }
    }

    private String makeRelDesignPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getDesignPath());
        stringBuffer.append("/").append(this.getFileName());
        stringBuffer.append("/").append("rel");
        stringBuffer.append("/").append(string);
        return stringBuffer.toString();
    }

    public void removeRelationalDesign(RelationalDesign relationalDesign) {
        if (relationalDesign != null) {
            this.pdesignSet.remove(relationalDesign);
            relationalDesign.clearDesignPart();
            relationalDesign.fireDeleted();
            relationalDesign.removeDesignPartListener(this.getExtendedMap());
            if (this.getRelationalDesign() == relationalDesign) {
                if (this.pdesignSet.size() > 0) {
                    this.setRelationalDesign((RelationalDesign)this.pdesignSet.getElement(0));
                } else {
                    this.setRelationalDesign(null);
                }
            }
            this.getExtendedMap().removeAllMappingsForDesignPart(relationalDesign.getObjectID());
            this.setDirty(true);
            this.setModelListChanged(true);
        }
    }

    public void removeMultidimensionalDesign(MultidimensionalDesign multidimensionalDesign) {
        if (multidimensionalDesign != null) {
            this.mddSet.remove(multidimensionalDesign);
            multidimensionalDesign.clearDesignPart();
            multidimensionalDesign.fireDeleted();
            this.setDirty(true);
            this.setModelListChanged(true);
        }
    }

    public ChangeRequestSet getChangeRequestSet() {
        if (this.changeRequestSet == null) {
            this.changeRequestSet = new ChangeRequestSet(this.getLogicalDesign());
            this.changeRequestSet.setDesign(this);
            this.changeRequestSet.setName(Messages.getString("Design.ChangeRequests"));
            this.changeRequestSet.setParent(this);
        }
        return this.changeRequestSet;
    }

    public RelationalDesignSet getRelationalDesigns() {
        return this.pdesignSet;
    }

    public RelationalDesign getFirstOpenRelationalDesign() {
        if (this.pdesignSet.size() > 0) {
            if (this.getRelationalDesign().isLoaded()) {
                return this.getRelationalDesign();
            }
            Iterator iterator = this.pdesignSet.iterator();
            while (iterator.hasNext()) {
                RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
                if (!relationalDesign.isLoaded()) continue;
                this.setRelationalDesign(relationalDesign);
                return relationalDesign;
            }
        }
        return null;
    }

    public MultidimensionalDesignSet getMultidimensionalDesigns() {
        return this.mddSet;
    }

    public boolean isEngineerCoordinates() {
        return this.engineerCoordinates;
    }

    public void setEngineerCoordinates(boolean bl) {
        this.engineerCoordinates = bl;
    }

    public boolean isPropagatePKChahges() {
        return this.propagatePKChahges;
    }

    public void setPropagatePKChahges(boolean bl) {
        this.propagatePKChahges = bl;
    }

    public boolean isShowEngineeringInTree() {
        return this.showEngineeringInTree;
    }

    public void setShowEngineeringInTree(boolean bl) {
        this.showEngineeringInTree = bl;
    }

    public boolean isEngineerGenerated() {
        return this.engineerGenerated;
    }

    public void setEngineerGenerated(boolean bl) {
        this.engineerGenerated = bl;
    }

    public boolean isCapitalNames() {
        return this.capitalNames;
    }

    public void setCapitalNames(boolean bl) {
        this.capitalNames = bl;
    }

    public boolean isReplaceSpaces() {
        return this.replaceSpaces;
    }

    public void setReplaceSpaces(boolean bl) {
        this.replaceSpaces = bl;
    }

    public boolean isDeleteWithoutOrigin() {
        return this.deleteWithoutOrigin;
    }

    public void setDeleteWithoutOrigin(boolean bl) {
        this.deleteWithoutOrigin = bl;
    }

    public boolean isShowMappingsInEngineeringDialog() {
        return this.showMappingsInEngineeringDialog;
    }

    public void setShowMappingsInEngineeringDialog(boolean bl) {
        this.showMappingsInEngineeringDialog = bl;
    }

    public Collection getDomainFileNames() {
        if (this.domainFileNames == null) {
            this.domainFileNames = new ArrayList();
        }
        return this.domainFileNames;
    }

    public boolean isCleaning() {
        return this.cleaning;
    }

    public void setCleaning(boolean bl) {
        this.cleaning = bl;
    }

    public boolean isLoading() {
        if (this.getAppView() != null) {
            return ApplicationView.loading;
        }
        return false;
    }

    public boolean isDisableTreeUpdate() {
        return this.disableTreeUpdate;
    }

    public void setDisableTreeUpdate(boolean bl) {
        this.disableTreeUpdate = bl;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
    }

    public boolean isEngineerAsSubView() {
        return this.engineerAsSubView;
    }

    public void setEngineerAsSubView(boolean bl) {
        this.engineerAsSubView = bl;
    }

    public float getLoadedVersion() {
        return this.loadedVersion;
    }

    public void setLoadedVersion(float f) {
        this.loadedVersion = f;
    }

    public float getVersion() {
        return 3.5f;
    }

    public boolean isImportToCurrent() {
        return this.importToCurrent;
    }

    public void setImportToCurrent(boolean bl) {
        this.importToCurrent = bl;
    }

    public ExtendedMap getExtendedMap() {
        if (this.extendedMap == null) {
            this.extendedMap = new ExtendedMap(this);
            this.getLogicalDesign().addDesignPartListener(this.extendedMap);
            Iterator iterator = this.getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
                relationalDesign.addDesignPartListener(this.extendedMap);
            }
        }
        return this.extendedMap;
    }

    public String getDesignID() {
        return this.getObjectID();
    }

    public void setDesignID(String string) {
        this.setObjectID(string);
    }

    public void closeAllDiagrams() {
        DesignPartViewPlaceHolder designPartViewPlaceHolder;
        Object object;
        Object object2;
        this.getLogicalDesign().setMainViewVisible(false);
        Iterator iterator = this.getLogicalDesign().getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder2 = (DesignPartViewPlaceHolder)iterator.next();
            if (!designPartViewPlaceHolder2.getDesignPartView().mustBeVisible()) continue;
            designPartViewPlaceHolder2.setVisible(false);
        }
        for (int i = 0; i < this.getRelationalDesigns().size(); ++i) {
            object2 = (RelationalDesign)this.getRelationalDesigns().getElement(i);
            ((DesignPart)object2).setMainViewVisible(false);
            object = ((DesignPart)object2).getDesignSubviews().iterator();
            while (object.hasNext()) {
                designPartViewPlaceHolder = (DesignPartViewPlaceHolder)object.next();
                designPartViewPlaceHolder.setVisible(false);
            }
        }
        this.getDataTypesDesign().setMainViewVisible(false);
        iterator = this.getDataTypesDesign().getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder3 = (DesignPartViewPlaceHolder)iterator.next();
            designPartViewPlaceHolder3.setVisible(false);
        }
        for (int i = 0; i < this.getMultidimensionalDesigns().size(); ++i) {
            object2 = (MultidimensionalDesign)this.getMultidimensionalDesigns().getElement(i);
            ((DesignPart)object2).setMainViewVisible(false);
            object = ((DesignPart)object2).getDesignSubviews().iterator();
            while (object.hasNext()) {
                designPartViewPlaceHolder = (DesignPartViewPlaceHolder)object.next();
                designPartViewPlaceHolder.setVisible(false);
            }
        }
        iterator = this.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            if (!dataFlowDesign.isLoaded() || !dataFlowDesign.isVisible()) continue;
            dataFlowDesign.setMainViewVisible(false);
        }
        iterator = this.getProcessModel().getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)iterator.next();
            object2 = transformationPackage.getTransformationTaskSet().iterator();
            while (object2.hasNext()) {
                object = (TransformationTask)object2.next();
                if (!((DesignPart)object).isVisible()) continue;
                ((TransformationTask)object).setMainViewVisible(false);
            }
        }
    }

    public void selectLastOpenDPV() {
        DesignPartView designPartView = this.findDPV(this.getAppView().getSettings().getLastOpenDPV());
        if (designPartView != null) {
            this.getAppView().setCurrentDPV(designPartView);
        }
    }

    public DesignPartView findDPV(String string) {
        try {
            if (string != null && string.length() > 0) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder;
                Object object;
                Object object2;
                if (string.equalsIgnoreCase(this.getLogicalDesign().getMainViewID())) {
                    return this.getLogicalDesign().getMainView();
                }
                Iterator iterator = this.getLogicalDesign().getDesignSubviews().iterator();
                while (iterator.hasNext()) {
                    DesignPartViewPlaceHolder designPartViewPlaceHolder2 = (DesignPartViewPlaceHolder)iterator.next();
                    if (!string.equalsIgnoreCase(designPartViewPlaceHolder2.getDesignPartView().getDPVId())) continue;
                    return designPartViewPlaceHolder2.getDesignPartView();
                }
                for (int i = 0; i < this.getRelationalDesigns().size(); ++i) {
                    object2 = (RelationalDesign)this.getRelationalDesigns().getElement(i);
                    if (string.equalsIgnoreCase(((DesignPart)object2).getMainViewID())) {
                        return ((RelationalDesign)object2).getMainView();
                    }
                    object = ((DesignPart)object2).getDesignSubviews().iterator();
                    while (object.hasNext()) {
                        designPartViewPlaceHolder = (DesignPartViewPlaceHolder)object.next();
                        if (!string.equalsIgnoreCase(designPartViewPlaceHolder.getDesignPartView().getDPVId())) continue;
                        return designPartViewPlaceHolder.getDesignPartView();
                    }
                }
                if (string.equalsIgnoreCase(this.getDataTypesDesign().getMainViewID())) {
                    return this.getDataTypesDesign().getMainView();
                }
                iterator = this.getDataTypesDesign().getDesignSubviews().iterator();
                while (iterator.hasNext()) {
                    DesignPartViewPlaceHolder designPartViewPlaceHolder3 = (DesignPartViewPlaceHolder)iterator.next();
                    if (!string.equalsIgnoreCase(designPartViewPlaceHolder3.getDesignPartView().getDPVId())) continue;
                    return designPartViewPlaceHolder3.getDesignPartView();
                }
                for (int i = 0; i < this.getMultidimensionalDesigns().size(); ++i) {
                    object2 = (MultidimensionalDesign)this.getMultidimensionalDesigns().getElement(i);
                    if (string.equalsIgnoreCase(((DesignPart)object2).getMainViewID())) {
                        return ((MultidimensionalDesign)object2).getMainView();
                    }
                    object = ((DesignPart)object2).getDesignSubviews().iterator();
                    while (object.hasNext()) {
                        designPartViewPlaceHolder = (DesignPartViewPlaceHolder)object.next();
                        if (!string.equalsIgnoreCase(designPartViewPlaceHolder.getDesignPartView().getDPVId())) continue;
                        return designPartViewPlaceHolder.getDesignPartView();
                    }
                }
                iterator = this.getProcessModel().getDataFlowDesigns().iterator();
                while (iterator.hasNext()) {
                    DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
                    if (!dataFlowDesign.isLoaded() || !dataFlowDesign.isVisible() || !string.equalsIgnoreCase(dataFlowDesign.getMainViewID())) continue;
                    return dataFlowDesign.getMainView();
                }
                iterator = this.getProcessModel().getTransformationPackageSet().iterator();
                while (iterator.hasNext()) {
                    TransformationPackage transformationPackage = (TransformationPackage)iterator.next();
                    object2 = transformationPackage.getTransformationTaskSet().iterator();
                    while (object2.hasNext()) {
                        object = (TransformationTask)object2.next();
                        if (!((DesignPart)object).isVisible() || !string.equalsIgnoreCase(((DesignPart)object).getMainViewID())) continue;
                        return ((TransformationTask)object).getMainView();
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Design.findDPV", exception);
        }
        return null;
    }

    public void closeAllDiagramsAndClearRefs() {
        DesignPartViewPlaceHolder designPartViewPlaceHolder;
        Object object;
        Object object2;
        this.getLogicalDesign().setMainViewVisible(false);
        this.getLogicalDesign().getMainView().clearCellRefsToObjects();
        Iterator iterator = this.getLogicalDesign().getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder2 = (DesignPartViewPlaceHolder)iterator.next();
            designPartViewPlaceHolder2.setVisible(false);
            designPartViewPlaceHolder2.getDesignPartView().clearCellRefsToObjects();
        }
        for (int i = 0; i < this.getRelationalDesigns().size(); ++i) {
            object2 = (RelationalDesign)this.getRelationalDesigns().getElement(i);
            ((DesignPart)object2).setMainViewVisible(false);
            ((RelationalDesign)object2).getMainView().clearCellRefsToObjects();
            object = ((DesignPart)object2).getDesignSubviews().iterator();
            while (object.hasNext()) {
                designPartViewPlaceHolder = (DesignPartViewPlaceHolder)object.next();
                designPartViewPlaceHolder.setVisible(false);
                designPartViewPlaceHolder.getDesignPartView().clearCellRefsToObjects();
            }
        }
        this.getDataTypesDesign().setMainViewVisible(false);
        this.getDataTypesDesign().getMainView().clearCellRefsToObjects();
        iterator = this.getDataTypesDesign().getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder3 = (DesignPartViewPlaceHolder)iterator.next();
            designPartViewPlaceHolder3.setVisible(false);
            designPartViewPlaceHolder3.getDesignPartView().clearCellRefsToObjects();
        }
        for (int i = 0; i < this.getMultidimensionalDesigns().size(); ++i) {
            object2 = (MultidimensionalDesign)this.getMultidimensionalDesigns().getElement(i);
            ((DesignPart)object2).setMainViewVisible(false);
            ((MultidimensionalDesign)object2).getMainView().clearCellRefsToObjects();
            object = ((DesignPart)object2).getDesignSubviews().iterator();
            while (object.hasNext()) {
                designPartViewPlaceHolder = (DesignPartViewPlaceHolder)object.next();
                designPartViewPlaceHolder.setVisible(false);
                designPartViewPlaceHolder.getDesignPartView().clearCellRefsToObjects();
            }
        }
        iterator = this.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            if (!dataFlowDesign.isLoaded() || !dataFlowDesign.isVisible()) continue;
            dataFlowDesign.setMainViewVisible(false);
            dataFlowDesign.getMainView().clearCellRefsToObjects();
        }
        iterator = this.getProcessModel().getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)iterator.next();
            object2 = transformationPackage.getTransformationTaskSet().iterator();
            while (object2.hasNext()) {
                object = (TransformationTask)object2.next();
                if (!((DesignPart)object).isVisible()) continue;
                ((TransformationTask)object).setMainViewVisible(false);
                ((TransformationTask)object).getMainView().clearCellRefsToObjects();
            }
        }
    }

    public boolean isApplyNameSubstitution() {
        return this.applyNameSubstitution;
    }

    public void setApplyNameSubstitution(boolean bl) {
        this.applyNameSubstitution = bl;
    }

    public String getUnloadDirectory() {
        return this.unloadDirectory;
    }

    public void setUnloadDirectory(String string) {
        this.unloadDirectory = string;
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(int n) {
        this.currentOperation = n;
    }

    public void addDesignPartView(DesignPartView designPartView) {
        String string = designPartView.getDPVId();
        if (string != null && !"".equalsIgnoreCase(string)) {
            this.dpvs.remove(string);
            this.dpvs.put(string, designPartView);
        }
    }

    public void removeDesignPartView(DesignPartView designPartView) {
        String string = designPartView.getDPVId();
        if (string != null && !"".equalsIgnoreCase(string)) {
            Object[] objectArray = this.dpvs.keySet().toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                Object v = this.dpvs.get(objectArray[i]);
                if (!v.equals(designPartView)) continue;
                this.dpvs.remove(objectArray[i]);
                this.removeDesignListener(designPartView);
            }
            this.dpvs.remove(string);
        } else {
            Object[] objectArray = this.dpvs.values().toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                Object object = objectArray[i];
                if (object != designPartView) continue;
                this.dpvs.remove(designPartView);
                this.removeDesignListener(designPartView);
            }
        }
    }

    public DesignPartView getDesignPartView(String string) {
        return (DesignPartView)this.dpvs.get(string);
    }

    public boolean hasUsageOfStructuredType(StructuredType structuredType) {
        Iterator iterator = this.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!relationalDesign.hasUsageOfStructuredType(structuredType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlossaries() {
        return this.getNamingStandardRule().getGlossariesList().size() > 0;
    }

    public void clearGlossaries() {
        this.getNamingStandardRule().clearGlossaries();
    }

    private Glossary getValidRelationalNameGlossary(DesignObject designObject) {
        char c;
        String string = designObject.getName().trim();
        NamingStandardRule namingStandardRule = this.getNamingStandardRule();
        List list = designObject instanceof Table || designObject instanceof TableView ? namingStandardRule.getTablesList() : (designObject instanceof Column ? namingStandardRule.getColumnsList() : new ArrayList());
        Iterator iterator = namingStandardRule.getGlossaries().iterator();
        NamingOptionsHolder namingOptionsHolder = designObject.getDesignPart().getNamingOptionsHolderFor(designObject.getClass());
        if (namingOptionsHolder == null) {
            namingOptionsHolder = designObject.getDesignPart().getNamingOptionsHolderFor(Table.class);
        }
        boolean bl = false;
        if (namingOptionsHolder != null && (c = namingOptionsHolder.getCaseType()) == '\u0000') {
            bl = true;
        }
        c = namingStandardRule.getRelationalSeparatorChar();
        boolean bl2 = namingStandardRule.isAbbreviatedOnly();
        while (iterator.hasNext()) {
            Glossary glossary = (Glossary)iterator.next();
            String string2 = glossary.checkValidName(string, list, c, false, bl, true, bl2);
            if (string2 != null) continue;
            return glossary;
        }
        return null;
    }

    private Glossary getValidLogicalNameGlossary(DesignObject designObject) {
        String string = designObject.getName().trim();
        NamingStandardRule namingStandardRule = this.getNamingStandardRule();
        List list = designObject instanceof Entity || designObject instanceof EntityView ? namingStandardRule.getEntitiesList() : (designObject instanceof Attribute ? namingStandardRule.getAttributesList() : new ArrayList());
        Iterator iterator = namingStandardRule.getGlossaries().iterator();
        char c = namingStandardRule.getLogicalSeparatorChar();
        boolean bl = "Title Case".equalsIgnoreCase(namingStandardRule.getLogicalSep());
        while (iterator.hasNext()) {
            Glossary glossary = (Glossary)iterator.next();
            String string2 = glossary.checkValidName(string, list, c, bl, false, false, false);
            if (string2 != null) continue;
            return glossary;
        }
        return null;
    }

    private Class getCorrespondentClass(DesignObject designObject) {
        if (designObject instanceof Table) {
            return Entity.class;
        }
        if (designObject instanceof Column) {
            return Attribute.class;
        }
        if (designObject instanceof TableView) {
            return EntityView.class;
        }
        if (designObject instanceof Entity) {
            return Table.class;
        }
        if (designObject instanceof EntityView) {
            return TableView.class;
        }
        if (designObject instanceof Attribute) {
            return Column.class;
        }
        return DesignObject.class;
    }

    public String transformNameFromLogicalToRelational(DesignObject designObject) {
        NamingStandardRule namingStandardRule = this.getNamingStandardRule();
        RelationalDesign relationalDesign = designObject.getDesign().getRelationalDesign();
        NamingOptionsHolder namingOptionsHolder = relationalDesign.getNamingOptionsHolderFor(this.getCorrespondentClass(designObject));
        if (namingOptionsHolder == null) {
            namingOptionsHolder = relationalDesign.getNamingOptionsHolderFor(Table.class);
        }
        boolean bl = false;
        int n = -1;
        if (namingOptionsHolder != null && (n = namingOptionsHolder.getCaseType()) == 0) {
            bl = true;
        }
        String string = designObject.getName().trim();
        char c = namingStandardRule.getLogicalSeparatorChar();
        char c2 = namingStandardRule.getRelationalSeparatorChar();
        Glossary glossary = null;
        String string2 = "";
        if (designObject instanceof Entity) {
            string2 = ((Entity)designObject).getPreferredAbbreviation();
        } else if (designObject instanceof Attribute) {
            string2 = ((Attribute)designObject).getPreferredAbbreviation();
        }
        if (this.isApplyNameStandardization() && this.isUsePreferredAbbreviation() && !"".equals(string2)) {
            if (bl) {
                return string2.toUpperCase();
            }
            return string2;
        }
        if (this.isApplyNameStandardization() && this.hasGlossaries() && (glossary = this.getValidLogicalNameGlossary(designObject)) != null) {
            int n2 = this.getRelationalNamesize(designObject, relationalDesign);
            boolean bl2 = "Title Case".equalsIgnoreCase(namingStandardRule.getLogicalSep());
            List list = glossary.getTerms(string, c, bl2);
            String string3 = "";
            if (list.size() == 1 && designObject instanceof Entity) {
                Glossary.NamePart namePart = (Glossary.NamePart)list.get(0);
                if (namePart.word != null && !"".equals(namePart.word.getPlural().trim())) {
                    string3 = namePart.word.getPlural().trim();
                }
            }
            if ("".equals(string3)) {
                string3 = this.transform(list, n2, 0, c2, false);
            }
            if (bl) {
                return string3.toUpperCase();
            }
            return string3;
        }
        if (this.isApplyNameStandardization()) {
            string = AbstractEngineering.transformSeparatorFromLogical(string, c, c2);
        }
        if (n == 0) {
            return string.toUpperCase();
        }
        if (n == 1) {
            return string.toLowerCase();
        }
        return string;
    }

    private String transform(List list, int n, int n2, char c, boolean bl) {
        String string = "";
        int n3 = 0;
        if (n2 < list.size()) {
            String string2 = "";
            Glossary.NamePart namePart = (Glossary.NamePart)list.get(n2);
            if (namePart.word != null) {
                GlossaryWord glossaryWord = namePart.word;
                if (!"".equalsIgnoreCase(glossaryWord.getAbbreviation()) && !bl) {
                    string2 = glossaryWord.getAbbreviation();
                    n3 = 1;
                } else if (!"".equalsIgnoreCase(glossaryWord.getAltAbbrevation())) {
                    string2 = glossaryWord.getAltAbbrevation();
                    n3 = 2;
                } else if (bl && "".equalsIgnoreCase(glossaryWord.getAltAbbrevation()) && !"".equalsIgnoreCase(glossaryWord.getAbbreviation())) {
                    string2 = glossaryWord.getAbbreviation();
                    n3 = 2;
                } else {
                    string2 = glossaryWord.getName();
                    n3 = 3;
                }
            } else {
                string2 = namePart.namePart;
                n3 = 4;
            }
            string = string2;
            int n4 = n2 + 1;
            if (n4 < list.size()) {
                int n5 = n - string.length();
                String string3 = this.transform(list, n5, n4, c, bl);
                String string4 = "";
                string4 = c != '\u0000' && !"".equals(string3) ? string + c + string3 : string + string3;
                if (string4.length() > n) {
                    if (!bl) {
                        string3 = this.transform(list, n5, n4, c, true);
                        string4 = c != '\u0000' && !"".equals(string3) ? string + c + string3 : string + string3;
                        if (string4.length() <= n) {
                            return string4;
                        }
                    }
                    if (n3 == 1 && !"".equalsIgnoreCase(namePart.word.getAltAbbrevation())) {
                        string = namePart.word.getAltAbbrevation();
                        string4 = c != '\u0000' && !"".equals(string3) ? string + c + string3 : string + string3;
                        return string4;
                    }
                    return string4;
                }
                return string4;
            }
            if (string.length() > n && n3 == 1 && !"".equalsIgnoreCase(namePart.word.getAltAbbrevation())) {
                return namePart.word.getAltAbbrevation();
            }
            return string;
        }
        return string;
    }

    private int getRelationalNamesize(DesignObject designObject, RelationalDesign relationalDesign) {
        NamingOptionsHolder namingOptionsHolder = null;
        namingOptionsHolder = designObject instanceof CandidateKey || designObject instanceof Entity ? relationalDesign.getNamingOptionsHolderFor(Table.class) : (designObject instanceof Attribute ? relationalDesign.getNamingOptionsHolderFor(Column.class) : (designObject instanceof EntityView ? relationalDesign.getNamingOptionsHolderFor(TableView.class) : relationalDesign.getNamingOptionsHolderFor(designObject.getClass())));
        if (namingOptionsHolder != null) {
            int n = namingOptionsHolder.getMaxNameLength();
            return n;
        }
        return 18;
    }

    public String transformNameFromRelationalToLogical(DesignObject designObject) {
        NamingStandardRule namingStandardRule = this.getNamingStandardRule();
        LogicalDesign logicalDesign = designObject.getDesign().getLogicalDesign();
        NamingOptionsHolder namingOptionsHolder = logicalDesign.getNamingOptionsHolderFor(this.getCorrespondentClass(designObject));
        if (namingOptionsHolder == null) {
            namingOptionsHolder = logicalDesign.getNamingOptionsHolderFor(Entity.class);
        }
        boolean bl = false;
        int n = -1;
        if (namingOptionsHolder != null && (n = namingOptionsHolder.getCaseType()) == 0) {
            bl = true;
        }
        String string = designObject.getName().trim();
        Glossary glossary = null;
        char c = namingStandardRule.getLogicalSeparatorChar();
        char c2 = namingStandardRule.getRelationalSeparatorChar();
        if (this.isApplyNameStandardization() && this.hasGlossaries() && (glossary = this.getValidRelationalNameGlossary(designObject)) != null) {
            boolean bl2 = "Title Case".equalsIgnoreCase(namingStandardRule.getLogicalSep());
            boolean bl3 = namingStandardRule.isAbbreviatedOnly();
            List list = glossary.getTerms(string, c2, false, true, bl, bl3);
            String string2 = "";
            boolean bl4 = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = "";
                Glossary.NamePart namePart = (Glossary.NamePart)iterator.next();
                string3 = namePart.word != null ? namePart.word.getName() : namePart.namePart;
                if (bl2 && !"".equalsIgnoreCase(string3)) {
                    string3 = string3.length() > 1 ? Character.toUpperCase(string3.charAt(0)) + string3.substring(1, string3.length()) : "" + Character.toUpperCase(string3.charAt(0));
                }
                if (bl4) {
                    string2 = string3;
                    bl4 = false;
                    continue;
                }
                if (c != '\u0000' && !bl2) {
                    string2 = string2 + c + string3;
                    continue;
                }
                string2 = string2 + string3;
            }
            if (n == 0) {
                return string2.toUpperCase();
            }
            if (n == 1) {
                return string2.toLowerCase();
            }
            return string2;
        }
        if (this.isApplyNameStandardization()) {
            string = AbstractEngineering.transformSeparatorFromRelational(string, c2, c);
        }
        if (n == 0) {
            return string.toUpperCase();
        }
        if (n == 1) {
            return string.toLowerCase();
        }
        return string;
    }

    public boolean isApplyNameStandardization() {
        return this.applyNameStandardization;
    }

    public void setApplyNameStandardization(boolean bl) {
        this.applyNameStandardization = bl;
    }

    public boolean isUsePreferredAbbreviation() {
        return this.usePreferredAbbreviation;
    }

    public void setUsePreferredAbbreviation(boolean bl) {
        this.usePreferredAbbreviation = bl;
    }

    public boolean isEditable() {
        return !ApplicationView.IS_VIEWER;
    }

    public boolean isSaveDefaultDomains() {
        return this.saveDefaultDomains;
    }

    public void setSaveDefaultDomains(boolean bl) {
        this.saveDefaultDomains = bl;
    }

    public void buildNativeToLogicalMappings() {
        RDBMSType[] rDBMSTypeArray = this.getDefaultRDBMSTypeSet().toTypeArray();
        LogicalDatatype logicalDatatype = (LogicalDatatype)this.getLogicalDatatypeSet().getByName("UNKNOWN");
        for (int i = 0; i < rDBMSTypeArray.length; ++i) {
            RDBMSType rDBMSType = rDBMSTypeArray[i];
            String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes(rDBMSType);
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                String string2 = StandardDatatypeNames.getUsedDatatypeName(string);
                LogicalDatatype logicalDatatype2 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rDBMSType, string2);
                if (logicalDatatype2 == null) {
                    logicalDatatype2 = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rDBMSType, string);
                }
                if (logicalDatatype2 != null) continue;
                String string3 = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(string2);
                logicalDatatype2 = (LogicalDatatype)this.getLogicalDatatypeSet().getByName(string3);
                if (logicalDatatype2 == null) {
                    logicalDatatype2 = logicalDatatype;
                }
                if (logicalDatatype2 == null) continue;
                MappingDatatypeNameLogicalDataType.addNativeToLogicalMapping(rDBMSType, string, logicalDatatype2);
            }
        }
    }

    public List getExportedDesignParts() {
        return this.exportedDesignParts;
    }

    public void buildExporMaps(List list) {
        this.clearExportMaps();
        for (SelectExportDialog.ExpObject expObject : list) {
            if (!expObject.isDesignPart()) continue;
            if (expObject.selected) {
                this.expDesPartsMap.put(expObject.getObject().getObjectID(), expObject.getObject());
                continue;
            }
            this.addSubviewObjectsToObjectsExpMap(expObject);
            if (expObject.getSubViews().size() <= 0) continue;
            for (int i = 0; i < expObject.getSubViews().size(); ++i) {
                SelectExportDialog.ExpObject expObject2 = (SelectExportDialog.ExpObject)expObject.getSubViews().get(i);
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)expObject2.getObject();
                DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
                DesignPart designPart = designPartView.getDesignPart();
                this.expPartialDesPartsMap.put(designPart.getObjectID(), designPart);
            }
        }
    }

    private void addSubviewObjectsToObjectsExpMap(SelectExportDialog.ExpObject expObject) {
        for (SelectExportDialog.ExpObject expObject2 : expObject.getSubViews()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)expObject2.getObject();
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            this.expDPVMap.put(designPartView.getDPVId(), designPartView);
            DesignPart designPart = designPartView.getDesignPart();
            Collection collection = designPart.getStorableDesignObjects();
            for (DesignObject designObject : collection) {
                TopView topView = designObject.getFirstViewForDPV(designPartView);
                if (topView == null) continue;
                this.expDesObjectsMap.put(designObject.getObjectID(), designObject);
                if (!(designObject instanceof Entity) || !((Entity)designObject).isHierarchicalEntityType()) continue;
                this.addEntitySuperTypes((Entity)designObject);
            }
        }
    }

    private void addEntitySuperTypes(Entity entity) {
        if (entity.isHierarchicalEntityType()) {
            for (Entity entity2 = entity.getHierarchicalParent(); entity2 != null; entity2 = entity2.getHierarchicalParent()) {
                this.expDesObjectsMap.put(entity2.getObjectID(), entity2);
            }
        }
    }

    public boolean shouldExportFull(DesignPart designPart) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        return this.expDesPartsMap.get(designPart.getObjectID()) != null;
    }

    public boolean shouldExportPartial(DesignPart designPart) {
        return this.expPartialDesPartsMap.get(designPart.getObjectID()) != null;
    }

    public boolean shouldExport(DesignObject designObject) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        if (this.shouldExportFull(designObject.getDesignPart())) {
            return true;
        }
        return this.expDesObjectsMap.get(designObject.getObjectID()) != null;
    }

    public boolean shouldExportDPV(DesignPartView designPartView) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        if (this.shouldExportFull(designPartView.getDesignPart())) {
            return true;
        }
        return this.expDPVMap.get(designPartView.getDPVId()) != null;
    }

    public boolean shouldExport(RelationalObjectProxy relationalObjectProxy) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        DesignObject designObject = relationalObjectProxy.getObject();
        if (designObject != null) {
            if (this.shouldExportFull(designObject.getDesignPart())) {
                return true;
            }
            if (designObject instanceof Column) {
                ContainerWithKeyObject containerWithKeyObject = ((Column)designObject).getContainerWithKeyObject();
                return this.shouldExport(containerWithKeyObject);
            }
            if (designObject instanceof Index) {
                ContainerWithKeyObject containerWithKeyObject = ((Index)designObject).getContainerWithKeyObject();
                return this.shouldExport(containerWithKeyObject);
            }
            if (designObject instanceof FKIndexAssociation) {
                ContainerWithKeyObject containerWithKeyObject = ((FKIndexAssociation)designObject).getContainerWithKeyObject();
                return this.shouldExport(containerWithKeyObject) && this.shouldExport(((FKIndexAssociation)designObject).getRemoteTable());
            }
            return this.shouldExport(designObject);
        }
        return false;
    }

    public boolean shouldExportMappedObject(DesignObject designObject) {
        if (this.getCurrentOperation() != 5) {
            return true;
        }
        if (designObject != null) {
            if (this.shouldExportFull(designObject.getDesignPart())) {
                return true;
            }
            if (designObject instanceof ContainedObject) {
                ContainerObject containerObject = ((ContainedObject)designObject).getContainer();
                return this.shouldExport(containerObject);
            }
            if (designObject instanceof KeyObject) {
                ContainerWithKeyObject containerWithKeyObject = ((KeyObject)designObject).getContainerWithKeyObject();
                return this.shouldExport(containerWithKeyObject);
            }
            if (designObject instanceof FKIndexAssociation) {
                ContainerWithKeyObject containerWithKeyObject = ((FKIndexAssociation)designObject).getContainerWithKeyObject();
                return this.shouldExport(containerWithKeyObject);
            }
            return this.shouldExport(designObject);
        }
        return false;
    }

    public void clearExportMaps() {
        this.expDesObjectsMap.clear();
        this.expDesPartsMap.clear();
        this.expPartialDesPartsMap.clear();
        this.expDPVMap.clear();
    }

    public static void clearMap(Map map) {
        Object[] objectArray = map.keySet().toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            map.remove(objectArray[i]);
        }
    }

    public static void openFailed() {
        OPEN_FAILED = true;
    }

    public List getAttrColPropertyList() {
        if (this.attrColPropertyList == null) {
            this.attrColPropertyList = new ArrayList();
            Attribute attribute = new Attribute(this.getLogicalDesign());
            attribute.setUseDomainConstraints(false);
            AttributeColumnComparator attributeColumnComparator = new AttributeColumnComparator(attribute, null);
            for (EngPropertyHolder engPropertyHolder : attributeColumnComparator.getPropertiesList()) {
                engPropertyHolder.setSelected(true);
                this.attrColPropertyList.add(engPropertyHolder);
            }
        }
        return this.attrColPropertyList;
    }

    public void setAttrColPropertyList(List list) {
        this.attrColPropertyList = list;
    }

    public List getEntTablePropertyList() {
        if (this.entTablePropertyList == null) {
            this.entTablePropertyList = new ArrayList();
            Entity entity = new Entity(this.getLogicalDesign());
            EntityTableComparator entityTableComparator = new EntityTableComparator(entity, null);
            for (EngPropertyHolder engPropertyHolder : entityTableComparator.getPropertiesList()) {
                engPropertyHolder.setSelected(true);
                this.entTablePropertyList.add(engPropertyHolder);
            }
        }
        return this.entTablePropertyList;
    }

    public void setEntTablePropertyList(List list) {
        this.entTablePropertyList = list;
    }

    public List getKeyIdxPropertyList() {
        if (this.keyIdxPropertyList == null) {
            this.keyIdxPropertyList = new ArrayList();
            CandidateKey candidateKey = new CandidateKey(this.getLogicalDesign());
            KeyIndexComparator keyIndexComparator = new KeyIndexComparator(candidateKey, null);
            for (EngPropertyHolder engPropertyHolder : keyIndexComparator.getPropertiesList()) {
                engPropertyHolder.setSelected(true);
                this.keyIdxPropertyList.add(engPropertyHolder);
            }
        }
        return this.keyIdxPropertyList;
    }

    public void setKeyIdxPropertyList(List list) {
        this.keyIdxPropertyList = list;
    }

    public static EngPropertyHolder getEngPropertyHolder(List list, String string) {
        for (Object e : list) {
            EngPropertyHolder engPropertyHolder;
            if (!(e instanceof EngPropertyHolder) || !string.equalsIgnoreCase((engPropertyHolder = (EngPropertyHolder)e).getName())) continue;
            return engPropertyHolder;
        }
        return null;
    }

    public List getRelFKPropertyList() {
        if (this.relFKPropertyList == null) {
            this.relFKPropertyList = new ArrayList();
            Relation relation = new Relation(this.getLogicalDesign());
            RelationFKComparator relationFKComparator = new RelationFKComparator(relation, null);
            for (EngPropertyHolder engPropertyHolder : relationFKComparator.getPropertiesList()) {
                engPropertyHolder.setSelected(true);
                this.relFKPropertyList.add(engPropertyHolder);
            }
        }
        return this.relFKPropertyList;
    }

    public void setRelFKPropertyList(List list) {
        this.relFKPropertyList = list;
    }

    public List getViewPropertyList() {
        if (this.viewPropertyList == null) {
            this.viewPropertyList = new ArrayList();
            EntityView entityView = new EntityView(this.getLogicalDesign());
            EntViewTableViewComparator entViewTableViewComparator = new EntViewTableViewComparator(entityView, null);
            for (EngPropertyHolder engPropertyHolder : entViewTableViewComparator.getPropertiesList()) {
                engPropertyHolder.setSelected(true);
                this.viewPropertyList.add(engPropertyHolder);
            }
        }
        return this.viewPropertyList;
    }

    public void setViewPropertyList(List list) {
        this.viewPropertyList = list;
    }

    public boolean getShowSelPropsOnly() {
        return this.showSelPropsOnly;
    }

    public void setShowSelPropsOnly(boolean bl) {
        this.showSelPropsOnly = bl;
    }

    public boolean getNotForNewObjects() {
        return this.notForNewObjects;
    }

    public void setNotForNewObjects(boolean bl) {
        this.notForNewObjects = bl;
    }

    public boolean getExcludeFromTree() {
        return this.excludeFromTree;
    }

    public void setExcludeFromTree(boolean bl) {
        this.excludeFromTree = bl;
    }

    private void clearCompareLists() {
        if (this.entTablePropertyList != null) {
            this.entTablePropertyList.clear();
            this.entTablePropertyList = null;
        }
        if (this.attrColPropertyList != null) {
            this.attrColPropertyList.clear();
            this.attrColPropertyList = null;
        }
        if (this.keyIdxPropertyList != null) {
            this.keyIdxPropertyList.clear();
            this.keyIdxPropertyList = null;
        }
        if (this.relFKPropertyList != null) {
            this.relFKPropertyList.clear();
            this.relFKPropertyList = null;
        }
        if (this.viewPropertyList != null) {
            this.viewPropertyList.clear();
            this.viewPropertyList = null;
        }
    }

    public DP_UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DesignPropertiesDialog designPropertiesDialog = new DesignPropertiesDialog(this.getAppView(), this);
            designPropertiesDialog.initProperties();
            designPropertiesDialog.showDialog();
        }
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public List getStorableDesignParts() {
        ArrayList<DesignPart> arrayList = new ArrayList<DesignPart>();
        arrayList.add(this.getBusinessInfoDesign());
        arrayList.add(this.getDataTypesDesign());
        arrayList.add(this.getLogicalDesign());
        Iterator iterator = this.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            arrayList.add((DesignPart)iterator.next());
        }
        iterator = this.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            arrayList.add((DesignPart)iterator.next());
        }
        arrayList.add(this.getProcessModel());
        iterator = this.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            arrayList.add((DesignPart)iterator.next());
        }
        return arrayList;
    }

    public boolean isLoadFromDB() {
        return this.loadFromDB;
    }

    public void setLoadFromDB(boolean bl) {
        this.loadFromDB = bl;
    }

    public boolean isRepositoryRelated() {
        return this.getRepositoryOID() != null;
    }

    public RLDomains getRLDomains() {
        return this.rlDomains;
    }

    public DLDomains getDLDomains() {
        return this.dlDomains;
    }

    public DLSettings getDLSettings() {
        return this.dlSettings;
    }

    public void saveDesignLevelSettings() {
        String string = this.getDesignPath() + "/" + this.getFileName();
        this.saveDLSettingsFile(string);
    }

    public void loadDesignLevelSettings() {
        String string = this.getDesignPath() + "/" + this.getFileName();
        this.loadDLSettingsFile(string);
    }

    private List getRemovableDesignParts() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = this.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = this.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = this.getProcessModel().getAllTransformationTasks().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    private void createRemovableDPMap(Map map) {
        map.clear();
        List list = this.getRemovableDesignParts();
        for (ModelIDObject modelIDObject : list) {
            if (modelIDObject.getRepositoryOID() == null) continue;
            RepDeleteDescr repDeleteDescr = new RepDeleteDescr();
            repDeleteDescr.objectType = modelIDObject.getObjectTypeName();
            repDeleteDescr.repOID = modelIDObject.getRepositoryOID();
            repDeleteDescr.repOVID = modelIDObject.getRepositoryOVID();
            repDeleteDescr.objectID = modelIDObject.getObjectID();
            repDeleteDescr.pathID = modelIDObject.getPathID();
            map.put(modelIDObject.getRepositoryOID(), repDeleteDescr);
        }
    }

    public void createDP_RepositoryMap() {
        this.createRemovableDPMap(this.repositoryMap);
    }

    public void createLocalDP_Map() {
        this.localDPMap.clear();
        List list = this.getRemovableDesignParts();
        for (ModelIDObject modelIDObject : list) {
            RepDeleteDescr repDeleteDescr = new RepDeleteDescr();
            repDeleteDescr.objectType = modelIDObject.getObjectTypeName();
            repDeleteDescr.repOID = modelIDObject.getRepositoryOID();
            repDeleteDescr.repOVID = modelIDObject.getRepositoryOVID();
            repDeleteDescr.objectID = modelIDObject.getObjectID();
            if (this.getLoadedVersion() >= 3.4f) {
                repDeleteDescr.shortObjectID = modelIDObject.getShortObjectID();
            }
            repDeleteDescr.pathID = modelIDObject.getPathID();
            repDeleteDescr.parent = modelIDObject.getParent();
            this.localDPMap.put(modelIDObject.getObjectID(), repDeleteDescr);
        }
    }

    private List getLocalDesignPartsToDelete(Map map) {
        Object object22;
        List list = this.getRemovableDesignParts();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Object object22 : list) {
            treeMap.put(((ModelIDObject)object22).getObjectID(), ((ModelIDObject)object22).getObjectID());
        }
        object22 = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            Object v = treeMap.get(entry.getKey());
            if (v != null) continue;
            object22.add(entry.getValue());
        }
        return object22;
    }

    private List getRepositoryDesignPartsToDelete(Map map) {
        Object object22;
        List list = this.getRemovableDesignParts();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Object object22 : list) {
            if (((ModelIDObject)object22).getRepositoryOID() == null) continue;
            treeMap.put(((ModelIDObject)object22).getRepositoryOID(), ((ModelIDObject)object22).getRepositoryOID());
        }
        object22 = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            Object v = treeMap.get(entry.getKey());
            if (v != null) continue;
            object22.add(entry.getValue());
        }
        return object22;
    }

    public List getDesignPartsToDeleteFromRepository() {
        return this.getRepositoryDesignPartsToDelete(this.repositoryMap);
    }

    public List getDesignPartsToDeleteFromLocalFS() {
        return this.getLocalDesignPartsToDelete(this.localDPMap);
    }

    public void addToRepositoryLoadedRemovableDesignParts(DesignPart designPart) {
        this.addToLoadedRemovableDesignParts(designPart, this.repositoryMap);
    }

    public void addToLocalLoadedRemovableDesignParts(DesignPart designPart) {
        this.addToLoadedRemovableDesignParts(designPart, this.localDPMap);
    }

    private void addToLoadedRemovableDesignParts(DesignPart designPart, Map map) {
        String string = designPart.getObjectID();
        Object v = map.get(string);
        if (v == null) {
            RepDeleteDescr repDeleteDescr = new RepDeleteDescr();
            repDeleteDescr.objectType = designPart.getObjectTypeName();
            repDeleteDescr.repOID = designPart.getRepositoryOID();
            repDeleteDescr.repOVID = designPart.getRepositoryOVID();
            repDeleteDescr.objectID = string;
            repDeleteDescr.pathID = designPart.getPathID();
            map.put(string, repDeleteDescr);
        }
    }

    public void removeDeletedDesignParts() {
        this.removeDeletedDesignParts(true);
    }

    public void removeDeletedDesignParts(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.getDesignPartsToDeleteFromLocalFS()) {
            String string = this.makeDesignPartPath((RepDeleteDescr)object);
            if ("".equals(string)) continue;
            String string2 = string + ".xml" + (this.compressedDesign ? "z" : "");
            arrayList.add(string);
            arrayList.add(string2);
        }
        if (arrayList.size() > 0) {
            if (Extension.isSVNExtensionLoaded() && this.isVersioned() && bl) {
                SVNClientHelper.getInstance().doRemove(arrayList);
            } else {
                Object object;
                object = this.getAppView().getPersistenceManager();
                ((PersistenceManager)object).deleteFiles(arrayList);
            }
        }
    }

    private String makeDesignPartPath(RepDeleteDescr repDeleteDescr) {
        String string = "";
        if ("RelationalModel".equalsIgnoreCase(repDeleteDescr.objectType)) {
            string = repDeleteDescr.shortObjectID != null ? this.makeRelDesignPath(String.valueOf(repDeleteDescr.shortObjectID)) : this.makeRelDesignPath(String.valueOf(repDeleteDescr.pathID));
        } else if ("Dimensional Model".equalsIgnoreCase(repDeleteDescr.objectType)) {
            string = this.makeDimensionalDesignPath(repDeleteDescr.objectID);
        } else if ("Data Flow Diagram".equalsIgnoreCase(repDeleteDescr.objectType)) {
            string = this.makeDataFlowDesignPath(repDeleteDescr.objectID);
        } else if ("TransformationTask".equalsIgnoreCase(repDeleteDescr.objectType)) {
            string = this.makeTransformationTaskDesignPath(repDeleteDescr.objectID, ((TransformationPackage)repDeleteDescr.parent).getObjectID());
        }
        return string;
    }

    private String makeDimensionalDesignPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getDesignPath());
        stringBuffer.append("/").append(this.getFileName());
        stringBuffer.append("/").append("multidimensional");
        stringBuffer.append("/").append(string);
        return stringBuffer.toString();
    }

    private String makeDataFlowDesignPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getDesignPath());
        stringBuffer.append("/").append(this.getFileName());
        stringBuffer.append("/").append("pm/dflows");
        stringBuffer.append("/").append(string);
        return stringBuffer.toString();
    }

    private String makeTransformationTaskDesignPath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDesignPath());
        stringBuffer.append("/").append(this.getFileName());
        stringBuffer.append("/").append("pm/tp");
        stringBuffer.append("/").append(string2);
        stringBuffer.append("/").append("tt");
        stringBuffer.append("/").append(string);
        return stringBuffer.toString();
    }

    public boolean isMerging() {
        return this.merging;
    }

    public void setMerging(boolean bl) {
        this.merging = bl;
    }

    public String getEngDateFormat() {
        if ("".equals(this.engDateFormat)) {
            return this.defDateFormat;
        }
        return this.engDateFormat;
    }

    public void setEngDateFormat(String string) {
        this.engDateFormat = string;
    }

    public String getEngTimestampFormat() {
        if ("".equals(this.engTimestampFormat)) {
            return this.defTimestampFormat;
        }
        return this.engTimestampFormat;
    }

    public void setEngTimestampFormat(String string) {
        this.engTimestampFormat = string;
    }

    public String getEngTimestampWTZFormat() {
        if ("".equals(this.engTimestampWTZFormat)) {
            return this.defTimestampWTZFormat;
        }
        return this.engTimestampWTZFormat;
    }

    public void setEngTimestampWTZFormat(String string) {
        this.engTimestampWTZFormat = string;
    }

    public void resetRDBMSSites() {
        if (this.rdbmsSiteSet != null) {
            this.rdbmsSiteSet.removeAll();
        }
    }

    @Override
    public Design getDesign() {
        return this;
    }

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        if (this.getRelationalDesign() != null && this.getRelationalDesign().getSelectedRDBMSSite() != null) {
            return this.getRelationalDesign().getSelectedRDBMSSite();
        }
        return this.getRDBMSSiteSet().getDefaultRDBMSSite(this.getAppView().getSettings());
    }

    public void setSelectedRDBMSSite(RDBMSSite rDBMSSite) {
        if (this.getRelationalDesign() != null) {
            this.getRelationalDesign().setSelectedRDBMSSite(rDBMSSite);
        }
    }

    public StorageDesignFactory getStorageDesignFactory() {
        if (this.getRelationalDesign() != null) {
            return this.getRelationalDesign().getStorageDesignFactory();
        }
        return null;
    }

    public RDBMSTypeSet getDefaultRDBMSTypeSet() {
        if (this.defauttRdbmsTypeSet == null) {
            this.defauttRdbmsTypeSet = new RDBMSTypeSet();
            this.defauttRdbmsTypeSet.add(StorageDesignOraclev11g.RDBMS_TYPE);
            this.defauttRdbmsTypeSet.add(StorageDesignOraclev10g.RDBMS_TYPE);
            this.defauttRdbmsTypeSet.add(StorageDesignOraclev9i.RDBMS_TYPE);
            this.defauttRdbmsTypeSet.add(StorageDesignSqlServerv2k5.RDBMS_TYPE);
            this.defauttRdbmsTypeSet.add(StorageDesignSqlServerv2k.RDBMS_TYPE);
            this.defauttRdbmsTypeSet.add(StorageDesignDB2v80.RDBMS_TYPE);
            this.defauttRdbmsTypeSet.add(StorageDesignDB2v70.RDBMS_TYPE);
            this.defauttRdbmsTypeSet.add(StorageDesignUDBv81.RDBMS_TYPE);
            this.defauttRdbmsTypeSet.add(StorageDesignUDBv71.RDBMS_TYPE);
        }
        return this.defauttRdbmsTypeSet;
    }

    public RDBMSTypeSet getRDBMSTypeSet() {
        return this.getDefaultRDBMSTypeSet();
    }

    public void setRDBMSSiteSet(RDBMSSiteSet rDBMSSiteSet) {
        this.rdbmsSiteSet = rDBMSSiteSet;
    }

    public RDBMSSiteSet getRDBMSSiteSet() {
        boolean bl;
        boolean bl2 = bl = this.rdbmsSiteSet != null && this.rdbmsSiteSet.size() == 0;
        if (this.rdbmsSiteSet != null && this.rdbmsSiteSet.isLoadFromRepository()) {
            bl = false;
        }
        if (this.rdbmsSiteSet == null || bl) {
            this.rdbmsSiteSet = new RDBMSSiteSet(this);
            RXMLDefaultRDBMSSiteSet rXMLDefaultRDBMSSiteSet = new RXMLDefaultRDBMSSiteSet();
            String string = this.getAppView().getSettings().getDefaultSystemTypesPath();
            File file = new File(string);
            if (string.length() == 0 || !file.exists()) {
                string = this.getAppView().getMDConfiguration().get("defaultFilePath") + "/" + this.getAppView().getMDConfiguration().get("typesPath");
            }
            this.rdbmsSiteSet = (RDBMSSiteSet)rXMLDefaultRDBMSSiteSet.readDefaultRDBMSSites(string + "/" + "defaultRDBMSSites" + ".xml", this);
        }
        return this.rdbmsSiteSet;
    }

    public RDBMSSite getFirstOfType(RDBMSType rDBMSType) {
        Iterator iterator = this.getRDBMSSiteSet().iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            if (rDBMSSite.getType() != rDBMSType) continue;
            return rDBMSSite;
        }
        return null;
    }

    public StorageDesign getStorageDesign(RDBMSSite rDBMSSite) {
        if (this.getRelationalDesign() != null) {
            return this.getRelationalDesign().getStorageDesign(rDBMSSite);
        }
        return null;
    }

    public StorageDesign getStorageDesign(RDBMSSite rDBMSSite, Table table) {
        if ((RelationalDesign)table.getDesignPart() != null) {
            return ((RelationalDesign)table.getDesignPart()).getStorageDesign(rDBMSSite);
        }
        return null;
    }

    public void destroyAll(boolean bl) {
        this.clearAll(bl);
        this.setReadOnly(false);
    }

    public boolean isNewDesign() {
        return this.newDesign;
    }

    public void setNewDesign(boolean bl) {
        this.newDesign = bl;
    }

    @Override
    public String getStoragePath() {
        try {
            String string = this.getFileName();
            if (string != null) {
                return new File(this.getDesignPath(), string).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            String string = this.getFileName();
            if (string != null) {
                return new File(this.getDesignPath(), string + ".dmd").getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void setModelListChanged(boolean bl) {
        this.modelListChanged = bl;
    }

    public boolean isModelListChanged() {
        return this.modelListChanged;
    }

    public void setOldRepositoryType(boolean bl) {
        this.oldRepositoryType = bl;
    }

    public boolean isOldRepositoryType() {
        return this.oldRepositoryType;
    }

    public void setChangeRequestListChanged(boolean bl) {
        this.changeRequestListChanged = bl;
    }

    public boolean isChangeRequestListChanged() {
        return this.changeRequestListChanged;
    }

    public void setCompressedDesign(boolean bl) {
        this.compressedDesign = bl;
    }

    public boolean isCompressedDesign() {
        return this.compressedDesign;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public void setVersioned(boolean bl) {
        this.versioned = bl;
    }

    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("changerequest", "ChangeRequest");
        }
        return this.f2tMap;
    }

    public String getDesignPath() {
        if (this.currentOperation == 5) {
            return this.exportDesignPath;
        }
        return this.designPath;
    }

    public void setDesignPath(String string) {
        this.designPath = string;
    }

    public String getExportDesignPath() {
        return this.exportDesignPath;
    }

    public void setExportDesignPath(String string) {
        this.exportDesignPath = string;
    }

    public StorableObjectStatusHelper getDesignPart(String string, String string2) {
        if ("businessinfo".equalsIgnoreCase(string)) {
            StorableObjectStatusHelper storableObjectStatusHelper = new StorableObjectStatusHelper();
            storableObjectStatusHelper.designPart = this.getBusinessInfoDesign();
            storableObjectStatusHelper.designPartClass = BusinessInfoDesign.class;
            return storableObjectStatusHelper;
        }
        if ("datatypes".equalsIgnoreCase(string)) {
            StorableObjectStatusHelper storableObjectStatusHelper = new StorableObjectStatusHelper();
            storableObjectStatusHelper.designPart = this.getDataTypesDesign();
            storableObjectStatusHelper.designPartClass = DataTypesDesign.class;
            return storableObjectStatusHelper;
        }
        if ("logical".equalsIgnoreCase(string)) {
            StorableObjectStatusHelper storableObjectStatusHelper = new StorableObjectStatusHelper();
            storableObjectStatusHelper.designPart = this.getLogicalDesign();
            storableObjectStatusHelper.designPartClass = LogicalDesign.class;
            return storableObjectStatusHelper;
        }
        if ("rel".equalsIgnoreCase(string)) {
            StorableObjectStatusHelper storableObjectStatusHelper = new StorableObjectStatusHelper();
            storableObjectStatusHelper.designPartClass = RelationalDesign.class;
            Iterator iterator = this.getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
                if (!string2.equalsIgnoreCase(relationalDesign.getShortObjectID())) continue;
                storableObjectStatusHelper.designPart = relationalDesign;
                storableObjectStatusHelper.shortObjectID = relationalDesign.getShortObjectID();
                break;
            }
            return storableObjectStatusHelper;
        }
        if ("multidimensional".equalsIgnoreCase(string)) {
            StorableObjectStatusHelper storableObjectStatusHelper = new StorableObjectStatusHelper();
            storableObjectStatusHelper.designPartClass = MultidimensionalDesign.class;
            Iterator iterator = this.getMultidimensionalDesigns().iterator();
            while (iterator.hasNext()) {
                MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
                if (!string2.equalsIgnoreCase(multidimensionalDesign.getObjectID())) continue;
                storableObjectStatusHelper.designPart = multidimensionalDesign;
                return storableObjectStatusHelper;
            }
            return storableObjectStatusHelper;
        }
        if ("pm".equalsIgnoreCase(string)) {
            StorableObjectStatusHelper storableObjectStatusHelper = new StorableObjectStatusHelper();
            storableObjectStatusHelper.designPart = this.getProcessModel();
            storableObjectStatusHelper.designPartClass = ProcessModel.class;
            return storableObjectStatusHelper;
        }
        return null;
    }

    public Map getDesignObjectsMap() {
        return this.idMap;
    }

    public Map getCorrespondenceMap() {
        return this.correspondenceMap;
    }

    public void setCorrespondenceMap(Map map) {
        this.correspondenceMap = map;
    }

    @Override
    public void setDirty(boolean bl) {
        if (bl && this.isNewDesign()) {
            return;
        }
        super.setDirty(bl);
    }

    public boolean areDlSettingsChanged() {
        return this.dlSettingsChanged;
    }

    public void setDlSettingsChanged(boolean bl) {
        this.dlSettingsChanged = bl;
    }

    public void setDlSettings(String string) {
        this.dlSettings.loadDLSettings(string);
    }

    public String getDesignLevelSettings() {
        StringBuffer stringBuffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        stringBuffer.append('\n');
        stringBuffer.append('<').append("settings").append('>');
        this.addDesignLevelSettings(stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append("</").append("settings").append('>');
        return stringBuffer.toString();
    }

    public void loadDLSettingsFile(String string) {
        try {
            File file = new File(string, "dl_settings.xml");
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                InputSource inputSource = new InputSource(inputStreamReader);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                this.loadDesignLevelSettings(document);
                this.getAppView().getSettings().loadDesignLevelSettings(document);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to load Design Level Settings: ", exception);
        }
    }

    private void loadDesignLevelSettings(Document document) {
        String string = this.getValue(document, "automatic_pk_generation");
        if (!"".equalsIgnoreCase(string)) {
            this.dlSettings.setAutomaticPKGeneration(Boolean.valueOf(string));
        }
        if (!"".equalsIgnoreCase(string = this.getValue(document, "automatic_uk_generation"))) {
            this.dlSettings.setAutomaticUKGeneration(Boolean.valueOf(string));
        }
        if (!"".equalsIgnoreCase(string = this.getValue(document, "automatic_fk_generation"))) {
            this.dlSettings.setAutomaticFKGeneration(Boolean.valueOf(string));
        }
        if (!"".equalsIgnoreCase(string = this.getValue(document, "logical_type_for_domain_presentation"))) {
            this.dlSettings.setLogicalTypeForDomainPresentation(Boolean.valueOf(string));
        }
        this.initSubstitutionPatterns(document);
        this.initClassificationTypes(document);
        this.initDefaultFontsAndColors(document);
        this.initDefaultLineWidthsAndColors(document);
        this.getNamingStandardRule();
        this.initNamingStandardRule(document);
        if (this.checkFileVersion()) {
            this.initCompareMappings(document);
        } else {
            this.dlSettings.getCompareMapping().clearCompareMappingsList();
            this.getCompareMappingList().init();
            Iterator<String> iterator = this.getCompareMappingList().getCompareMap().keySet().iterator();
            while (iterator.hasNext()) {
                this.dlSettings.getCompareMapping().addCompareMappingObject(this.getCompareMappingList().getCompareMap().get(iterator.next()));
            }
        }
        this.initEngineeringParams(document);
        this.initEngineeringCompare(document);
        this.initNamingOptions(document);
        this.initMergeConflicts(document);
        this.initDeletedFiles(document);
    }

    private void initSubstitutionPatterns(Document document) {
        Element element;
        this.dlSettings.getSubstitutionList().clear();
        NodeList nodeList = document.getElementsByTagName("substitution_patterns");
        if (nodeList.getLength() > 0 && (element = (Element)nodeList.item(0)) != null) {
            NodeList nodeList2 = element.getElementsByTagName("*");
            int n = nodeList2.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList2.item(i);
                if (element2 == null) continue;
                try {
                    String string = element2.getAttribute("oldstring");
                    String string2 = element2.getAttribute("newstring");
                    boolean bl = Boolean.valueOf(element2.getAttribute("selected"));
                    boolean bl2 = Boolean.valueOf(element2.getAttribute("casesensitive"));
                    String string3 = element2.getAttribute("comments");
                    SubstitutionPattern substitutionPattern = new SubstitutionPattern(string, string2, bl, bl2, string3);
                    this.dlSettings.getSubstitutionList().add(substitutionPattern);
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn(exception.getMessage(), exception);
                }
            }
        }
    }

    private void initClassificationTypes(Document document) {
        Element element;
        this.dlSettings.getClassificationTypeList().clear();
        NodeList nodeList = document.getElementsByTagName("classification_types");
        if (nodeList.getLength() > 0 && (element = (Element)nodeList.item(0)) != null) {
            NodeList nodeList2 = element.getElementsByTagName("type");
            int n = nodeList2.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList2.item(i);
                if (element2 == null) continue;
                try {
                    String string = element2.getAttribute("name");
                    int n2 = Integer.parseInt(element2.getAttribute("color"));
                    String string2 = element2.getAttribute("prefix");
                    String string3 = element2.getAttribute("id");
                    ClassificationType classificationType = null;
                    classificationType = !string3.equalsIgnoreCase("") ? this.dlSettings.getClassificationTypeByID(string3) : this.dlSettings.getClassificationTypeByName(string);
                    if (classificationType != null) {
                        classificationType.setTypeColor(new Color(n2));
                        classificationType.setTypePrefix(string2);
                        continue;
                    }
                    classificationType = new ClassificationType(string, new Color(n2), "", string2);
                    if (!"".equalsIgnoreCase(string3)) {
                        classificationType.setTypeID(string3);
                    }
                    this.dlSettings.addClassificationType(classificationType);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void initDefaultFontsAndColors(Document document) {
        Element element;
        NodeList nodeList = document.getElementsByTagName("default_fonts_and_colors");
        if (nodeList.getLength() > 0 && (element = (Element)nodeList.item(0)) != null) {
            NodeList nodeList2 = element.getElementsByTagName("fc_object");
            int n = nodeList2.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList2.item(i);
                if (element2 == null) continue;
                try {
                    String string = element2.getAttribute("classname");
                    DefaultFontAndColor defaultFontAndColor = this.getDefaultFCObject(string);
                    if (defaultFontAndColor == null) continue;
                    int n2 = Integer.parseInt(element2.getAttribute("background"));
                    int n3 = Integer.parseInt(element2.getAttribute("foreground"));
                    defaultFontAndColor.setBackgroundColor(new Color(n2));
                    defaultFontAndColor.setForegroundColor(new Color(n3));
                    Element element3 = this.getFirstElementByTagName("fonts", element2);
                    if (element3 == null) continue;
                    NodeList nodeList3 = element3.getElementsByTagName("font_object");
                    int n4 = nodeList3.getLength();
                    for (int j = 0; j < n4; ++j) {
                        Element element4 = (Element)nodeList3.item(j);
                        String string2 = element4.getAttribute("fo_type");
                        FontObject fontObject = defaultFontAndColor.getFontObject(string2);
                        if (fontObject == null) continue;
                        int n5 = Integer.parseInt(element4.getAttribute("font_color"));
                        String string3 = element4.getAttribute("font_name");
                        int n6 = Integer.parseInt(element4.getAttribute("font_size"));
                        int n7 = Integer.parseInt(element4.getAttribute("font_style"));
                        fontObject.setColor(new Color(n5));
                        fontObject.setFont(new Font(string3, n7, n6));
                    }
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn(exception.getMessage(), exception);
                }
            }
        }
    }

    private void initDefaultLineWidthsAndColors(Document document) {
        Element element;
        NodeList nodeList = document.getElementsByTagName("default_line_widths_and_colors");
        if (nodeList.getLength() > 0 && (element = (Element)nodeList.item(0)) != null) {
            NodeList nodeList2 = element.getElementsByTagName("lwc_object");
            int n = nodeList2.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList2.item(i);
                if (element2 == null) continue;
                try {
                    String string = element2.getAttribute("classname");
                    DefaultLineWidthAndColor defaultLineWidthAndColor = this.getDefaultLWCObject(string);
                    if (defaultLineWidthAndColor == null) continue;
                    int n2 = Integer.parseInt(element2.getAttribute("color"));
                    int n3 = Integer.parseInt(element2.getAttribute("width"));
                    defaultLineWidthAndColor.setColor(new Color(n2));
                    defaultLineWidthAndColor.setWidth(n3);
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn(exception.getMessage(), exception);
                }
            }
        }
    }

    private void initNamingStandardRule(Document document) {
        Element element = this.getFirstElementByTagName("naming_standard_rules", document.getDocumentElement());
        if (element != null) {
            boolean bl;
            boolean bl2;
            Object object;
            int n;
            Object object2;
            Element element2;
            Element element3;
            Element element4 = this.getFirstElementByTagName("logical", element);
            if (element4 != null) {
                try {
                    element3 = this.getFirstElementByTagName("separator", element4);
                    if (element3 != null) {
                        this.namingRule.setLogicalSep(element3.getAttribute("value"));
                        this.namingRule.setLogicalChar(element3.getAttribute("char"));
                    }
                    this.namingRule.getEntitiesList().clear();
                    element2 = this.getFirstElementByTagName("entity", element4);
                    if (element2 != null) {
                        object2 = element2.getElementsByTagName("value");
                        int n2 = object2.getLength();
                        for (n = 0; n < n2; ++n) {
                            Element element5 = (Element)object2.item(n);
                            object = element5.getAttribute("type");
                            boolean bl3 = Boolean.valueOf(element5.getAttribute("mandatory"));
                            this.namingRule.getEntitiesList().add(new WordRule((String)object, bl3));
                        }
                    }
                    this.namingRule.getAttributesList().clear();
                    object2 = this.getFirstElementByTagName("attribute", element4);
                    if (object2 != null) {
                        NodeList nodeList = object2.getElementsByTagName("value");
                        n = nodeList.getLength();
                        for (int i = 0; i < n; ++i) {
                            object = (Element)nodeList.item(i);
                            String string = object.getAttribute("type");
                            bl2 = Boolean.valueOf(object.getAttribute("mandatory"));
                            this.namingRule.getAttributesList().add(new WordRule(string, bl2));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((element3 = this.getFirstElementByTagName("relational", element)) != null) {
                try {
                    element2 = this.getFirstElementByTagName("separator", element3);
                    if (element2 != null) {
                        this.namingRule.setRelSep(element2.getAttribute("value"));
                        object2 = element2.getAttribute("abbreviated_only");
                        if (object2 != null && !"".equalsIgnoreCase((String)object2)) {
                            if ("true".equalsIgnoreCase((String)object2)) {
                                this.namingRule.setAbbreviatedOnly(true);
                            } else {
                                this.namingRule.setAbbreviatedOnly(false);
                            }
                        }
                    }
                    this.namingRule.getTablesList().clear();
                    object2 = this.getFirstElementByTagName("table", element3);
                    if (object2 != null) {
                        NodeList nodeList = object2.getElementsByTagName("value");
                        n = nodeList.getLength();
                        for (int i = 0; i < n; ++i) {
                            object = (Element)nodeList.item(i);
                            String string = object.getAttribute("type");
                            bl2 = Boolean.valueOf(object.getAttribute("mandatory"));
                            this.namingRule.getTablesList().add(new WordRule(string, bl2));
                        }
                    }
                    this.namingRule.getColumnsList().clear();
                    Element element6 = this.getFirstElementByTagName("column", element3);
                    if (element6 != null) {
                        NodeList nodeList = element6.getElementsByTagName("value");
                        int n3 = nodeList.getLength();
                        for (int i = 0; i < n3; ++i) {
                            Element element7 = (Element)nodeList.item(i);
                            String string = element7.getAttribute("type");
                            bl = Boolean.valueOf(element7.getAttribute("mandatory"));
                            this.namingRule.getColumnsList().add(new WordRule(string, bl));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((element2 = this.getFirstElementByTagName("domains", element)) != null) {
                try {
                    object2 = this.getFirstElementByTagName("separator", element2);
                    if (object2 != null) {
                        this.namingRule.setDomainsSep(object2.getAttribute("value"));
                    }
                    this.namingRule.getDomainsList().clear();
                    Element element8 = this.getFirstElementByTagName("domain", element2);
                    if (element8 != null) {
                        NodeList nodeList = element8.getElementsByTagName("value");
                        int n4 = nodeList.getLength();
                        for (int i = 0; i < n4; ++i) {
                            Element element9 = (Element)nodeList.item(i);
                            String string = element9.getAttribute("type");
                            bl = Boolean.valueOf(element9.getAttribute("mandatory"));
                            this.namingRule.getDomainsList().add(new WordRule(string, bl));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object2 = this.getFirstElementByTagName("constraints", element)) != null) {
                Element element10 = this.getFirstElementByTagName("pk", (Element)object2);
                if (element10 != null) {
                    this.namingRule.setPkConstr(element10.getAttribute("value"));
                }
                if ((element10 = this.getFirstElementByTagName("fk", (Element)object2)) != null) {
                    this.namingRule.setFkConstr(element10.getAttribute("value"));
                }
                if ((element10 = this.getFirstElementByTagName("ck", (Element)object2)) != null) {
                    this.namingRule.setCkConstr(element10.getAttribute("value"));
                }
                if ((element10 = this.getFirstElementByTagName("un", (Element)object2)) != null) {
                    this.namingRule.setUnConstr(element10.getAttribute("value"));
                }
                if ((element10 = this.getFirstElementByTagName("idx", (Element)object2)) != null) {
                    this.namingRule.setIdxConstr(element10.getAttribute("value"));
                }
                if ((element10 = this.getFirstElementByTagName("colck", (Element)object2)) != null) {
                    this.namingRule.setColckConstr(element10.getAttribute("value"));
                }
                if ((element10 = this.getFirstElementByTagName("column_foreign_key", (Element)object2)) != null) {
                    this.namingRule.setFkColumn(element10.getAttribute("value"));
                }
                if ((element10 = this.getFirstElementByTagName("ui", (Element)object2)) != null) {
                    this.namingRule.setUIConstr(element10.getAttribute("value"));
                }
                if ((element10 = this.getFirstElementByTagName("relation_attribute", (Element)object2)) != null) {
                    this.namingRule.setRelationAttribute(element10.getAttribute("value"));
                }
            }
            Element element11 = this.getFirstElementByTagName("glossaries", element);
            this.namingRule.getGlossariesList().clear();
            if (element11 != null) {
                NodeList nodeList = element11.getElementsByTagName("glossary_file");
                int n5 = nodeList.getLength();
                for (int i = 0; i < n5; ++i) {
                    Element element12 = (Element)nodeList.item(i);
                    String string = element12.getAttribute("value");
                    this.namingRule.getGlossariesList().add(new GlossaryFile(string));
                }
            }
        }
        this.dlSettings.setNamingStandardRule(this.namingRule);
    }

    private void initCompareMappings(Document document) {
        try {
            this.dlSettings.getCompareMapping().clearCompareMappingsList();
            NodeList nodeList = document.getElementsByTagName("mapping");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                if (element == null) continue;
                String string = element.getAttribute("sourceparent");
                String string2 = element.getAttribute("targetparent");
                String string3 = element.getAttribute("sourceobject");
                String string4 = element.getAttribute("targetobject");
                CompareMappingObject compareMappingObject = new CompareMappingObject(string, string3, string2, string4);
                this.dlSettings.getCompareMapping().addCompareMappingObject(compareMappingObject);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to initialize Compare mappings: ", exception);
        }
    }

    public CompareMapping getCompareMappingList() {
        if (this.compareMapping == null) {
            this.compareMapping = new CompareMapping();
        }
        return this.compareMapping;
    }

    private void initEngineeringParams(Document document) {
        Design design = this.appView.getCurrentDesign();
        Element element = this.getFirstElementByTagName("engineering_params", document.getDocumentElement());
        if (element != null) {
            Element element2 = this.getFirstElementByTagName("delete_without_origin", element);
            if (element2 != null) {
                design.setDeleteWithoutOrigin("true".equalsIgnoreCase(element2.getAttribute("value")));
            }
            if ((element2 = this.getFirstElementByTagName("engineer_coordinates", element)) != null) {
                design.setEngineerCoordinates("true".equalsIgnoreCase(element2.getAttribute("value")));
            }
            if ((element2 = this.getFirstElementByTagName("engineer_generated", element)) != null) {
                design.setEngineerGenerated("true".equalsIgnoreCase(element2.getAttribute("value")));
            }
            if ((element2 = this.getFirstElementByTagName("show_engineering_intree", element)) != null) {
                design.setShowEngineeringInTree("true".equalsIgnoreCase(element2.getAttribute("value")));
            }
            if ((element2 = this.getFirstElementByTagName("apply_naming_std", element)) != null && !"".equals(element2.getAttribute("value"))) {
                design.setApplyNameStandardization("true".equalsIgnoreCase(element2.getAttribute("value")));
            }
            if ((element2 = this.getFirstElementByTagName("use_pref_abbreviation", element)) != null && !"".equals(element2.getAttribute("value"))) {
                design.setUsePreferredAbbreviation("true".equalsIgnoreCase(element2.getAttribute("value")));
            }
            if ((element2 = this.getFirstElementByTagName("upload_directory", element)) != null) {
                design.setUnloadDirectory(StringUtilities.decodeAttributeValue(element2.getAttribute("value")));
            }
            if ((element2 = this.getFirstElementByTagName("date_format", element)) != null) {
                design.setEngDateFormat(StringUtilities.decodeAttributeValue(element2.getAttribute("value")));
            }
            if ((element2 = this.getFirstElementByTagName("timestamp_format", element)) != null) {
                design.setEngTimestampFormat(StringUtilities.decodeAttributeValue(element2.getAttribute("value")));
            }
            if ((element2 = this.getFirstElementByTagName("timestamp_tz_format", element)) != null) {
                design.setEngTimestampWTZFormat(StringUtilities.decodeAttributeValue(element2.getAttribute("value")));
            }
        }
    }

    private void initEngineeringCompare(Document document) {
        Object object;
        Design design = this.appView.getCurrentDesign();
        NodeList nodeList = document.getElementsByTagName("eng_compare");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = StringUtilities.decodeAttributeValue(element.getAttribute("show_sel_prop_only"));
            object = StringUtilities.decodeAttributeValue(element.getAttribute("not_apply_for_new_objects"));
            String string2 = StringUtilities.decodeAttributeValue(element.getAttribute("exclude_from_tree"));
            design.setShowSelPropsOnly(Boolean.valueOf(string));
            design.setNotForNewObjects(Boolean.valueOf((String)object));
            design.setExcludeFromTree(Boolean.valueOf(string2));
        }
        NodeList nodeList2 = document.getDocumentElement().getElementsByTagName("property");
        int n = nodeList2.getLength();
        for (int i = 0; i < n; ++i) {
            object = (Element)nodeList2.item(i);
            if (object.getParentNode().getNodeName().equalsIgnoreCase("entity_table")) {
                this.addToList((Element)object, design.getEntTablePropertyList());
                continue;
            }
            if (object.getParentNode().getNodeName().equalsIgnoreCase("attribute_column")) {
                this.addToList((Element)object, design.getAttrColPropertyList());
                continue;
            }
            if (object.getParentNode().getNodeName().equalsIgnoreCase("key_index")) {
                this.addToList((Element)object, design.getKeyIdxPropertyList());
                continue;
            }
            if (object.getParentNode().getNodeName().equalsIgnoreCase("relation_fk")) {
                this.addToList((Element)object, design.getRelFKPropertyList());
                continue;
            }
            if (!object.getParentNode().getNodeName().equalsIgnoreCase("entityview_view")) continue;
            this.addToList((Element)object, design.getViewPropertyList());
        }
    }

    private void initNamingOptions(Document document) {
        Object object;
        ArrayList<DesignPart> arrayList = new ArrayList<DesignPart>();
        Iterator iterator = this.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            object = (DesignPart)iterator.next();
            arrayList.add((DesignPart)object);
        }
        arrayList.add(this.getLogicalDesign());
        object = document.getElementsByTagName("model_options");
        for (int i = 0; i < object.getLength(); ++i) {
            Element element = (Element)object.item(i);
            String string = element.getAttribute("objectid");
            for (DesignPart designPart : arrayList) {
                if (!designPart.getObjectID().equals(string)) continue;
                NodeList nodeList = element.getElementsByTagName("naming_option");
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Element element2 = (Element)nodeList.item(j);
                    String string2 = element2.getAttribute("class_name");
                    int n = Integer.parseInt(element2.getAttribute("max_name_length"));
                    int n2 = Integer.parseInt(element2.getAttribute("case_type"));
                    String string3 = element2.getAttribute("valid_characters");
                    boolean bl = Boolean.valueOf(element2.getAttribute("all_valid"));
                    NamingOptionsHolder namingOptionsHolder = designPart.getNamingOptionsHolderFor(string2);
                    namingOptionsHolder.setCaseType(n2);
                    namingOptionsHolder.setIsValid(bl);
                    namingOptionsHolder.setMaxNameLength(n);
                    namingOptionsHolder.setValidChars(string3);
                }
            }
        }
    }

    private void initMergeConflicts(Document document) {
        NodeList nodeList = document.getElementsByTagName("merge_conflict");
        List<MergeConflict> list = this.getDLSettings().getMergeConflicts();
        list.clear();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("path");
            String string2 = element.getAttribute("local_version_extension");
            String string3 = element.getAttribute("remote_version_extension");
            String string4 = element.getAttribute("text_status");
            String string5 = element.getAttribute("property_status");
            list.add(new MergeConflict(new File(this.getDesignPath() + string), string2, null, string3, string4, string5));
        }
    }

    private void initDeletedFiles(Document document) {
        NodeList nodeList = document.getElementsByTagName("deleted_file");
        List<DeletedFile> list = this.getDLSettings().getDeletedFiles();
        list.clear();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("path");
            String string2 = element.getAttribute("url");
            Long l = Long.valueOf(element.getAttribute("revision"));
            list.add(new DeletedFile(new File(this.getDesignPath() + string), string2, l));
        }
    }

    private void addToList(Element element, List list) {
        String string = StringUtilities.decodeAttributeValue(element.getAttribute("name"));
        String string2 = StringUtilities.decodeAttributeValue(element.getAttribute("selected"));
        for (EngPropertyHolder engPropertyHolder : list) {
            if (!string.equalsIgnoreCase(engPropertyHolder.getName())) continue;
            engPropertyHolder.setSelected(Boolean.valueOf(string2));
            break;
        }
    }

    private void appendEngineeringCompare(StringBuffer stringBuffer) {
        Design design = this.appView.getCurrentDesign();
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("<").append("eng_compare");
        stringBuffer.append(' ').append("show_sel_prop_only").append("=\"").append(design.getShowSelPropsOnly()).append("\"");
        stringBuffer.append(' ').append("not_apply_for_new_objects").append("=\"").append(design.getNotForNewObjects()).append("\"");
        stringBuffer.append(' ').append("exclude_from_tree").append("=\"").append(design.getExcludeFromTree()).append("\"").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("entity_table").append(">");
        for (EngPropertyHolder engPropertyHolder : design.getEntTablePropertyList()) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append("name").append("=\"").append(StringUtilities.encodeAttributeValue(engPropertyHolder.getName())).append("\"").append(' ');
            stringBuffer.append("selected").append("=\"").append(engPropertyHolder.isSelected()).append("\"").append("/>");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("entity_table").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("attribute_column").append(">");
        for (EngPropertyHolder engPropertyHolder : design.getAttrColPropertyList()) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append("name").append("=\"").append(StringUtilities.encodeAttributeValue(engPropertyHolder.getName())).append("\"").append(' ');
            stringBuffer.append("selected").append("=\"").append(engPropertyHolder.isSelected()).append("\"").append("/>");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("attribute_column").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("key_index").append(">");
        for (EngPropertyHolder engPropertyHolder : design.getKeyIdxPropertyList()) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append("name").append("=\"").append(StringUtilities.encodeAttributeValue(engPropertyHolder.getName())).append("\"").append(' ');
            stringBuffer.append("selected").append("=\"").append(engPropertyHolder.isSelected()).append("\"").append("/>");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("key_index").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("relation_fk").append(">");
        for (EngPropertyHolder engPropertyHolder : design.getRelFKPropertyList()) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append("name").append("=\"").append(StringUtilities.encodeAttributeValue(engPropertyHolder.getName())).append("\"").append(' ');
            stringBuffer.append("selected").append("=\"").append(engPropertyHolder.isSelected()).append("\"").append("/>");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("relation_fk").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("entityview_view").append(">");
        for (EngPropertyHolder engPropertyHolder : design.getViewPropertyList()) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append("name").append("=\"").append(StringUtilities.encodeAttributeValue(engPropertyHolder.getName())).append("\"").append(' ');
            stringBuffer.append("selected").append("=\"").append(engPropertyHolder.isSelected()).append("\"").append("/>");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("entityview_view").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("eng_compare").append(">");
    }

    private void appendNamingOptions(StringBuffer stringBuffer) {
        NamingOptionsHolder namingOptionsHolder;
        Iterator iterator;
        DesignPart designPart;
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("<").append("naming_options").append(">");
        Iterator iterator2 = this.getRelationalDesigns().iterator();
        while (iterator2.hasNext()) {
            designPart = (RelationalDesign)iterator2.next();
            iterator = ((RelationalDesign)designPart).getNamingOptionsHolderList().iterator();
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("<").append("model_options").append(" ").append("objectid").append("=\"").append(designPart.getObjectID()).append("\"").append(">");
            while (iterator.hasNext()) {
                namingOptionsHolder = (NamingOptionsHolder)iterator.next();
                stringBuffer.append('\n');
                stringBuffer.append('\t').append('\t').append('\t').append("<").append("naming_option").append(" ");
                stringBuffer.append("class_name").append("=\"").append(namingOptionsHolder.getClassName().getName()).append("\"").append(" ");
                stringBuffer.append("max_name_length").append("=\"").append(namingOptionsHolder.getMaxNameLength()).append("\"").append(" ");
                stringBuffer.append("case_type").append("=\"").append(namingOptionsHolder.getCaseType()).append("\"").append(" ");
                stringBuffer.append("valid_characters").append("=\"").append(StringUtilities.encodeAttributeValue(namingOptionsHolder.getValidChars())).append("\"").append(" ");
                stringBuffer.append("all_valid").append("=\"").append(namingOptionsHolder.getIsValid()).append("\"").append(" />");
            }
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("</").append("model_options").append(">");
        }
        designPart = this.getLogicalDesign();
        iterator = ((LogicalDesign)designPart).getNamingOptionsHolderList().iterator();
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("model_options").append(" ").append("objectid").append("=\"").append(designPart.getObjectID()).append("\"").append(">");
        while (iterator.hasNext()) {
            namingOptionsHolder = (NamingOptionsHolder)iterator.next();
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append('\t').append("<").append("naming_option").append(" ");
            stringBuffer.append("class_name").append("=\"").append(namingOptionsHolder.getClassName().getName()).append("\"").append(" ");
            stringBuffer.append("max_name_length").append("=\"").append(namingOptionsHolder.getMaxNameLength()).append("\"").append(" ");
            stringBuffer.append("case_type").append("=\"").append(namingOptionsHolder.getCaseType()).append("\"").append(" ");
            stringBuffer.append("valid_characters").append("=\"").append(namingOptionsHolder.getValidChars()).append("\"").append(" ");
            stringBuffer.append("all_valid").append("=\"").append(namingOptionsHolder.getIsValid()).append("\"").append(" />");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("model_options").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("naming_options").append(">");
    }

    private void appendMergeConflicts(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("<").append("merge_conflicts").append(">");
        for (MergeConflict mergeConflict : this.getDLSettings().getMergeConflicts()) {
            String string = mergeConflict.getLocalFile().getPath().replace(this.getDesignPath(), "");
            String string2 = mergeConflict.getBaseLabel();
            String string3 = mergeConflict.getRepositoryLabel();
            String string4 = mergeConflict.getStorableObjectStatus().getTextStatus();
            String string5 = mergeConflict.getStorableObjectStatus().getPropertyStatus();
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("<").append("merge_conflict").append(" ");
            stringBuffer.append("path").append("=\"").append(string).append("\" ");
            stringBuffer.append("local_version_extension").append("=\"").append(string2).append("\" ");
            stringBuffer.append("remote_version_extension").append("=\"").append(string3).append("\" ");
            stringBuffer.append("text_status").append("=\"").append(string4).append("\" ");
            stringBuffer.append("property_status").append("=\"").append(string5).append("\"");
            stringBuffer.append(" />");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("merge_conflicts").append(">");
    }

    private void appendDeletedFiles(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("<").append("deleted_files").append(">");
        for (DeletedFile deletedFile : this.getDLSettings().getDeletedFiles()) {
            String string = deletedFile.getLocalFile().getPath().replace(this.getDesignPath(), "");
            String string2 = deletedFile.getUrl();
            String string3 = deletedFile.getRevision().toString();
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("<").append("deleted_file").append(" ");
            stringBuffer.append("path").append("=\"").append(string).append("\" ");
            stringBuffer.append("url").append("=\"").append(string2).append("\" ");
            stringBuffer.append("revision").append("=\"").append(string3).append("\" ");
            stringBuffer.append(" />");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("deleted_files").append(">");
    }

    public DefaultLineWidthAndColor getDefaultLWCObject(String string) {
        for (DefaultLineWidthAndColor defaultLineWidthAndColor : this.dlSettings.defaultLWCObjects) {
            if (!defaultLineWidthAndColor.getClassName().equalsIgnoreCase(string)) continue;
            return defaultLineWidthAndColor;
        }
        return null;
    }

    public void saveDLSettingsFile(String string) {
        try {
            long l;
            File file = new File(string, "dl_settings.xml");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(this.getDesignLevelSettings());
            outputStreamWriter.close();
            if (Extension.isSVNExtensionLoaded() && file.exists() && this.isVersioned() && (l = SVNClientHelper.getInstance().getRevision(file)) == -1L) {
                SVNClientHelper.getInstance().doAdd(file);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to Save Design Level Settings: ", exception);
        }
    }

    private void addDesignLevelSettings(StringBuffer stringBuffer) {
        this.getNamingStandardRule();
        this.appendElement("logical_type_for_domain_presentation", Boolean.toString(this.dlSettings.isLogicalTypeForDomainPresentation()), stringBuffer);
        this.appendElement("automatic_pk_generation", Boolean.toString(this.dlSettings.isAutomaticPKGeneration()), stringBuffer);
        this.appendElement("automatic_uk_generation", Boolean.toString(this.dlSettings.isAutomaticUKGeneration()), stringBuffer);
        this.appendElement("automatic_fk_generation", Boolean.toString(this.dlSettings.isAutomaticFKGeneration()), stringBuffer);
        this.appendSubstitutionPatterns(stringBuffer);
        this.appendClassificationTypes(stringBuffer);
        this.appendDefaultFontsAndColors(stringBuffer);
        this.appendDefaultLineWidthsAndColors(stringBuffer);
        this.appendNamingStandardRules(stringBuffer);
        this.appendCompareMappings(stringBuffer);
        this.appendEngineeringParams(stringBuffer);
        this.appendEngineeringCompare(stringBuffer);
        this.appendNamingOptions(stringBuffer);
        this.appendMergeConflicts(stringBuffer);
        this.appendDeletedFiles(stringBuffer);
    }

    private void appendSubstitutionPatterns(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('<').append("substitution_patterns").append('>');
        for (SubstitutionPattern substitutionPattern : this.dlSettings.getSubstitutionList()) {
            String string = substitutionPattern.getSourceString().trim();
            if (string.length() == 0) continue;
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t');
            stringBuffer.append("<substitutions").append(' ');
            stringBuffer.append("oldstring=\"").append(substitutionPattern.getSourceString()).append("\" ");
            stringBuffer.append("newstring=\"").append(String.valueOf(substitutionPattern.getReplacementString())).append("\" ");
            stringBuffer.append("selected=\"").append(String.valueOf(substitutionPattern.isSelected())).append("\" ");
            stringBuffer.append("casesensitive=\"").append(String.valueOf(substitutionPattern.isCaseSensitive())).append("\" ");
            stringBuffer.append("comments=\"").append(String.valueOf(substitutionPattern.getComments())).append("\" ");
            stringBuffer.append("/>");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("substitution_patterns").append(">");
    }

    private void appendClassificationTypes(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('<').append("classification_types").append('>');
        for (ClassificationType classificationType : this.dlSettings.getClassificationTypeList()) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("<").append("type").append(' ');
            stringBuffer.append("name=\"").append(classificationType.getTypeName()).append("\" ");
            stringBuffer.append("color=\"").append(classificationType.getTypeColor().getRGB()).append("\" ");
            stringBuffer.append("prefix=\"").append(classificationType.getTypePrefix()).append("\" ");
            stringBuffer.append("id=\"").append(classificationType.getTypeID()).append("\" ");
            stringBuffer.append("/>");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("classification_types").append(">");
    }

    private void appendDefaultFontsAndColors(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('<').append("default_fonts_and_colors").append('>');
        for (DefaultFontAndColor defaultFontAndColor : this.dlSettings.defaultFCObjects) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("<").append("fc_object").append(' ');
            stringBuffer.append("classname=\"").append(defaultFontAndColor.getClassName()).append("\" ");
            stringBuffer.append("background=\"").append(defaultFontAndColor.getBackgroundColor().getRGB()).append("\" ");
            stringBuffer.append("foreground=\"").append(defaultFontAndColor.getForegroundColor().getRGB()).append("\"");
            stringBuffer.append(">");
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append('<').append("fonts").append('>');
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                stringBuffer.append('\n');
                stringBuffer.append('\t').append('\t').append('\t').append("<").append("font_object").append(' ');
                stringBuffer.append("fo_type=\"").append(fontObject.getType()).append("\" ");
                stringBuffer.append("font_color=\"").append(fontObject.getColor().getRGB()).append("\" ");
                stringBuffer.append("font_name=\"").append(fontObject.getFont().getName()).append("\" ");
                stringBuffer.append("font_size=\"").append(fontObject.getFont().getSize()).append("\" ");
                stringBuffer.append("font_style=\"").append(fontObject.getFont().getStyle()).append("\"");
                stringBuffer.append("/>");
            }
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("</").append("fonts").append(">");
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("</").append("fc_object").append(">");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("default_fonts_and_colors").append(">");
    }

    private void appendDefaultLineWidthsAndColors(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('<').append("default_line_widths_and_colors").append('>');
        for (DefaultLineWidthAndColor defaultLineWidthAndColor : this.dlSettings.defaultLWCObjects) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("<").append("lwc_object").append(' ');
            stringBuffer.append("classname=\"").append(defaultLineWidthAndColor.getClassName()).append("\" ");
            stringBuffer.append("color=\"").append(defaultLineWidthAndColor.getColor().getRGB()).append("\" ");
            stringBuffer.append("width=\"").append(defaultLineWidthAndColor.getWidth()).append("\"");
            stringBuffer.append(">");
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append("</").append("lwc_object").append(">");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("default_line_widths_and_colors").append(">");
    }

    private void appendNamingStandardRules(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("<").append("naming_standard_rules").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("logical").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("separator").append(' ');
        stringBuffer.append("value= \"").append(this.namingRule.getLogicalSep()).append("\"").append(' ');
        stringBuffer.append("char=\"").append(this.namingRule.getLogicalChar()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("entity").append(">");
        this.getListElements(this.namingRule.getEntitiesList(), stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("</").append("entity").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("attribute").append(">");
        this.getListElements(this.namingRule.getAttributesList(), stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("</").append("attribute").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("logical").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("relational").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("separator").append(' ');
        stringBuffer.append("value= \"").append(this.namingRule.getRelSep()).append("\"").append(' ');
        stringBuffer.append("abbreviated_only=\"").append(this.namingRule.isAbbreviatedOnly()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("table").append(">");
        this.getListElements(this.namingRule.getTablesList(), stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("</").append("table").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("column").append(">");
        this.getListElements(this.namingRule.getColumnsList(), stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("</").append("column").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("relational").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("domains").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("separator").append(' ');
        stringBuffer.append("value= \"").append(this.namingRule.getDomainsSep()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("domain").append(">");
        this.getListElements(this.namingRule.getDomainsList(), stringBuffer);
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("</").append("domain").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("domains").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("constraints").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("pk value=\"").append(this.namingRule.getPkConstr()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("fk value=\"").append(this.namingRule.getFkConstr()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("ck value=\"").append(this.namingRule.getCkConstr()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("un value=\"").append(this.namingRule.getUnConstr()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("idx value=\"").append(this.namingRule.getIdxConstr()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("colck value=\"").append(this.namingRule.getColckConstr()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("column_foreign_key value=\"").append(this.namingRule.getFkColumn()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("ui value=\"").append(this.namingRule.getUIConstr()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append('\t').append("<").append("relation_attribute value=\"").append(this.namingRule.getRelationAttribute()).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("constraints").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("glossaries").append(">");
        for (GlossaryFile glossaryFile : this.namingRule.getGlossariesList()) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append('\t').append("<").append("glossary_file").append(' ');
            stringBuffer.append("value=\"").append(glossaryFile.getFilePath()).append("\"");
            stringBuffer.append("/>");
        }
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("</").append("glossaries").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("naming_standard_rules").append(">");
    }

    public void appendCompareMappings(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append('<').append("comparemapping").append('>');
        Iterator<String> iterator = this.dlSettings.getCompareMapping().getCompareMap().keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append('\n');
            CompareMappingObject compareMappingObject = this.dlSettings.getCompareMapping().getCompareMap().get(iterator.next());
            stringBuffer.append('\t').append('<').append("mapping").append(' ');
            stringBuffer.append("sourceparent").append(' ').append("=\"").append(compareMappingObject.getSourceParentName()).append("\"").append(' ');
            stringBuffer.append("sourceobject").append(' ').append("=\"").append(compareMappingObject.getSourceObjectName()).append("\"").append(' ');
            stringBuffer.append("targetparent").append(' ').append("=\"").append(compareMappingObject.getTargetParentName()).append("\"").append(' ');
            stringBuffer.append("targetobject").append(' ').append("=\"").append(compareMappingObject.getTargetObjectName()).append("\"").append(' ');
            stringBuffer.append("selected").append(' ').append("=\"").append(compareMappingObject.isSelected()).append("\" />");
        }
        stringBuffer.append('\n');
        stringBuffer.append("</").append("comparemapping").append('>');
    }

    private void appendEngineeringParams(StringBuffer stringBuffer) {
        Design design = this.appView.getCurrentDesign();
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("<").append("engineering_params").append(">");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("delete_without_origin").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.isDeleteWithoutOrigin()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("engineer_coordinates").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.isEngineerCoordinates()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("engineer_generated").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.isEngineerGenerated()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("show_engineering_intree").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.isShowEngineeringInTree()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("apply_naming_std").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.isApplyNameStandardization()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("use_pref_abbreviation").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.isUsePreferredAbbreviation()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("upload_directory").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.getUnloadDirectory()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("date_format").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.getEngDateFormat()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("timestamp_format").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.getEngTimestampFormat()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('\t').append("<").append("timestamp_tz_format").append(' ');
        stringBuffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(design.getEngTimestampWTZFormat()))).append("\"").append("/>");
        stringBuffer.append('\n');
        stringBuffer.append('\t').append("</").append("engineering_params").append(">");
    }

    private void appendElement(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append('\n');
        stringBuffer.append('\t').append('<').append(string).append(' ').append("value").append("=\"").append(string2).append("\" />");
    }

    private String getValue(Document document, String string) {
        Element element;
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (element = (Element)nodeList.item(0)) != null) {
            return element.getAttribute("value");
        }
        return "";
    }

    public Element getFirstElementByTagName(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            return element2;
        }
        return null;
    }

    public DefaultFontAndColor getDefaultFCObject(String string) {
        for (DefaultFontAndColor defaultFontAndColor : this.dlSettings.defaultFCObjects) {
            if (!defaultFontAndColor.getClassName().equalsIgnoreCase(string)) continue;
            return defaultFontAndColor;
        }
        return null;
    }

    private boolean checkFileVersion() {
        if (Settings.fileVersion != null && Settings.fileVersion != "") {
            Float f = new Float(Settings.fileVersion);
            if (this.getLoadedVersion() >= f.floatValue()) {
                return true;
            }
        }
        return false;
    }

    public void getListElements(List list, StringBuffer stringBuffer) {
        for (WordRule wordRule : list) {
            stringBuffer.append('\n');
            stringBuffer.append('\t').append('\t').append('\t').append('\t').append("<").append("value").append(' ');
            stringBuffer.append("type=\"").append(wordRule.getWordType()).append("\"").append(' ');
            stringBuffer.append("mandatory=\"").append(wordRule.isMandatory()).append("\"");
            stringBuffer.append("/>");
        }
    }

    public NamingStandardRule getNamingStandardRule() {
        this.namingRule = this.getDLSettings().getNamingStandardRule();
        return this.namingRule;
    }

    public List getProxiesToDeleteList() {
        return this.proxiesToDelete;
    }

    public void createChangeRequestsMap() {
        this.changeRequestsMap.clear();
        Iterator iterator = this.getChangeRequestSet().iterator();
        while (iterator.hasNext()) {
            ChangeRequest changeRequest = (ChangeRequest)iterator.next();
            this.changeRequestsMap.put(changeRequest.getObjectID(), changeRequest.getSegmentedStorageName());
        }
    }

    public void synchronizeChangeRequestsMap() {
        this.removeDeletedChangeRequests();
        this.createChangeRequestsMap();
    }

    public void removeDeletedChangeRequests() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : this.changeRequestsMap.keySet()) {
            if (this.getChangeRequestSet().containsId(object)) continue;
            arrayList.add(this.changeRequestsMap.get(object));
        }
        if (arrayList.size() > 0) {
            if (Extension.isSVNExtensionLoaded()) {
                if (this.isVersioned()) {
                    ArrayList<File> arrayList2 = new ArrayList<File>();
                    for (String string : arrayList) {
                        File file = null;
                        try {
                            file = new File(string);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (file == null) continue;
                        arrayList2.add(file);
                    }
                    if (arrayList2.size() > 0) {
                        SVNClientHelper.getInstance().doRemove(arrayList2.toArray(new File[0]));
                    }
                } else {
                    this.getAppView().getXMLTransformationManager().deleteFiles(arrayList);
                }
            } else {
                this.getAppView().getXMLTransformationManager().deleteFiles(arrayList);
            }
        }
    }

    public ChangeRequest createChangeRequest() {
        return this.getChangeRequestSet().createChangeRequest(null);
    }

    public void doAfterExternalLoad() {
        this.sortDomains();
        this.createLocalDP_Map();
        this.createChangeRequestsMap();
        this.setDirty(false);
        this.setModelListChanged(false);
        this.setChangeRequestListChanged(false);
        this.setLoadFromDB(false);
        this.setNewDesign(false);
    }

    public List getDefaultDomainsList() {
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        Iterator iterator = this.getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            if (!"defaultdomains".equalsIgnoreCase(domain.getFileName())) continue;
            arrayList.add(domain);
        }
        return arrayList;
    }

    public List getDL_DomainsList() {
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        Iterator iterator = this.getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            if ("defaultdomains".equalsIgnoreCase(domain.getFileName())) continue;
            arrayList.add(domain);
        }
        return arrayList;
    }

    public Domain createDomain() {
        return this.getDomainSet().createDomain();
    }

    public Domain getDomainByID(String string) {
        return (Domain)this.getDesignObject(string);
    }

    public void sortDomains() {
        this.getDomainSet().sort();
    }

    public RDBMSSite createRDBMSSite() {
        return this.getRDBMSSiteSet().createSite("", this.design);
    }

    public RDBMSSite getRDBMSSiteByID(String string) {
        return this.getRDBMSSiteSet().getByObjectID(string);
    }

    public List getDefaultRDBMSSites() {
        ArrayList<RDBMSSite> arrayList = new ArrayList<RDBMSSite>();
        Iterator iterator = this.getRDBMSSiteSet().iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            if (!rDBMSSite.getIsDefault()) continue;
            arrayList.add(rDBMSSite);
        }
        return arrayList;
    }

    public List getDL_RDBMSSites() {
        ArrayList<RDBMSSite> arrayList = new ArrayList<RDBMSSite>();
        Iterator iterator = this.getRDBMSSiteSet().iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            if (!rDBMSSite.isDesignLevel()) continue;
            arrayList.add(rDBMSSite);
        }
        return arrayList;
    }

    public void clearMappings() {
        this.getExtendedMap().clearMappings();
    }

    public void setSelectedSubView(DesignPartView designPartView) {
        this.selectedSubView = designPartView;
    }

    public DesignPartView getSelectedSubView() {
        return this.selectedSubView;
    }

    public List getAllDPVs() {
        RepositoryObject repositoryObject2;
        Iterator iterator;
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        ArrayList<ID_ObjectPropertyTranslator> arrayList2 = new ArrayList<ID_ObjectPropertyTranslator>();
        arrayList.add(this.getDataTypesDesign().getMainView());
        Iterator iterator2 = this.getDataTypesDesign().getDesignSubviews().iterator();
        while (iterator2.hasNext()) {
            DesignPartViewPlaceHolder repositoryObject22 = (DesignPartViewPlaceHolder)iterator2.next();
            arrayList.add(repositoryObject22.getDesignPartView());
        }
        arrayList.add(this.getLogicalDesign().getMainView());
        iterator2 = this.getLogicalDesign().getDesignSubviews().iterator();
        while (iterator2.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator2.next();
            arrayList.add(designPartViewPlaceHolder.getDesignPartView());
        }
        iterator2 = this.getRelationalDesigns().iterator();
        while (iterator2.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator2.next();
            arrayList.add(relationalDesign.getMainView());
            iterator = relationalDesign.getDesignSubviews().iterator();
            while (iterator.hasNext()) {
                repositoryObject2 = (DesignPartViewPlaceHolder)iterator.next();
                arrayList.add(repositoryObject2.getDesignPartView());
            }
        }
        iterator2 = this.getProcessModel().getDataFlowDesigns().iterator();
        while (iterator2.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator2.next();
            arrayList.add(dataFlowDesign.getMainView());
        }
        iterator2 = this.getProcessModel().getTransformationPackageSet().iterator();
        while (iterator2.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)iterator2.next();
            iterator = transformationPackage.getTransformationTaskSet().iterator();
            while (iterator.hasNext()) {
                repositoryObject2 = (TransformationTask)iterator.next();
                arrayList.add(((TransformationTask)repositoryObject2).getMainView());
            }
        }
        iterator2 = this.getMultidimensionalDesigns().iterator();
        while (iterator2.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator2.next();
            arrayList.add(multidimensionalDesign.getMainView());
        }
        arrayList2.addAll(arrayList);
        for (DesignPartView designPartView : arrayList) {
            if (!designPartView.isMasterDPV()) continue;
            for (RepositoryObject repositoryObject2 : designPartView.getSubordinateViews()) {
                arrayList2.add((ID_ObjectPropertyTranslator)((Object)repositoryObject2));
            }
        }
        return arrayList2;
    }

    public class DLSettings
    extends Settings {
        private List<MergeConflict> mergeConflicts;
        private List<DeletedFile> deletedFiles;

        public DLSettings(ApplicationView applicationView) {
            super(applicationView);
            this.mergeConflicts = new ArrayList<MergeConflict>();
            this.deletedFiles = new ArrayList<DeletedFile>();
        }

        public List<MergeConflict> getMergeConflicts() {
            return this.mergeConflicts;
        }

        public List<DeletedFile> getDeletedFiles() {
            return this.deletedFiles;
        }

        public String toString() {
            return Messages.getString("Design.DesignLevelSettings");
        }
    }
}

