/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public abstract class ContainerWithKeyObject
extends ContainerObject {
    private KeyObject primaryKey = null;
    private KeyObjectSet keys;
    private String pkName = null;
    private String typeID = "";

    public ContainerWithKeyObject(DesignPart designPart) {
        super(designPart);
    }

    public abstract KeyObject createKeyObject(String var1);

    public KeyObject createKeyObject() {
        return this.createKeyObject(null);
    }

    public void add(KeyObject keyObject) {
        boolean bl = keyObject.isPK();
        keyObject.setContainerObject(this);
        this.getKeySet().add(keyObject);
        keyObject.setDesign(this.getDesign());
        this.assignLocalID(keyObject);
        if (!this.isBackup()) {
            this.getDesign().addDesignObject(keyObject);
        }
        if (!this.getDesign().isLoading()) {
            this.setDirty(true);
        }
        this.sharedEvent.setElement(keyObject);
        this.sharedEvent.setType(5);
        this.fireChange(this.sharedEvent);
        if (bl) {
            keyObject.setPK(bl);
        }
    }

    @Override
    public void remove() {
        StructuredType structuredType = this.getBasedOnStructuredType();
        if (structuredType != null) {
            structuredType.removeObjectListener(this);
        }
        this.removeAllKeys();
        super.remove();
    }

    public void removeAllKeys() {
        KeyObject[] keyObjectArray = this.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            this.remove(keyObjectArray[i]);
        }
    }

    public void remove(KeyObject keyObject) {
        this.getKeySet().remove(keyObject);
        this.getDesign().removeDesignObject(keyObject);
        if (keyObject == this.primaryKey) {
            this.primaryKey = null;
        }
        keyObject.setContainerObject(null);
        keyObject.remove();
        this.sharedEvent.setElement(keyObject);
        this.sharedEvent.setType(4);
        this.fireChange(this.sharedEvent);
    }

    public KeyObject[] getKeysWith(ContainedObject[] containedObjectArray) {
        return this.getKeysWith(Arrays.asList(containedObjectArray));
    }

    public KeyObject[] getKeysWith(Collection collection) {
        HashSet<KeyObject> hashSet = new HashSet<KeyObject>();
        KeyObjectSet keyObjectSet = this.getKeySet();
        Iterator iterator = keyObjectSet.iterator();
        int n = collection.size();
        if (n > 0) {
            while (iterator.hasNext()) {
                KeyObject keyObject = (KeyObject)iterator.next();
                if (!keyObject.containsAll(collection)) continue;
                hashSet.add(keyObject);
            }
        }
        return (KeyObject[])hashSet.toArray(keyObjectSet.getProtoTypeArray());
    }

    public final KeyObjectSet getKeySet() {
        if (this.keys == null) {
            this.keys = this.createKeySet();
            this.keys.setDesign(this.getDesign());
            this.keys.setParentContainer(this);
        }
        return this.keys;
    }

    protected abstract KeyObjectSet createKeySet();

    public KeyObject[] getKeys() {
        return (KeyObject[])this.getKeySet().toArray();
    }

    public abstract KeyObject[] getKeyArrayPrototype();

    public void setPK(KeyObject keyObject) {
        if (this.primaryKey != keyObject) {
            this.primaryKey = keyObject;
            ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.PK_CHANGED;
            objectChangeEvent.setAffected(keyObject);
            this.fireChange(objectChangeEvent);
        }
    }

    public KeyObject getPK() {
        return this.primaryKey;
    }

    public KeyObject getPKorUnique() {
        if (this.primaryKey != null) {
            return this.primaryKey;
        }
        KeyObject[] keyObjectArray = this.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (!keyObjectArray[i].isUnique()) continue;
            return keyObjectArray[i];
        }
        return null;
    }

    public boolean hasPK() {
        return this.getPK() != null;
    }

    public boolean hasUnique() {
        KeyObject[] keyObjectArray = this.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (!keyObjectArray[i].isUnique()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return this.size() > 0 && this.hasPK() && this.getPK().isValidPK();
    }

    public KeyObject getKeyGeneratedBy(DesignObject designObject) {
        return this.getKeyGeneratedBy(designObject.getObjectID());
    }

    public KeyObject getKeyGeneratedBy(String string) {
        KeyObject[] keyObjectArray = this.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (!string.equals(keyObjectArray[i].getGeneratorID())) continue;
            return keyObjectArray[i];
        }
        return null;
    }

    public int getNumberOfKeys() {
        return this.keys.size();
    }

    public int countRelationsWith(ContainerWithKeyObject containerWithKeyObject) {
        return 0;
    }

    public int countRelations() {
        return 0;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 1;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n < super.getNumberOfChildren()) {
            return super.getChild(n);
        }
        return this.getKeySet();
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.keys) {
            return this.getNumberOfChildren();
        }
        return super.getIndexForChild(modelObject);
    }

    public KeyObject getKeyObject(String string) {
        return (KeyObject)this.getKeySet().getObjectByID(string);
    }

    public void setPKName(String string) {
        boolean bl = false;
        if (this.pkName != null && !this.pkName.equals(string) || this.pkName == null && string != null) {
            bl = true;
        }
        this.pkName = string;
        if (bl) {
            this.fireChange(ObjectChangeEvent.PK_NAME_CHANGED);
        }
    }

    public String getPKName() {
        if ((this.pkName == null || "".equals(this.pkName)) && this.hasPK()) {
            this.pkName = this.getPK().getName();
        }
        return this.pkName;
    }

    public ContainedObjectWithDomain getExactRefToStructurtedType(StructuredType structuredType, ContainerObject containerObject) {
        ArrayList<ContainedObjectWithDomain> arrayList = new ArrayList<ContainedObjectWithDomain>();
        for (ContainedObjectWithDomain containedObjectWithDomain : this.getElementsCollection()) {
            ContainerWithKeyObject containerWithKeyObject;
            if (!containedObjectWithDomain.isExactRefToStructuredType(structuredType)) continue;
            if (containedObjectWithDomain.getScopeId() != null && (containerWithKeyObject = (ContainerWithKeyObject)this.getDesign().getDesignObject(containedObjectWithDomain.getScopeId())) != null && containerWithKeyObject.isBST() && containerWithKeyObject.getBasedOnStructuredType() == structuredType && containerWithKeyObject == containerObject) {
                return containedObjectWithDomain;
            }
            arrayList.add(containedObjectWithDomain);
        }
        for (ContainedObjectWithDomain containedObjectWithDomain : arrayList) {
            if (containedObjectWithDomain.getScopeId() != null) continue;
            return containedObjectWithDomain;
        }
        if (arrayList.size() > 0) {
            return (ContainedObjectWithDomain)arrayList.get(0);
        }
        return null;
    }

    public ContainedObjectWithDomain getRefToStructurtedType(StructuredType structuredType, ContainerObject containerObject) {
        ArrayList<ContainedObjectWithDomain> arrayList = new ArrayList<ContainedObjectWithDomain>();
        for (ContainedObjectWithDomain containedObjectWithDomain : this.getElementsCollection()) {
            ContainerWithKeyObject containerWithKeyObject;
            if (!containedObjectWithDomain.isRefToStructuredType(structuredType)) continue;
            if (containedObjectWithDomain.getScopeId() != null && (containerWithKeyObject = (ContainerWithKeyObject)this.getDesign().getDesignObject(containedObjectWithDomain.getScopeId())) != null && containerWithKeyObject.isBST() && containerWithKeyObject.getBasedOnStructuredType() == structuredType && containerWithKeyObject == containerObject) {
                return containedObjectWithDomain;
            }
            arrayList.add(containedObjectWithDomain);
        }
        for (ContainedObjectWithDomain containedObjectWithDomain : arrayList) {
            if (containedObjectWithDomain.getScopeId() != null) continue;
            return containedObjectWithDomain;
        }
        if (arrayList.size() > 0) {
            return (ContainedObjectWithDomain)arrayList.get(0);
        }
        return null;
    }

    public KeyObject getFirstFK() {
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            KeyObject keyObject = (KeyObject)iterator.next();
            if (!keyObject.isFK()) continue;
            return keyObject;
        }
        return null;
    }

    public void updateDeletedMappings(String string, String string2, String string3) {
        XtdMapping xtdMapping;
        for (DesignObject designObject : this.getElementsCollection()) {
            xtdMapping = ((ContainedObject)designObject).getDeletedMapping(string, string3);
            if (xtdMapping == null) continue;
            xtdMapping.setRecreatedContainerID(string2);
        }
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            DesignObject designObject;
            designObject = (KeyObject)iterator.next();
            xtdMapping = ((KeyObject)designObject).getDeletedMapping(string, string3);
            if (xtdMapping == null) continue;
            xtdMapping.setRecreatedContainerID(string2);
        }
    }

    @Override
    public void setTypeSubstitution(TypeSubstitution typeSubstitution) {
        TypeSubstitution typeSubstitution2 = this.getTypeSubstitution();
        super.setTypeSubstitution(typeSubstitution);
        if (typeSubstitution != null) {
            KeyObject keyObject = this.getPK();
            if (keyObject != null) {
                keyObject.remove();
            }
        } else if (typeSubstitution2 != null) {
            KeyObject keyObject = this.createKeyObject();
            ContainedObject containedObject = this.getOidElement();
            keyObject.setPK(true);
            if (containedObject != null) {
                keyObject.add(containedObject);
            }
            keyObject.setName("Oid_PK_" + this.getName());
            keyObject.setOidKey(true);
        }
    }

    public String getTypeID() {
        return this.typeID;
    }

    public void setTypeID(String string) {
        this.typeID = string;
    }

    public boolean hasKey(KeyObject keyObject) {
        return this.getKeySet().contains(keyObject);
    }

    public KeyObject getOidKey() {
        if (this.isBST()) {
            Iterator iterator = this.getKeySet().iterator();
            while (iterator.hasNext()) {
                KeyObject keyObject = (KeyObject)iterator.next();
                if (!keyObject.isOidKey()) continue;
                return keyObject;
            }
        }
        return null;
    }
}

