/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;

public abstract class ContainedObject
extends DesignObject
implements LongNameObject,
ObjectListener {
    private ContainerObject container;
    private boolean nullAllowed = true;
    private boolean unique = false;
    private String constraintName;
    protected boolean useDomainConstraints = true;
    private CheckConstraint check;
    private ConstraintEnumeration valueList;
    private Set avts = new TreeSet();
    private StructuredType structuredType = null;
    private CollectionType collectionType = null;
    public static final String NLS_TYPE_MANUAL = Messages.getString("ContainedObject.Manual");
    public static final String NLS_TYPE_SYSTEM = Messages.getString("ContainedObject.System");
    public static final String NLS_TYPE_DERIVED = Messages.getString("ContainedObject.Derived");
    public static final String NLS_TYPE_AGGREGATE = Messages.getString("ContainedObject.Aggregate");
    public static final String[] SOURCE_TYPE_STATES_DISPLAY = new String[]{"", NLS_TYPE_MANUAL, NLS_TYPE_SYSTEM, NLS_TYPE_DERIVED, NLS_TYPE_AGGREGATE};
    public static final String TYPE_MANUAL = "Manual";
    public static final String TYPE_SYSTEM = "System";
    public static final String TYPE_DERIVED = "Derived";
    public static final String TYPE_AGGREGATE = "Aggregate";
    public static final String[] SOURCE_TYPE_STATES_INTERNAL = new String[]{"", "Manual", "System", "Derived", "Aggregate"};
    private static Set sourceTypeSet = null;
    private String sourceType = "";
    private String formulaDesc = "";
    private StringBuffer buffer = new StringBuffer();
    private String synonym = "";
    private String structAttributeID = "";
    private boolean oid = false;
    protected String scopeId = null;
    private List nestedObjects = new ArrayList();
    private ContainedObject parentObject;
    private int avtSortOrder = 0;
    private String referedAttribute;

    public ContainedObject(DesignPart designPart) {
        super(designPart);
        if (designPart.getDesign().getAppView() != null) {
            this.setNullsAllowed(designPart.getDesign().getAppView().getSettings().getNullsAllowed());
        }
    }

    public void setContainer(ContainerObject containerObject) {
        if (this.isWriteable()) {
            this.container = containerObject;
            if (containerObject != null) {
                this.setBackup(containerObject.isBackup());
            }
        }
    }

    public ContainerObject getContainer() {
        return this.container;
    }

    public boolean belongsTo(ContainerObject containerObject) {
        return this.getContainer() == containerObject;
    }

    public void setNullsAllowed(boolean bl) {
        if (this.isWriteable() && bl != this.nullAllowed) {
            this.nullAllowed = bl;
            if (bl) {
                this.unique = false;
            }
            this.fireChange(ObjectChangeEvent.NULLS_ALLOWED_CHANGED);
        }
    }

    public boolean getNullsAllowed() {
        return this.nullAllowed;
    }

    public void setUnique(boolean bl) {
        if (this.isWriteable()) {
            this.unique = bl;
        }
    }

    public String getConstraintName() {
        if (this.constraintName != null) {
            return this.constraintName;
        }
        return "";
    }

    public void setConstraintName(String string) {
        if (this.isWriteable()) {
            this.constraintName = string;
        }
    }

    public boolean getUseDomainConstraints() {
        return this.useDomainConstraints;
    }

    public void setUseDomainConstraints(boolean bl) {
        if (this.isWriteable() && this.useDomainConstraints != bl) {
            this.useDomainConstraints = bl;
            this.fireChange(ObjectChangeEvent.ATTRIBUTE_DOMAIN_CHANGED);
        }
    }

    public CheckConstraint getCheck() {
        return this.check;
    }

    public void setCheck(CheckConstraint checkConstraint) {
        if (this.isWriteable()) {
            this.check = checkConstraint;
            if (checkConstraint != null) {
                this.check.setDesign(this.getDesign());
            }
        }
    }

    public void addAVT(AVT aVT) {
        if (!this.avts.contains(aVT)) {
            this.avts.add(aVT);
        }
    }

    public Set getAVTs() {
        LogicalDatatype logicalDatatype;
        if (this.avts.size() > 1 && this instanceof ContainedObjectWithDomain && (logicalDatatype = ((ContainedObjectWithDomain)this).getLogicalDatatype()) != null && logicalDatatype.isNumeric()) {
            TreeSet treeSet = new TreeSet(new AVTNumberComparator());
            treeSet.addAll(this.avts);
            return treeSet;
        }
        return this.avts;
    }

    public void removeAVT(AVT aVT) {
        if (this.avts.contains(aVT)) {
            this.avts.remove(aVT);
        }
    }

    public void clearAVTs() {
        this.avts.clear();
    }

    public ConstraintEnumeration getValueList() {
        return this.valueList;
    }

    public void setValueList(ConstraintEnumeration constraintEnumeration) {
        this.valueList = constraintEnumeration;
        if (constraintEnumeration != null) {
            constraintEnumeration.setDesign(this.getDesign());
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String getLongName() {
        this.buffer.setLength(0);
        if (this.container != null) {
            this.buffer.append(this.container.getName());
            this.buffer.append('.');
        }
        this.buffer.append(this.getName());
        return this.buffer.toString();
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainer() != null && this.getContainer().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public boolean isFKElement() {
        return false;
    }

    @Override
    public boolean isContainedObject() {
        return true;
    }

    public ContainedObject getDelegateElement() {
        return null;
    }

    public int getIndex() {
        if (this.getContainer() != null) {
            return this.getContainer().getIndexOf(this);
        }
        return -1;
    }

    public int getPositionInContainerOneBased() {
        return this.getIndex() + 1;
    }

    public void moveToIndex(int n) {
        if (this.getContainer() != null) {
            this.getContainer().moveToIndex(this, n);
        }
    }

    @Override
    public Object getParent() {
        if (this.getContainer() != null) {
            return this.getContainer();
        }
        return super.getParent();
    }

    @Override
    public void remove() {
        if (this.parentObject != null) {
            this.parentObject.removeNestedObject(this);
        }
        this.removeNestedObjects();
        this.parentObject = null;
        boolean bl = !this.getIsBeingRemoved();
        super.remove();
        if (bl && this.getContainer() != null) {
            this.getContainer().remove(this);
        }
    }

    public void removeNestedObjects() {
        Object[] objectArray = this.nestedObjects.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ContainedObject containedObject = (ContainedObject)objectArray[i];
            containedObject.remove();
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.setName(this.getName());
        }
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String string) {
        if (!this.synonym.equals(string)) {
            this.synonym = string;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView designPartView) {
        return this.getContainer().hasRepresentationInDPV(designPartView);
    }

    private boolean checkSourceType(String string) {
        if (sourceTypeSet == null) {
            sourceTypeSet = new HashSet();
            sourceTypeSet.addAll(Arrays.asList(SOURCE_TYPE_STATES_INTERNAL));
        }
        return sourceTypeSet.contains(string);
    }

    public String getFormulaDesc() {
        return this.formulaDesc;
    }

    public void setFormulaDesc(String string) {
        if (string != null && string.equals(this.formulaDesc)) {
            return;
        }
        this.formulaDesc = string;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String string) {
        if (string != null && string.equals(this.sourceType)) {
            return;
        }
        if (this.checkSourceType(string)) {
            this.sourceType = string;
        }
    }

    public String getStructAttributeID() {
        return this.structAttributeID;
    }

    public void setStructAttributeID(String string) {
        this.structAttributeID = string != null ? string : "";
    }

    public boolean isOid() {
        return this.oid;
    }

    public void setOid(boolean bl) {
        this.oid = bl;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String string) {
        this.scopeId = string;
    }

    public ContainerObject getScope() {
        if (this.scopeId == null) {
            return null;
        }
        return (ContainerObject)this.getDesign().getDesignObject(this.scopeId);
    }

    public StructuredType getStructuredType() {
        return this.structuredType;
    }

    public void setStructuredType(StructuredType structuredType) {
        this.structuredType = structuredType;
    }

    public ContainedObject getParentObject() {
        return this.parentObject;
    }

    public void setParentObject(ContainedObject containedObject) {
        if (this.parentObject != containedObject && this.parentObject != null) {
            this.parentObject.removeNestedObject(this);
        }
        this.parentObject = containedObject;
        if (this.parentObject != null) {
            this.parentObject.addNestedObject(this);
        }
    }

    public void addNestedObject(ContainedObject containedObject) {
        if (!this.nestedObjects.contains(containedObject)) {
            this.nestedObjects.add(containedObject);
        }
    }

    public void removeNestedObject(ContainedObject containedObject) {
        this.nestedObjects.remove(containedObject);
    }

    public boolean isAtomic() {
        return this.getStructuredType() == null;
    }

    public boolean isNested() {
        return this.parentObject != null;
    }

    @Override
    public String getName() {
        if (this.isNested()) {
            return this.parentObject.getName() + "." + super.getName();
        }
        return super.getName();
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public String getSize() {
        return "";
    }

    public XtdMapping getDeletedMapping(ContainerObject containerObject) {
        String string = containerObject.getObjectID();
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, containerObject.getDesignPartId());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                if (!xtdMapping.isMappingForContainer(string)) continue;
                return xtdMapping;
            }
        }
        return null;
    }

    public XtdMapping getDeletedMapping(String string, String string2) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, string2);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                if (string.equals(xtdMapping.getRecreatedContainerID())) {
                    return xtdMapping;
                }
                String string3 = xtdMapping.getDeletedID();
                String string4 = ContainerObject.getContainerID_From(string3);
                if (!string.equals(string4)) continue;
                return xtdMapping;
            }
        }
        return null;
    }

    @Override
    public void setDirty(boolean bl) {
        super.setDirty(bl);
        if (bl && this.getContainer() != null) {
            this.getContainer().setDirty(bl);
        }
    }

    public int getAVTSortOrder() {
        return this.avtSortOrder;
    }

    public void setAVTSortOrder(int n) {
        this.avtSortOrder = n;
    }

    public List getNestedObjects() {
        return this.nestedObjects;
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        DesignObject designObject = null;
        if ("structuredType".equalsIgnoreCase(string)) {
            designObject = this.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(string2);
        } else if ("collectionType".equalsIgnoreCase(string)) {
            designObject = this.getDesign().getDataTypesDesign().getCollectionTypeSet().getObjectByID(string2);
        }
        if (designObject != null) {
            return designObject;
        }
        return super.translateIdToObject(string, string2);
    }

    public AVT createAVT() {
        return new AVT();
    }

    public List getAVTList() {
        ArrayList<AVT> arrayList = new ArrayList<AVT>();
        for (AVT aVT : this.getAVTs()) {
            arrayList.add(aVT);
        }
        return arrayList;
    }

    public void applyAVTList(List list) {
        this.avts.clear();
        this.avts.addAll(list);
    }

    @Override
    public void setObjectID(String string) {
        String string2 = this.getObjectID();
        super.setObjectID(string);
        ContainerObject containerObject = this.getContainer();
        if (containerObject != null && string2 == null) {
            containerObject.putInLocalIDMap(string, this);
        }
        if (containerObject != null && string != null && string2 != null && !string.equals(string2)) {
            containerObject.updateLocalObjectId(string2, string);
        }
    }

    public String getReferedAttribute() {
        return this.referedAttribute;
    }

    public void setReferedAttribute(String string) {
        this.referedAttribute = string;
    }

    public void setMandatory(boolean bl) {
        this.setNullsAllowed(!bl);
    }

    public boolean isMandatory() {
        return !this.getNullsAllowed();
    }

    private class AVTNumberComparator
    implements Comparator {
        private AVTNumberComparator() {
        }

        public int compare(Object object, Object object2) {
            try {
                double d = Double.parseDouble(((AVT)object).getBeginValue());
                double d2 = Double.parseDouble(((AVT)object2).getBeginValue());
                if (d > d2) {
                    return 1;
                }
                if (d < d2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception exception) {
                return ((AVT)object).getBeginValue().compareTo(((AVT)object2).getBeginValue());
            }
        }
    }
}

