/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import com.adbs.ast.KeywordFormat;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryStatistics;
import com.adbs.querybuilder.StatisticsDatabaseObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateView;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateViewOracle;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateViewSqlServer;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateViewUDB;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateViewUDBv81;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.SubsetCOMultiple;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractView
extends SubsetCOMultiple {
    public static final String VALUE_ASCENDING = "ASC";
    public static final String VALUE_DESCENDING = "DESC";
    public static final String CONTAINER_ID = "containerID";
    public static final String ALIAS = "alias";
    private static final String ID = "id";
    private static final String SORT = "sort";
    private static final String NAME = "name";
    private static final String REF_ELEM_ID = "relem_id";
    private static final String REF_VIEW_ELEM_ID = "rvelem_id";
    public static final String[] SORT_ORDER_CHOICES = new String[]{"ASC", "DESC"};
    public static final String DB2_SYNTAX_PROVIDER = "DB2";
    public static final String FIREBIRD_SYNTAX_PROVIDER = "Firebird";
    public static final String INFORMIX_SYNTAX_PROVIDER = "Informix";
    public static final String MSSQL_SYNTAX_PROVIDER = "MSSQL";
    public static final String MYSQL_SYNTAX_PROVIDER = "MySQL";
    public static final String ORACLE_SYNTAX_PROVIDER = "Oracle";
    public static final String POSTGRESQL_SYNTAX_PROVIDER = "PostgreSQL";
    public static final String SQL2003_SYNTAX_PROVIDER = "SQL2003";
    public static final String SQL89_SYNTAX_PROVIDER = "SQL89";
    public static final String SQL92_SYNTAX_PROVIDER = "SQL92";
    public static final String SQLITE_SYNTAX_PROVIDER = "SQLite";
    public static final String SYBASE_SYNTAX_PROVIDER = "Sybase";
    public static final String[] DB_SYNTAX_PROVIDERS = new String[]{"DB2", "Firebird", "Informix", "MSSQL", "MySQL", "Oracle", "PostgreSQL", "SQLite", "Sybase"};
    protected String where = "";
    protected String groupBy = "";
    protected String having = "";
    protected boolean userDefined = false;
    protected String userDefinedSQL = "";
    protected Map containerMap = new HashMap();
    protected List tables;
    protected List views;
    protected Map orderByMap = new HashMap();
    protected List orderByList;
    protected List groupByList = new ArrayList();
    protected DesignObjectCollection phelements = new DesignObjectCollection();
    protected List usedContainers = new ArrayList();
    protected List viewsNotAdded = new ArrayList();
    private String layoutSQL = "";
    private List sqlNames = new ArrayList();
    private List deletedSQLNames = new ArrayList();
    private boolean includeSchemaNameInQuery = false;
    private boolean validSQL = true;
    private boolean parsed = false;
    private boolean incorrectSQL = false;
    private String useObjectsOnlyFrom = "";
    private String syntaxProvider = "Oracle";
    private static final Logger LOGGER = new Logger(AbstractView.class);
    public static final String TYPE_NAME = "View";

    public AbstractView(DesignPart designPart) {
        super(designPart);
        this.phelements.setParent(this);
        this.orderByList = new ArrayList();
        this.tables = new ArrayList();
        this.views = new ArrayList();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setContainers(DesignObjectSet designObjectSet) {
        throw new RuntimeException("Should not be used, table set is found dynamically");
    }

    @Override
    public abstract String getIDPrefix();

    @Override
    public abstract DesignObjectSet getContainedSet();

    public abstract void addToContainers(ContainerObject var1, String var2);

    public abstract void addToContainers(String var1, String var2);

    public abstract void clearContainers();

    public abstract void clearElements(ContainerObject var1);

    public abstract void clearOrderByElements(ContainerObject var1);

    public abstract void importView(DesignObject var1);

    public abstract void updateElements(List var1);

    public abstract AbstractViewElement createViewElement(DesignPart var1);

    public abstract DesignObjectSet getTableSet();

    @Override
    public int getIndexOf(ContainedObject containedObject) {
        return this.phelements.getIndexOf(containedObject);
    }

    @Override
    public int getNumberOfChildren() {
        return this.phelements.size();
    }

    @Override
    public ModelObject getChild(int n) {
        return this.phelements.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return this.phelements.getIndexForChild(modelObject);
    }

    @Override
    public boolean isLeaf() {
        return this.phelements.size() < 1;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String string) {
        this.groupBy = string;
    }

    public String getHaving() {
        return this.having;
    }

    public void setHaving(String string) {
        this.having = string;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String string) {
        this.where = string;
    }

    public void removeAllFromOrderBy() {
        this.orderByMap.clear();
        this.orderByList.clear();
    }

    public String getSortOrder(ContainedObject containedObject) {
        String string = (String)this.orderByMap.get(containedObject.getObjectID());
        if (string == null) {
            string = VALUE_ASCENDING;
        }
        return string;
    }

    public List getOrderByList() {
        return this.orderByList;
    }

    public String getSortOrder(String string) {
        String string2 = (String)this.orderByMap.get(string);
        if (string2 == null) {
            string2 = VALUE_ASCENDING;
        }
        return string2;
    }

    public Map getOrderByMap() {
        return this.orderByMap;
    }

    public void removeAllElements() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getElementsCollection().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.remove((ContainedObject)iterator.next());
        }
    }

    public void removeAllFromElements() {
        this.containerMap.clear();
        this.tables.clear();
        this.views.clear();
        this.usedContainers.clear();
        this.orderByList.clear();
        this.orderByMap.clear();
    }

    @Override
    public void setDesign(Design design) {
        super.setDesign(design);
    }

    public void removeFromOrderBy(ContainedObject containedObject) {
        this.orderByMap.remove(containedObject.getObjectID());
        this.orderByList.remove(containedObject);
    }

    public String getContainerID(String string) {
        return (String)this.containerMap.get(string);
    }

    public List getTables() {
        return this.tables;
    }

    public void setTables(List list) {
        this.tables = list;
    }

    public List getViews() {
        return this.views;
    }

    public void setViews(List list) {
        this.views = list;
    }

    public Map getContainerMap() {
        return this.containerMap;
    }

    public boolean getUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean bl) {
        this.userDefined = bl;
    }

    public String getUserDefinedSQL() {
        return this.userDefinedSQL;
    }

    public String getUserDefinedSQL(String string) {
        return this.userDefinedSQL.replaceAll(this.getName(), string);
    }

    public void setUserDefinedSQL(String string) {
        this.userDefinedSQL = string;
    }

    public void clear(ContainerObject containerObject) {
        this.tables.remove(containerObject);
        this.views.remove(containerObject);
        Object[] objectArray = this.containerMap.keySet().toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            String string = (String)objectArray[i];
            String string2 = (String)this.containerMap.get(string);
            if (!containerObject.getObjectID().equalsIgnoreCase(string2)) continue;
            this.containerMap.remove(string);
        }
        if (containerObject != this) {
            this.clearElements(containerObject);
        }
        this.clearOrderByElements(containerObject);
    }

    public String getCaption() {
        return "Query";
    }

    public List getGroupByList() {
        return this.groupByList;
    }

    public void addGroupByList(ContainedObject containedObject) {
        this.groupByList.add(containedObject);
    }

    public void removeAllGroupByList() {
        this.groupByList.clear();
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    public DesignObject getObjectByID(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignObject)iterator.next();
            if (!string.equals(designObject.getObjectID())) continue;
            iterator = null;
            return designObject;
        }
        return null;
    }

    @Override
    protected void clearStructure() {
        this.userDefinedSQL = "";
        this.where = "";
        this.groupBy = "";
        this.having = "";
        this.removeAll();
    }

    @Override
    protected void updateStructure() {
        if (this.isBST()) {
            TypeElement typeElement;
            int n;
            StructuredType structuredType = this.getBasedOnStructuredType();
            List list = structuredType.getAllElements();
            ContainedObject[] containedObjectArray = this.getElements();
            for (n = 0; n < containedObjectArray.length; ++n) {
                if (containedObjectArray[n].isOid() || (typeElement = this.findTypeElement(list, containedObjectArray[n].getStructAttributeID())) != null) continue;
                containedObjectArray[n].remove();
            }
            this.updateElements(list);
            for (n = 0; n < list.size(); ++n) {
                typeElement = (TypeElement)list.get(n);
                ContainedObject containedObject = this.getElementByStructAttributeID(typeElement.getObjectID());
                if (containedObject == null) continue;
                this.moveToIndex(containedObject, n);
            }
        }
    }

    private TypeElement findTypeElement(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement typeElement = (TypeElement)list.get(i);
            if (!typeElement.getObjectID().equalsIgnoreCase(string)) continue;
            return typeElement;
        }
        return null;
    }

    public void getElements(String string) {
        this.getElements(string, true);
    }

    public void getElements(String string, boolean bl) {
        int n = this.getDesignPart().getAppView().getSettings().getDefaultRDBMSType();
        switch (n) {
            case 0: 
            case 1: {
                SHCreateView sHCreateView = new SHCreateView(this.getDesign());
                sHCreateView.setStatement(string);
                sHCreateView.setAsSelectOnly(bl);
                sHCreateView.setView(this);
                if (sHCreateView.initCols()) break;
                sHCreateView.initCol();
                break;
            }
            case 2: {
                SHCreateViewUDB sHCreateViewUDB = new SHCreateViewUDB(this.getDesign());
                sHCreateViewUDB.setStatement(string);
                sHCreateViewUDB.setAsSelectOnly(bl);
                sHCreateViewUDB.setView(this);
                if (sHCreateViewUDB.initCols()) break;
                sHCreateViewUDB.initCol();
                break;
            }
            case 3: {
                SHCreateViewUDBv81 sHCreateViewUDBv81 = new SHCreateViewUDBv81(this.getDesign());
                sHCreateViewUDBv81.setStatement(string);
                sHCreateViewUDBv81.setAsSelectOnly(bl);
                sHCreateViewUDBv81.setView(this);
                if (sHCreateViewUDBv81.initCols()) break;
                sHCreateViewUDBv81.initCol();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                SHCreateViewOracle sHCreateViewOracle = new SHCreateViewOracle(this.getDesign());
                sHCreateViewOracle.setStatement(string);
                sHCreateViewOracle.setAsSelectOnly(bl);
                sHCreateViewOracle.setView(this);
                sHCreateViewOracle.initCols();
                break;
            }
            case 4: 
            case 5: {
                SHCreateViewSqlServer sHCreateViewSqlServer = new SHCreateViewSqlServer(this.getDesign());
                sHCreateViewSqlServer.setStatement(string);
                sHCreateViewSqlServer.setAsSelectOnly(bl);
                sHCreateViewSqlServer.setView(this);
                if (sHCreateViewSqlServer.initCols()) break;
                try {
                    sHCreateViewSqlServer.initCol();
                    break;
                }
                catch (Exception exception) {
                    LOGGER.error("Error in parsing columns!", exception);
                }
            }
        }
    }

    protected String appendQuotes(String string) {
        if (string.trim().indexOf(32) > -1) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public String generateSQL() {
        return this.generateSQL(null);
    }

    protected String generateGroupBy() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (AbstractViewElement abstractViewElement : this.groupByList) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.getGroupByValue(abstractViewElement));
        }
        return stringBuffer.toString();
    }

    private String getGroupByValue(AbstractViewElement abstractViewElement) {
        if (!"".equals(abstractViewElement.getExpression())) {
            return abstractViewElement.getExpression();
        }
        String string = this.appendQuotes(abstractViewElement.getName());
        if (!abstractViewElement.getTableAlias().equalsIgnoreCase("")) {
            return this.appendQuotes(abstractViewElement.getTableAlias()) + "." + string;
        }
        return string;
    }

    public String generateSQL(StorageDesign storageDesign) {
        Object object;
        StorageDesign storageDesign2 = storageDesign;
        if (storageDesign2 == null) {
            object = this.getDesignPart();
            storageDesign2 = object instanceof RelationalDesign ? ((RelationalDesign)object).getStorageDesign() : ((ModelObject)object).getDesign().getStorageDesign(((DesignPart)object).getSelectedRDBMSSite());
        }
        object = new StringBuffer();
        ContainedObject[] containedObjectArray = this.getElements();
        if (containedObjectArray.length > 0) {
            ModelIDObject modelIDObject;
            Object object2;
            Object object3;
            Object object42;
            Object object5;
            int n;
            object = new StringBuffer("CREATE VIEW ");
            ((StringBuffer)object).append(storageDesign2.getFormatedName(this.getName()));
            int n2 = 0;
            for (n = 0; n < containedObjectArray.length; ++n) {
                object5 = (AbstractViewElement)containedObjectArray[n];
                object42 = ((AbstractViewElement)object5).getAlias().trim();
                if ("".equals(object42)) {
                    object42 = ((AbstractViewElement)object5).getReferencedName();
                }
                if (((String)object42).equalsIgnoreCase("")) continue;
                if (n2 == 0) {
                    ((StringBuffer)object).append("\n");
                    ((StringBuffer)object).append("  (");
                } else {
                    ((StringBuffer)object).append(",\n   ");
                }
                ((StringBuffer)object).append(' ');
                ((StringBuffer)object).append(storageDesign2.getFormatedName((String)object42));
                ++n2;
            }
            ((StringBuffer)object).append(' ');
            ((StringBuffer)object).append(')');
            ((StringBuffer)object).append("\n");
            ((StringBuffer)object).append(" AS SELECT\n   ");
            n2 = 0;
            for (n = 0; n < containedObjectArray.length; ++n) {
                object5 = (AbstractViewElement)containedObjectArray[n];
                object42 = storageDesign2.getFormatedName(((AbstractViewElement)object5).getReferencedName());
                object3 = ((AbstractViewElement)object5).getReferencedContainer();
                if (object3 != null) {
                    object2 = this.getContainerHolderFor((ContainerObject)object3);
                    if (object2 != null && ((ContainerHolder)object2).getAlias() != null && !"".equals(((ContainerHolder)object2).getAlias().trim())) {
                        object42 = storageDesign2.getFormatedName(((ContainerHolder)object2).getAlias().trim()) + "." + (String)object42;
                    }
                    if (!"".equalsIgnoreCase(((AbstractViewElement)object5).getAlias())) {
                        object42 = (String)object42 + " " + storageDesign2.getFormatedName(((AbstractViewElement)object5).getAlias().trim());
                    }
                } else {
                    object42 = !((AbstractViewElement)object5).getExpression().equalsIgnoreCase("") ? ((AbstractViewElement)object5).getExpression() + " " + storageDesign2.getFormatedName(((AbstractViewElement)object5).getAlias().trim()) : (String)object42 + " " + storageDesign2.getFormatedName(((AbstractViewElement)object5).getAlias().trim());
                }
                if (n2 > 0) {
                    ((StringBuffer)object).append(",\n   ");
                }
                ((StringBuffer)object).append(' ').append((String)object42);
                ++n2;
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.tables);
            arrayList.addAll(this.views);
            if (containedObjectArray.length > 0) {
                if (arrayList.size() > 0) {
                    ((StringBuffer)object).append("\n");
                    ((StringBuffer)object).append(" FROM \n");
                }
                n2 = 0;
                object5 = this.getUsedContainers().iterator();
                while (object5.hasNext()) {
                    if (n2 > 0) {
                        ((StringBuffer)object).append(",\n    ");
                    } else {
                        ((StringBuffer)object).append("    ");
                    }
                    object42 = (ContainerHolder)object5.next();
                    object3 = ((ContainerHolder)object42).getContainer();
                    object2 = ((DesignObject)object3).getName();
                    if (storageDesign2 != null) {
                        if (object3 instanceof Table) {
                            modelIDObject = (TableProxy)storageDesign2.getTableProxySet().getObjectGeneratedBy(((ModelIDObject)object3).getObjectID());
                            if (modelIDObject != null) {
                                object2 = ((RelationalObjectProxy)modelIDObject).getLongName();
                            }
                        } else if (object3 instanceof TableView && (modelIDObject = (TableViewProxy)storageDesign2.getTableViewProxySet().getObjectGeneratedBy(((ModelIDObject)object3).getObjectID())) != null) {
                            object2 = ((RelationalObjectProxy)modelIDObject).getLongName();
                        }
                    }
                    ((StringBuffer)object).append(storageDesign2.getFormatedName((String)object2)).append(" ").append(storageDesign2.getFormatedName(((ContainerHolder)object42).getAlias()));
                    ++n2;
                }
            }
            if (!"".equalsIgnoreCase(this.where)) {
                ((StringBuffer)object).append("\n");
                ((StringBuffer)object).append(" WHERE \n    ");
                ((StringBuffer)object).append(this.where);
            }
            if ("".equalsIgnoreCase(this.groupBy)) {
                this.groupBy = this.generateGroupBy();
            }
            if (!"".equalsIgnoreCase(this.groupBy)) {
                ((StringBuffer)object).append("\n");
                ((StringBuffer)object).append(" GROUP BY \n    ");
                ((StringBuffer)object).append(this.groupBy);
            }
            if (!"".equalsIgnoreCase(this.having)) {
                ((StringBuffer)object).append("\n");
                ((StringBuffer)object).append(" HAVING \n    ");
                ((StringBuffer)object).append(this.having);
            }
            if (this.orderByList.size() > 0) {
                ((StringBuffer)object).append("\n");
                ((StringBuffer)object).append(" ORDER BY \n");
                n2 = 0;
                for (Object object42 : this.orderByList) {
                    object3 = "";
                    for (int i = 0; i < containedObjectArray.length; ++i) {
                        modelIDObject = (AbstractViewElement)containedObjectArray[i];
                        if (!((ContainedObject)object42).getName().equalsIgnoreCase(((ContainedObject)modelIDObject).getName())) continue;
                        object3 = ((AbstractViewElement)modelIDObject).getAlias().trim();
                        break;
                    }
                    if (((String)object3).equalsIgnoreCase("")) {
                        object3 = ((ContainedObject)object42).getName();
                    }
                    object2 = this.getOrderByMap().get(((ModelIDObject)object42).getObjectID()).toString();
                    if (n2 > 0) {
                        ((StringBuffer)object).append(",\n   ");
                    } else {
                        ((StringBuffer)object).append("   ");
                    }
                    ((StringBuffer)object).append(' ');
                    ((StringBuffer)object).append(storageDesign2.getFormatedName((String)object3));
                    ((StringBuffer)object).append(' ');
                    ((StringBuffer)object).append((String)object2);
                    ++n2;
                }
                ((StringBuffer)object).append("\n");
            }
            ((StringBuffer)object).append(';');
        }
        return ((StringBuffer)object).toString();
    }

    public List getUsedContainers() {
        if (!ApplicationView.loading && this.viewsNotAdded.size() > 0) {
            for (ViewNotAdded viewNotAdded : this.viewsNotAdded) {
                ContainerHolder containerHolder = null;
                containerHolder = this.getDesignPart() instanceof LogicalDesign ? new ContainerHolder((EntityView)((LogicalDesign)this.getDesignPart()).getEntityViewSet().getObjectByID(viewNotAdded.getId()), viewNotAdded.getAlias()) : new ContainerHolder((TableView)((RelationalDesign)this.getDesignPart()).getTableViewSet().getObjectByID(viewNotAdded.getId()), viewNotAdded.getAlias());
                if (containerHolder.getContainer() == null || this.usedContainers.contains(containerHolder) || !this.checkObjectId(viewNotAdded.getId(), viewNotAdded.getAlias())) continue;
                int n = this.viewsNotAdded.indexOf(viewNotAdded);
                this.usedContainers.add(n, containerHolder);
            }
            this.viewsNotAdded.clear();
        }
        return this.usedContainers;
    }

    private boolean checkObjectId(String string, String string2) {
        for (ContainerHolder containerHolder : this.usedContainers) {
            if (containerHolder.getContainer() == null || !containerHolder.getContainer().getObjectID().equalsIgnoreCase(string) || !containerHolder.getAlias().equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    public ContainerHolder getContainerHolderFor(ContainerObject containerObject) {
        for (ContainerHolder containerHolder : this.usedContainers) {
            if (containerHolder.container != containerObject) continue;
            return containerHolder;
        }
        return null;
    }

    public List getViewsNotAdded() {
        return this.viewsNotAdded;
    }

    public AbstractViewElement createViewElement(boolean bl) {
        AbstractViewElement abstractViewElement = this.createViewElement(this.getDesignPart());
        abstractViewElement.setContainer(this);
        if (bl) {
            this.add(abstractViewElement);
        }
        return abstractViewElement;
    }

    public AbstractViewElement createViewElement() {
        return this.createViewElement(true);
    }

    public List getContainersMaps() {
        ArrayList arrayList = new ArrayList();
        for (ContainerHolder containerHolder : this.getUsedContainers()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(CONTAINER_ID, containerHolder.getContainer().getObjectID());
            if (containerHolder.getAlias() != null && !"".equals(containerHolder.getAlias())) {
                hashMap.put(ALIAS, containerHolder.getAlias());
            }
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public void applyContainers(List list) {
        this.usedContainers.clear();
        this.viewsNotAdded.clear();
        for (Map map : list) {
            String string = (String)map.get(CONTAINER_ID);
            if (string == null) continue;
            String string2 = (String)map.get(ALIAS);
            if (string2 != null) {
                this.addToContainers(string, string2);
                continue;
            }
            this.addToContainers(string, "");
        }
    }

    public List getOrderByMaps() {
        if (this.orderByList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.orderByList.iterator();
        while (iterator.hasNext()) {
            String string;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            AbstractViewElement abstractViewElement = (AbstractViewElement)iterator.next();
            String string2 = abstractViewElement.getObjectID();
            treeMap.put(ID, string2);
            String string3 = this.getSortOrder(string2);
            if (VALUE_DESCENDING.equals(string3)) {
                treeMap.put(SORT, VALUE_DESCENDING);
            }
            String string4 = abstractViewElement.getName();
            treeMap.put(NAME, string4);
            if (abstractViewElement.getReferencedColumn() != null) {
                string = abstractViewElement.getReferencedColumn().getObjectID();
                treeMap.put(REF_ELEM_ID, string);
            }
            if (abstractViewElement.getReferencedColumnViewID() != null) {
                string = abstractViewElement.getReferencedColumnView().getObjectID();
                treeMap.put(REF_VIEW_ELEM_ID, string);
            }
            arrayList.add(treeMap);
        }
        return arrayList;
    }

    public void applyOrderByMaps(List list) {
        ArrayList<AbstractViewElement> arrayList = new ArrayList<AbstractViewElement>();
        for (Map map : list) {
            String string = (String)map.get(ID);
            boolean bl = true;
            AbstractViewElement abstractViewElement = this.getOrderElemByID(string);
            if (abstractViewElement == null) {
                bl = false;
                abstractViewElement = this.createViewElement(false);
                abstractViewElement.setObjectID(string);
            }
            String string2 = (String)map.get(NAME);
            abstractViewElement.setName(string2);
            String string3 = (String)map.get(SORT);
            if (string3 == null) {
                string3 = VALUE_ASCENDING;
            }
            String string4 = (String)map.get(REF_ELEM_ID);
            ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)this.getDesign().getDesignObject(string4);
            if (containedObjectWithDomain != null) {
                abstractViewElement.setReferencedColumn(containedObjectWithDomain);
            }
            String string5 = (String)map.get(REF_VIEW_ELEM_ID);
            abstractViewElement.setReferencedColumnViewID(string5);
            arrayList.add(abstractViewElement);
            if (bl) continue;
            this.addToOrderBy(abstractViewElement, string3);
        }
        this.orderByList.clear();
        this.orderByList.addAll(arrayList);
    }

    private AbstractViewElement getOrderElemByID(String string) {
        for (AbstractViewElement abstractViewElement : this.orderByList) {
            if (!abstractViewElement.getObjectID().equals(string)) continue;
            return abstractViewElement;
        }
        return null;
    }

    public abstract void addToOrderBy(ContainedObject var1, String var2);

    public String getLayoutSQL() {
        return this.layoutSQL;
    }

    public void setLayoutSQL(String string) {
        this.layoutSQL = string;
    }

    public List getSQLNames() {
        return this.sqlNames;
    }

    public List getDeletedSQLNames() {
        this.deletedSQLNames.clear();
        for (SQLNameHelper sQLNameHelper : this.sqlNames) {
            DesignObject designObject = this.getDesign().getDesignObject(sQLNameHelper.getID());
            if (designObject != null) continue;
            this.deletedSQLNames.add(sQLNameHelper);
        }
        return this.deletedSQLNames;
    }

    public List getUsedTablesAndViews() {
        ArrayList<SQLNameHelper> arrayList = new ArrayList<SQLNameHelper>();
        for (SQLNameHelper sQLNameHelper : this.sqlNames) {
            if (!sQLNameHelper.isContainer()) continue;
            arrayList.add(sQLNameHelper);
        }
        return arrayList;
    }

    public boolean isSQLNamesChanged() {
        for (SQLNameHelper sQLNameHelper : this.sqlNames) {
            DesignObject designObject = this.getDesign().getDesignObject(sQLNameHelper.getID());
            if (designObject != null) {
                String string = sQLNameHelper.isContainer() ? sQLNameHelper.getTableName() : sQLNameHelper.getColumnName();
                if (!designObject.getName().equalsIgnoreCase(string)) {
                    return true;
                }
                if (!sQLNameHelper.isContainer() || !(designObject instanceof ContainerObject)) continue;
                SchemaObject schemaObject = ((ContainerObject)designObject).getSchemaObject();
                String string2 = null;
                if (schemaObject != null) {
                    string2 = schemaObject.getName();
                }
                if (!(sQLNameHelper.getSchema() != null && string2 != null ? !sQLNameHelper.getSchema().equalsIgnoreCase(string2) : sQLNameHelper.getSchema() != string2)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void updateSQLNames(QueryBuilder queryBuilder) {
        String string;
        String string2;
        String string3;
        StatisticsDatabaseObject statisticsDatabaseObject;
        int n;
        this.sqlNames.clear();
        QueryStatistics queryStatistics = queryBuilder.getQueryStatistics();
        for (n = 0; n < queryStatistics.getUsedDatabaseObjects().getCount(); ++n) {
            statisticsDatabaseObject = queryStatistics.getUsedDatabaseObjects().get(n);
            if (statisticsDatabaseObject.getMetadataObject() == null) continue;
            string3 = statisticsDatabaseObject.getMetadataObject().getNameStrNotQuoted();
            string2 = statisticsDatabaseObject.getMetadataObject().getSchemaStrNotQuoted();
            if (string2 != null && string2.length() > 0) {
                this.addToSQLNames(string2, string3, null);
                continue;
            }
            this.addToSQLNames(null, string3, null);
        }
        for (n = 0; n < queryStatistics.getUsedDatabaseObjectColumns().getCount(); ++n) {
            statisticsDatabaseObject = queryStatistics.getUsedDatabaseObjectColumns().get(n);
            if (statisticsDatabaseObject.getMetadataObject() == null || statisticsDatabaseObject.getMetadataField() == null) continue;
            string3 = statisticsDatabaseObject.getMetadataObject().getNameStrNotQuoted();
            string2 = statisticsDatabaseObject.getMetadataField().getNameStrNotQuoted();
            string = statisticsDatabaseObject.getMetadataObject().getSchemaStrNotQuoted();
            if (string != null && string.length() > 0) {
                this.addToSQLNames(string, string3, string2);
                continue;
            }
            this.addToSQLNames(null, string3, string2);
        }
        for (n = 0; n < queryStatistics.getOutputColumns().getCount(); ++n) {
            statisticsDatabaseObject = queryStatistics.getOutputColumns().get(n);
            if (statisticsDatabaseObject.getMetadataObject() == null || statisticsDatabaseObject.getMetadataField() == null) continue;
            string3 = statisticsDatabaseObject.getMetadataObject().getNameStrNotQuoted();
            string2 = statisticsDatabaseObject.getMetadataField().getNameStrNotQuoted();
            string = statisticsDatabaseObject.getMetadataObject().getSchemaStrNotQuoted();
            if (string != null && string.length() > 0) {
                this.addToSQLNames(string, string3, string2);
                continue;
            }
            this.addToSQLNames(null, string3, string2);
        }
    }

    public SQLNameHelper getOldName2(DesignObject designObject) {
        for (SQLNameHelper sQLNameHelper : this.sqlNames) {
            if (!sQLNameHelper.getID().equalsIgnoreCase(designObject.getObjectID())) continue;
            return sQLNameHelper;
        }
        return null;
    }

    public boolean sqlNameExists(String string) {
        for (SQLNameHelper sQLNameHelper : this.sqlNames) {
            if (!sQLNameHelper.getID().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    protected void addToSQLNames(String string, String string2, String string3) {
        boolean bl = false;
        DesignObject designObject = null;
        if (this.getDesignPart() instanceof RelationalDesign) {
            designObject = string != null ? ((RelationalDesign)this.getDesignPart()).getTableSet().getByLongName(string + "." + string2) : ((RelationalDesign)this.getDesignPart()).getTableSet().getByName(string2);
            if (designObject == null) {
                designObject = string != null ? ((RelationalDesign)this.getDesignPart()).getTableViewSet().getByLongName(string + "." + string2) : ((RelationalDesign)this.getDesignPart()).getTableViewSet().getByName(string2);
                bl = true;
            }
        } else if (this.getDesignPart() instanceof LogicalDesign && (designObject = string != null ? ((LogicalDesign)this.getDesignPart()).getEntitySet().getByLongName(string + "." + string2) : ((LogicalDesign)this.getDesignPart()).getEntitySet().getByName(string2)) == null) {
            designObject = string != null ? ((LogicalDesign)this.getDesignPart()).getEntityViewSet().getByLongName(string + "." + string2) : ((LogicalDesign)this.getDesignPart()).getEntityViewSet().getByName(string2);
            bl = true;
        }
        if (designObject != null) {
            if (string3 != null) {
                ContainedObject containedObject = ((ContainerObject)designObject).getElementByName(string3);
                if (containedObject != null) {
                    if (!this.sqlNameExists(containedObject.getObjectID())) {
                        SQLNameHelper sQLNameHelper = new SQLNameHelper(false, false);
                        sQLNameHelper.setID(containedObject.getObjectID());
                        sQLNameHelper.setSchema(string);
                        sQLNameHelper.setTableName(string2);
                        sQLNameHelper.setColumnName(string3);
                        this.sqlNames.add(sQLNameHelper);
                    }
                    containedObject.addObjectListener(this);
                }
            } else {
                if (!this.sqlNameExists(designObject.getObjectID())) {
                    SQLNameHelper sQLNameHelper = new SQLNameHelper(true, bl);
                    sQLNameHelper.setID(designObject.getObjectID());
                    sQLNameHelper.setSchema(string);
                    sQLNameHelper.setTableName(string2);
                    this.sqlNames.add(sQLNameHelper);
                }
                designObject.addObjectListener(this);
            }
        }
    }

    public void validateSQL() {
        QueryBuilder queryBuilder = new QueryBuilder(true);
        PlainTextSQLBuilder plainTextSQLBuilder = new PlainTextSQLBuilder();
        plainTextSQLBuilder.setKeywordFormat(KeywordFormat.UpperCase);
        plainTextSQLBuilder.setQueryBuilder(queryBuilder);
        QBUtils.initProperties(this, queryBuilder, plainTextSQLBuilder, null, null, false);
        QBUtils.updateMetadata(this, queryBuilder, plainTextSQLBuilder, false);
        QBUtils.updateColumns(this, queryBuilder);
        QBUtils.setViewSQL(this, queryBuilder, plainTextSQLBuilder, true);
        this.setValidSQL(true);
        this.setParsed(true);
    }

    public void parseOlderStyleView(QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder) {
        QBUtils.initSQL(this, queryBuilder);
        QBUtils.updateColumns(this, queryBuilder);
        QBUtils.setViewSQL(this, queryBuilder, plainTextSQLBuilder, false);
        this.setValidSQL(true);
        this.setParsed(true);
    }

    public boolean includeSchemaNameInQuery() {
        return this.includeSchemaNameInQuery;
    }

    public void setIncludeSchemaNameInQuery(boolean bl) {
        this.includeSchemaNameInQuery = bl;
    }

    public List getUsedObjectsList() {
        return this.sqlNames;
    }

    public void addUsedObject(SQLNameHelper sQLNameHelper) {
        this.sqlNames.add(sQLNameHelper);
    }

    public SQLNameHelper createSQLNameHelper() {
        return new SQLNameHelper();
    }

    public SQLNameHelper getSQLNameHelperByID(String string) {
        if (string != null) {
            for (SQLNameHelper sQLNameHelper : this.sqlNames) {
                if (!string.equalsIgnoreCase(sQLNameHelper.getID())) continue;
                return sQLNameHelper;
            }
        }
        return null;
    }

    public boolean isValidSQL() {
        return this.validSQL;
    }

    public void setValidSQL(boolean bl) {
        if (this.validSQL != bl) {
            this.validSQL = bl;
            this.setDirty(true);
        }
    }

    public boolean isParsed() {
        if (!this.parsed) {
            return this.userDefinedSQL.length() == 0;
        }
        return this.parsed;
    }

    public void setParsed(boolean bl) {
        if (this.parsed != bl) {
            this.parsed = bl;
            this.setDirty(true);
        }
    }

    public boolean isIncorrectSQL() {
        return this.incorrectSQL;
    }

    public void setIncorrectSQL(boolean bl) {
        if (this.incorrectSQL != bl) {
            this.incorrectSQL = bl;
            this.setDirty(true);
        }
    }

    public String getUseObjectsOnlyFrom() {
        return this.useObjectsOnlyFrom;
    }

    public void setUseObjectsOnlyFrom(String string) {
        this.useObjectsOnlyFrom = string;
    }

    @Override
    public void clearElements() {
        this.phelements.removeAll();
        super.clearElements();
    }

    public String getSyntaxProvider() {
        return this.syntaxProvider;
    }

    public void setSyntaxProvider(String string) {
        this.syntaxProvider = string;
    }

    public class ViewNotAdded {
        private String id = "";
        private String alias = "";

        public ViewNotAdded(String string, String string2) {
            if (string2 != null) {
                this.alias = string2;
            }
            this.id = string;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getId() {
            return this.id;
        }
    }

    public class ContainerHolder {
        private String alias = "";
        private ContainerObject container;

        public ContainerHolder(ContainerObject containerObject, String string) {
            if (string != null) {
                this.alias = string;
            }
            this.container = containerObject;
        }

        public String getAlias() {
            return this.alias;
        }

        public ContainerObject getContainer() {
            return this.container;
        }
    }
}

