/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public abstract class AbstractLevelDomains
implements RepositoryObject {
    private Design design;
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private boolean checkedOut = false;
    private boolean checkedOutByMe = false;
    private String checkedOutBy = "";
    private boolean dirty = false;
    private TreeMap repositoryMap = new TreeMap();
    private RepositoryObject pac_Element;

    public AbstractLevelDomains(Design design) {
        this.design = design;
    }

    public abstract List getDomains();

    public abstract String getType();

    @Override
    public abstract String getName();

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public boolean canBedeleted() {
        return false;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean bl) {
        this.checkedOut = bl;
    }

    @Override
    public void setCheckedOutBy(String string) {
        this.checkedOutBy = string;
    }

    @Override
    public void setCheckedOutByMe(boolean bl) {
        this.checkedOutByMe = bl;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public void setRepositoryOID(String string) {
        this.repositoryOID = string;
    }

    @Override
    public void setRepositoryOVID(String string) {
        this.repositoryOVID = string;
    }

    public void createRepositoryMap() {
        this.repositoryMap.clear();
        for (DesignObject designObject : this.getDomains()) {
            if (designObject.getRepositoryOID() == null) continue;
            RepDeleteDescr repDeleteDescr = new RepDeleteDescr();
            repDeleteDescr.objectType = designObject.getObjectTypeName();
            repDeleteDescr.repOID = designObject.getRepositoryOID();
            repDeleteDescr.repOVID = designObject.getRepositoryOVID();
            this.repositoryMap.put(designObject.getObjectID(), repDeleteDescr);
        }
    }

    public List getObjectsToDeleteFromRepository() {
        Object object22;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Object object22 : this.getDomains()) {
            if (((ModelIDObject)object22).getRepositoryOID() == null) continue;
            treeMap.put(((ModelIDObject)object22).getObjectID(), ((ModelIDObject)object22).getObjectID());
        }
        object22 = new ArrayList();
        for (Map.Entry entry : this.repositoryMap.entrySet()) {
            Object v = treeMap.get(entry.getKey());
            if (v != null) continue;
            object22.add(entry.getValue());
        }
        return object22;
    }

    public void clearDomains() {
        List list = this.getDomains();
        for (int i = list.size() - 1; i >= 0; --i) {
            Domain domain = (Domain)list.get(i);
            if (!domain.isDefault()) continue;
            domain.remove();
        }
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject repositoryObject) {
        this.pac_Element = repositoryObject;
    }
}

