/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.udb;

import java.util.Map;
import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.MDFloat;
import oracle.dbtools.crest.model.datatype.MDUnknown;
import oracle.dbtools.crest.model.datatype.MDUserDefined_NoParams;
import oracle.dbtools.crest.model.datatype.udb.MDBigIntUDB;
import oracle.dbtools.crest.model.datatype.udb.MDBlobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDCharacterUDB;
import oracle.dbtools.crest.model.datatype.udb.MDClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDBClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDataLinkUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDateUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDecimalUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDoubleUDB;
import oracle.dbtools.crest.model.datatype.udb.MDGraphicUDB;
import oracle.dbtools.crest.model.datatype.udb.MDIntegerUDB;
import oracle.dbtools.crest.model.datatype.udb.MDLongVarGraphicUDB;
import oracle.dbtools.crest.model.datatype.udb.MDLongVarcharUDB;
import oracle.dbtools.crest.model.datatype.udb.MDRealUDB;
import oracle.dbtools.crest.model.datatype.udb.MDSmallIntUDB;
import oracle.dbtools.crest.model.datatype.udb.MDTimeStampUDB;
import oracle.dbtools.crest.model.datatype.udb.MDTimeUDB;
import oracle.dbtools.crest.model.datatype.udb.MDVarGraphicUDB;
import oracle.dbtools.crest.model.datatype.udb.MDVarcharUDB;

public class MDDataTypeFactoryUDB
extends MDDataTypeFactory {
    @Override
    protected void initFlyWeights() {
        Map map = this.getFlyWeights();
        map.put("UNKNOWN", new MDUnknown());
        map.put("REAL", new MDRealUDB());
        MDDoubleUDB mDDoubleUDB = new MDDoubleUDB();
        mDDoubleUDB.setFloatSynonym();
        map.put("DATALINK", new MDDataLinkUDB());
        map.put("DATE", new MDDateUDB());
        map.put("DOUBLE", new MDDoubleUDB());
        map.put("INTEGER", new MDIntegerUDB());
        map.put("REAL", new MDRealUDB());
        map.put("TIME", new MDTimeUDB());
        map.put("TIMESTAMP", new MDTimeStampUDB());
        MDVarcharUDB mDVarcharUDB = new MDVarcharUDB();
        mDVarcharUDB.setCharVaryingSynonym();
        map.put("CHAR VARYING", mDVarcharUDB);
        MDVarcharUDB mDVarcharUDB2 = new MDVarcharUDB();
        mDVarcharUDB2.setCharacterVaryingSynonym();
        map.put("CHARACTER VARYING", mDVarcharUDB2);
        MDDecimalUDB mDDecimalUDB = new MDDecimalUDB();
        mDDecimalUDB.setNumericSynonym();
        map.put("NUMERIC", mDDecimalUDB);
        map.put("XML", new MDUserDefined_NoParams("XML"));
    }

    @Override
    protected void initHeavyWeights() {
        Map map = this.getHeavyWeights();
        map.put("BLOB", MDBlobUDB.class);
        map.put("CLOB", MDClobUDB.class);
        map.put("CHAR", MDCharacterUDB.class);
        map.put("DECIMAL", MDDecimalUDB.class);
        map.put("VARCHAR", MDVarcharUDB.class);
        map.put("GRAPHIC", MDGraphicUDB.class);
        map.put("VARGRAPHIC", MDVarGraphicUDB.class);
        map.put("LONG VARCHAR", MDLongVarcharUDB.class);
        map.put("LONG VARGRAPHIC", MDLongVarGraphicUDB.class);
        map.put("DBCLOB", MDDBClobUDB.class);
        map.put("BIGINT", MDBigIntUDB.class);
        map.put("SMALLINT", MDSmallIntUDB.class);
        map.put("FLOAT", MDFloat.class);
    }

    @Override
    public MDDataType createType(String string, String string2) {
        AbstractDataType abstractDataType = null;
        if ("BLOB".equals(string)) {
            abstractDataType = new MDBlobUDB();
        } else if ("CLOB".equals(string)) {
            abstractDataType = new MDClobUDB();
        } else if ("DBCLOB".equals(string)) {
            abstractDataType = new MDDBClobUDB();
        } else if ("CHAR".equals(string)) {
            abstractDataType = new MDCharacterUDB();
        } else if ("VARCHAR".equals(string)) {
            abstractDataType = new MDVarcharUDB();
        } else if ("GRAPHIC".equals(string)) {
            abstractDataType = new MDGraphicUDB();
        } else if ("VARGRAPHIC".equals(string)) {
            abstractDataType = new MDVarGraphicUDB();
        } else if ("LONG VARGRAPHIC".equals(string)) {
            abstractDataType = new MDLongVarGraphicUDB();
        } else {
            if ("DECIMAL".equals(string)) {
                abstractDataType = new MDDecimalUDB();
                abstractDataType.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return abstractDataType;
            }
            if ("NUMERIC".equals(string)) {
                MDDecimalUDB mDDecimalUDB = new MDDecimalUDB();
                mDDecimalUDB.setNumericSynonym();
                mDDecimalUDB.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return mDDecimalUDB;
            }
            if ("FLOAT".equals(string)) {
                abstractDataType = new MDFloat();
                abstractDataType.setPrecision(MDDataTypeFactory.stringToInt(string2));
                return abstractDataType;
            }
        }
        if (abstractDataType != null) {
            abstractDataType.setSize(string2);
        }
        return abstractDataType;
    }

    @Override
    public MDDataType createType(String string, int n, int n2) {
        MDDecimalUDB mDDecimalUDB = null;
        if ("DECIMAL".equals(string)) {
            mDDecimalUDB = new MDDecimalUDB();
            mDDecimalUDB.setPrecision(n);
            mDDecimalUDB.setScale(n2);
            return mDDecimalUDB;
        }
        if ("NUMERIC".equals(string)) {
            MDDecimalUDB mDDecimalUDB2 = new MDDecimalUDB();
            mDDecimalUDB2.setNumericSynonym();
            mDDecimalUDB2.setPrecision(n);
            mDDecimalUDB2.setScale(n2);
            return mDDecimalUDB2;
        }
        return null;
    }
}

