/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle.v9i;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDYearToMonthOraclev9i
extends MDPackedSized {
    private String name = "INTERVAL YEAR TO MONTH";

    public MDYearToMonthOraclev9i() {
        this.precision = 2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getNameFirstPart() {
        return "INTERVAL YEAR";
    }

    protected String getNameSecondPart() {
        return " TO MONTH";
    }

    @Override
    public String getMaxSize() {
        return "31";
    }

    @Override
    public MDDataType deepCopy() {
        MDYearToMonthOraclev9i mDYearToMonthOraclev9i = new MDYearToMonthOraclev9i();
        mDYearToMonthOraclev9i.setPrecision(this.getPrecision());
        return mDYearToMonthOraclev9i;
    }

    @Override
    public void setPrecision(int n) {
        if (n >= 0 && n <= 9) {
            this.precision = n;
        }
    }

    public void setPrecision(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= 0 && n <= 9) {
                this.precision = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.precision = 2;
        }
    }

    @Override
    public String getScaleText() {
        return Messages.getString("MDYearToMonthOracle.NA");
    }

    @Override
    public String getPrecisionText() {
        return Messages.getString("MDYearToMonthOracle.YearPrecision");
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    @Override
    public void appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.getNameFirstPart());
        if (this.getPrecision() != 2) {
            stringBuffer.append(" (");
            stringBuffer.append(this.getPrecision());
            stringBuffer.append(")");
        }
        stringBuffer.append(this.getNameSecondPart());
    }
}

