/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle.v9i;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDDayToSecondOraclev9i
extends MDPackedSized {
    private String name = "INTERVAL DAY TO SECOND";

    public MDDayToSecondOraclev9i() {
        this.precision = 2;
        this.scale = 6;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMaxSize() {
        return "31";
    }

    @Override
    public MDDataType deepCopy() {
        MDDayToSecondOraclev9i mDDayToSecondOraclev9i = new MDDayToSecondOraclev9i();
        mDDayToSecondOraclev9i.setPrecision(this.getPrecision());
        return mDDayToSecondOraclev9i;
    }

    @Override
    public void setPrecision(int n) {
        if (n >= 0 && n <= 9) {
            this.precision = n;
            this.fireSizeChange();
        }
    }

    public void setPrecision(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= 0 && n <= 9) {
                this.precision = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.precision = 2;
        }
    }

    @Override
    public void appendTo(StringBuffer stringBuffer) {
        stringBuffer.append("INTERVAL DAY");
        if (this.precision != 2) {
            stringBuffer.append(" (");
            stringBuffer.append(this.precision);
            stringBuffer.append(')');
        }
        stringBuffer.append(" TO SECOND");
        if (this.scale != 6) {
            stringBuffer.append(" (");
            stringBuffer.append(this.scale);
            stringBuffer.append(')');
        }
    }

    @Override
    public String getScaleText() {
        return Messages.getString("MDDayToSecondOracle.FractionalSecondsPrecision");
    }

    @Override
    public String getPrecisionText() {
        return Messages.getString("MDDayToSecondOracle.DayPrecision");
    }

    @Override
    public boolean hasScale() {
        return false;
    }
}

