/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle;

import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDVarSized;
import oracle.dbtools.crest.util.options.Settings;

public class MDVarChar2Oracle
extends MDVarSized {
    String name = "VARCHAR2";
    Settings settings;

    public MDVarChar2Oracle() {
    }

    public MDVarChar2Oracle(Settings settings) {
        this.settings = settings;
    }

    @Override
    public String getMaxSize() {
        return "4000";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MDDataType deepCopy() {
        MDVarChar2Oracle mDVarChar2Oracle = new MDVarChar2Oracle(this.settings);
        mDVarChar2Oracle.setSize(this.getSize());
        return mDVarChar2Oracle;
    }

    @Override
    public int getByteSize() {
        return AbstractDataType.parseSize(this.getSize()) + 2;
    }

    @Override
    public void appendTo(StringBuffer stringBuffer) {
        String string = this.size;
        if (string != null && string.indexOf(32) > 0) {
            String[] stringArray = string.split(" ");
            if (stringArray.length == 2 && (stringArray[1].equalsIgnoreCase("BYTE") || stringArray[1].equalsIgnoreCase("CHAR"))) {
                stringBuffer.append(this.getName());
                stringBuffer.append(" (");
                if (this.settings != null && this.settings.isShowByteCharInDDL()) {
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append(stringArray[0]);
                }
                stringBuffer.append(')');
                return;
            }
            string = stringArray[0];
        }
        if (string == null || "".equalsIgnoreCase(string) || "0".equalsIgnoreCase(string)) {
            stringBuffer.append(this.getName());
        } else {
            stringBuffer.append(this.getName());
            stringBuffer.append(" (");
            stringBuffer.append(this.getSize());
            stringBuffer.append(')');
        }
    }

    public void setVarcharSynonym() {
        this.name = "VARCHAR";
    }
}

