/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.MDFloat;
import oracle.dbtools.crest.model.datatype.MDUnknown;
import oracle.dbtools.crest.model.datatype.oracle.MDBFileOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDBlobOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDCharOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDClobOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDDateOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDDecimalOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDFixedSizeOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDLongOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDLongRowOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNCharOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNClobOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNVarChar2Oracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNumberOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNumericOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDRawOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDRowIDOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDURowIDOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDVarChar2Oracle;
import oracle.dbtools.crest.util.options.Settings;

public class MDDataTypeFactoryOracle
extends MDDataTypeFactory {
    protected Settings settings;

    public MDDataTypeFactoryOracle(Settings settings) {
        this.settings = settings;
    }

    @Override
    protected void initFlyWeights() {
        this.flyweights.put("UNKNOWN", new MDUnknown());
        this.flyweights.put("DATE", new MDDateOracle());
        this.flyweights.put("LONG", new MDLongOracle());
        this.flyweights.put("LONG VARCHAR", new MDLongOracle());
        MDFixedSizeOracle mDFixedSizeOracle = new MDFixedSizeOracle();
        mDFixedSizeOracle.setIntegerSynonym();
        this.flyweights.put("INTEGER", mDFixedSizeOracle);
        this.flyweights.put("INT", mDFixedSizeOracle);
        MDFixedSizeOracle mDFixedSizeOracle2 = new MDFixedSizeOracle();
        mDFixedSizeOracle2.setSmallIntSynonym();
        this.flyweights.put("SMALLINT", mDFixedSizeOracle2);
        MDFixedSizeOracle mDFixedSizeOracle3 = new MDFixedSizeOracle();
        mDFixedSizeOracle3.setRealSynonym();
        this.flyweights.put("REAL", mDFixedSizeOracle3);
        MDFixedSizeOracle mDFixedSizeOracle4 = new MDFixedSizeOracle();
        mDFixedSizeOracle4.setDoubleSynonym();
        this.flyweights.put("DOUBLE", mDFixedSizeOracle4);
        this.flyweights.put("LONG RAW", new MDLongRowOracle());
        this.flyweights.put("ROWID", new MDRowIDOracle());
        this.flyweights.put("BLOB", new MDBlobOracle());
        this.flyweights.put("CLOB", new MDClobOracle());
        this.flyweights.put("NCLOB", new MDNClobOracle());
        this.flyweights.put("BFILE", new MDBFileOracle());
        this.initFlyWeightsTimeTypes();
    }

    protected void initFlyWeightsTimeTypes() {
        this.flyweights.put("TIME", new MDDateOracle());
        this.flyweights.put("TIMESTAMP", new MDDateOracle());
    }

    @Override
    protected void initHeavyWeights() {
        this.heavyweights.put("VARCHAR", MDVarChar2Oracle.class);
        this.heavyweights.put("VARCHAR2", MDVarChar2Oracle.class);
        this.heavyweights.put("NVARCHAR2", MDNVarChar2Oracle.class);
        this.heavyweights.put("NVARCHAR", MDNVarChar2Oracle.class);
        this.heavyweights.put("RAW", MDRawOracle.class);
        this.heavyweights.put("ROWID", MDRowIDOracle.class);
        this.heavyweights.put("UROWID", MDURowIDOracle.class);
        this.heavyweights.put("NUMBER", MDNumberOracle.class);
        this.heavyweights.put("DECIMAL", MDDecimalOracle.class);
        this.heavyweights.put("DEC", MDDecimalOracle.class);
        this.heavyweights.put("NUMERIC", MDNumericOracle.class);
        this.heavyweights.put("CHAR", MDCharOracle.class);
        this.heavyweights.put("NCHAR", MDNCharOracle.class);
        this.heavyweights.put("FLOAT", MDFloat.class);
    }

    @Override
    public MDDataType createType(String string, String string2) {
        MDDataType mDDataType = null;
        if ("CHAR".equals(string) || "CHARACTER".equals(string)) {
            mDDataType = new MDCharOracle(this.settings);
        } else if ("NCHAR".equals(string)) {
            mDDataType = new MDNCharOracle();
        } else if ("VARCHAR2".equals(string)) {
            mDDataType = new MDVarChar2Oracle(this.settings);
        } else if ("VARCHAR".equals(string)) {
            mDDataType = new MDVarChar2Oracle(this.settings);
            ((MDVarChar2Oracle)mDDataType).setVarcharSynonym();
        } else if ("NVARCHAR2".equals(string)) {
            mDDataType = new MDNVarChar2Oracle();
        } else if ("NVARCHAR".equals(string)) {
            mDDataType = new MDNVarChar2Oracle();
        } else if ("RAW".equals(string)) {
            mDDataType = new MDRawOracle();
        } else if ("UROWID".equals(string)) {
            mDDataType = new MDURowIDOracle();
        } else {
            if ("NUMBER".equals(string)) {
                mDDataType = new MDNumberOracle();
                mDDataType.setPrecision(MDDataTypeFactoryOracle.stringToInt(string2));
                return mDDataType;
            }
            if ("NUMERIC".equals(string)) {
                MDNumberOracle mDNumberOracle = new MDNumberOracle();
                mDNumberOracle.setNumericSynonym();
                mDNumberOracle.setPrecision(MDDataTypeFactoryOracle.stringToInt(string2));
                return mDNumberOracle;
            }
            if ("DECIMAL".equals(string)) {
                MDNumberOracle mDNumberOracle = new MDNumberOracle();
                mDNumberOracle.setDecimalSynonym();
                mDNumberOracle.setPrecision(MDDataTypeFactoryOracle.stringToInt(string2));
                return mDNumberOracle;
            }
            if ("DEC".equals(string)) {
                MDNumberOracle mDNumberOracle = new MDNumberOracle();
                mDNumberOracle.setDecSynonym();
                mDNumberOracle.setPrecision(MDDataTypeFactoryOracle.stringToInt(string2));
                return mDNumberOracle;
            }
            if ("FLOAT".equals(string)) {
                MDFloat mDFloat = new MDFloat();
                mDDataType = mDFloat;
                mDDataType.setPrecision(MDDataTypeFactoryOracle.stringToInt(string2));
                return mDDataType;
            }
            if ("NATIONAL CHARACTER".equals(string)) {
                mDDataType = new MDNCharOracle();
            } else if ("NATIONAL CHARACTER VARYING".equals(string)) {
                mDDataType = new MDNVarChar2Oracle();
            } else if ("NATIONAL CHAR".equals(string)) {
                mDDataType = new MDNCharOracle();
            } else if ("NATIONAL CHAR VARYING".equals(string)) {
                mDDataType = new MDNVarChar2Oracle();
            } else if ("NCHAR VARYING".equals(string)) {
                mDDataType = new MDNVarChar2Oracle();
            }
        }
        if (mDDataType == null) {
            mDDataType = super.createUDNativeType(string, string2);
        } else {
            mDDataType.setSize(string2);
        }
        return mDDataType;
    }

    @Override
    public MDDataType createType(String string, int n, int n2) {
        if ("NUMBER".equals(string)) {
            MDNumberOracle mDNumberOracle = new MDNumberOracle();
            mDNumberOracle.setPrecision(n);
            mDNumberOracle.setScale(n2);
            return mDNumberOracle;
        }
        if ("NUMERIC".equals(string)) {
            MDNumberOracle mDNumberOracle = new MDNumberOracle();
            mDNumberOracle.setNumericSynonym();
            mDNumberOracle.setPrecision(n);
            mDNumberOracle.setScale(n2);
            return mDNumberOracle;
        }
        if ("DECIMAL".equals(string)) {
            MDNumberOracle mDNumberOracle = new MDNumberOracle();
            mDNumberOracle.setDecimalSynonym();
            mDNumberOracle.setPrecision(n);
            mDNumberOracle.setScale(n2);
            return mDNumberOracle;
        }
        if ("DEC".equals(string)) {
            MDNumberOracle mDNumberOracle = new MDNumberOracle();
            mDNumberOracle.setDecSynonym();
            mDNumberOracle.setPrecision(n);
            mDNumberOracle.setScale(n2);
            return mDNumberOracle;
        }
        if ("FLOAT".equals(string)) {
            MDFloat mDFloat = new MDFloat();
            return mDFloat;
        }
        return super.createUDNativeType(string, n, n2);
    }
}

