/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.datatype.MDDataTypeNames;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class StandardDatatypeNames
implements MDDataTypeNames {
    private static final Hashtable SYNONYM_TABLE = new Hashtable();
    private static final Logger LOGGER;
    private static Map ud_nativeMap;
    private static final String[] DB2v70_DATATYPES;
    private static String[] DB2v70_DATATYPES_ALL;
    private static final String[] DB2v80_DATATYPES;
    private static String[] DB2v80_DATATYPES_ALL;
    private static final String[] UDBv71_DATATYPES;
    private static String[] UDBv71_DATATYPES_ALL;
    private static final String[] UDBv81_DATATYPES;
    private static String[] UDBv81_DATATYPES_ALL;
    private static final String[] ORACLEv9i_DATATYPES;
    private static String[] ORACLEv9i_DATATYPES_ALL;
    private static final String[] ORACLEv10g_DATATYPES;
    private static String[] ORACLEv10g_DATATYPES_ALL;
    private static final String[] ORACLEv11g_DATATYPES;
    private static String[] ORACLEv11g_DATATYPES_ALL;
    private static final String[] SQL_SERVERv2k_DATATYPES;
    private static String[] SQL_SERVERv2k_DATATYPES_ALL;
    private static final String[] SQL_SERVERv2kv5_DATATYPES;
    private static String[] SQL_SERVERv2kv5_DATATYPES_ALL;
    private static String[] PACKED_SIZED;

    public static String getUsedDatatypeName(String string) {
        if (string != null) {
            String string2 = (String)SYNONYM_TABLE.get(string.toUpperCase());
            if (string2 != null) {
                return string2;
            }
            string2 = NotStandartDataTypeNames.getUsedNotStandartDatatypeName(string);
            if (string2 != null) {
                return string2;
            }
            return string;
        }
        return "UNKNOWN";
    }

    public static String getTransformedDatatypeName(String string, RDBMSType rDBMSType) {
        if ("VARCHAR".equalsIgnoreCase(string) && StandardDatatypeNames.isOracleRDBMSType(rDBMSType)) {
            return "VARCHAR2";
        }
        if ("NVARCHAR".equalsIgnoreCase(string) && StandardDatatypeNames.isOracleRDBMSType(rDBMSType)) {
            return "NVARCHAR2";
        }
        return string;
    }

    private static boolean isOracleRDBMSType(RDBMSType rDBMSType) {
        for (RDBMSType rDBMSType2 = rDBMSType; rDBMSType2 != null; rDBMSType2 = rDBMSType2.getParentType()) {
            if (rDBMSType2 != StorageDesignOraclev9i.RDBMS_TYPE) continue;
            return true;
        }
        return false;
    }

    public static String[] getAllPossibleDatatypes(String string) {
        if (string.equalsIgnoreCase("DB2/390 7")) {
            return DB2v70_DATATYPES_ALL;
        }
        if (string.equalsIgnoreCase("DB2/390 8")) {
            return DB2v80_DATATYPES_ALL;
        }
        if (string.equalsIgnoreCase("DB2/UDB 7.1")) {
            return UDBv71_DATATYPES_ALL;
        }
        if (string.equalsIgnoreCase("DB2/UDB 8.1")) {
            return UDBv81_DATATYPES_ALL;
        }
        if (string.equalsIgnoreCase("Oracle9i")) {
            return ORACLEv9i_DATATYPES_ALL;
        }
        if (string.equalsIgnoreCase("Oracle Database 10g")) {
            return ORACLEv10g_DATATYPES_ALL;
        }
        if (string.equalsIgnoreCase("Oracle Database 11g")) {
            return ORACLEv11g_DATATYPES_ALL;
        }
        if (string.equalsIgnoreCase("SQL Server 2000")) {
            return SQL_SERVERv2k_DATATYPES_ALL;
        }
        if (string.equalsIgnoreCase("SQL Server 2005")) {
            return SQL_SERVERv2kv5_DATATYPES_ALL;
        }
        return DB2v70_DATATYPES_ALL;
    }

    public static String[] getAllPossibleDatatypes(RDBMSType rDBMSType) {
        if (StorageDesignDB2v70.RDBMS_TYPE == rDBMSType) {
            return DB2v70_DATATYPES_ALL;
        }
        if (StorageDesignDB2v80.RDBMS_TYPE == rDBMSType) {
            return DB2v80_DATATYPES_ALL;
        }
        if (StorageDesignUDBv71.RDBMS_TYPE == rDBMSType) {
            return UDBv71_DATATYPES_ALL;
        }
        if (StorageDesignUDBv81.RDBMS_TYPE == rDBMSType) {
            return UDBv81_DATATYPES_ALL;
        }
        if (StorageDesignOraclev9i.RDBMS_TYPE == rDBMSType) {
            return ORACLEv9i_DATATYPES_ALL;
        }
        if (StorageDesignOraclev10g.RDBMS_TYPE == rDBMSType) {
            return ORACLEv10g_DATATYPES_ALL;
        }
        if (StorageDesignOraclev11g.RDBMS_TYPE == rDBMSType) {
            return ORACLEv11g_DATATYPES_ALL;
        }
        if (StorageDesignSqlServerv2k.RDBMS_TYPE == rDBMSType) {
            return SQL_SERVERv2k_DATATYPES_ALL;
        }
        if (StorageDesignSqlServerv2k5.RDBMS_TYPE == rDBMSType) {
            return SQL_SERVERv2kv5_DATATYPES_ALL;
        }
        return DB2v70_DATATYPES_ALL;
    }

    public static String[] getPredefinedNativeDatatypes(String string) {
        if (string.equalsIgnoreCase("DB2/390 7")) {
            return DB2v70_DATATYPES;
        }
        if (string.equalsIgnoreCase("DB2/390 8")) {
            return DB2v80_DATATYPES;
        }
        if (string.equalsIgnoreCase("DB2/UDB 7.1")) {
            return UDBv71_DATATYPES;
        }
        if (string.equalsIgnoreCase("DB2/UDB 8.1")) {
            return UDBv81_DATATYPES;
        }
        if (string.equalsIgnoreCase("Oracle9i")) {
            return ORACLEv9i_DATATYPES;
        }
        if (string.equalsIgnoreCase("Oracle Database 10g")) {
            return ORACLEv10g_DATATYPES;
        }
        if (string.equalsIgnoreCase("Oracle Database 11g")) {
            return ORACLEv11g_DATATYPES;
        }
        if (string.equalsIgnoreCase("SQL Server 2000")) {
            return SQL_SERVERv2k_DATATYPES;
        }
        if (string.equalsIgnoreCase("SQL Server 2005")) {
            return SQL_SERVERv2kv5_DATATYPES;
        }
        return DB2v70_DATATYPES;
    }

    public static String[] getPredefinedNativeDatatypes(RDBMSType rDBMSType) {
        if (StorageDesignDB2v70.RDBMS_TYPE == rDBMSType) {
            return DB2v70_DATATYPES;
        }
        if (StorageDesignDB2v80.RDBMS_TYPE == rDBMSType) {
            return DB2v80_DATATYPES;
        }
        if (StorageDesignUDBv71.RDBMS_TYPE == rDBMSType) {
            return UDBv71_DATATYPES;
        }
        if (StorageDesignUDBv81.RDBMS_TYPE == rDBMSType) {
            return UDBv81_DATATYPES;
        }
        if (StorageDesignOraclev9i.RDBMS_TYPE == rDBMSType) {
            return ORACLEv9i_DATATYPES;
        }
        if (StorageDesignOraclev10g.RDBMS_TYPE == rDBMSType) {
            return ORACLEv10g_DATATYPES;
        }
        if (StorageDesignOraclev11g.RDBMS_TYPE == rDBMSType) {
            return ORACLEv11g_DATATYPES;
        }
        if (StorageDesignSqlServerv2k.RDBMS_TYPE == rDBMSType) {
            return SQL_SERVERv2k_DATATYPES;
        }
        if (StorageDesignSqlServerv2k5.RDBMS_TYPE == rDBMSType) {
            return SQL_SERVERv2kv5_DATATYPES;
        }
        return DB2v70_DATATYPES;
    }

    public static boolean isPackedSized(String string) {
        for (int i = 0; i < PACKED_SIZED.length; ++i) {
            if (!PACKED_SIZED[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static void addUD_NativeType(RDBMSType rDBMSType, NativeDBType nativeDBType) {
        TreeMap<String, NativeDBType> treeMap = (TreeMap<String, NativeDBType>)ud_nativeMap.get(rDBMSType);
        if (treeMap == null) {
            treeMap = new TreeMap<String, NativeDBType>();
            ud_nativeMap.put(rDBMSType, treeMap);
        }
        treeMap.put(nativeDBType.getName(), nativeDBType);
    }

    public static void removeUD_NativeType(RDBMSType rDBMSType, NativeDBType nativeDBType) {
        Map map = (Map)ud_nativeMap.get(rDBMSType);
        if (map != null) {
            map.remove(nativeDBType.getName());
        }
    }

    public static Map getUD_NativeTypesMap(RDBMSType rDBMSType) {
        TreeMap treeMap = (TreeMap)ud_nativeMap.get(rDBMSType);
        if (treeMap == null) {
            treeMap = new TreeMap();
            ud_nativeMap.put(rDBMSType, treeMap);
        }
        return treeMap;
    }

    public static List getUD_NativeTypesAsList(RDBMSType rDBMSType) {
        TreeMap treeMap = (TreeMap)ud_nativeMap.get(rDBMSType);
        if (treeMap == null) {
            treeMap = new TreeMap();
            ud_nativeMap.put(rDBMSType, treeMap);
        }
        return new ArrayList(treeMap.values());
    }

    public static void clearUD_NativeTypes() {
        for (Map map : ud_nativeMap.values()) {
            if (map == null) continue;
            map.clear();
        }
    }

    public static void applyUD_NativeTypes(Map map) {
    }

    public static Map getUd_nativeMap() {
        return ud_nativeMap;
    }

    public static NativeDBType getNativeDBType(RDBMSType rDBMSType, String string) {
        for (RDBMSType rDBMSType2 = rDBMSType; rDBMSType2 != null; rDBMSType2 = rDBMSType2.getParentType()) {
            Map map = StandardDatatypeNames.getUD_NativeTypesMap(rDBMSType2);
            if (map == null) continue;
            NativeDBType nativeDBType = (NativeDBType)map.get(string);
            if (nativeDBType != null) {
                return nativeDBType;
            }
            String string2 = string.toUpperCase();
            if (string2.equals(string)) {
                string2 = string.toLowerCase();
            }
            if ((nativeDBType = (NativeDBType)map.get(string2)) == null) continue;
            return nativeDBType;
        }
        return null;
    }

    static {
        ud_nativeMap = new TreeMap();
        LOGGER = new Logger(StandardDatatypeNames.class);
        SYNONYM_TABLE.put("INTEGER", "INTEGER");
        SYNONYM_TABLE.put("INT", "INTEGER");
        SYNONYM_TABLE.put("DEC", "DECIMAL");
        SYNONYM_TABLE.put("DECIMAL", "DECIMAL");
        SYNONYM_TABLE.put("CHARACTER", "CHAR");
        SYNONYM_TABLE.put("CHAR", "CHAR");
        SYNONYM_TABLE.put("BOOLEAN", "BOOLEAN");
        SYNONYM_TABLE.put("VARCHAR2", "VARCHAR2");
        SYNONYM_TABLE.put("VARCHAR", "VARCHAR");
        SYNONYM_TABLE.put("CHAR VARYING", "VARCHAR");
        SYNONYM_TABLE.put("CHARACTER VARYING", "VARCHAR");
        SYNONYM_TABLE.put("CLOB", "CLOB");
        SYNONYM_TABLE.put("CHAR LARGE OBJECT", "CLOB");
        SYNONYM_TABLE.put("CHARACTER LARGE OBJECT", "CLOB");
        SYNONYM_TABLE.put("BLOB", "BLOB");
        SYNONYM_TABLE.put("BINARY LARGE OBJECT", "BLOB");
        SYNONYM_TABLE.put("DOUBLE PRECISION", "NUMBER");
        SYNONYM_TABLE.put("DOUBLE", "DOUBLE");
        SYNONYM_TABLE.put("FLOAT", "FLOAT");
        SYNONYM_TABLE.put("REAL", "REAL");
        SYNONYM_TABLE.put("DATALINK", "DATALINK");
        SYNONYM_TABLE.put("NUMERIC", "NUMERIC");
        SYNONYM_TABLE.put("NUM", "NUMERIC");
        SYNONYM_TABLE.put("GRAPHIC", "GRAPHIC");
        SYNONYM_TABLE.put("TIME", "TIME");
        SYNONYM_TABLE.put("DATE", "DATE");
        SYNONYM_TABLE.put("TIMESTAMP", "TIMESTAMP");
        SYNONYM_TABLE.put("BIGINT", "BIGINT");
        SYNONYM_TABLE.put("SMALLINT", "SMALLINT");
        SYNONYM_TABLE.put("UNKNOWN", "UNKNOWN");
        SYNONYM_TABLE.put("VARGRAPHIC", "VARGRAPHIC");
        SYNONYM_TABLE.put("LONG VARCHAR", "LONG VARCHAR");
        SYNONYM_TABLE.put("LONG VARGRAPHIC", "LONG VARGRAPHIC");
        SYNONYM_TABLE.put("NUMBER", "NUMBER");
        SYNONYM_TABLE.put("ROWID", "ROWID");
        SYNONYM_TABLE.put("DBCLOB", "DBCLOB");
        SYNONYM_TABLE.put("BFILE", "BFILE");
        SYNONYM_TABLE.put("LONG", "LONG");
        SYNONYM_TABLE.put("LONG RAW", "LONG RAW");
        SYNONYM_TABLE.put("NCLOB", "NCLOB");
        SYNONYM_TABLE.put("NVARCHAR2", "NVARCHAR2");
        SYNONYM_TABLE.put("RAW", "RAW");
        SYNONYM_TABLE.put("UROWID", "UROWID");
        SYNONYM_TABLE.put("TEXT", "TEXT");
        SYNONYM_TABLE.put("NVARCHAR", "NVARCHAR");
        SYNONYM_TABLE.put("NTEXT", "NTEXT");
        SYNONYM_TABLE.put("TINYINT", "TINYINT");
        SYNONYM_TABLE.put("BIT", "BIT");
        SYNONYM_TABLE.put("MONEY", "MONEY");
        SYNONYM_TABLE.put("SMALLMONEY", "SMALLMONEY");
        SYNONYM_TABLE.put("DATETIME", "DATETIME");
        SYNONYM_TABLE.put("SMALLDATETIME", "SMALLDATETIME");
        SYNONYM_TABLE.put("BINARY", "BINARY");
        SYNONYM_TABLE.put("VARBINARY", "VARBINARY");
        SYNONYM_TABLE.put("IMAGE", "IMAGE");
        SYNONYM_TABLE.put("SQL_VARIANT", "SQL_VARIANT");
        SYNONYM_TABLE.put("SYSNAME", "SYSNAME");
        SYNONYM_TABLE.put("NCHAR", "NCHAR");
        SYNONYM_TABLE.put("UNIQUEIDENTIFIER", "UNIQUEIDENTIFIER");
        SYNONYM_TABLE.put("STRING", "UNIQUEIDENTIFIER");
        SYNONYM_TABLE.put("SHORT", "SMALLINT");
        SYNONYM_TABLE.put("UNSIGNEDBYTE", "SMALLINT");
        SYNONYM_TABLE.put("UNSIGNEDINT", "SMALLINT");
        SYNONYM_TABLE.put("BASE64BINARY", "BINARY");
        SYNONYM_TABLE.put("XML", "XML");
        SYNONYM_TABLE.put("NATIONAL CHARACTER", "NCHAR");
        SYNONYM_TABLE.put("NATIONAL CHAR", "NCHAR");
        SYNONYM_TABLE.put("NATIONAL CHARACTER VARYING", "NVARCHAR");
        SYNONYM_TABLE.put("NATIONAL CHAR VARYING", "NVARCHAR");
        SYNONYM_TABLE.put("NCHAR VARYING", "NVARCHAR");
        SYNONYM_TABLE.put("TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH TIME ZONE");
        SYNONYM_TABLE.put("TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE");
        SYNONYM_TABLE.put("INTERVAL YEAR TO MONTH", "INTERVAL YEAR TO MONTH");
        SYNONYM_TABLE.put("INTERVAL DAY TO SECOND", "INTERVAL DAY TO SECOND");
        SYNONYM_TABLE.put("XMLTYPE", "XMLTYPE");
        SYNONYM_TABLE.put("URITYPE", "URITYPE");
        SYNONYM_TABLE.put("HTTPURITYPE", "HTTPURITYPE");
        SYNONYM_TABLE.put("XDBURITYPE", "XDBURITYPE");
        SYNONYM_TABLE.put("DBURITYPE", "DBURITYPE");
        SYNONYM_TABLE.put("SYS.ANYDATA", "SYS.ANYDATA");
        SYNONYM_TABLE.put("SYS.ANYDATASET", "SYS.ANYDATASET");
        SYNONYM_TABLE.put("SYS.ANYTYPE", "SYS.ANYTYPE");
        SYNONYM_TABLE.put("ANYDATA", "SYS.ANYDATA");
        SYNONYM_TABLE.put("ANYDATASET", "SYS.ANYDATASET");
        SYNONYM_TABLE.put("ANYTYPE", "SYS.ANYTYPE");
        SYNONYM_TABLE.put("ORDSYS.ORDAudio".toUpperCase(), "ORDSYS.ORDAudio");
        SYNONYM_TABLE.put("ORDSYS.ORDDoc".toUpperCase(), "ORDSYS.ORDDoc");
        SYNONYM_TABLE.put("ORDSYS.ORDImage".toUpperCase(), "ORDSYS.ORDImage");
        SYNONYM_TABLE.put("ORDSYS.ORDImageSignature".toUpperCase(), "ORDSYS.ORDImageSignature");
        SYNONYM_TABLE.put("ORDSYS.ORDVideo".toUpperCase(), "ORDSYS.ORDVideo");
        SYNONYM_TABLE.put("ORDAudio".toUpperCase(), "ORDSYS.ORDAudio");
        SYNONYM_TABLE.put("ORDDoc".toUpperCase(), "ORDSYS.ORDDoc");
        SYNONYM_TABLE.put("ORDImage".toUpperCase(), "ORDSYS.ORDImage");
        SYNONYM_TABLE.put("ORDImageSignature".toUpperCase(), "ORDSYS.ORDImageSignature");
        SYNONYM_TABLE.put("ORDVideo".toUpperCase(), "ORDSYS.ORDVideo");
        SYNONYM_TABLE.put("BINARY_FLOAT", "BINARY_FLOAT");
        SYNONYM_TABLE.put("BINARY_DOUBLE", "BINARY_DOUBLE");
        SYNONYM_TABLE.put("LARGE BINARY", "BLOB");
        SYNONYM_TABLE.put("TIMESTAMP WITH TZ", "TIMESTAMP WITH TIME ZONE");
        SYNONYM_TABLE.put("TIMESTAMP WITH LOCAL TZ", "TIMESTAMP WITH LOCAL TIME ZONE");
        DB2v70_DATATYPES = new String[]{"BINARY LARGE OBJECT", "BLOB", "CHAR VARYING", "CHARACTER VARYING", "CHAR LARGE OBJECT", "CHARACTER LARGE OBJECT", "CHARACTER", "CHAR", "CLOB", "DATE", "DBCLOB", "DECIMAL", "DEC", "DOUBLE", "FLOAT", "GRAPHIC", "INTEGER", "INT", "LONG VARCHAR", "LONG VARGRAPHIC", "NUMERIC", "REAL", "ROWID", "SMALLINT", "TIMESTAMP", "TIME", "VARCHAR", "VARGRAPHIC", "UNKNOWN"};
        DB2v70_DATATYPES_ALL = DB2v70_DATATYPES;
        DB2v80_DATATYPES = new String[]{"BINARY LARGE OBJECT", "BLOB", "CHAR", "CHARACTER", "CHAR VARYING", "CHARACTER VARYING", "CHAR LARGE OBJECT", "CHARACTER LARGE OBJECT", "CLOB", "DATE", "DBCLOB", "DECIMAL", "DEC", "DOUBLE", "FLOAT", "GRAPHIC", "INTEGER", "INT", "LONG VARCHAR", "LONG VARGRAPHIC", "NUMERIC", "REAL", "ROWID", "SMALLINT", "TIME", "TIMESTAMP", "VARCHAR", "VARGRAPHIC", "UNKNOWN"};
        DB2v80_DATATYPES_ALL = DB2v80_DATATYPES;
        UDBv71_DATATYPES = new String[]{"BIGINT", "BLOB", "CHAR VARYING", "CHARACTER VARYING", "CHARACTER", "CHAR", "CLOB", "DATALINK", "DATE", "DBCLOB", "DECIMAL", "DEC", "DOUBLE", "GRAPHIC", "FLOAT", "INTEGER", "INT", "LONG VARCHAR", "LONG VARGRAPHIC", "NUMERIC", "NUM", "REAL", "SMALLINT", "TIMESTAMP", "TIME", "VARCHAR", "VARGRAPHIC", "UNKNOWN"};
        UDBv71_DATATYPES_ALL = UDBv71_DATATYPES;
        UDBv81_DATATYPES = new String[]{"BIGINT", "BLOB", "CHAR VARYING", "CHARACTER VARYING", "CHARACTER", "CHAR", "CLOB", "DATALINK", "DATE", "DBCLOB", "DECIMAL", "DEC", "DOUBLE", "GRAPHIC", "FLOAT", "INTEGER", "INT", "LONG VARCHAR", "LONG VARGRAPHIC", "NUMERIC", "NUM", "REAL", "SMALLINT", "TIMESTAMP", "TIME", "VARCHAR", "VARGRAPHIC", "XML", "UNKNOWN"};
        UDBv81_DATATYPES_ALL = UDBv81_DATATYPES;
        ORACLEv9i_DATATYPES = new String[]{"BFILE", "BLOB", "CHARACTER VARYING", "CHARACTER", "CHAR VARYING", "CHAR", "CLOB", "DATE", "DECIMAL", "DEC", "FLOAT", "INTEGER", "INT", "INTERVAL DAY TO SECOND", "INTERVAL YEAR TO MONTH", "LONG RAW", "LONG", "NATIONAL CHARACTER VARYING", "NATIONAL CHARACTER", "NATIONAL CHAR VARYING", "NATIONAL CHAR", "NCHAR VARYING", "NCHAR", "NCLOB", "NUMBER", "NUMERIC", "NVARCHAR2", "RAW", "REAL", "ROWID", "SMALLINT", "TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP", "UROWID", "VARCHAR2", "VARCHAR", "XMLTYPE", "URITYPE", "HTTPURITYPE", "XDBURITYPE", "DBURITYPE", "SYS.ANYDATA", "SYS.ANYDATASET", "SYS.ANYTYPE", "ORDSYS.ORDAudio", "ORDSYS.ORDDoc", "ORDSYS.ORDImage", "ORDSYS.ORDImageSignature", "ORDSYS.ORDVideo", "UNKNOWN"};
        ORACLEv9i_DATATYPES_ALL = ORACLEv9i_DATATYPES;
        ORACLEv10g_DATATYPES = new String[]{"BFILE", "BINARY_DOUBLE", "BINARY_FLOAT", "BLOB", "CHARACTER VARYING", "CHARACTER", "CHAR VARYING", "CHAR", "CLOB", "DATE", "DECIMAL", "DEC", "FLOAT", "INTEGER", "INT", "INTERVAL DAY TO SECOND", "INTERVAL YEAR TO MONTH", "LONG RAW", "LONG", "NATIONAL CHARACTER VARYING", "NATIONAL CHARACTER", "NATIONAL CHAR VARYING", "NATIONAL CHAR", "NCHAR VARYING", "NCHAR", "NCLOB", "NUMBER", "NUMERIC", "NVARCHAR2", "RAW", "REAL", "ROWID", "SMALLINT", "TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP", "UROWID", "VARCHAR2", "VARCHAR", "XMLTYPE", "URITYPE", "HTTPURITYPE", "XDBURITYPE", "DBURITYPE", "SYS.ANYDATA", "SYS.ANYDATASET", "SYS.ANYTYPE", "ORDSYS.ORDAudio", "ORDSYS.ORDDoc", "ORDSYS.ORDImage", "ORDSYS.ORDImageSignature", "ORDSYS.ORDVideo", "UNKNOWN"};
        ORACLEv10g_DATATYPES_ALL = Arrays.copyOf(ORACLEv10g_DATATYPES, ORACLEv10g_DATATYPES.length);
        ORACLEv11g_DATATYPES = new String[]{"BFILE", "BINARY_DOUBLE", "BINARY_FLOAT", "BLOB", "CHARACTER VARYING", "CHARACTER", "CHAR VARYING", "CHAR", "CLOB", "DATE", "DECIMAL", "DEC", "FLOAT", "INTEGER", "INT", "INTERVAL DAY TO SECOND", "INTERVAL YEAR TO MONTH", "LONG RAW", "LONG", "NATIONAL CHARACTER VARYING", "NATIONAL CHARACTER", "NATIONAL CHAR VARYING", "NATIONAL CHAR", "NCHAR VARYING", "NCHAR", "NCLOB", "NUMBER", "NUMERIC", "NVARCHAR2", "RAW", "REAL", "ROWID", "SMALLINT", "TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP", "UROWID", "VARCHAR2", "VARCHAR", "XMLTYPE", "URITYPE", "HTTPURITYPE", "XDBURITYPE", "DBURITYPE", "SYS.ANYDATA", "SYS.ANYDATASET", "SYS.ANYTYPE", "ORDSYS.ORDAudio", "ORDSYS.ORDDoc", "ORDSYS.ORDImage", "ORDSYS.ORDImageSignature", "ORDSYS.ORDVideo", "UNKNOWN"};
        ORACLEv11g_DATATYPES_ALL = ORACLEv11g_DATATYPES;
        SQL_SERVERv2k_DATATYPES = new String[]{"BIGINT", "BINARY", "BIT", "CHAR", "DATE", "DATETIME", "DECIMAL", "DOUBLE", "FLOAT", "IMAGE", "INT", "INTEGER", "MONEY", "NCHAR", "NTEXT", "NUMERIC", "NVARCHAR", "REAL", "SMALLDATETIME", "SMALLINT", "SMALLMONEY", "SQL_VARIANT", "SYSNAME", "TEXT", "TIMESTAMP", "TINYINT", "VARBINARY", "VARCHAR", "UNIQUEIDENTIFIER", "UNKNOWN"};
        SQL_SERVERv2k_DATATYPES_ALL = SQL_SERVERv2k_DATATYPES;
        SQL_SERVERv2kv5_DATATYPES = new String[]{"BIGINT", "BINARY", "BIT", "CHAR", "DATE", "DATETIME", "DECIMAL", "DOUBLE", "FLOAT", "IMAGE", "INT", "INTEGER", "MONEY", "NCHAR", "NTEXT", "NUMERIC", "NVARCHAR", "REAL", "SMALLDATETIME", "SMALLINT", "SMALLMONEY", "SQL_VARIANT", "XML", "SYSNAME", "TEXT", "TIMESTAMP", "TINYINT", "VARBINARY", "VARCHAR", "UNIQUEIDENTIFIER", "UNKNOWN"};
        SQL_SERVERv2kv5_DATATYPES_ALL = SQL_SERVERv2kv5_DATATYPES;
        PACKED_SIZED = new String[]{"NUMBER", "DECIMAL", "DEC", "FLOAT", "TIMESTAMP", "NUMERIC", "REAL", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "INTERVAL YEAR TO MONTH", "INTERVAL DAY TO SECOND"};
    }
}

