/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDExplicitSized;

public abstract class MDPackedSized
extends MDExplicitSized {
    public static final int MAX_PRECISION = 31;
    protected int scale;
    protected int precision;

    @Override
    public void setScale(int n) {
        this.scale = n;
        this.fireSizeChange();
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setPrecision(int n) {
        this.precision = n;
        this.fireSizeChange();
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public String getSize() {
        return Integer.toString(this.getPrecision() / 2 + 1);
    }

    @Override
    public boolean isPacked() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendTo(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public void appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
        boolean bl = false;
        if (this.getPrecision() > 0) {
            stringBuffer.append(" (");
            if (this.getPrecision() > 0) {
                stringBuffer.append(this.getPrecision());
                bl = true;
            }
            if (this.getScale() > 0) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.getScale());
            }
            stringBuffer.append(')');
        }
    }

    @Override
    public boolean hasPrecision() {
        return true;
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public String getPrecisionText() {
        return Messages.getString("MDPackedSized.Precision");
    }

    @Override
    public String getScaleText() {
        return Messages.getString("MDPackedSized.Scale");
    }
}

