/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIContactSet;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIDocumentSet;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BIEmailSet;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BILocationSet;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIPhoneSet;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocatorSet;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.businessinfo.BIResponsiblePartySet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.businessinfo.BusinessInfoModelPropertiesDialog;

public class BusinessInfoDesign
extends DesignPart {
    public static final String OBJECT_TYPE_NAME = "Business Information";
    public static final String DOCUMENT_SET_NAME = "Documents";
    public static final String RES_PARTY_SET_NAME = "Responsible Parties";
    public static final String CONTACT_SET_NAME = "Contacts";
    public static final String EMAIL_SET_NAME = "EMails";
    public static final String LOCATION_SET_NAME = "Locations";
    public static final String PHONE_SET_NAME = "Telephones";
    public static final String URL_SET_NAME = "Resource Locators";
    private BIDocumentSet docSet;
    private BIResponsiblePartySet resPartySet;
    private BIContactSet contactSet;
    private BIEmailSet emailSet;
    private BILocationSet locationSet;
    private BIPhoneSet phoneSet;
    private BIResourceLocatorSet urlSet;

    public BusinessInfoDesign(Design design) {
        this.setDesign(design);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    @Override
    public void clearAll() {
        this.getDocumentSet().removeAll();
        this.getResPartySet().removeAll();
        this.getContactSet().removeAll();
        this.getEmailSet().removeAll();
        this.getLocationSet().removeAll();
        this.getPhoneSet().removeAll();
        this.getUrlSet().removeAll();
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> arrayList = new ArrayList<DesignObjectSet>();
        arrayList.add(this.getEmailSet());
        arrayList.add(this.getLocationSet());
        arrayList.add(this.getPhoneSet());
        arrayList.add(this.getUrlSet());
        arrayList.add(this.getContactSet());
        arrayList.add(this.getResPartySet());
        arrayList.add(this.getDocumentSet());
        return arrayList;
    }

    @Override
    public void sortCollections() {
        this.getDocumentSet().sort();
        this.getResPartySet().sort();
        this.getContactSet().sort();
        this.getEmailSet().sort();
        this.getLocationSet().sort();
        this.getPhoneSet().sort();
        this.getUrlSet().sort();
    }

    @Override
    public void doAfterLoad() {
        this.createFilesMap();
        this.setLoaded(true);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        XMLPersistenceManager xMLPersistenceManager = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader abstractXMLReader = xMLPersistenceManager.getDesignPartReader(this);
        if (abstractXMLReader != null) {
            abstractXMLReader.recreateDesign(this.getName(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    protected DesignPartView createDesignPartSubView(String string) {
        return null;
    }

    @Override
    public DesignPartView getMainView() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "BI";
    }

    public BIContactSet getContactSet() {
        if (this.contactSet == null) {
            this.contactSet = new BIContactSet(this);
            this.contactSet.setDesign(this.getDesign());
            this.contactSet.setName(Messages.getString("BusinessInfoDesign.Contacts"));
            this.contactSet.setParent(this);
            this.contactSet.addSetListener(this);
        }
        return this.contactSet;
    }

    public BIDocumentSet getDocumentSet() {
        if (this.docSet == null) {
            this.docSet = new BIDocumentSet(this);
            this.docSet.setDesign(this.getDesign());
            this.docSet.setName(Messages.getString("BusinessInfoDesign.Documents"));
            this.docSet.setParent(this);
            this.docSet.addSetListener(this);
        }
        return this.docSet;
    }

    public BIEmailSet getEmailSet() {
        if (this.emailSet == null) {
            this.emailSet = new BIEmailSet(this);
            this.emailSet.setDesign(this.getDesign());
            this.emailSet.setName(Messages.getString("BusinessInfoDesign.Emails"));
            this.emailSet.setParent(this);
            this.emailSet.addSetListener(this);
        }
        return this.emailSet;
    }

    public BILocationSet getLocationSet() {
        if (this.locationSet == null) {
            this.locationSet = new BILocationSet(this);
            this.locationSet.setDesign(this.getDesign());
            this.locationSet.setName(Messages.getString("BusinessInfoDesign.Locations"));
            this.locationSet.setParent(this);
            this.locationSet.addSetListener(this);
        }
        return this.locationSet;
    }

    public BIPhoneSet getPhoneSet() {
        if (this.phoneSet == null) {
            this.phoneSet = new BIPhoneSet(this);
            this.phoneSet.setDesign(this.getDesign());
            this.phoneSet.setName(Messages.getString("BusinessInfoDesign.Telephones"));
            this.phoneSet.setParent(this);
            this.phoneSet.addSetListener(this);
        }
        return this.phoneSet;
    }

    public BIResponsiblePartySet getResPartySet() {
        if (this.resPartySet == null) {
            this.resPartySet = new BIResponsiblePartySet(this);
            this.resPartySet.setDesign(this.getDesign());
            this.resPartySet.setName(Messages.getString("BusinessInfoDesign.ResponsibleParties"));
            this.resPartySet.setParent(this);
            this.resPartySet.addSetListener(this);
        }
        return this.resPartySet;
    }

    public BIResourceLocatorSet getUrlSet() {
        if (this.urlSet == null) {
            this.urlSet = new BIResourceLocatorSet(this);
            this.urlSet.setDesign(this.getDesign());
            this.urlSet.setName(Messages.getString("BusinessInfoDesign.ResourceLocators"));
            this.urlSet.setParent(this);
            this.urlSet.addSetListener(this);
        }
        return this.urlSet;
    }

    public BIDocument createDocument() {
        return this.getDocumentSet().createDocument(null);
    }

    public BIResponsibleParty createResParty() {
        return this.getResPartySet().createParty(null);
    }

    public BIContact createContact() {
        return this.getContactSet().createContact(null);
    }

    public BIEmail createEmail() {
        return this.getEmailSet().createEmail(null);
    }

    public BILocation createLocation() {
        return this.getLocationSet().createLocation(null);
    }

    public BIPhone createPhone() {
        return this.getPhoneSet().createPhone(null);
    }

    public BIResourceLocator createUrl() {
        return this.getUrlSet().createResLocator(null);
    }

    @Override
    public int getNumberOfChildren() {
        return 7;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.getDocumentSet();
            }
            case 1: {
                return this.getResPartySet();
            }
            case 2: {
                return this.getContactSet();
            }
            case 3: {
                return this.getEmailSet();
            }
            case 4: {
                return this.getLocationSet();
            }
            case 5: {
                return this.getPhoneSet();
            }
            case 6: {
                return this.getUrlSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.getDocumentSet()) {
            return 0;
        }
        if (modelObject == this.getResPartySet()) {
            return 1;
        }
        if (modelObject == this.getContactSet()) {
            return 2;
        }
        if (modelObject == this.getEmailSet()) {
            return 3;
        }
        if (modelObject == this.getLocationSet()) {
            return 4;
        }
        if (modelObject == this.getPhoneSet()) {
            return 5;
        }
        if (modelObject == this.getUrlSet()) {
            return 6;
        }
        return -1;
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent == SetEvent.OBJECT_ADDED) {
            this.fireAdded(setEvent.getAffected());
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            this.fireRemoved(setEvent.getAffected());
        }
    }

    @Override
    public Note createNote() {
        return null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            BusinessInfoModelPropertiesDialog businessInfoModelPropertiesDialog = new BusinessInfoModelPropertiesDialog(this.getDesign().getAppView(), this, true);
            businessInfoModelPropertiesDialog.initProperties(this);
            businessInfoModelPropertiesDialog.show();
        }
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Email");
        arrayList.add("Location");
        arrayList.add("Phone");
        arrayList.add("ResLocator");
        arrayList.add("Contact");
        arrayList.add("ResponsibleParty");
        arrayList.add("Document");
        return arrayList;
    }

    @Override
    public boolean isNewModel() {
        return false;
    }

    @Override
    public String getStoragePath() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "businessinfo").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "businessinfo/" + this.getName() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String toString() {
        return Messages.getString("Design.BusinessInformation");
    }

    @Override
    public boolean setName(String string) {
        return true;
    }

    @Override
    public StorableObject createObject(String string, String string2, String string3) {
        DesignObject designObject = null;
        if ("Email".equalsIgnoreCase(string)) {
            designObject = this.getEmailSet().createEmail(string2);
        } else if ("Location".equalsIgnoreCase(string)) {
            designObject = this.getLocationSet().createLocation(string2);
        } else if ("Phone".equalsIgnoreCase(string)) {
            designObject = this.getPhoneSet().createPhone(string2);
        } else if ("ResLocator".equalsIgnoreCase(string)) {
            designObject = this.getUrlSet().createResLocator(string2);
        } else if ("Contact".equalsIgnoreCase(string)) {
            designObject = this.getContactSet().createContact(string2);
        } else if ("ResponsibleParty".equalsIgnoreCase(string)) {
            designObject = this.getResPartySet().createParty(string2);
        } else if ("Document".equalsIgnoreCase(string)) {
            designObject = this.getDocumentSet().createDocument(string2);
        }
        if (designObject != null && string3 != null && string3.length() > 0) {
            designObject.setName(string3);
        }
        return designObject;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("email", "Email");
            this.f2tMap.put("location", "Location");
            this.f2tMap.put("phone", "Phone");
            this.f2tMap.put("url", "ResLocator");
            this.f2tMap.put("contact", "Contact");
            this.f2tMap.put("party", "ResponsibleParty");
            this.f2tMap.put("document", "Document");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String string, StorableObjectStatusHelper storableObjectStatusHelper, String string2) {
        storableObjectStatusHelper.treePath.add(new TreePathHelper(OBJECT_TYPE_NAME, new File(design.getBusinessInfoDesign().getStorageName()), BusinessInfoDesign.class));
        if ("email".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = BIEmail.class;
            storableObjectStatusHelper.objectType = "Email";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(EMAIL_SET_NAME, file.getParentFile(), BIEmailSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getEmailSet();
                storableObjectStatusHelper.storableObject = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getEmailSet().getObjectByID(string2);
            }
        } else if ("location".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = BILocation.class;
            storableObjectStatusHelper.objectType = "Location";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(LOCATION_SET_NAME, file.getParentFile(), BILocationSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getLocationSet();
                storableObjectStatusHelper.storableObject = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getLocationSet().getObjectByID(string2);
            }
        } else if ("phone".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = BIPhone.class;
            storableObjectStatusHelper.objectType = "Phone";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(PHONE_SET_NAME, file.getParentFile(), BIPhoneSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getPhoneSet();
                storableObjectStatusHelper.storableObject = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getPhoneSet().getObjectByID(string2);
            }
        } else if ("url".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = BIResourceLocator.class;
            storableObjectStatusHelper.objectType = "ResLocator";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(URL_SET_NAME, file.getParentFile(), BIResourceLocatorSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getUrlSet();
                storableObjectStatusHelper.storableObject = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getUrlSet().getObjectByID(string2);
            }
        } else if ("contact".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = BIContact.class;
            storableObjectStatusHelper.objectType = "Contact";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(CONTACT_SET_NAME, file.getParentFile(), BIContactSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getContactSet();
                storableObjectStatusHelper.storableObject = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getContactSet().getObjectByID(string2);
            }
        } else if ("party".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = BIResponsibleParty.class;
            storableObjectStatusHelper.objectType = "ResponsibleParty";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(RES_PARTY_SET_NAME, file.getParentFile(), BIResponsiblePartySet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getResPartySet();
                storableObjectStatusHelper.storableObject = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getResPartySet().getObjectByID(string2);
            }
        } else if ("document".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = BIDocument.class;
            storableObjectStatusHelper.objectType = "Document";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(DOCUMENT_SET_NAME, file.getParentFile(), BIDocumentSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getDocumentSet();
                storableObjectStatusHelper.storableObject = ((BusinessInfoDesign)storableObjectStatusHelper.designPart).getDocumentSet().getObjectByID(string2);
            }
        }
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        this.sortCollections();
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        DesignObject designObject2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (DesignObject designObject2 : this.getDocuments()) {
            if (designObject2.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject2);
        }
        Iterator iterator = this.getResPartySet().iterator();
        while (iterator.hasNext()) {
            designObject2 = (BIResponsibleParty)iterator.next();
            if (designObject2.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject2);
        }
        iterator = this.getContactSet().iterator();
        while (iterator.hasNext()) {
            designObject2 = (BIContact)iterator.next();
            if (designObject2.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject2);
        }
        iterator = this.getEmailSet().iterator();
        while (iterator.hasNext()) {
            designObject2 = (BIEmail)iterator.next();
            if (designObject2.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject2);
        }
        iterator = this.getLocationSet().iterator();
        while (iterator.hasNext()) {
            designObject2 = (BILocation)iterator.next();
            if (designObject2.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject2);
        }
        iterator = this.getPhoneSet().iterator();
        while (iterator.hasNext()) {
            designObject2 = (BIPhone)iterator.next();
            if (designObject2.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject2);
        }
        return arrayList;
    }
}

