/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.businessinfo.PhonePropertiesDialogEx;

public class BIPhone
extends DesignObject {
    private String phoneNumber = "";
    private String phoneType = "";
    private List contacts = new ArrayList();
    public static final String TYPE_NAME = "Phone";

    public BIPhone(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PhonePropertiesDialogEx phonePropertiesDialogEx = new PhonePropertiesDialogEx(this.getDesign().getAppView(), this);
            phonePropertiesDialogEx.initProperties(this);
            phonePropertiesDialogEx.show();
        }
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String string) {
        this.phoneNumber = string;
    }

    public String getPhoneType() {
        return this.phoneType;
    }

    public void setPhoneType(String string) {
        this.phoneType = string;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void addContact(BIContact bIContact) {
        if (!this.contacts.contains(bIContact)) {
            this.contacts.add(bIContact);
        }
    }

    public void removeContact(BIContact bIContact) {
        this.contacts.remove(bIContact);
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        ((BIPhone)designObject).setPhoneNumber(this.getPhoneNumber());
        ((BIPhone)designObject).setPhoneType(this.getPhoneType());
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "phone/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

