/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.businessinfo.LocationPropertiesDialogEx;

public class BILocation
extends DesignObject {
    private String locationType = "";
    private String address = "";
    private String city = "";
    private String postCode = "";
    private String area = "";
    private String country = "";
    private List contacts = new ArrayList();
    public static final String TYPE_NAME = "Location";

    public BILocation(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "Loc";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LocationPropertiesDialogEx locationPropertiesDialogEx = new LocationPropertiesDialogEx(this.getDesign().getAppView(), this);
            locationPropertiesDialogEx.initProperties(this);
            locationPropertiesDialogEx.show();
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String string) {
        this.area = string;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String string) {
        this.city = string;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String string) {
        this.country = string;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public void setLocationType(String string) {
        this.locationType = string;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String string) {
        this.postCode = string;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void addContact(BIContact bIContact) {
        if (!this.contacts.contains(bIContact)) {
            this.contacts.add(bIContact);
        }
    }

    public void removeContact(BIContact bIContact) {
        this.contacts.remove(bIContact);
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        ((BILocation)designObject).setLocationType(this.getLocationType());
        ((BILocation)designObject).setAddress(this.getAddress());
        ((BILocation)designObject).setCity(this.getCity());
        ((BILocation)designObject).setPostCode(this.getPostCode());
        ((BILocation)designObject).setArea(this.getArea());
        ((BILocation)designObject).setCountry(this.getCountry());
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "location/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

