/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

public interface StatusBarOwner {
    public static final int DEFAULT_TIMEOUT_STATUS = 5000;
    public static final StatusBarOwner NULL_INSTANCE = new NullStatusBarOwner();
    public static final StatusBarOwner SYSTEM_OUT_INSTANCE = new SystemOutStatusBarOwner();

    public void setFixedStatusMessage(String var1);

    public void setTempStatusMessage(String var1, int var2);

    public void setTempStatusMessage(String var1);

    public void clearStatusMessage();

    public static class SystemOutStatusBarOwner
    implements StatusBarOwner {
        @Override
        public void setFixedStatusMessage(String string) {
            System.out.print("statusbar: ");
            System.out.println(string);
        }

        @Override
        public void setTempStatusMessage(String string, int n) {
            System.out.print("statusbar: ");
            System.out.println(string);
        }

        @Override
        public void clearStatusMessage() {
        }

        @Override
        public void setTempStatusMessage(String string) {
            this.setTempStatusMessage(string, 5000);
        }
    }

    public static class NullStatusBarOwner
    implements StatusBarOwner {
        @Override
        public void setFixedStatusMessage(String string) {
        }

        @Override
        public void setTempStatusMessage(String string, int n) {
        }

        @Override
        public void clearStatusMessage() {
        }

        @Override
        public void setTempStatusMessage(String string) {
        }
    }
}

