/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.util.string.ToStringComparator;

public abstract class ModelObjectSet
extends ModelObject
implements ElementSet {
    public static final Comparator TOSTRING_COMPARATOR = new ToStringComparator();
    public static final Comparator NAME_COMPARATOR = new NameComparator();
    public static final Comparator NAME_IGNORE_CASE_COMPARATOR = new NameIgnoreCaseComparator();
    public static final Comparator LONG_NAME_COMPARATOR = new LongNameComparator();
    public static final Comparator UPPERCASE_NAME_COMPARATOR = new UpperCaseNameComparator();
    protected int count = 1;
    protected List elementsList = new ArrayList();
    protected List elements = new ArrayList();
    private Set listeners = new HashSet();
    private int maxIndex = 0;

    public Comparator getElementSorter() {
        return TOSTRING_COMPARATOR;
    }

    public void add(ModelObject modelObject) {
        this.elements.add(modelObject);
        this.elementsList.add(modelObject);
        if (modelObject.getName() == null || modelObject.getName().equals("")) {
            while (!modelObject.setName(this.createName())) {
            }
        }
        this.doAdd();
        int n = -1;
        this.fireAdded(modelObject, n);
    }

    public void doAdd() {
    }

    public boolean remove(ModelObject modelObject) {
        int n = this.elements.indexOf(modelObject);
        n = -1;
        boolean bl = this.elements.remove(modelObject);
        if (bl) {
            this.elementsList.remove(modelObject);
            this.fireRemoved(modelObject, n);
        }
        return bl;
    }

    public boolean moveElementToIndex(ModelObject modelObject, int n) {
        if (this.elements.contains(modelObject) && this.elements.size() > n && n >= 0) {
            this.elements.remove(modelObject);
            this.elements.add(n, modelObject);
            this.elementsList.clear();
            return true;
        }
        return false;
    }

    public void removeAll() {
        ModelObject[] modelObjectArray = (ModelObject[])this.toArray();
        for (int i = 0; i < modelObjectArray.length; ++i) {
            this.remove(modelObjectArray[i]);
        }
    }

    @Override
    public boolean contains(ModelObject modelObject) {
        return this.elements.contains(modelObject);
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray(this.getProtoTypeArray());
    }

    public List getElementsList() {
        if (this.elements.size() != this.elementsList.size()) {
            this.elementsList.clear();
            this.elementsList.addAll(this.elements);
        }
        return Collections.unmodifiableList(this.elementsList);
    }

    @Override
    public Iterator iterator() {
        return this.getElementsList().iterator();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public abstract Object[] getProtoTypeArray();

    public void addSetListener(ModelObjectSetListener modelObjectSetListener) {
        this.listeners.add(modelObjectSetListener);
    }

    public void removeSetListener(ModelObjectSetListener modelObjectSetListener) {
        this.listeners.remove(modelObjectSetListener);
    }

    protected void fireAdded(ModelObject modelObject, int n) {
        this.fireChange(modelObject, 1, n);
    }

    protected void fireRemoved(ModelObject modelObject, int n) {
        this.fireChange(modelObject, 0, n);
    }

    protected void fireChange(ModelObject modelObject, int n, int n2) {
        Iterator iterator = this.listeners.iterator();
        ModelObjectSetEvent modelObjectSetEvent = new ModelObjectSetEvent(modelObject, n);
        modelObjectSetEvent.childIndex = n2;
        while (iterator.hasNext()) {
            ((ModelObjectSetListener)iterator.next()).changed(this, modelObjectSetEvent);
        }
    }

    public abstract String getDefaultNamePrefix();

    public String getSeparator() {
        return "_";
    }

    public boolean containsName(String string) {
        for (ModelObject modelObject : this.elements) {
            if (!string.equalsIgnoreCase(modelObject.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModelObject getByName(String string) {
        if (string != null) {
            String string2 = string.trim();
            for (ModelObject modelObject : this.elements) {
                if (modelObject.getName() == null || !modelObject.getName().trim().equalsIgnoreCase(string2)) continue;
                return modelObject;
            }
        }
        return null;
    }

    public boolean notContainsName(String string) {
        return !this.containsName(string);
    }

    public boolean containsLongName(String string) {
        for (ModelObject modelObject : this.elements) {
            if (!string.equalsIgnoreCase(modelObject.getLongName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsLongName(ModelObject modelObject, String string) {
        for (ModelObject modelObject2 : this.elements) {
            if (modelObject == modelObject2 || !string.equalsIgnoreCase(modelObject2.getLongName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsName(ModelObject modelObject, String string) {
        for (ModelObject modelObject2 : this.elements) {
            if (modelObject == modelObject2 || !string.equalsIgnoreCase(modelObject2.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean notContainsLongName(String string) {
        return !this.containsLongName(string);
    }

    public Class getElementClass() {
        return this.getProtoTypeArray().getClass().getComponentType();
    }

    protected String createName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDefaultNamePrefix());
        stringBuffer.append(this.getSeparator());
        while (this.containsName(stringBuffer.toString() + String.valueOf(this.count))) {
            ++this.count;
        }
        stringBuffer.append(this.count++);
        return stringBuffer.toString();
    }

    protected void setNameCounter(int n) {
        this.count = n;
    }

    public void resetCounter() {
        this.count = 1;
    }

    protected void nameCounterDecrement() {
        --this.count;
    }

    public ModelObject getElement(int n) {
        return (ModelObject)this.elements.get(n);
    }

    public int getIndexOf(ModelObject modelObject) {
        return this.elements.indexOf(modelObject);
    }

    @Override
    public int getNumberOfChildren() {
        return this.size();
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return this.getIndexOf(modelObject);
    }

    @Override
    public ModelObject getChild(int n) {
        return this.getElement(n);
    }

    @Override
    public boolean isLeaf() {
        return this.size() <= 0;
    }

    @Override
    public boolean isObjectCollection() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(DesignObject designObject) {
        return this.getObjectGeneratedBy(designObject.getObjectID());
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ModelIDObject modelIDObject = (ModelIDObject)iterator.next();
            if (!string.equals(modelIDObject.getGeneratorID())) continue;
            iterator = null;
            return modelIDObject;
        }
        iterator = null;
        return null;
    }

    @Override
    public ModelIDObject getObjectByID(String string) {
        for (ModelIDObject modelIDObject : this.elements) {
            if (!string.equals(modelIDObject.getObjectID())) continue;
            return modelIDObject;
        }
        return null;
    }

    @Override
    public Collection getObjectsGeneratedBy(String string, Collection collection) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignObject)iterator.next();
            if (!string.equals(designObject.getGeneratorID())) continue;
            collection.add(designObject);
        }
        return collection;
    }

    @Override
    public void addAllElementsTo(Collection collection) {
        collection.addAll(this.elements);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (super.getName() != null && !super.getName().trim().equalsIgnoreCase("")) {
            return super.getName();
        }
        return this.getDefaultNamePrefix();
    }

    public DesignObject[] getProtoArray() {
        return (DesignObject[])this.getProtoTypeArray();
    }

    public void sortByLongName() {
        Collections.sort(this.elements, LONG_NAME_COMPARATOR);
    }

    public void sortByName() {
        Collections.sort(this.elements, NAME_COMPARATOR);
    }

    public void updateMaxIndex(int n) {
        this.maxIndex = Math.max(this.maxIndex, n);
    }

    public int nextIndex() {
        return ++this.maxIndex;
    }

    @Override
    public boolean canSort() {
        return false;
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, NAME_COMPARATOR);
    }

    static class UpperCaseNameComparator
    implements Comparator {
        UpperCaseNameComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((LongNameObject)object).getName().toUpperCase().compareTo(((LongNameObject)object2).getName().toUpperCase());
        }
    }

    static class LongNameComparator
    implements Comparator {
        LongNameComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((LongNameObject)object).getLongName().compareTo(((LongNameObject)object2).getLongName());
        }
    }

    static class NameIgnoreCaseComparator
    implements Comparator {
        NameIgnoreCaseComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((LongNameObject)object).getName().compareToIgnoreCase(((LongNameObject)object2).getName());
        }
    }

    static class NameComparator
    implements Comparator {
        NameComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((LongNameObject)object).getName().compareTo(((LongNameObject)object2).getName());
        }
    }
}

