/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;

public abstract class ModelObject
implements LongNameObject {
    protected Design design;
    private ModelObjectSet objectSet = null;
    protected String name = "";
    protected Object parent;
    private Icon icon = null;
    private String sourceConnName = "";
    private String sourceObjSchema = "";
    private String sourceObjName = "";
    private String sourceDDLFile = "";

    public void setDesign(Design design) {
        this.design = design;
    }

    public Design getDesign() {
        return this.design;
    }

    public ApplicationView getAppView() {
        if (this.design != null) {
            return this.design.getAppView();
        }
        return null;
    }

    public String getConfiguration(String string) {
        return this.getDesign().getAppView().getMDConfiguration().get(string);
    }

    public String getPreference(String string) {
        return this.getDesign().getAppView().getPreference().get(string);
    }

    public MDPreferences getPreferences() {
        return this.getDesign().getAppView().getPreference();
    }

    public RDBMSType getSelectedRDBMSType() {
        RDBMSSite rDBMSSite = this.getSelectedRDBMSSite();
        if (rDBMSSite != null) {
            return rDBMSSite.getType();
        }
        return StorageDesignOraclev11g.RDBMS_TYPE;
    }

    public RDBMSSite getSelectedRDBMSSite() {
        return this.getDesign().getSelectedRDBMSSite();
    }

    public int getNumberOfChildren() {
        return 0;
    }

    public ModelObject getChild(int n) {
        return null;
    }

    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    public int getIndexForChild(ModelObject modelObject) {
        return -1;
    }

    public int getIndexForChild(Object object) {
        return -1;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isObjectCollection() {
        return false;
    }

    public final Object[] getPath() {
        ArrayList arrayList = new ArrayList();
        this.addToPath(arrayList);
        return arrayList.toArray();
    }

    public final List addToPath(List list) {
        list.add(0, this);
        if (this.getParent() != null && this.getParent() instanceof ModelObject) {
            ((ModelObject)this.getParent()).addToPath(list);
        }
        return list;
    }

    public boolean hasAlternatePaths() {
        return false;
    }

    public Object[][] getAlternatePaths() {
        return new Object[][]{this.getPath()};
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object object) {
        this.parent = object;
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (this.name == null && this.objectSet != null) {
            this.name = this.objectSet.createName();
        }
        return this.name;
    }

    public boolean isWriteable() {
        return true;
    }

    public boolean allowName(String string, boolean bl) {
        if (this.objectSet == null) {
            return true;
        }
        if (bl) {
            return !this.objectSet.containsLongName(this, string);
        }
        return !this.objectSet.containsName(this, string);
    }

    public boolean setName(String string) {
        if (this.isWriteable() && this.allowName(string, false)) {
            this.name = string;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getLongName();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public ModelObjectSet getObjectSet() {
        return this.objectSet;
    }

    public void setObjectSet(ModelObjectSet modelObjectSet) {
        this.objectSet = modelObjectSet;
    }

    public String getSourceConnName() {
        return this.sourceConnName;
    }

    public void setSourceConnName(String string) {
        this.sourceConnName = string;
    }

    public String getSourceObjSchema() {
        return this.sourceObjSchema;
    }

    public void setSourceObjSchema(String string) {
        this.sourceObjSchema = string;
    }

    public String getSourceObjName() {
        return this.sourceObjName;
    }

    public void setSourceObjName(String string) {
        this.sourceObjName = string;
    }

    public String getSourceDDLFile() {
        return this.sourceDDLFile;
    }

    public void setSourceDDLFile(String string) {
        this.sourceDDLFile = string;
    }
}

