/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelectionListener;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.FE_LogicalToRelational;
import oracle.dbtools.crest.model.design.engineering.RE_RelationalToLogical;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.logging.Logger;

public class ModelIdObjectSelection
extends ModelObject {
    public static int STATE_UNCHANGED = 0;
    public static int STATE_MODIFIED = 1;
    public static int STATE_NEW = 2;
    public static int STATE_DELETED = 3;
    public static final int NO_FILTER = -1;
    public static final String TO_DELETE = Messages.getString("ModelIdObjectSelection.Missed");
    public static final String TO_DROP = Messages.getString("ModelIdObjectSelection.ToDrop");
    public static String NEW_TABLE = Messages.getString("ModelIdObjectSelection.NewTable");
    public static String NEW_COLUMN = Messages.getString("ModelIdObjectSelection.NewColumn");
    public static String NEW_INDEX = Messages.getString("ModelIdObjectSelection.NewIndex");
    public static String NEW_KEY = Messages.getString("ModelIdObjectSelection.NewKey");
    public static String NEW_CONSTRAINT = Messages.getString("ModelIdObjectSelection.NewConstraint");
    public static String NEW_RELATION = Messages.getString("ModelIdObjectSelection.NewRelation");
    public static String NEW_INHERITANCE = Messages.getString("ModelIdObjectSelection.NewInheritance");
    public static String NEW_VIEW = Messages.getString("ModelIdObjectSelection.NewVIEW");
    public static String NEW_NOTE = Messages.getString("ModelIdObjectSelection.NewNote");
    protected int status = STATE_UNCHANGED;
    private static final String ASSIGNED_TO_SCHEMAS = oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.AssignedToSchemas");
    private static final String NOT_ASSIGNED_TO_SCHEMAS = oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.NotAssignedToSchemas");
    private Set listeners = new HashSet();
    private boolean collection;
    protected ModelIDObject object;
    protected List childs = new ArrayList();
    protected Object elDescriptor;
    protected boolean selected = true;
    private static final Logger LOGGER = new Logger(DesignObject.class);
    private boolean applySelectionImmediate = false;
    private boolean oldSelection;
    protected boolean loaded = false;
    private List tableList;
    private List viewList;
    private List constraintList;
    private List indexList;
    private List fkList;
    private List schemaList;

    public ModelIdObjectSelection(ModelIDObject modelIDObject) {
        this.object = modelIDObject;
        this.elDescriptor = modelIDObject.getClass();
        this.oldSelection = this.selected = modelIDObject.isMarkedGenerate();
    }

    public ModelIdObjectSelection(ModelIDObject modelIDObject, boolean bl) {
        this.object = modelIDObject;
        this.elDescriptor = modelIDObject.getClass();
        this.oldSelection = this.selected = modelIDObject.isMarkedGenerate();
        this.applySelectionImmediate = bl;
    }

    public ModelIdObjectSelection(String string) {
        super.setName(string);
        this.collection = true;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public void setCollection(boolean bl) {
        this.collection = bl;
    }

    public void addChild(ModelIdObjectSelection modelIdObjectSelection) {
        modelIdObjectSelection.setParent(this);
        this.childs.add(modelIdObjectSelection);
    }

    @Override
    public String getName() {
        if (this.object != null) {
            return this.object.getName();
        }
        return super.getName();
    }

    public void addDDLSelectionListener(ModelIdObjectSelectionListener modelIdObjectSelectionListener) {
        this.getListeners().add(modelIdObjectSelectionListener);
    }

    public void removeDDLSelectionListener(ModelIdObjectSelectionListener modelIdObjectSelectionListener) {
        this.getListeners().remove(modelIdObjectSelectionListener);
    }

    protected void fireChange() {
        ModelIdObjectSelectionListener[] modelIdObjectSelectionListenerArray = this.getListeners().toArray(new ModelIdObjectSelectionListener[0]);
        for (int i = 0; i < modelIdObjectSelectionListenerArray.length; ++i) {
            try {
                if (modelIdObjectSelectionListenerArray[i] == null) continue;
                modelIdObjectSelectionListenerArray[i].changed(this);
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Listener caused exception: ", exception);
            }
        }
    }

    public void setElementDescriptor(Object object) {
        this.elDescriptor = object;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    private void propagateSelection() {
        for (ModelIdObjectSelection modelIdObjectSelection : this.childs) {
            modelIdObjectSelection.setSelected(this.selected);
        }
    }

    public boolean isSelected() {
        if (this.applySelectionImmediate && this.object != null) {
            return this.object.isMarkedGenerate();
        }
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        if (this.applySelectionImmediate && this.object != null) {
            this.object.setMarkedGenerate(bl);
        }
        this.fireChange();
        this.propagateSelection();
    }

    public void setSelectedNoPropagateSelection(boolean bl) {
        this.selected = bl;
        if (this.applySelectionImmediate && this.object != null) {
            this.object.setMarkedGenerate(bl);
        }
        this.fireChange();
    }

    public boolean checkSelected() {
        ModelIdObjectSelection modelIdObjectSelection = this.getRoot(this);
        if (modelIdObjectSelection instanceof FE_LogicalToRelational || modelIdObjectSelection instanceof RE_RelationalToLogical) {
            return this.hasGenerate(modelIdObjectSelection);
        }
        return true;
    }

    private ModelIdObjectSelection getRoot(ModelIdObjectSelection modelIdObjectSelection) {
        Object object = modelIdObjectSelection.getParent();
        if (object != null && object instanceof ModelIdObjectSelection) {
            ModelIdObjectSelection modelIdObjectSelection2 = (ModelIdObjectSelection)object;
            return modelIdObjectSelection2.getRoot(modelIdObjectSelection2);
        }
        return modelIdObjectSelection;
    }

    private boolean hasGenerate(ModelIdObjectSelection modelIdObjectSelection) {
        ModelIDObject modelIDObject = modelIdObjectSelection.getObject();
        if (modelIDObject != null && modelIDObject.isMarkedGenerate() && modelIdObjectSelection.isSelected()) {
            return true;
        }
        List list = modelIdObjectSelection.getChilds();
        if (list.size() > 0) {
            for (ModelIdObjectSelection modelIdObjectSelection2 : list) {
                if (!this.hasGenerate(modelIdObjectSelection2)) continue;
                return true;
            }
        }
        return false;
    }

    public void applySelectionToObjects() {
        if (this.object != null) {
            if (this.applySelectionImmediate) {
                this.oldSelection = this.selected = this.object.isMarkedGenerate();
            }
            this.object.setMarkedGenerate(this.selected);
        }
        for (ModelIdObjectSelection modelIdObjectSelection : this.childs) {
            modelIdObjectSelection.applySelectionToObjects();
        }
    }

    public void restoreOldSelectionToObjects() {
        if (this.object != null) {
            this.object.setMarkedGenerate(this.oldSelection);
        }
        for (ModelIdObjectSelection modelIdObjectSelection : this.childs) {
            modelIdObjectSelection.restoreOldSelectionToObjects();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return this.childs.size();
    }

    @Override
    public ModelObject getChild(int n) {
        if (this.childs.size() > 0 && n < this.childs.size()) {
            return (ModelObject)this.childs.get(n);
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (this.childs.size() > 0) {
            return this.childs.indexOf(modelObject);
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (this.childs.size() > 0) {
            return this.childs.indexOf(object);
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        if (!this.loaded) {
            return false;
        }
        return this.childs.size() == 0;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public ModelIDObject getObject() {
        return this.object;
    }

    protected Set getListeners() {
        return this.listeners;
    }

    public void removeChild(ModelIdObjectSelection modelIdObjectSelection) {
        if (this.childs.remove(modelIdObjectSelection)) {
            this.fireChange();
        }
    }

    public List getChilds() {
        return this.childs;
    }

    public boolean isFiltered(List list) {
        for (Integer n : list) {
            if (n.intValue() != this.getStatus()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFilteredChilds(List list) {
        for (ModelIdObjectSelection modelIdObjectSelection : this.getChilds()) {
            if (!modelIdObjectSelection.isFiltered(list) && !modelIdObjectSelection.hasFilteredChilds(list)) continue;
            return true;
        }
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    public void sort() {
        Collections.sort(this.childs, ModelObjectSet.NAME_COMPARATOR);
    }

    public void sortAsString() {
        Collections.sort(this.childs, ModelObjectSet.TOSTRING_COMPARATOR);
    }

    public boolean hasAsParent(ModelIDObject modelIDObject) {
        ModelIDObject modelIDObject2 = this.getObject();
        if (modelIDObject2 == modelIDObject) {
            return true;
        }
        if (modelIDObject2 != null && modelIDObject2 instanceof DesignObjectPlaceHolder && ((DesignObjectPlaceHolder)modelIDObject2).getObject() == modelIDObject) {
            return true;
        }
        Object object = this.getParent();
        if (object != null && object instanceof ModelIdObjectSelection) {
            return ((ModelIdObjectSelection)object).hasAsParent(modelIDObject);
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.loaded = true;
    }

    public void addCommonObjectsFromRelationalModel(RelationalDesign relationalDesign, DesignPartView designPartView) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = relationalDesign.getSchemaObjectSet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this.setElementDescriptor(StorageDesign.class);
        this.addObjectsAssignedToSchemas(relationalDesign, designPartView, ASSIGNED_TO_SCHEMAS, this, arrayList);
        this.addObjectsNotAssignedToSchemas(relationalDesign, designPartView, NOT_ASSIGNED_TO_SCHEMAS, this);
        iterator = relationalDesign.getSchemaObjectSet().iterator();
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionOraclev8i.Schemas"));
        modelIdObjectSelection.setElementDescriptor(SchemaSetSqlServerv2k5.class);
        while (iterator.hasNext()) {
            SchemaObject schemaObject = (SchemaObject)iterator.next();
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(schemaObject);
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
            if (this.schemaList == null) {
                this.schemaList = new ArrayList();
            }
            this.getSchemaList().add(modelIdObjectSelection2);
        }
        this.addChild(modelIdObjectSelection);
    }

    protected void addObjectsAssignedToSchemas(RelationalDesign relationalDesign, DesignPartView designPartView, String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaObjectSet.class);
        for (SchemaObject schemaObject : list) {
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(schemaObject.getName());
            modelIdObjectSelection3.setElementDescriptor(SchemaObject.class);
            this.addSchemaDetails(relationalDesign, designPartView, schemaObject, modelIdObjectSelection3);
            modelIdObjectSelection2.addChild(modelIdObjectSelection3);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    protected void addObjectsNotAssignedToSchemas(RelationalDesign relationalDesign, DesignPartView designPartView, String string, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaSetUDB.class);
        this.addSchemaDetails(relationalDesign, designPartView, null, modelIdObjectSelection2);
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    protected void addSchemaDetails(RelationalDesign relationalDesign, DesignPartView designPartView, SchemaObject schemaObject, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2;
        ContainerObject containerObject;
        int n;
        ModelIdObjectSelection modelIdObjectSelection3;
        List list = null;
        list = schemaObject != null ? (designPartView == null ? this.getTableForSchema(relationalDesign, schemaObject) : this.getTableForSubView(schemaObject, designPartView)) : this.getTableWithNoSchema(relationalDesign, designPartView);
        if (list.size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.Tables"));
            modelIdObjectSelection3.setElementDescriptor(TableSet.class);
            for (n = 0; n < list.size(); ++n) {
                containerObject = (Table)list.get(n);
                modelIdObjectSelection2 = new ModelIdObjectSelection(containerObject);
                this.addTableDetails((Table)containerObject, modelIdObjectSelection2);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
                this.getTableList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection3);
        }
        list = schemaObject != null ? (designPartView == null ? this.getViewForSchema(relationalDesign, schemaObject) : this.getViewForSubView(schemaObject, designPartView)) : this.getViewWithNoSchema(relationalDesign, designPartView);
        if (list.size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.Views"));
            modelIdObjectSelection3.setElementDescriptor(TableViewSet.class);
            for (n = 0; n < list.size(); ++n) {
                containerObject = (TableView)list.get(n);
                modelIdObjectSelection2 = new ModelIdObjectSelection(containerObject);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
                this.getViewList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection3);
        }
        modelIdObjectSelection.sort();
    }

    private List getTableForSchema(RelationalDesign relationalDesign, SchemaObject schemaObject) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Iterator iterator = relationalDesign.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (table.getSchema() == null || !table.getSchema().equals(schemaObject.getName())) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private List getTableForSubView(SchemaObject schemaObject, DesignPartView designPartView) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        if (designPartView != null) {
            for (int i = 0; i < designPartView.getComponentCount(); ++i) {
                String string = designPartView.getChild(i).getName();
                DesignObjectCollection designObjectCollection = (DesignObjectCollection)designPartView.getChild(i);
                for (Object e : designObjectCollection.getElementsList()) {
                    if (!string.equals(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.Tables"))) continue;
                    Table table = (Table)((DesignObjectPlaceHolder)e).getDesignObject();
                    if (table.getSchema() != null) {
                        if (schemaObject != null) {
                            if (!table.getSchema().equals(schemaObject.getName())) continue;
                            arrayList.add(table);
                            continue;
                        }
                        if (!table.getSchema().equals("")) continue;
                        arrayList.add(table);
                        continue;
                    }
                    if (schemaObject != null) continue;
                    arrayList.add(table);
                }
            }
        }
        return arrayList;
    }

    private List getTableWithNoSchema(RelationalDesign relationalDesign, DesignPartView designPartView) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        if (designPartView != null) {
            for (int i = 0; i < designPartView.getComponentCount(); ++i) {
                String string = designPartView.getChild(i).getName();
                DesignObjectCollection designObjectCollection = (DesignObjectCollection)designPartView.getChild(i);
                for (Object e : designObjectCollection.getElementsList()) {
                    if (!string.equals(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.Tables"))) continue;
                    Table table = (Table)((DesignObjectPlaceHolder)e).getDesignObject();
                    if (table.getSchema() != null) {
                        if (!table.getSchema().equals("")) continue;
                        arrayList.add(table);
                        continue;
                    }
                    arrayList.add(table);
                }
            }
        } else {
            Iterator iterator = relationalDesign.getTableSet().iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                if (table.getSchema() != null && table.getSchema().equals("")) {
                    arrayList.add(table);
                    continue;
                }
                if (table.getSchema() != null) continue;
                arrayList.add(table);
            }
        }
        return arrayList;
    }

    private List getViewForSchema(RelationalDesign relationalDesign, SchemaObject schemaObject) {
        ArrayList<TableView> arrayList = new ArrayList<TableView>();
        Iterator iterator = relationalDesign.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            if (tableView.getSchema() == null || !tableView.getSchema().equals(schemaObject.getName())) continue;
            arrayList.add(tableView);
        }
        return arrayList;
    }

    private List getViewForSubView(SchemaObject schemaObject, DesignPartView designPartView) {
        ArrayList<TableView> arrayList = new ArrayList<TableView>();
        if (designPartView != null) {
            for (int i = 0; i < designPartView.getComponentCount(); ++i) {
                String string = designPartView.getChild(i).getName();
                DesignObjectCollection designObjectCollection = (DesignObjectCollection)designPartView.getChild(i);
                for (Object e : designObjectCollection.getElementsList()) {
                    if (!string.equals(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.Views"))) continue;
                    TableView tableView = (TableView)((DesignObjectPlaceHolder)e).getDesignObject();
                    if (tableView.getSchema() != null) {
                        if (schemaObject != null) {
                            if (!tableView.getSchema().equals(schemaObject.getName())) continue;
                            arrayList.add(tableView);
                            continue;
                        }
                        if (!tableView.getSchema().equals("")) continue;
                        arrayList.add(tableView);
                        continue;
                    }
                    if (schemaObject != null) continue;
                    arrayList.add(tableView);
                }
            }
        }
        return arrayList;
    }

    private List getViewWithNoSchema(RelationalDesign relationalDesign, DesignPartView designPartView) {
        ArrayList<TableView> arrayList = new ArrayList<TableView>();
        if (designPartView != null) {
            for (int i = 0; i < designPartView.getComponentCount(); ++i) {
                String string = designPartView.getChild(i).getName();
                DesignObjectCollection designObjectCollection = (DesignObjectCollection)designPartView.getChild(i);
                for (Object e : designObjectCollection.getElementsList()) {
                    if (!string.equals(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.Views"))) continue;
                    TableView tableView = (TableView)((DesignObjectPlaceHolder)e).getDesignObject();
                    if (tableView.getSchema() != null) {
                        if (!tableView.getSchema().equals("")) continue;
                        arrayList.add(tableView);
                        continue;
                    }
                    arrayList.add(tableView);
                }
            }
        } else {
            Iterator iterator = relationalDesign.getTableViewSet().iterator();
            while (iterator.hasNext()) {
                TableView tableView = (TableView)iterator.next();
                if (tableView.getSchema() != null && tableView.getSchema().equals("")) {
                    arrayList.add(tableView);
                    continue;
                }
                if (tableView.getSchema() != null) continue;
                arrayList.add(tableView);
            }
        }
        return arrayList;
    }

    private void addTableDetails(Table table, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2;
        Object object;
        ModelObject modelObject;
        Object object2;
        if (table.getPKandUKConstraints().size() > 0) {
            object2 = new ModelIdObjectSelection(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.PKUKConstraints"));
            for (DesignObject designObject : table.getPKandUKConstraints()) {
                modelObject = new ModelIdObjectSelection(designObject);
                if (((KeyObject)designObject).isPK()) {
                    modelObject.setName("(PK) " + designObject.getName());
                }
                ((ModelIdObjectSelection)object2).addChild((ModelIdObjectSelection)modelObject);
                this.getConstraintList().add(modelObject);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object2);
        }
        if (table.getIndexes().size() > 0) {
            object2 = new ModelIdObjectSelection(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.Indexes"));
            object = table.getIndexes().iterator();
            while (object.hasNext()) {
                DesignObject designObject;
                designObject = (ContainerObjectPlaceHolder)object.next();
                modelObject = (Index)((DesignObjectPlaceHolder)designObject).getDesignObject();
                modelIdObjectSelection2 = new ModelIdObjectSelection((ModelIDObject)modelObject);
                ((ModelIdObjectSelection)object2).addChild(modelIdObjectSelection2);
                if (this.indexList == null) {
                    this.indexList = new ArrayList();
                }
                this.getIndexList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object2);
        }
        if (((FKIndexAssociation[])(object2 = table.getFKAssociations())).length > 0) {
            object = new ModelIdObjectSelection(oracle.dbtools.crest.swingui.ddl.Messages.getString("DDLSelectionRelational.ForeignKeys"));
            for (int i = 0; i < ((FKIndexAssociation[])object2).length; ++i) {
                modelObject = object2[i];
                modelIdObjectSelection2 = new ModelIdObjectSelection((ModelIDObject)modelObject);
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection2);
                if (this.fkList == null) {
                    this.fkList = new ArrayList();
                }
                this.getFkList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object);
        }
    }

    public List getTableList() {
        if (this.tableList == null) {
            this.tableList = new ArrayList();
        }
        return this.tableList;
    }

    public List getConstraintList() {
        if (this.constraintList == null) {
            this.constraintList = new ArrayList();
        }
        return this.constraintList;
    }

    public List getViewList() {
        if (this.viewList == null) {
            this.viewList = new ArrayList();
        }
        return this.viewList;
    }

    public List getFkList() {
        if (this.fkList == null) {
            this.fkList = new ArrayList();
        }
        return this.fkList;
    }

    public List getIndexList() {
        if (this.indexList == null) {
            this.indexList = new ArrayList();
        }
        return this.indexList;
    }

    public List getSchemaList() {
        if (this.schemaList == null) {
            this.schemaList = new ArrayList();
        }
        return this.schemaList;
    }
}

