/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.swingui.ApplicationView;

public abstract class ModelIDObjectSet
extends ModelObjectSet {
    public static ObjectIDComparator OBJECT_ID_COMPARATOR = new ObjectIDComparator();

    @Override
    public void add(ModelObject modelObject) {
        if (modelObject instanceof ModelIDObject) {
            ModelIDObject modelIDObject = (ModelIDObject)modelObject;
            if (modelIDObject.getDesign() == null) {
                modelIDObject.setDesign(this.getDesign());
            }
            if (modelIDObject.getObjectID() == null && this.getDesign() != null) {
                modelIDObject.createGlobalID();
            }
        }
        super.add(modelObject);
    }

    public abstract ModelIDObject createElement(String var1);

    public boolean containsId(String string) {
        return null != this.getById(string);
    }

    public ModelIDObject getById(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ModelIDObject modelIDObject = (ModelIDObject)iterator.next();
            if (!modelIDObject.getObjectID().equals(string)) continue;
            return modelIDObject;
        }
        return null;
    }

    public boolean remove(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ModelIDObject modelIDObject = (ModelIDObject)iterator.next();
            if (!modelIDObject.getObjectID().equals(string)) continue;
            return this.remove(modelIDObject);
        }
        return false;
    }

    @Override
    public Comparator getElementSorter() {
        return LONG_NAME_COMPARATOR;
    }

    public boolean canCreateElement() {
        return false;
    }

    @Override
    public boolean canSort() {
        return ApplicationView.canLogging;
    }

    static class ObjectIDComparator
    implements Comparator {
        ObjectIDComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof ModelIDObject && object2 instanceof ModelIDObject) {
                return ((ModelIDObject)object).getObjectID().compareTo(((ModelIDObject)object2).getObjectID());
            }
            return object.toString().compareTo(object2.toString());
        }
    }
}

