/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.util.options.Settings;

public class MDPreferences
implements Serializable {
    public static final String DEFAULT_ATTRIBUTE_NAME = "default attribute name";
    public static final String DEFAULT_ENTITY_NAME = "default entity name";
    public static final String DEFAULT_ALTERNATE_KEY_NAME = "alt key name";
    public static final String DEFAULT_RELATION_NAME = "default relation name";
    public static final String DEFAULT_INHERITANCE_RELATION_NAME = "default inheritance relation name";
    public static final String DEFAULT_LOGICAL_DATATYPE_NAME = "default log datatype name";
    public static final String DEFAULT_DOMAIN_NAME = "default domain name";
    public static final String DEFAULT_COLUMN_NAME = "default column name";
    public static final String DEFAULT_TABLE_NAME = "default table name";
    public static final String DEFAULT_TABLESPACE_NAME = "default tablespace name";
    public static final String DEFAULT_INDEX_NAME = "default index name";
    public static final String DEFAULT_DATABASE_NAME = "default database name";
    public static final String DEFAULT_TABLESPACEPARTITION_NAME = "DEFAULT TABLESPACEPARTITION NAME";
    public static final String DEFAULT_DATATYPE_CODE = "datatypecode";
    public static final String DEFAULT_COLUMN_GROUP_NAME = "default column group name";
    public static final String DEFAULT_SCHEMA_NAME = "default schema name";
    public static final String IDPREFIX_ENTITY = "entity id prefix";
    public static final String IDPREFIX_ATTRIBUTE = "attribute id prefix";
    public static final String IDPREFIX_RELATION = "relation id prefix";
    public static final String IDPREFIX_INHERITANCE = "inheritance id prefix";
    public static final String IDPREFIX_ALTERNATE_KEY = "altkey id prefix";
    public static final String IDPREFIX_TABLE = "table id prefix";
    public static final String IDPREFIX_TABLEVIEW = "tableview id prefix";
    public static final String IDPREFIX_ENTITYVIEW = "entityview id prefix";
    public static final String IDPREFIX_COLUMN = "column id prefix";
    public static final String IDPREFIX_INDEX = "index id prefix";
    public static final String IDPREFIX_CHKCONSTR = "chkconstr id prefix";
    public static final String IDPREFIX_DOMAIN = "domain id prefix";
    public static final String IDPREFIX_LOGTYPES = "log datatype id prefix";
    public static final String IDPREFIX_RDBMS_SITE = "rsdbms site id prefix";
    public static final String IDPREFIX_SCHEMA = "schema id prefix";
    private static MDPreferences instance;
    private static Map defaults;

    private MDPreferences() {
    }

    public static MDPreferences getDefaultInstance() {
        if (instance == null) {
            instance = new MDPreferences();
        }
        return instance;
    }

    public String get(String string) {
        return (String)defaults.get(string);
    }

    public MDDataType getDefaultType(Settings settings) {
        MDDataType mDDataType = MDDataTypeFactory.getInstance(settings).createStringEncodedType(this.get(DEFAULT_DATATYPE_CODE));
        return mDDataType;
    }

    static {
        defaults = new TreeMap();
        defaults.put(DEFAULT_RELATION_NAME, "Relation");
        defaults.put(DEFAULT_ENTITY_NAME, "Entity");
        defaults.put(DEFAULT_ATTRIBUTE_NAME, "Attribute");
        defaults.put(DEFAULT_ALTERNATE_KEY_NAME, "Key");
        defaults.put(DEFAULT_INHERITANCE_RELATION_NAME, "Hierarchy");
        defaults.put(DEFAULT_DOMAIN_NAME, "Domain");
        defaults.put(DEFAULT_TABLE_NAME, "TABLE");
        defaults.put(DEFAULT_COLUMN_NAME, "COL");
        defaults.put(DEFAULT_INDEX_NAME, "INDEX");
        defaults.put(DEFAULT_TABLESPACE_NAME, "TABLESPACE");
        defaults.put(DEFAULT_DATABASE_NAME, "database");
        defaults.put(DEFAULT_TABLESPACEPARTITION_NAME, "TSPARTITION");
        defaults.put(DEFAULT_LOGICAL_DATATYPE_NAME, "Logical type");
        defaults.put(DEFAULT_DATATYPE_CODE, "NUMBER, 14, 4");
        defaults.put(IDPREFIX_ENTITY, "ENT");
        defaults.put(IDPREFIX_ATTRIBUTE, "ATT");
        defaults.put(IDPREFIX_RELATION, "REL");
        defaults.put(IDPREFIX_INHERITANCE, "INHR");
        defaults.put(IDPREFIX_ALTERNATE_KEY, "ALT");
        defaults.put(IDPREFIX_TABLE, "TAB");
        defaults.put(IDPREFIX_TABLEVIEW, "VW");
        defaults.put(IDPREFIX_ENTITYVIEW, "VW");
        defaults.put(IDPREFIX_COLUMN, "COL");
        defaults.put(IDPREFIX_INDEX, "IDX");
        defaults.put(IDPREFIX_DOMAIN, "DOM");
        defaults.put(IDPREFIX_RDBMS_SITE, "SITE");
        defaults.put(IDPREFIX_LOGTYPES, "LOGDT");
    }
}

