/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import oracle.dbtools.crest.model.persistence.ConfigurationFileLoader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;

public class MDConfiguration
extends ConfigurationFileLoader
implements Serializable {
    public static final String PATH_BASE_FILE = "defaultFilePath";
    public static final String PATH_BASE_PROPERTIES = "defaultPropertiesPath";
    public static final String PATH_OLD_REL_STORAGE = "oldstoragePath";
    public static final String PATH_REL_STORAGE = "storagePath";
    public static final String PATH_REL_ENTITY = "entityPath";
    public static final String PATH_REL_RELATION = "relationPath";
    public static final String PATH_REL_INHERITANCE = "inheritancePath";
    public static final String PATH_REL_ARC = "arcPath";
    public static final String PATH_REL_NOTE = "notePath";
    public static final String PATH_REL_DOMAIN = "domainPath";
    public static final String PATH_RDBMS_SITES_REL_DOMAIN = "rdbmsSitePath";
    public static final String PATH_REL_LOGICAL_TYPE = "logtypePath";
    public static final String PATH_TYPES = "typesPath";
    public static final String PATH_REL_TABLE = "tablePath";
    public static final String PATH_REL_FKEY = "fkeyPath";
    public static final String PATH_DF_PROCESS = "processPath";
    public static final String PATH_DF_AGENT = "agentPath";
    public static final String PATH_DF_STORE = "storePath";
    public static final String PATH_DF_FLOW = "flowPath";
    public static final String PATH_DF_EVENT = "eventPath";
    public static final String PATH_DF_EXT_DATA = "extDataPath";
    public static final String PATH_DF_REC_STRUCTURE = "recordStructurePath";
    public static final String PATH_DF_INFOSTRUCTURE = "infoStructurePath";
    public static final String PATH_DF_ROLE = "rolePath";
    public static final String PATH_REL_TABLEVIEW = "tableViewPath";
    public static final String PATH_REL_INDEX = "indexPath";
    public static final String PATH_MD_CUBE = "cubePath";
    public static final String PATH_MD_SLICE = "slicePath";
    public static final String PATH_MD_SQLTOAW = "sqltoawPath";
    public static final String PATH_MD_DIMENSION = "dimensionPath";
    public static final String PATH_MD_HIERARCHY = "hierarchyPath";
    public static final String PATH_MD_LEVEL = "levelPath";
    public static final String PATH_MD_ROLLUPLINK = "rolluplinkPath";
    public static final String PATH_MD_RAGGEDHLINK = "raggedhlinkPath";
    public static final String PATH_MD_MEASURE = "measurePath";
    public static final String PATH_MD_LINK = "linkPath";
    public static final String PATH_MD_SEL_CRITERIA = "selcriteriaPath";
    public static final String PATH_MD_FE_JOINS = "feJoinsPath";
    public static final String PATH_MD_MEASUREFOLDER = "measureFolderPath";
    public static final String PATH_REL_SCHEMA = "schemaPath";
    public static final String PATH_DT_DISTINCT_TYPE = "distincttypePath";
    public static final String PATH_DT_STRUCTURED_TYPE = "structuredtypePath";
    public static final String PATH_DT_COLLECTION_TYPE = "collectiontypePath";
    public static final String PATH_BI_DOCUMENT = "docPath";
    public static final String PATH_BI_PARTY = "partyPath";
    public static final String PATH_BI_CONTACT = "contactPath";
    public static final String PATH_BI_PHONE = "phonePath";
    public static final String PATH_BI_EMAIL = "emailPath";
    public static final String PATH_BI_LOCATION = "locationPath";
    public static final String PATH_BI_URL = "urlPath";
    public static final String APPLICATION_NAME = "appName";
    public static final String DATEONLY_FORMAT = "dateonlyformat";
    public static final String TIMESTAMP_FORMAT = "dateformat";
    public static final String TIMESTAMP_FORMAT_TZ = "dateformatTZ";
    public static final String NAME_PHYS_DESIGN = "namePhysDesign";
    public static final String NAME_LOG_DESIGN = "nameLogDesign";
    public static final String NAME_DF_DESIGN = "nameDFDesign";
    public static final String TYPE_SYSTEM_OUT = "enable.system.out";
    public static final String TEST_WRITE_TIMEOUT = "test.write.timeout";
    public static final String XML_DOCUMENTTYPE = "xml.documenttype";
    public static final String XML_PRETTY_PRINT = "xml.prettyprint";
    public static final String PATH_REL_RDBMSTYPES = "knownRdbmsTypes";
    public static final String OBJECT_ETL4ALL_INTEGRATION_MANAGER = "object.atl4allintegrationmanager";
    public static final String OBJECT_WORDMAPPER = "object.wordmapper";
    public static final String PREFIX_OBJECT = "object.";
    public static final String PREFIX_PLUGIN = "plugin.";
    private static MDConfiguration instance;
    private Map stringMap = new TreeMap();
    private Map classNameMap = new TreeMap();
    public static final SimpleDateFormat DATEONLY_FORMATTER;
    public static final SimpleDateFormat DATE_FORMATTER;
    public static final SimpleDateFormat DATE_FORMATTER_TZ;
    private static final Logger LOGGER;

    private MDConfiguration() {
        this.initMap();
    }

    protected void initMap() {
        this.stringMap.put(PATH_BASE_FILE, ApplicationView.basePath);
        this.stringMap.put(PATH_REL_DOMAIN, "domains");
        this.stringMap.put(PATH_RDBMS_SITES_REL_DOMAIN, "rdbms");
        this.stringMap.put(PATH_REL_RDBMSTYPES, "rdbms");
        this.stringMap.put(PATH_OLD_REL_STORAGE, "storage");
        this.stringMap.put(PATH_REL_STORAGE, "phys");
        this.stringMap.put(PATH_REL_LOGICAL_TYPE, "logtypes");
        this.stringMap.put(PATH_TYPES, "types");
        this.stringMap.put(PATH_REL_ENTITY, "entity");
        this.stringMap.put(PATH_REL_ARC, "arc");
        this.stringMap.put(PATH_REL_NOTE, "note");
        this.stringMap.put(PATH_REL_TABLE, "table");
        this.stringMap.put(PATH_REL_FKEY, "foreignkey");
        this.stringMap.put(PATH_REL_TABLEVIEW, "view");
        this.stringMap.put(PATH_REL_INDEX, "index");
        this.stringMap.put(PATH_REL_RELATION, "relation");
        this.stringMap.put(PATH_REL_INHERITANCE, "inheritance");
        this.stringMap.put(PATH_DF_PROCESS, "process");
        this.stringMap.put(PATH_DF_AGENT, "agent");
        this.stringMap.put(PATH_DF_STORE, "store");
        this.stringMap.put(PATH_DF_FLOW, "flow");
        this.stringMap.put(PATH_DF_EVENT, "event");
        this.stringMap.put(PATH_DF_EXT_DATA, "extdata");
        this.stringMap.put(PATH_DF_REC_STRUCTURE, "recordstructure");
        this.stringMap.put(PATH_DF_INFOSTRUCTURE, "infostructure");
        this.stringMap.put(PATH_DF_ROLE, "role");
        this.stringMap.put(PATH_MD_CUBE, "cube");
        this.stringMap.put(PATH_MD_SLICE, "slice");
        this.stringMap.put(PATH_MD_SQLTOAW, "sqltoaw");
        this.stringMap.put(PATH_MD_DIMENSION, "dimension");
        this.stringMap.put(PATH_MD_HIERARCHY, "hierarchy");
        this.stringMap.put(PATH_MD_LEVEL, "level");
        this.stringMap.put(PATH_MD_MEASURE, "measure");
        this.stringMap.put(PATH_MD_LINK, "link");
        this.stringMap.put(PATH_MD_ROLLUPLINK, "rolluplink");
        this.stringMap.put(PATH_MD_RAGGEDHLINK, "rhlink");
        this.stringMap.put(PATH_MD_SEL_CRITERIA, "selcriteria");
        this.stringMap.put(PATH_MD_FE_JOINS, "fejoins");
        this.stringMap.put(PATH_MD_MEASUREFOLDER, "measurefolder");
        this.stringMap.put(PATH_DT_DISTINCT_TYPE, "distincttype");
        this.stringMap.put(PATH_DT_STRUCTURED_TYPE, "structuredtype");
        this.stringMap.put(PATH_DT_COLLECTION_TYPE, "collectiontype");
        this.stringMap.put(PATH_BI_DOCUMENT, "document");
        this.stringMap.put(PATH_BI_PARTY, "party");
        this.stringMap.put(PATH_BI_CONTACT, "contact");
        this.stringMap.put(PATH_BI_PHONE, "phone");
        this.stringMap.put(PATH_BI_EMAIL, "email");
        this.stringMap.put(PATH_BI_LOCATION, "location");
        this.stringMap.put(PATH_BI_URL, "url");
        if (ApplicationView.IS_VIEWER) {
            this.stringMap.put(APPLICATION_NAME, "Oracle SQL Developer Data Modeler Viewer");
        } else {
            this.stringMap.put(APPLICATION_NAME, "Oracle SQL Developer Data Modeler");
        }
        this.stringMap.put(DATEONLY_FORMAT, "yyyy-MM-dd");
        this.stringMap.put(TIMESTAMP_FORMAT, "yyyy-MM-dd HH:mm:ss");
        this.stringMap.put(TIMESTAMP_FORMAT_TZ, "yyyy-MM-dd HH:mm:ss zzz");
        this.stringMap.put(NAME_LOG_DESIGN, "Logical");
        this.stringMap.put(NAME_PHYS_DESIGN, "Relational");
        this.stringMap.put(NAME_DF_DESIGN, "DataFlow");
        this.stringMap.put(TYPE_SYSTEM_OUT, "enable");
        this.stringMap.put(XML_DOCUMENTTYPE, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.stringMap.put(XML_PRETTY_PRINT, "true");
        this.stringMap.put(OBJECT_WORDMAPPER, "oracle.dbtools.crest.model.design.WordMapper");
    }

    public static MDConfiguration getDefaultInstance() {
        if (instance == null) {
            instance = new MDConfiguration();
        }
        return instance;
    }

    public void loadStringValues(Map map) {
        this.loadProps(map, this.stringMap);
    }

    public void loadObjectValues(Map map) {
        this.loadProps(map, this.classNameMap);
    }

    public String get(String string) {
        return (String)this.stringMap.get(string);
    }

    public void put(String string, String string2) {
        this.stringMap.put(string, string2);
    }

    public static String timeToString(long l) {
        return MDConfiguration.timeToString(l, null);
    }

    public static String timeToString(long l, String string) {
        if (string != null) {
            DATE_FORMATTER_TZ.setTimeZone(TimeZone.getTimeZone(string));
        } else {
            DATE_FORMATTER_TZ.setTimeZone(TimeZone.getDefault());
        }
        return DATE_FORMATTER_TZ.format(new Date(l));
    }

    public static long stringToTime(String string) {
        return MDConfiguration.stringToTime(string, null);
    }

    public static long stringToTime(String string, String string2) {
        if (string2 != null) {
            DATE_FORMATTER_TZ.setTimeZone(TimeZone.getTimeZone(string2));
        } else {
            DATE_FORMATTER_TZ.setTimeZone(TimeZone.getDefault());
        }
        try {
            return DATE_FORMATTER_TZ.parse(string).getTime();
        }
        catch (ParseException parseException) {
            try {
                if (string2 != null) {
                    DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone(string2));
                } else {
                    DATE_FORMATTER.setTimeZone(TimeZone.getDefault());
                }
                return DATE_FORMATTER.parse(string).getTime();
            }
            catch (ParseException parseException2) {
                LOGGER.error("", parseException2);
                return 0L;
            }
        }
    }

    public void putObject(String string, String string2) {
        this.classNameMap.put(string, string2);
    }

    public Object getObject(String string) {
        String string2 = (String)this.stringMap.get(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.startsWith(PREFIX_OBJECT) && !string.startsWith(PREFIX_PLUGIN)) {
            stringBuffer.append("Property should start with: ");
            stringBuffer.append(PREFIX_OBJECT);
            stringBuffer.append(" or ");
            stringBuffer.append(PREFIX_PLUGIN);
            throw new RuntimeException(stringBuffer.toString());
        }
        if (string2 == null) {
            stringBuffer.append("Can not load object in MDConfiguration");
            stringBuffer.append("MDConfiguration.getObject() no configuration for <");
            stringBuffer.append(string);
            stringBuffer.append(">");
            throw new RuntimeException(stringBuffer.toString());
        }
        try {
            Class<?> clazz = Class.forName(string2);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            stringBuffer.append("Can not find class named: <");
            stringBuffer.append(string2);
            stringBuffer.append("> for MDConfiguration.getObject(), property: ");
            stringBuffer.append(string);
            stringBuffer.append(". Probably not in classpath.");
        }
        catch (InstantiationException instantiationException) {
            stringBuffer.append("MDConfiguration.getObject() can not instantiate abstract class or interface: <");
            stringBuffer.append(string2);
            stringBuffer.append(">.");
        }
        catch (IllegalAccessException illegalAccessException) {
            stringBuffer.append("Class is not public or default constructor is not accessible for MDConfiguration.getObject() in <");
            stringBuffer.append(string2);
            stringBuffer.append(">.");
        }
        throw new RuntimeException(stringBuffer.toString());
    }

    @Override
    protected void createDefaultFile(File file) {
        File file2 = new File(file, "modelconfig.properties");
        try {
            System.out.println("MDConfiguration writing: " + file2);
            file2.createNewFile();
            this.storeMap(this.stringMap, file2);
        }
        catch (Exception exception) {
            LOGGER.error("", exception);
        }
    }

    public Iterator getPluginNames() {
        return this.getNamesStartingWith(PREFIX_PLUGIN);
    }

    protected Iterator getNamesStartingWith(String string) {
        Iterator iterator = this.stringMap.keySet().iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            linkedList.add(string2);
        }
        return linkedList.iterator();
    }

    public void writeMap(Writer writer) {
        try {
            this.storeMap(this.stringMap, writer);
        }
        catch (IOException iOException) {
            LOGGER.error("MDConfiguration.writeMap(Writer)", iOException);
        }
    }

    public static void main(String[] stringArray) {
        MDConfiguration mDConfiguration = new MDConfiguration();
        mDConfiguration.writePropertyFile();
    }

    static {
        DATEONLY_FORMATTER = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get(DATEONLY_FORMAT));
        DATE_FORMATTER = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get(TIMESTAMP_FORMAT));
        DATE_FORMATTER_TZ = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get(TIMESTAMP_FORMAT_TZ));
        LOGGER = new Logger(MDConfiguration.class);
    }
}

