/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.ChangeRequestPropertiesDialog;

public class ChangeRequest
extends DesignObject {
    private String reason = "";
    private String status = STATUS_STATES_INTERNAL[0];
    private boolean completed = false;
    private String requestDate = "";
    private String completionDate = "";
    private String implDescription = "";
    public static final String[] STATUS_STATES_DISPLAY = new String[]{Messages.getString("ChangeRequest.Proposed"), Messages.getString("ChangeRequest.Agreed"), Messages.getString("ChangeRequest.Implemented"), Messages.getString("ChangeRequest.Implementing"), Messages.getString("ChangeRequest.Rejected")};
    public static final String[] STATUS_STATES_INTERNAL = new String[]{"Proposed", "Agreed", "Implemented", "Implementing", "Rejected"};
    private static Set statusSet = null;
    private ArrayList objects;
    public static final String TYPE_NAME = "ChangeRequest";

    public ChangeRequest(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ChangeRequestPropertiesDialog changeRequestPropertiesDialog = new ChangeRequestPropertiesDialog(this.getDesign().getAppView(), this);
            changeRequestPropertiesDialog.initProperties(this);
            changeRequestPropertiesDialog.show();
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    private boolean checkStatus(String string) {
        if (statusSet == null) {
            statusSet = new HashSet();
            statusSet.addAll(Arrays.asList(STATUS_STATES_INTERNAL));
        }
        return statusSet.contains(string);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean bl) {
        this.completed = bl;
    }

    public String getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(String string) {
        if (string != null && string.equals(this.completionDate)) {
            return;
        }
        this.completionDate = string;
    }

    public String getImplDescription() {
        return this.implDescription;
    }

    public void setImplDescription(String string) {
        if (string != null && string.equals(this.implDescription)) {
            return;
        }
        this.implDescription = string;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        if (string != null && string.equals(this.reason)) {
            return;
        }
        this.reason = string;
    }

    public String getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(String string) {
        if (string != null && string.equals(this.requestDate)) {
            return;
        }
        this.requestDate = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        if (string != null && string.equals(this.status)) {
            return;
        }
        if (this.checkStatus(string)) {
            this.status = string;
        }
    }

    public ArrayList getObjects() {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        return this.objects;
    }

    public void addObject(DesignObject designObject) {
        if (!this.getObjects().contains(designObject)) {
            this.getObjects().add(designObject);
        }
    }

    public void removeObject(DesignObject designObject) {
        this.getObjects().remove(designObject);
    }

    public void setObject(DesignObject designObject) {
        if (!this.getObjects().contains(designObject)) {
            this.getObjects().add(designObject);
        }
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "changerequest/" + this.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

