/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.imports.var.process.RHStructureAttributes;
import oracle.dbtools.crest.imports.var.process.RHStructureEntities;
import oracle.dbtools.crest.imports.var.process.RHStructureProps;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.util.logging.Logger;

public class RHStructure
extends RowHandler {
    public static final String OBJECT_TYPE = "STRUCTURE";
    private static final Logger LOGGER = new Logger(RHStructure.class);

    public RHStructure(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createStructure(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createStructure(VarFileLine varFileLine) {
        block12: {
            try {
                int n;
                int n2;
                String string = this.getField(varFileLine, "general_id");
                String string2 = this.getField(varFileLine, "STRUCTURE_NAME");
                InfoStructure infoStructure = this.getProcessModel().createInfoStructure();
                if (infoStructure == null) break block12;
                infoStructure.setName(string2);
                String string3 = this.getComment(varFileLine);
                infoStructure.setComment(string3);
                infoStructure.setSynonym(this.getSynonym(varFileLine));
                infoStructure.setNotes(this.getNotes(varFileLine, "NOTE_STRUCTURE_ID"));
                this.setFlows(infoStructure, string);
                String string4 = this.getField(varFileLine, "STRUCTURE_VOLUME_INFO");
                if (!"0".equalsIgnoreCase(string4)) {
                    try {
                        int n3 = 0x200000;
                        n2 = 0x40000000;
                        n = Integer.parseInt(string4);
                        if (n < 0) {
                            if ((n += n2) < 0) {
                                n += n2;
                                infoStructure.setGrowthRateUnit(InfoStructure.GROWTH_RATE_UNITS[1]);
                            } else {
                                infoStructure.setGrowthRateUnit(InfoStructure.GROWTH_RATE_UNITS[2]);
                            }
                        }
                        if (n > 0) {
                            int n4 = n / n3;
                            int n5 = n % n3;
                            infoStructure.setVolume(n5);
                            infoStructure.setGrowthRatePercent(n4);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Error in RHStructure.createStructure()", numberFormatException);
                    }
                }
                try {
                    List list = this.getAttributesIDs(string);
                    n2 = list.size();
                    for (n = 0; n < n2; ++n) {
                        String string5 = (String)list.get(n);
                        Attribute attribute = (Attribute)this.getAllCreatedObjects().get(string5);
                        if (attribute == null) continue;
                        infoStructure.addAttribute(attribute);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error in RHStructure.createStructure() - Assign Attributes", exception);
                }
                this.addCreatedObject(string, infoStructure);
            }
            catch (Exception exception) {
                LOGGER.error("Error in RHStructure.createStructure()", exception);
            }
        }
        this.removeSelectedLine(varFileLine);
    }

    private List getAttributesIDs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = (List)this.getSpecificRowHandler(RHStructureEntities.class).getMap().get(string);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                VarFileLine varFileLine = (VarFileLine)list.get(i);
                String string2 = this.getField(varFileLine, "general_id");
                List list2 = (List)this.getSpecificRowHandler(RHStructureAttributes.class).getMap().get(string2);
                if (list2 == null) continue;
                int n2 = list2.size();
                for (int j = 0; j < n2; ++j) {
                    VarFileLine varFileLine2 = (VarFileLine)list2.get(j);
                    arrayList.add(this.getField(varFileLine2, "STRUCTURE_ATTR_ATTRIBUTE_ID"));
                }
            }
        }
        return arrayList;
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        String string2 = this.getField(varFileLine, "STRUCTURE_TEXT_ID");
        if (!"0".equalsIgnoreCase(string2)) {
            VarFileLine varFileLine2 = this.getCommentLine(string2, "ANLTEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "TEXT_COMMENT_2");
                this.removeSelectedLine(varFileLine2);
            }
        } else {
            string = "";
        }
        return string;
    }

    private void setFlows(InfoStructure infoStructure, String string) {
        List list = this.getSpecificRowHandler(RHStructureProps.class).getOwnLines();
        for (int i = list.size() - 1; i >= 0; --i) {
            VarFileLine varFileLine = (VarFileLine)list.get(i);
            if (!string.equalsIgnoreCase(this.getField(varFileLine, "general_id"))) continue;
            String string2 = this.getField(varFileLine, "DESTINATION_OBJECT_ID");
            Flow flow = (Flow)this.getAllCreatedObjects().get(string2);
            if (flow != null) {
                flow.addInfoStructure(infoStructure);
            }
            list.remove(varFileLine);
        }
    }

    private String getSynonym(VarFileLine varFileLine) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getField(varFileLine, "general_id");
        for (VarFileLine varFileLine2 : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine varFileLine3;
            String string2;
            String string3;
            if (!varFileLine2.getType().equalsIgnoreCase("STRUCTURESYNONYM_O") || !string.equalsIgnoreCase(string3 = this.getField(varFileLine2, "general_id")) || "0".equalsIgnoreCase(string2 = this.getField(varFileLine2, "SYNONYM_ID")) || (varFileLine3 = this.getCommentLine(string2, "SYNONYM_OBJECT")) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.getField(varFileLine3, "SYNONYM_OBJ_NAME"));
        }
        return stringBuffer.toString();
    }
}

