/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.util.logging.Logger;

public class RHStore
extends RowHandler {
    public static final String OBJECT_TYPE = "INFO_STORE";
    private static final Logger LOGGER = new Logger(RHStore.class);

    public RHStore(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createStore(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createStore(VarFileLine varFileLine) {
        try {
            Object object;
            String string = this.getField(varFileLine, "general_id");
            String string2 = this.getField(varFileLine, "INFO_STORE_NAME");
            String string3 = this.getField(varFileLine, "INFO_STORE_PROCESS_ID");
            String string4 = this.getField(varFileLine, "INFO_STORE_PMID");
            DesignObject designObject = null;
            if (!"0".equalsIgnoreCase(string3)) {
                DataFlowDesign dataFlowDesign;
                object = (Process)this.getAllCreatedObjects().get(string3);
                if (object != null && (dataFlowDesign = ((Process)object).getDiagram()) != null) {
                    designObject = dataFlowDesign.createInfoStore();
                    ((DPVProcess)dataFlowDesign.getMainView()).createViewSynonim(designObject);
                }
            } else if (!"".equalsIgnoreCase(string4) && (object = (DataFlowDesign)this.getAllCreatedObjects().get(string4)) != null) {
                designObject = ((DataFlowDesign)object).createInfoStore();
                ((DPVProcess)((DataFlowDesign)object).getMainView()).createViewSynonim(designObject);
            }
            if (designObject != null) {
                designObject.setName(string2);
                object = this.getComment(varFileLine);
                designObject.setComment((String)object);
                ((InfoStore)designObject).setSystemObjective(this.getSystemObjective(varFileLine));
                ((AbstractProcessObject)designObject).setSynonym(this.getSynonym(varFileLine));
                designObject.setNotes(this.getNotes(varFileLine, "NOTE_STORE_ID"));
                this.addCreatedObject(string, designObject);
                this.removeSelectedLine(varFileLine);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error in RHStore.createStore()", exception);
        }
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        String string2 = this.getField(varFileLine, "INFO_STORE_TEXT_ID");
        if (!"0".equalsIgnoreCase(string2)) {
            VarFileLine varFileLine2 = this.getCommentLine(string2, "ANLTEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "TEXT_COMMENT_2");
                this.removeSelectedLine(varFileLine2);
            }
        } else {
            string = "";
        }
        return string;
    }

    private String getSystemObjective(VarFileLine varFileLine) {
        String string = null;
        String string2 = this.getField(varFileLine, "INFO_STORE_SYSTEM_OBJECTIVE");
        if (!"0".equalsIgnoreCase(string2)) {
            VarFileLine varFileLine2 = this.getCommentLine(string2, "ANLTEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "TEXT_COMMENT_2");
                this.removeSelectedLine(varFileLine2);
            }
        } else {
            string = "";
        }
        return string;
    }

    private String getSynonym(VarFileLine varFileLine) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getField(varFileLine, "general_id");
        for (VarFileLine varFileLine2 : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine varFileLine3;
            String string2;
            String string3;
            if (!varFileLine2.getType().equalsIgnoreCase("INFO_STORESYNONYM_") || !string.equalsIgnoreCase(string3 = this.getField(varFileLine2, "general_id")) || "0".equalsIgnoreCase(string2 = this.getField(varFileLine2, "SYNONYM_ID")) || (varFileLine3 = this.getCommentLine(string2, "SYNONYM_OBJECT")) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.getField(varFileLine3, "SYNONYM_OBJ_NAME"));
        }
        return stringBuffer.toString();
    }
}

