/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.util.logging.Logger;

public class RHProcess
extends RowHandler {
    public static final String OBJECT_TYPE = "PROCESS";
    private static final Logger LOGGER = new Logger(RHProcess.class);

    public RHProcess(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createProcess(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private Process getParent(String string) {
        Process process = null;
        for (VarFileLine varFileLine : this.getAllSelectedLines()) {
            Object object;
            if (!varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || !string.equalsIgnoreCase(this.getField(varFileLine, "general_id"))) continue;
            String string2 = this.getField(varFileLine, "PROCESS_PARENT_PROCESS_ID");
            String string3 = this.getField(varFileLine, "PROCESS_NAME");
            String string4 = this.getField(varFileLine, "PROCESS_PMID");
            if (!"0".equalsIgnoreCase(string2)) {
                DataFlowDesign dataFlowDesign;
                object = (Process)this.getAllCreatedObjects().get(string2);
                if (object == null) {
                    object = this.getParent(string2);
                }
                if (object != null && (dataFlowDesign = ((Process)object).getDiagram()) != null) {
                    process = dataFlowDesign.createProcess();
                }
            } else if (!"".equalsIgnoreCase(string4) && (object = (DataFlowDesign)this.getAllCreatedObjects().get(string4)) != null) {
                process = ((DataFlowDesign)object).createProcess();
            }
            if (process != null) {
                object = this.getField(varFileLine, "PROCESS_TYPE");
                if ("0".equalsIgnoreCase((String)object)) {
                    process.setType(1);
                    process.getDiagram().setVisible(false);
                }
                this.addCreatedObject(string, process);
            }
            return process;
        }
        return process;
    }

    private void createProcess(VarFileLine varFileLine) {
        block32: {
            try {
                Process process;
                String string;
                block33: {
                    Object object;
                    Object object2;
                    string = this.getField(varFileLine, "general_id");
                    String string2 = this.getField(varFileLine, "PROCESS_NAME");
                    String string3 = this.getField(varFileLine, "PROCESS_PARENT_PROCESS_ID");
                    String string4 = this.getField(varFileLine, "PROCESS_PMID");
                    process = (Process)this.getAllCreatedObjects().get(string);
                    if (process == null) {
                        if (!"0".equalsIgnoreCase(string3)) {
                            object2 = (Process)this.getAllCreatedObjects().get(string3);
                            if (object2 == null) {
                                object2 = this.getParent(string3);
                            }
                            if (object2 != null && (object = ((Process)object2).getDiagram()) != null) {
                                process = ((DataFlowDesign)object).createProcess();
                            }
                        } else if (!"".equalsIgnoreCase(string4) && (object2 = (DataFlowDesign)this.getAllCreatedObjects().get(string4)) != null) {
                            process = ((DataFlowDesign)object2).createProcess();
                        }
                        if (process != null && "0".equalsIgnoreCase((String)(object2 = this.getField(varFileLine, "PROCESS_TYPE")))) {
                            process.setType(1);
                            process.getDiagram().setVisible(false);
                        }
                    }
                    if (process == null) break block32;
                    process.setName(string2);
                    object2 = this.getComment(varFileLine);
                    process.setComment((String)object2);
                    process.setSynonym(this.getSynonym(varFileLine));
                    process.setNotes(this.getNotes(varFileLine, "NOTE_PROCESS_ID"));
                    process.setFootNote(this.getField(varFileLine, "PROCESS_FOOTNOTE"));
                    object = this.getField(varFileLine, "PROCESS_MODE");
                    try {
                        String string5;
                        String string6;
                        int n = Integer.parseInt((String)object);
                        process.setMode(Process.MODES[n]);
                        if (n == 1) {
                            string6 = this.getField(varFileLine, "PROCESS_BATCH_MIN_TRANS");
                            try {
                                int n2 = Integer.parseInt(string6);
                                process.setBatchMinimumTransactions(n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            string5 = this.getField(varFileLine, "PROCESS_BATCH_TIME_UNIT");
                            try {
                                int n3 = Integer.parseInt(string5);
                                process.setBatchTimeUnit(Process.BATCH_TIME_UNITS[n3 - 1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("Error in RHProcess.createProcess()", numberFormatException);
                            }
                            break block33;
                        }
                        if (n != 2) break block33;
                        string6 = this.getField(varFileLine, "PROCESS_LONGEST_RESPONSE_TIME");
                        try {
                            int n4 = Integer.parseInt(string6);
                            process.setInteractiveLongestResponseTime(n4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("Error in RHProcess.createProcess()", numberFormatException);
                        }
                        string5 = this.getField(varFileLine, "PROCESS_RESPONSE_TIME_UNIT");
                        try {
                            int n5 = Integer.parseInt(string5);
                            process.setInteractiveResponseTimeUnit(Process.INTERACTIVE_RESPONSE_TIME_UNITS[n5 - 1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("Error in RHProcess.createProcess()", numberFormatException);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                String string7 = this.getField(varFileLine, "PROCESS_FREQ_TIMES");
                try {
                    int n = Integer.parseInt(string7);
                    process.setFrequencyTimes(n);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Error in RHProcess.createProcess()", numberFormatException);
                }
                String string8 = this.getField(varFileLine, "PROCESS_FREQ_TIME_UNIT");
                try {
                    int n = Integer.parseInt(string8);
                    if (n <= 6) {
                        process.setFrequencyTimeUnit(Process.FREQUENCY_TIME_UNITS[n - 1]);
                    } else {
                        process.setFrequencyTimeUnit(Process.FREQUENCY_TIME_UNITS[8]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Error in RHProcess.createProcess()", numberFormatException);
                }
                String string9 = this.getField(varFileLine, "PROCESS_PRIORITY");
                try {
                    int n = Integer.parseInt(string9);
                    process.setPriority(Process.PRIORITY[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Error in RHProcess.createProcess()", numberFormatException);
                }
                String string10 = this.getField(varFileLine, "PROCESS_PEAK_PERIODS");
                try {
                    int n = Integer.parseInt(string10);
                    if (n > 0) {
                        for (int i = 0; i < 24; ++i) {
                            int n6 = n & 1 << i;
                            process.getPeakPeriods()[i] = n6 != 0;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("Error in RHProcess.createProcess()", numberFormatException);
                }
                this.addCreatedObject(string, process);
                this.removeSelectedLine(varFileLine);
            }
            catch (Exception exception) {
                LOGGER.error("Error in RHProcess.createProcess()", exception);
            }
        }
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        String string2 = this.getField(varFileLine, "PROCESS_TEXT_ID");
        if (!"0".equalsIgnoreCase(string2)) {
            VarFileLine varFileLine2 = this.getCommentLine(string2, "ANLTEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "TEXT_COMMENT_2");
                this.removeSelectedLine(varFileLine2);
            }
        } else {
            string = "";
        }
        return string;
    }

    private String getSynonym(VarFileLine varFileLine) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getField(varFileLine, "general_id");
        for (VarFileLine varFileLine2 : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine varFileLine3;
            String string2;
            String string3;
            if (!varFileLine2.getType().equalsIgnoreCase("PROCESSSYNONYM_OBJ") || !string.equalsIgnoreCase(string3 = this.getField(varFileLine2, "general_id")) || "0".equalsIgnoreCase(string2 = this.getField(varFileLine2, "SYNONYM_ID")) || (varFileLine3 = this.getCommentLine(string2, "SYNONYM_OBJECT")) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.getField(varFileLine3, "SYNONYM_OBJ_NAME"));
        }
        return stringBuffer.toString();
    }
}

