/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.imports.var.process.RHProcessModelEvents;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.util.logging.Logger;

public class RHClockEvent
extends RowHandler {
    public static final String OBJECT_TYPE = "CLOCK_EVENT";
    private static final Logger LOGGER = new Logger(RHClockEvent.class);

    public RHClockEvent(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createEvent(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createEvent(VarFileLine varFileLine) {
        block26: {
            try {
                DesignObject designObject;
                String string;
                block27: {
                    int n;
                    String string2;
                    Object object;
                    string = this.getField(varFileLine, "general_id");
                    String string3 = this.getField(varFileLine, "EVENT_NAME");
                    String string4 = this.getDiagramID(string);
                    designObject = null;
                    if (!"".equalsIgnoreCase(string4) && (object = (DataFlowDesign)this.getAllCreatedObjects().get(string4)) != null) {
                        designObject = ((DataFlowDesign)object).getProcessModel().createEvent(1);
                    }
                    if (designObject == null) break block26;
                    designObject.setName(string3);
                    object = this.getComment(varFileLine);
                    designObject.setComment((String)object);
                    ((AbstractProcessObject)designObject).setSynonym(this.getSynonym(varFileLine));
                    designObject.setNotes(this.getNotes(varFileLine, "NOTE_CLOCK_EVENT_ID"));
                    String string5 = this.getField(varFileLine, "CLOCK_EVENT_ON_DAY");
                    if (!"0".equalsIgnoreCase(string5)) {
                        ((Event)designObject).setOnDay(false);
                        string2 = this.getField(varFileLine, "CLOCK_EVENT_FREQUENCY");
                        try {
                            n = Integer.parseInt(string2);
                            ((Event)designObject).setFrequency(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                        }
                    }
                    string2 = this.getField(varFileLine, "CLOCK_EVENT_DAY_OF_WEEK");
                    try {
                        n = Integer.parseInt(string2);
                        ((Event)designObject).setDayOfWeek(Event.DAYS_OF_WEEK[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                    }
                    String string6 = this.getField(varFileLine, "CLOCK_EVENT_DAY_OF_MONTH");
                    try {
                        int n2 = Integer.parseInt(string6);
                        ((Event)designObject).setDayOfMonth(n2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                    }
                    String string7 = this.getField(varFileLine, "CLOCK_EVENT_MONTH");
                    try {
                        int n3 = Integer.parseInt(string7);
                        ((Event)designObject).setMonths(Event.MONTHS[n3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                    }
                    String string8 = this.getField(varFileLine, "CLOCK_EVENT_QUARTER");
                    try {
                        int n4 = Integer.parseInt(string8);
                        ((Event)designObject).setQuarter(n4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                    }
                    String string9 = this.getField(varFileLine, "CLOCK_EVENT_FISCAL");
                    if (!"0".equalsIgnoreCase(string9)) {
                        ((Event)designObject).setFiscal(false);
                    }
                    String string10 = this.getField(varFileLine, "CLOCK_EVENT_YEAR");
                    try {
                        int n5 = Integer.parseInt(string10);
                        ((Event)designObject).setYear(n5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                    }
                    String string11 = this.getField(varFileLine, "CLOCK_EVENT_TIMES_WHEN_RUN");
                    try {
                        int n6;
                        String string12;
                        int n7 = Integer.parseInt(string11);
                        ((Event)designObject).setTimesWhenRun(n7 + 1);
                        if (n7 != 3) break block27;
                        String string13 = this.getField(varFileLine, "CLOCK_EVENT_AT_TIME");
                        if (!"0".equalsIgnoreCase(string13)) {
                            ((Event)designObject).setAtTime(true);
                            string12 = this.getField(varFileLine, "CLOCK_EVENT_TIME_FREQUENCY");
                            try {
                                n6 = Integer.parseInt(string12);
                                ((Event)designObject).setTimeFreq(n6);
                            }
                            catch (NumberFormatException numberFormatException) {
                                LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                            }
                        }
                        string12 = this.getField(varFileLine, "CLOCK_EVENT_HOUR");
                        try {
                            n6 = Integer.parseInt(string12);
                            ((Event)designObject).setHour(n6);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                        }
                        String string14 = this.getField(varFileLine, "CLOCK_EVENT_MINUTE");
                        try {
                            int n8 = Integer.parseInt(string14);
                            ((Event)designObject).setMinute(n8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.error("Error in RHClockEvent.createEvent()", numberFormatException);
                    }
                }
                this.addCreatedObject(string, designObject);
                this.removeSelectedLine(varFileLine);
            }
            catch (Exception exception) {
                LOGGER.error("Error in RHClockEvent.createEvent()", exception);
            }
        }
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        String string2 = this.getField(varFileLine, "EVENT_TEXT_ID");
        if (!"0".equalsIgnoreCase(string2)) {
            VarFileLine varFileLine2 = this.getCommentLine(string2, "ANLTEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "TEXT_COMMENT_2");
                this.removeSelectedLine(varFileLine2);
            }
        } else {
            string = "";
        }
        return string;
    }

    private String getDiagramID(String string) {
        List list = this.getSpecificRowHandler(RHProcessModelEvents.class).getOwnLines();
        for (VarFileLine varFileLine : list) {
            if (!varFileLine.getType().equalsIgnoreCase("PROCESS_MODELCLOCK") || !string.equalsIgnoreCase(this.getField(varFileLine, "DESTINATION_OBJECT_ID"))) continue;
            String string2 = this.getField(varFileLine, "general_id");
            return string2;
        }
        return "";
    }

    private String getSynonym(VarFileLine varFileLine) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getField(varFileLine, "general_id");
        for (VarFileLine varFileLine2 : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine varFileLine3;
            String string2;
            String string3;
            if (!varFileLine2.getType().equalsIgnoreCase("CLOCK_EVENTSYNONYM") || !string.equalsIgnoreCase(string3 = this.getField(varFileLine2, "general_id")) || "0".equalsIgnoreCase(string2 = this.getField(varFileLine2, "SYNONYM_ID")) || (varFileLine3 = this.getCommentLine(string2, "SYNONYM_OBJECT")) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.getField(varFileLine3, "SYNONYM_OBJ_NAME"));
        }
        return stringBuffer.toString();
    }
}

