/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.util.logging.Logger;

public class VarFileReader {
    private BufferedReader in;
    private String filePath;
    private String version;
    private Fields constants;
    private String type;
    private String line;
    private String name;
    private static final Logger LOGGER = new Logger(VarFileReader.class);

    public VarFileReader(String string) {
        try {
            this.filePath = string;
            this.in = new BufferedReader(new FileReader(this.filePath));
            this.version = this.readVersionLine();
            this.name = this.readName();
            this.constants = new Fields(this.version);
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer("Can not open file : ");
            stringBuffer.append(string);
            LOGGER.error(stringBuffer.toString(), fileNotFoundException);
        }
    }

    public boolean isSupportedVersion() {
        return this.constants.isSupportedVersion();
    }

    public boolean isLogicalDesign() {
        return this.constants.isLogicalDesign();
    }

    private String readVersionLine() {
        try {
            String string = this.in.readLine().trim();
            return string;
        }
        catch (IOException iOException) {
            StringBuffer stringBuffer = new StringBuffer("Can not read file : ");
            stringBuffer.append(this.filePath);
            LOGGER.error(stringBuffer.toString(), iOException);
            return null;
        }
    }

    public VarFileLine readLine() {
        try {
            String string = this.in.readLine();
            while (string != null) {
                if (this.isTypeLine(string)) {
                    this.type = this.getTypeFromLine(string);
                    this.line = "";
                } else {
                    this.line = string;
                }
                if (!this.line.equalsIgnoreCase("") && !this.type.equalsIgnoreCase("")) {
                    return new VarFileLine(this.type, this.line);
                }
                string = this.in.readLine();
            }
        }
        catch (IOException iOException) {
            StringBuffer stringBuffer = new StringBuffer("Can not read file : ");
            stringBuffer.append(this.filePath);
            LOGGER.error(stringBuffer.toString(), iOException);
            return null;
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public Fields getConstants() {
        return this.constants;
    }

    public boolean isTypeLine(String string) {
        return (string = string.trim()).startsWith("**") && string.endsWith("**");
    }

    public boolean isDataLine(String string) {
        return !this.isTypeLine(string);
    }

    public String getTypeFromLine(String string) {
        if (this.isTypeLine(string = string.trim())) {
            return string.substring(2, string.length() - 2);
        }
        return "";
    }

    public void closeReader() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            StringBuffer stringBuffer = new StringBuffer("Cannot close file in VarFileReader.closeReader : ");
            stringBuffer.append(this.filePath);
            LOGGER.error(stringBuffer.toString(), iOException);
        }
    }

    public void startReader() {
        try {
            this.in = new BufferedReader(new FileReader(this.filePath));
            this.version = this.readVersionLine();
            this.constants = new Fields(this.version);
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer("Can not reset file at beginning: ");
            stringBuffer.append(this.filePath);
            LOGGER.error(stringBuffer.toString(), fileNotFoundException);
        }
    }

    private String readName() {
        int n = this.version.indexOf("\"");
        String string = this.version.substring(n + 1);
        int n2 = string.indexOf("\"");
        this.name = string.substring(0, n2);
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.filePath;
    }
}

