/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RHNotes;
import oracle.dbtools.crest.imports.var.RowCollector;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class RowHandler {
    private RowHandler successor = null;
    private RowCollector rowCollector = null;
    protected ImportLogger importLog = new ImportLogger();

    public RowHandler(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        this.rowCollector = new RowCollector();
        this.rowCollector.initialize(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    public void add(RowHandler rowHandler) {
        RowHandler rowHandler2 = this;
        while (rowHandler2.successor != null) {
            rowHandler2 = rowHandler2.successor;
        }
        rowHandler2.successor = rowHandler;
    }

    public RowHandler next() {
        return this.successor;
    }

    public List getAllTypes() {
        return new ArrayList();
    }

    public void handle(VarFileLine varFileLine, boolean bl) {
        this.nextHandler(varFileLine, bl);
    }

    protected void nextHandler(VarFileLine varFileLine, boolean bl) {
        if (this.successor != null) {
            this.successor.setImportLog(this.importLog);
            this.successor.handle(varFileLine, bl);
        }
    }

    public RowHandler getSpecificRowHandler(Class clazz) {
        if (this.getClass() == clazz) {
            return this;
        }
        if (this.successor != null) {
            return this.successor.getSpecificRowHandler(clazz);
        }
        return null;
    }

    public void read(VarFileLine varFileLine) {
        this.nextRead(varFileLine);
    }

    protected void nextRead(VarFileLine varFileLine) {
        if (this.successor != null) {
            this.successor.read(varFileLine);
        }
    }

    protected String getNotes(VarFileLine varFileLine, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = this.getField(varFileLine, "general_id");
        for (VarFileLine varFileLine2 : this.getSpecificRowHandler(RHNotes.class).getOwnLines()) {
            VarFileLine varFileLine3;
            String string3 = this.getField(varFileLine2, string);
            if (!string2.equalsIgnoreCase(string3)) continue;
            String string4 = this.getField(varFileLine2, "note_text_id");
            String string5 = this.getField(varFileLine2, "note_text_name");
            if ("0".equalsIgnoreCase(string4) || (varFileLine3 = this.getCommentLine(string4, "ANLTEXT")) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n\n");
            }
            stringBuffer.append(string5).append("\n");
            stringBuffer.append(this.getField(varFileLine3, "TEXT_COMMENT_2"));
        }
        return stringBuffer.toString();
    }

    protected void addSelectedLine(VarFileLine varFileLine) {
        this.rowCollector.addSelectedLine(varFileLine);
    }

    protected void addForeignKeyLine(VarFileLine varFileLine) {
        this.rowCollector.addForeignKeyLine(varFileLine);
    }

    protected void addPrimaryKeyLine(VarFileLine varFileLine) {
        this.rowCollector.addPrimaryKeyLine(varFileLine);
    }

    protected void addColumnLine(VarFileLine varFileLine) {
        this.rowCollector.addColumnLine(varFileLine);
    }

    protected void addReferences(String string, Object object) {
        this.rowCollector.addReferences(string, object);
    }

    protected void addCreatedObject(String string, ModelIDObject modelIDObject) {
        this.rowCollector.addCreatedObject(string, modelIDObject);
    }

    protected boolean contains(VarFileLine varFileLine) {
        return this.rowCollector.contains(varFileLine);
    }

    public List getAllSelectedLines() {
        return this.rowCollector.getAllSelectedLines();
    }

    public List getCommentLines() {
        return this.rowCollector.getCommentLines();
    }

    public void setCommentLines(List list) {
        this.rowCollector.setCommentLines(list);
    }

    public List getAllForeignKeyLines() {
        return this.rowCollector.getAllForeignKeyLines();
    }

    public List getAllPrimaryKeyLines() {
        return this.rowCollector.getAllPrimaryKeyLines();
    }

    public List getAllColumnLines() {
        return this.rowCollector.getAllColumnLines();
    }

    public VarFileLine getLastSelectedLine() {
        return this.rowCollector.getLastSelectedLine();
    }

    public List getSelectedLinesOfType(String string) {
        return this.rowCollector.getSelectedLinesOfType(string);
    }

    public List removeSelectedLinesOfType(String string) {
        return this.rowCollector.removeSelectedLinesOfType(string);
    }

    public void removeSelectedLine(VarFileLine varFileLine) {
        this.rowCollector.removeSelectedLine(varFileLine);
    }

    public List getOwnLines() {
        return null;
    }

    public Map getMap() {
        return null;
    }

    public void removeSelectedLineObject(VarFileLine varFileLine) {
        this.rowCollector.removeSelectedLineObject(varFileLine);
    }

    public void removeAllSelectedLines() {
        this.rowCollector.removeAllSelectedLines();
    }

    public Hashtable getFieldConstants() {
        return this.rowCollector.getFieldConstants();
    }

    protected String getField(VarFileLine varFileLine, String string) {
        return this.getField(varFileLine.getLine(), this.getFieldConstants().get(string));
    }

    protected String getCommentField(VarFileLine varFileLine, String string) {
        return this.getCommentField(varFileLine.getLine(), this.getFieldConstants().get(string));
    }

    protected String getDefinitionField(VarFileLine varFileLine, String string) {
        return this.rowCollector.getDefinitionField(varFileLine.getLine(), this.getFieldConstants().get(string));
    }

    protected String getCommentField(String string, Object object) {
        return this.rowCollector.getCommentField(string, object);
    }

    protected String getField(String string, Object object) {
        return this.rowCollector.getField(string, object);
    }

    public VarFileLine getCommentLine(String string, String string2) {
        return this.rowCollector.getCommentLine(string, string2);
    }

    public VarFileLine getCommentLine(String string, String string2, List list) {
        return this.rowCollector.getCommentLine(string, string2, list);
    }

    public ModelIDObject getCreatedObject(String string) {
        return this.rowCollector.getCreatedObject(string);
    }

    public Design getDesign() {
        return this.rowCollector.getDesign();
    }

    protected void setCreatorChanger(ModelIDObject modelIDObject, VarFileLine varFileLine) {
        this.rowCollector.setCreatorChanger(modelIDObject, varFileLine);
    }

    public Map getAllCreatedObjects() {
        return this.rowCollector.getAllCreatedObjects();
    }

    public Map getAllReferences() {
        return this.rowCollector.getAllReferences();
    }

    public LogicalDesign getLogicalDesign() {
        return this.rowCollector.getLogicalDesign();
    }

    public RelationalDesign getPhysicalDesign() {
        return this.rowCollector.getPhysicalDesign();
    }

    public DataFlowDesign getDataFlowDesign() {
        return this.rowCollector.getDataFlowDesign();
    }

    public ProcessModel getProcessModel() {
        return this.rowCollector.getProcessModel();
    }

    public ImportLogger getImportLog() {
        return this.importLog;
    }

    public void setImportLog(ImportLogger importLogger) {
        this.importLog = importLogger;
    }
}

