/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHView
extends RowHandler {
    public static final String OBJECT_TYPE = "VIEW";
    public static final String OBJECT_TYPE_COOL = "VIEWS";
    private int tableKey;
    private int viewKey;
    private int tableColumnKey;
    private int viewColumnKey;
    private boolean found;
    private static final Logger LOGGER = new Logger(RHView.class);

    public RHView(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        arrayList.add(OBJECT_TYPE_COOL);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE) || varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createView(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    public void createView(VarFileLine varFileLine) {
        this.found = true;
        ContainerObject containerObject = null;
        String string = this.getField(varFileLine, "general_id");
        if (string != null) {
            String string2 = this.getField(varFileLine, "VIEW_NAME");
            if (this.getPhysicalDesign().getTableViewSet().getByName(string2) == null) {
                containerObject = this.getPhysicalDesign().getTableViewSet().createTableView(null);
                if (containerObject != null) {
                    if (!Fields.typeVar.equalsIgnoreCase("Sterling COOL:DBA V2.1")) {
                        List list = this.getViewDependentKey(string);
                        if (list.size() > 0) {
                            for (String string3 : list) {
                                this.addColumnsToView((TableView)containerObject, string3);
                            }
                        }
                    } else {
                        List list = this.getView2Key(string);
                        if (list.size() > 0) {
                            for (String string4 : list) {
                                this.addColumnsToViewForCool((TableView)containerObject, string4);
                            }
                        }
                    }
                } else {
                    this.found = false;
                }
            } else {
                this.found = false;
            }
        } else {
            this.found = false;
        }
        if (this.found && containerObject.getElements().length > 0) {
            containerObject.setName(this.getField(varFileLine, "VIEW_NAME"));
            this.addDefinition(varFileLine, (TableView)containerObject);
            this.fillElements(varFileLine, (TableView)containerObject);
            if (containerObject.getTopView() == null) {
                this.getDesign().getRelationalDesign().getMainView().createViewFor(containerObject);
            }
            this.addCreatedObject(this.getField(varFileLine, "general_id"), containerObject);
            this.removeSelectedLine(varFileLine);
        } else if (containerObject != null) {
            ((TableView)containerObject).remove();
        }
    }

    private List getViewDependentKey(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getAllSelectedLines();
        for (VarFileLine varFileLine : list) {
            if (!varFileLine.getType().equalsIgnoreCase("VIEWSVIEW_DEPENDEN") || !this.getField(varFileLine, "VIEW_VIEW_DEPENDENT_VIEWSKEY").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine, "VIEW_VIEW_DEPENDENT_VIEWDEPENDENTKEY");
            arrayList.add(string2);
        }
        return arrayList;
    }

    private List getView2Key(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getAllSelectedLines();
        for (VarFileLine varFileLine : list) {
            if (!varFileLine.getType().equalsIgnoreCase("VIEWDEPENDE2") || !this.getField(varFileLine, "VIEW_VIEW_DEPENDENT2_VIEWSKEY").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine, "VIEW_VIEW_DEPENDENT2_KEY");
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void addColumnsToView(TableView tableView, String string) {
        List list = this.getAllSelectedLines();
        for (VarFileLine varFileLine : list) {
            Column column;
            int n;
            ContainedObject[] containedObjectArray;
            DesignObject designObject;
            if (!varFileLine.getType().equalsIgnoreCase("VIEWDEPENDENT") || !this.getField(varFileLine, "general_id").equalsIgnoreCase(string)) continue;
            int n2 = Integer.parseInt(this.getField(varFileLine, "VIEW_DEPENDENT_TYPE"));
            if (tableView == null) continue;
            this.determineType();
            if (n2 == this.tableKey) {
                designObject = (Table)this.getCreatedObject(this.getField(varFileLine, "VIEW_DEPENDENT_TABLE"));
                if (designObject != null) {
                    containedObjectArray = ((ContainerObject)designObject).getElements();
                    for (n = 0; n < containedObjectArray.length; ++n) {
                        column = (Column)containedObjectArray[n];
                        if (column != null) {
                            tableView.add(column);
                            continue;
                        }
                        this.found = false;
                    }
                    continue;
                }
                this.found = false;
                continue;
            }
            if (n2 == this.tableColumnKey) {
                designObject = (Column)this.getCreatedObject(this.getField(varFileLine, "VIEW_DEPENDENT_TABLE_COLUMN"));
                if (designObject != null) {
                    tableView.add((ContainedObject)designObject);
                    continue;
                }
                this.found = false;
                continue;
            }
            if (n2 == this.viewColumnKey) {
                designObject = (Column)this.getCreatedObject(this.getField(varFileLine, "VIEW_DEPENDENT_VIEW_COLUMN"));
                if (designObject != null) {
                    tableView.add((ContainedObject)designObject);
                    continue;
                }
                this.found = false;
                continue;
            }
            if (n2 != this.viewKey) continue;
            designObject = (TableView)this.getCreatedObject(this.getField(varFileLine, "VIEW_DEPENDENT_VIEW"));
            if (designObject != null) {
                containedObjectArray = ((ContainerObject)designObject).getElements();
                for (n = 0; n < containedObjectArray.length; ++n) {
                    column = (Column)containedObjectArray[n];
                    if (column != null) {
                        tableView.add(column);
                        continue;
                    }
                    this.found = false;
                }
                continue;
            }
            this.found = false;
        }
    }

    private void addColumnsToViewForCool(TableView tableView, String string) {
        ModelIDObject modelIDObject = this.getCreatedObject(string);
        if (modelIDObject instanceof Column) {
            if (modelIDObject != null) {
                tableView.add((Column)modelIDObject);
            } else {
                this.found = false;
            }
        }
    }

    private void determineType() {
        if (Fields.typeVar.equals("BACHMAN DB2 V6.1") || Fields.typeVar.equals("BACHMAN DB2 V7.1")) {
            this.tableColumnKey = 2053;
            this.tableKey = 2054;
            this.viewColumnKey = 2055;
            this.viewKey = 2061;
        } else if (Fields.typeVar.equals("CAYENNE DB2 V7.1")) {
            this.tableColumnKey = 2055;
            this.tableKey = 2054;
        }
    }

    private void fillElements(VarFileLine varFileLine, TableView tableView) {
        tableView.setComment(this.getComment(varFileLine));
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        TableViewProxySet tableViewProxySet = storageDesignDB2v70.getTableViewProxySet();
        TableViewProxyDB2 tableViewProxyDB2 = (TableViewProxyDB2)tableViewProxySet.getProxy(tableView.getObjectID());
        if (tableViewProxyDB2 != null) {
            String string = this.getField(varFileLine, "VIEW_OWNER");
            Owner owner = (Owner)this.getCreatedObject(string);
            if (owner != null) {
                tableViewProxyDB2.setOwner(owner);
            }
            try {
                int n = Integer.parseInt(this.getField(varFileLine, "VIEW_CHECK_OPTIONS"));
                switch (n) {
                    case 0: {
                        tableViewProxyDB2.setCheckOption(false);
                        break;
                    }
                    case 1: {
                        tableViewProxyDB2.setCheckOption(true);
                        break;
                    }
                    default: {
                        tableViewProxyDB2.setCheckOption(false);
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong Format in RHView.fillElements (Set CheckOption) : ");
                stringBuffer.append(varFileLine.getLine());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addError("Wrong CHECK OPTION format in " + varFileLine);
            }
            String string2 = this.getField(varFileLine, "VIEW_LABEL_ON");
            tableViewProxyDB2.setLabelOn(string2);
            this.fillDefinition(varFileLine, tableViewProxyDB2);
        }
    }

    private void fillDefinition(VarFileLine varFileLine, TableViewProxyDB2 tableViewProxyDB2) {
        try {
            int n = Integer.parseInt(this.getField(varFileLine, "VIEW_TEXT_ID"));
            if (n > 0) {
                int n2;
                String string = null;
                VarFileLine varFileLine2 = this.getCommentLine(String.valueOf(n), "TEXT");
                if (varFileLine2 != null) {
                    string = this.getField(varFileLine2, "text_comment");
                    this.removeSelectedLine(varFileLine2);
                }
                if (string != null && (n2 = string.toUpperCase().indexOf("WHERE")) > -1) {
                    String string2 = string.substring(n2 + 5).trim();
                    tableViewProxyDB2.setDefinition(string2);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer("wrong Format in RHView.fillDefinition : ");
            stringBuffer.append(varFileLine.getLine());
            LOGGER.error(stringBuffer.toString(), numberFormatException);
            this.importLog.addError("Unknown view body near " + varFileLine);
        }
    }

    private String getComment(VarFileLine varFileLine) {
        String string = null;
        if (!this.getField(varFileLine, "VIEW_COMMENT_ID").equalsIgnoreCase("0")) {
            VarFileLine varFileLine2 = this.getCommentLine(this.getField(varFileLine, "VIEW_COMMENT_ID"), "TEXT");
            if (varFileLine2 != null) {
                string = this.getField(varFileLine2, "text_comment");
            }
        } else {
            string = "";
        }
        return string;
    }

    private void addDefinition(VarFileLine varFileLine, TableView tableView) {
        int n = Integer.parseInt(this.getField(varFileLine, "VIEW_TEXT_ID"));
        if (n > 0) {
            String string = null;
            VarFileLine varFileLine2 = this.getCommentLine(String.valueOf(n), "TEXT");
            if (varFileLine2 != null) {
                string = this.getDefinitionField(varFileLine2, "text_comment");
                this.removeSelectedLine(varFileLine2);
            }
            if (string != null) {
                tableView.setUserDefined(true);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("CREATE VIEW ").append(tableView.getName()).append('\n').append(string);
                tableView.setUserDefinedSQL(stringBuffer.toString());
            }
        }
    }
}

