/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class RHSynonym
extends RowHandler {
    public static final String OBJECT_TYPE = "SYNONYM";

    public RHSynonym(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createSynonym(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createSynonym(VarFileLine varFileLine) {
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        if (storageDesignDB2v70 != null) {
            SynonymDB2 synonymDB2 = storageDesignDB2v70.getSynonymSet().createSynonym();
            synonymDB2.setName(this.getField(varFileLine, "SYNONYM_NAME"));
            this.fillOwner(varFileLine, synonymDB2);
            String string = this.getField(varFileLine, "SYNONYM_TABLE_KEY");
            if (!string.equalsIgnoreCase("0")) {
                TableProxyDB2 tableProxyDB2;
                Table table = (Table)this.getCreatedObject(string);
                if (table != null && (tableProxyDB2 = (TableProxyDB2)storageDesignDB2v70.getTableProxySet().getProxy(table.getObjectID())) != null) {
                    synonymDB2.setTable(tableProxyDB2);
                }
            } else {
                TableViewProxyDB2 tableViewProxyDB2;
                TableView tableView;
                String string2 = this.getField(varFileLine, "SYNONYM_VIEW_KEY");
                if (!string2.equalsIgnoreCase("0") && (tableView = (TableView)this.getCreatedObject(string2)) != null && (tableViewProxyDB2 = (TableViewProxyDB2)storageDesignDB2v70.getTableViewProxySet().getProxy(tableView.getObjectID())) != null) {
                    synonymDB2.setView(tableViewProxyDB2);
                }
            }
            this.addCreatedObject(this.getField(varFileLine, "general_id"), synonymDB2);
            this.removeSelectedLine(varFileLine);
        }
    }

    private void fillOwner(VarFileLine varFileLine, SynonymDB2 synonymDB2) {
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n == 1000) {
            String string = this.getField(varFileLine, "SYNONYM_AUTHID");
            Owner owner = (Owner)this.getAllCreatedObjects().get(string);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)synonymDB2.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(string);
            }
            synonymDB2.setOwner(owner);
        } else {
            String string = this.getField(varFileLine, "SYNONYM_AUTHID");
            Owner owner = (Owner)this.getCreatedObject(string);
            synonymDB2.setOwner(owner);
        }
    }
}

