/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class RHStorageGroup
extends RowHandler {
    public static final String OBJECT_TYPE = "STORAGE_GROUPS";

    public RHStorageGroup(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createStorageGroup(varFileLine);
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    private void createStorageGroup(VarFileLine varFileLine) {
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesignDB2v70 = (StorageDesignDB2v70)this.getDesign().getStorageDesign(rDBMSSite);
        if (!this.getField(varFileLine, "STORAGEGROUP_NAME").equalsIgnoreCase("SYSDEFLT")) {
            StorageGroupDB2 storageGroupDB2 = storageDesignDB2v70.createStorageGroup();
            if (storageGroupDB2 != null) {
                Object object;
                Object object2;
                storageGroupDB2.setName(this.getField(varFileLine, "STORAGEGROUP_NAME"));
                this.setCreatorChanger(storageGroupDB2, varFileLine);
                this.fillCommontOn(varFileLine, storageGroupDB2);
                String string = this.getField(varFileLine, "general_id");
                List list = this.getVolSGMapKeys(string);
                if (list.size() > 0) {
                    object2 = list.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        VolumesDB2 volumesDB2 = (VolumesDB2)this.getCreatedObject((String)object);
                        if (volumesDB2 == null) continue;
                        storageGroupDB2.setVolumes(volumesDB2.getObjectID());
                    }
                }
                if ((object = (VCatDB2)this.getCreatedObject((String)(object2 = this.getField(varFileLine, "STORAGEGROUP_VCAT_ID")))) != null) {
                    storageGroupDB2.setVCat((VCatDB2)object);
                }
                this.addCreatedObject(this.getField(varFileLine, "general_id"), storageGroupDB2);
                this.removeSelectedLine(varFileLine);
            }
        } else {
            StorageGroupSetDB2 storageGroupSetDB2 = storageDesignDB2v70.getStorageGroupSet();
            Iterator iterator = storageGroupSetDB2.iterator();
            while (iterator.hasNext()) {
                StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)iterator.next();
                if (!storageGroupDB2.getName().equalsIgnoreCase("SYSDEFLT")) continue;
                this.addCreatedObject(this.getField(varFileLine, "general_id"), storageGroupDB2);
                this.removeSelectedLine(varFileLine);
            }
        }
    }

    private void fillCommontOn(VarFileLine varFileLine, StorageGroupDB2 storageGroupDB2) {
        String string = this.getField(varFileLine, "STORAGEGROUP_TEXT");
        for (VarFileLine varFileLine2 : this.getAllSelectedLines()) {
            if (!varFileLine2.getType().equalsIgnoreCase("TEXT") || !this.getField(varFileLine2, "general_id").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine2, "text_comment");
            storageGroupDB2.setCommentInRDBMS(string2);
        }
    }

    private List getVolSGMapKeys(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getAllSelectedLines();
        for (VarFileLine varFileLine : list) {
            if (!varFileLine.getType().equalsIgnoreCase("VOL_SG_MAP") || !this.getField(varFileLine, "STORAGEGROUP_VOL_SG_MAP_KEY").equalsIgnoreCase(string)) continue;
            String string2 = this.getField(varFileLine, "STORAGEGROUP_VOLUME_KEY");
            arrayList.add(string2);
        }
        return arrayList;
    }
}

