/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.Logger;

public class RHPlacement
extends RowHandler {
    public static final String OBJECT_TYPE = "PLACEMENT";
    private Fields constants;
    private Map viewsWithPlacement = new TreeMap();
    private List viewsWithNoPlacement = new ArrayList();
    private List lines = new ArrayList();
    private static final Logger LOGGER = new Logger(RHPlacement.class);
    int xmin;
    int ymin;
    int xmax;
    int ymax;

    public RHPlacement(Design design, Fields fields, List list, Map map, List list2, List list3, Map map2, List list4, List list5) {
        super(design, fields, list, map, list2, list3, map2, list4, list5);
        this.constants = fields;
    }

    @Override
    public void read(VarFileLine varFileLine) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(varFileLine);
        } else {
            this.nextRead(varFileLine);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OBJECT_TYPE);
        return arrayList;
    }

    @Override
    public void handle(VarFileLine varFileLine, boolean bl) {
        if (varFileLine.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            if (this.getField(varFileLine, "PLACEMENT_DIAGRAM_ID").equalsIgnoreCase(this.constants.getPhysicalDesignID())) {
                this.rearrangeTables(varFileLine);
            } else if (!this.lines.contains(varFileLine)) {
                this.lines.add(varFileLine);
                this.removeSelectedLine(varFileLine);
            }
        } else {
            this.nextHandler(varFileLine, bl);
        }
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    public void createObjectsInSubViews(Map map) {
        for (VarFileLine varFileLine : this.lines) {
            String string;
            DesignPartView designPartView;
            int n = (Integer)this.getFieldConstants().get("IS_COOL");
            if (n == 1000 || (designPartView = (DesignPartView)map.get(string = this.getField(varFileLine, "PLACEMENT_DIAGRAM_ID"))) == null) continue;
            String string2 = this.getField(varFileLine, "PLACEMENT_TABLE_ID");
            DesignObject designObject = (DesignObject)this.getAllCreatedObjects().get(string2);
            if (designObject == null) continue;
            try {
                ContainerView containerView;
                int n2 = Integer.parseInt(this.getField(varFileLine, "PLACEMENT_LEFT"));
                int n3 = Integer.parseInt(this.getField(varFileLine, "PLACEMENT_TOP"));
                int n4 = Integer.parseInt(this.getField(varFileLine, "PLACEMENT_WIDTH"));
                int n5 = Integer.parseInt(this.getField(varFileLine, "PLACEMENT_HEIGHT"));
                if (n4 == 0 && n5 == 0 || (containerView = ((ContainerView)designObject.getTopView()).createViewSynonim(designPartView)) == null) continue;
                if (containerView.getCellView() != null) {
                    containerView.getCellView().setNewBounds(new Rectangle(n2, n3, n4, n5));
                } else {
                    containerView.setBounds(new Rectangle(n2, n3, n4, n5));
                }
                if (!(containerView instanceof TVTable)) continue;
                ((TVTable)containerView).addTVFKRelations();
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("wrong Format in RHPlacement.createObjectsInSubViews: ");
                stringBuffer.append(varFileLine.getLine());
                LOGGER.error(stringBuffer.toString(), numberFormatException);
                this.importLog.addWarning("Error occured while creating objects in subview near " + varFileLine);
            }
        }
    }

    private void rearrangeTables(VarFileLine varFileLine) {
        int n = (Integer)this.getFieldConstants().get("IS_COOL");
        if (n != 1000) {
            String string = this.getField(varFileLine, "PLACEMENT_TABLE_ID");
            DesignObject designObject = (DesignObject)this.getAllCreatedObjects().get(string);
            if (designObject != null) {
                try {
                    TopView topView;
                    int n2 = Integer.parseInt(this.getField(varFileLine, "PLACEMENT_LEFT"));
                    int n3 = Integer.parseInt(this.getField(varFileLine, "PLACEMENT_TOP"));
                    int n4 = Integer.parseInt(this.getField(varFileLine, "PLACEMENT_WIDTH"));
                    int n5 = Integer.parseInt(this.getField(varFileLine, "PLACEMENT_HEIGHT"));
                    int n6 = Integer.parseInt(this.getField(varFileLine, "PLACEMENT_COLOR"));
                    if ((n4 != 0 || n5 != 0) && (topView = designObject.getTopView()) != null) {
                        if (topView.getCellView() != null) {
                            topView.getCellView().setNewBounds(new Rectangle(n2, n3, n4, n5));
                        } else {
                            topView.setBounds(new Rectangle(n2, n3, n4, n5));
                        }
                        if (designObject instanceof TableView) {
                            this.viewsWithPlacement.put(designObject.getObjectID(), designObject);
                        }
                        RHPlacement.setColor(topView, n6);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer("wrong Format in RHPlacement.replaceTables: ");
                    stringBuffer.append(varFileLine.getLine());
                    LOGGER.error(stringBuffer.toString(), numberFormatException);
                    this.importLog.addWarning("Error occured while rearranging tables in subview near " + varFileLine);
                }
                this.removeSelectedLine(varFileLine);
            }
        }
    }

    public void rearrangePhysDes() {
        TopView topView;
        Object object;
        Rectangle rectangle = null;
        int n = 0;
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = this.getDesign().getRelationalDesign().getTableViewSet().iterator();
        while (iterator.hasNext()) {
            ++n;
            object = (TableView)iterator.next();
            topView = ((MultiShapedDesignObject)object).getTopView();
            if ((object = (TableView)this.viewsWithPlacement.get(((ModelIDObject)object).getObjectID())) == null) {
                this.viewsWithNoPlacement.add(topView);
                continue;
            }
            arrayList.add(topView);
            if (rectangle == null) {
                rectangle = new Rectangle(topView.getBounds());
                continue;
            }
            rectangle.add(topView.getBounds());
        }
        object = this.getDesign().getRelationalDesign().getTableSet().iterator();
        while (object.hasNext()) {
            ++n;
            topView = ((Table)object.next()).getTopView();
            arrayList.add(topView);
            if (rectangle == null) {
                rectangle = new Rectangle(topView.getBounds());
                continue;
            }
            rectangle.add(topView.getBounds());
        }
        if (n > 0 && rectangle != null) {
            this.xmin = rectangle.x;
            this.ymin = rectangle.y;
            this.xmax = this.xmin + rectangle.width;
            this.ymax = this.ymin + rectangle.height;
            int n2 = 20 - this.xmin;
            int n3 = 20 - this.ymin;
            this.translateComponents(n2, n3, arrayList);
            this.xmin = 20;
            this.ymin = 20;
            this.xmax += n2;
            this.ymax += n3;
            this.arrangeViewsWithoutPositionInVar();
        }
    }

    private void translateComponents(int n, int n2, Collection collection) {
        for (Object object2 : collection) {
            Point point = ((TopView)object2).getLocation();
            point.x += n;
            point.y += n2;
            ((TopView)object2).setLocation(point);
        }
        Iterator iterator = this.getDesign().getRelationalDesign().getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            Point2D point2D;
            Object object;
            int n3;
            Object[] objectArray;
            Object object2;
            object2 = (FKIndexAssociation)iterator.next();
            TVFKRelation tVFKRelation = (TVFKRelation)((FKIndexAssociation)object2).getViewFor(((DesignObject)object2).getDesignPart().getMainView());
            if (tVFKRelation == null) continue;
            EdgeView edgeView = (EdgeView)tVFKRelation.getCellView();
            if (edgeView != null) {
                objectArray = edgeView.getPoints().toArray();
                for (n3 = 1; n3 < objectArray.length - 1; ++n3) {
                    object = objectArray[n3];
                    if (object instanceof Point) {
                        point2D = (Point)object;
                        point2D.x += n;
                        point2D.y += n2;
                        continue;
                    }
                    if (!(object instanceof DiagramConstants.SerializablePoint2D)) continue;
                    point2D = (DiagramConstants.SerializablePoint2D)object;
                    ((DiagramConstants.SerializablePoint2D)point2D).x += (double)n;
                    ((DiagramConstants.SerializablePoint2D)point2D).y += (double)n2;
                }
                edgeView.update();
                continue;
            }
            objectArray = tVFKRelation.getEdgePoints().toArray();
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                object = objectArray[n3];
                if (object instanceof Point) {
                    point2D = (Point)object;
                    point2D.x += n;
                    point2D.y += n2;
                    continue;
                }
                if (!(object instanceof DiagramConstants.SerializablePoint2D)) continue;
                point2D = (DiagramConstants.SerializablePoint2D)object;
                ((DiagramConstants.SerializablePoint2D)point2D).x += (double)n;
                ((DiagramConstants.SerializablePoint2D)point2D).y += (double)n2;
            }
        }
    }

    private void arrangeViewsWithoutPositionInVar() {
        int n = 210;
        int n2 = 120;
        int n3 = 20;
        Dimension dimension = this.getDesign().getRelationalDesign().getMainView().getConfiguration().getWorkSpaceSize();
        int n4 = dimension.height;
        int n5 = this.ymax + n3;
        int n6 = (n4 - n5) / (n2 + n3);
        int n7 = this.xmax;
        int n8 = this.xmin;
        int n9 = (n7 - n8) / (n + n3);
        int n10 = this.viewsWithNoPlacement.size();
        if (n6 * n9 < n10) {
            n7 = dimension.width;
            n9 = (n7 - n8) / (n + n3);
        }
        while (n6 * n9 < n10) {
            if ((n -= n3) < n3 || (n2 -= n3) < n3) {
                return;
            }
            n9 = (n7 - n8) / (n + n3);
            n6 = (n4 - n5) / (n2 + n3);
        }
        Iterator iterator = this.viewsWithNoPlacement.iterator();
        for (int i = 0; i < n6; ++i) {
            int n11 = n5 + i * (n2 + n3);
            for (int j = 0; j < n9; ++j) {
                int n12 = n8 + j * (n + n3);
                if (iterator.hasNext()) {
                    TopView topView = (TopView)iterator.next();
                    if (topView.getCellView() != null) {
                        topView.getCellView().setNewBounds(new Rectangle(n12, n11, n, n2));
                        continue;
                    }
                    topView.setBounds(new Rectangle(n12, n11, n, n2));
                    continue;
                }
                return;
            }
        }
    }

    public static void setColor(TopView topView, int n) {
        int n2 = RHPlacement.getRed(n);
        int n3 = RHPlacement.getGreen(n);
        int n4 = RHPlacement.getBlue(n);
        Color color = new Color(n2, n3, n4);
        topView.setBackgroundColor(color);
        topView.setUseDefaultColor(false);
    }

    private static int getRed(int n) {
        int n2 = 255;
        int n3 = n & n2;
        return n3;
    }

    private static int getGreen(int n) {
        int n2 = 65280;
        int n3 = n & n2;
        return n3 >> 8;
    }

    private static int getBlue(int n) {
        int n2 = 0xFF0000;
        int n3 = n & n2;
        return n3 >> 16;
    }
}

